/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.ability.api.FscBillEcomCheckAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillEcomCheckTaskAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckTaskReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckTaskRspBO;
import com.tydic.fsc.bill.busi.api.FscBillEcomCheckApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.busibase.atom.bo.SortQueryConfigBo;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillEcomCheckTaskAbilityService"})
public class FscBillEcomCheckTaskServiceAbilityImpl
implements FscBillEcomCheckTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillEcomCheckTaskServiceAbilityImpl.class);
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;
    @Autowired
    private FscBillEcomCheckAbilityService fscBillEcomCheckAbilityService;
    @Autowired
    private FscBillEcomCheckApplyBusiService fscBillEcomCheckApplyBusiService;
    @Autowired
    private CacheClient cacheClient;
    @Resource(name="fscInvoiceEcomCheck")
    private ProxyMessageProducer fscInvoiceEcomCheckProvider;
    @Value(value="${FSC_BILL_ECOM_CHECK_TOPIC:FSC_BILL_ECOM_CHECK_TOPIC}")
    private String FSC_BILL_ECOM_CHECK_TOPIC;
    @Value(value="${FSC_BILL_ECOM_CHECK_TAG:*}")
    private String FSC_BILL_ECOM_CHECK_TAG;
    private static final String AUTO_ECOM_CHECK_KEY = "AUTO_ECOM_CHECK_KEY_";

    @PostMapping(value={"dealAotuEcomCheck"})
    public FscBillEcomCheckTaskRspBO dealAotuEcomCheck(@RequestBody FscBillEcomCheckTaskReqBO reqBo) {
        FscUocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.getOrder(1, 100, reqBo);
        if (CollectionUtils.isEmpty((Collection)inspectionDetailsList.getRows())) {
            return new FscBillEcomCheckTaskRspBO();
        }
        try {
            this.dealCheck(inspectionDetailsList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("\u7535\u5546\u5bf9\u8d26\u6761\u6570:{}", (Object)inspectionDetailsList.getRecordsTotal());
        if (inspectionDetailsList.getRecordsTotal() > 100) {
            for (int i = 2; i <= inspectionDetailsList.getTotal(); ++i) {
                FscUocInspectionDetailsListPageQueryRspBO orders = this.getOrder(i, 100, reqBo);
                this.dealCheck(orders);
            }
        }
        return new FscBillEcomCheckTaskRspBO();
    }

    private void dealCheck(FscUocInspectionDetailsListPageQueryRspBO inspectionDetailsList) {
        for (FscUocInspectionDetailsListBO order : inspectionDetailsList.getRows()) {
            FscBillEcomCheckApplyBusiReqBO applyBusiReqBO = null;
            ArrayList<RelOrderBO> relOrderBOList = null;
            if (null == this.cacheClient.get(AUTO_ECOM_CHECK_KEY + order.getOrderId())) {
                try {
                    applyBusiReqBO = new FscBillEcomCheckApplyBusiReqBO();
                    applyBusiReqBO.setSupplierId(this.str2Long(order.getSupplierId()));
                    relOrderBOList = new ArrayList<RelOrderBO>();
                    RelOrderBO relOrderBO = new RelOrderBO();
                    relOrderBO.setAcceptOrderId(order.getAcceptOrderId());
                    relOrderBO.setMyAmount(order.getInspTotalPurchaseFee());
                    relOrderBO.setOrderId(order.getSaleOrderId());
                    relOrderBO.setOtherNo(order.getSaleOrderNoExt());
                    relOrderBO.setSaleAmount(order.getInspTotalSalefee());
                    relOrderBOList.add(relOrderBO);
                    applyBusiReqBO.setRelOrderList(relOrderBOList);
                    applyBusiReqBO.setSysTenantId(order.getSysTenantId());
                    applyBusiReqBO.setSysTenantName(order.getSysTenantName());
                }
                catch (Exception e) {
                    log.error("\u81ea\u52a8\u5bf9\u8d26\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)order.getOrderId(), (Object)e);
                }
                FscBillEcomCheckApplyBusiRspBO applyBusiRspBO = this.fscBillEcomCheckApplyBusiService.dealEcomCheckApply(applyBusiReqBO);
                if (!"0000".equals(applyBusiRspBO.getRespCode())) {
                    log.error("\u8ba2\u5355id:{}\u5bf9\u8d26\u51fa\u9519\uff1a{}", (Object)order.getOrderId(), (Object)applyBusiRspBO.getRespDesc());
                    continue;
                }
                this.cacheClient.set(AUTO_ECOM_CHECK_KEY + order.getOrderId(), (Object)order.getOrderId());
            }
            if (null == this.cacheClient.get(AUTO_ECOM_CHECK_KEY + order.getOrderId())) continue;
            FscBillEcomCheckAbilityReqBO checkAbilityReqBO = new FscBillEcomCheckAbilityReqBO();
            checkAbilityReqBO.setRelOrderList(relOrderBOList);
            checkAbilityReqBO.setSysTenantId(order.getSysTenantId());
            checkAbilityReqBO.setSysTenantName(order.getSysTenantName());
            this.fscInvoiceEcomCheckProvider.send(new ProxyMessage(this.FSC_BILL_ECOM_CHECK_TOPIC, this.FSC_BILL_ECOM_CHECK_TAG, JSON.toJSONString((Object)checkAbilityReqBO)));
            this.cacheClient.delete(AUTO_ECOM_CHECK_KEY + order.getOrderId());
        }
    }

    private FscUocInspectionDetailsListPageQueryRspBO getOrder(Integer pageNo, Integer pageSize, FscBillEcomCheckTaskReqBO reqBO) {
        FscUocInspectionDetailsListPageQueryReqBO fscUocInspectionDetailsListPageQueryReqBO = new FscUocInspectionDetailsListPageQueryReqBO();
        ArrayList<String> orderSourceList = new ArrayList<String>();
        orderSourceList.add("2");
        fscUocInspectionDetailsListPageQueryReqBO.setOrderSourceList(orderSourceList);
        fscUocInspectionDetailsListPageQueryReqBO.setInspOrderIdList(reqBO.getInspOrderIdList());
        ArrayList<Integer> checkStateList = new ArrayList<Integer>();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getCheckState())) {
            checkStateList.add(reqBO.getCheckState());
        } else {
            checkStateList.add(FscConstants.BillCheck.NOT_CHECK);
        }
        fscUocInspectionDetailsListPageQueryReqBO.setCheckStateList(checkStateList);
        fscUocInspectionDetailsListPageQueryReqBO.setCanSettleChng(Boolean.valueOf(true));
        fscUocInspectionDetailsListPageQueryReqBO.setPageNo(pageNo);
        fscUocInspectionDetailsListPageQueryReqBO.setPageSize(pageSize);
        fscUocInspectionDetailsListPageQueryReqBO.setSupNo(reqBO.getSupNo());
        ArrayList<SortQueryConfigBo> sortQueryConfigList = new ArrayList<SortQueryConfigBo>();
        SortQueryConfigBo sortQueryConfigBo = new SortQueryConfigBo();
        sortQueryConfigBo.setIndexFieldName("checkState.keyword");
        sortQueryConfigBo.setIndexDataType("Integer");
        sortQueryConfigBo.setIndexSort(Integer.valueOf(1));
        sortQueryConfigList.add(sortQueryConfigBo);
        sortQueryConfigBo = new SortQueryConfigBo();
        sortQueryConfigBo.setIndexFieldName("createTime");
        sortQueryConfigBo.setIndexDataType("date");
        sortQueryConfigBo.setIndexSort(Integer.valueOf(1));
        sortQueryConfigList.add(sortQueryConfigBo);
        fscUocInspectionDetailsListPageQueryReqBO.setSortQueryConfigList(sortQueryConfigList);
        fscUocInspectionDetailsListPageQueryReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscUocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.fscUocInspectionDetailsListPageQueryService.getInspectionDetailsList(fscUocInspectionDetailsListPageQueryReqBO);
        if (!"0000".equals(inspectionDetailsList.getRespCode())) {
            throw new FscBusinessException("191034", inspectionDetailsList.getRespDesc());
        }
        return inspectionDetailsList;
    }

    private Long str2Long(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("191034", "\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
        }
    }
}

