/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.common.ability.api.UccbBatchQryCatalogRelListAbilityService;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListBO;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceApplyAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceApplyAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceApplyAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceApplyBusiService;
import com.tydic.fsc.bill.busi.api.FscCrcInvoicSubmitBusiService;
import com.tydic.fsc.bill.busi.api.FscOrderMapEditBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceApplyBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoicSubmitBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoicSubmitBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscOrderMapEditBusiReqBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderMapPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillInvoiceApplyAbilityService"})
public class FscBillInvoiceApplyAbilityServiceImpl
implements FscBillInvoiceApplyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillInvoiceApplyAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscCrcInvoicSubmitBusiService fscCrcInvoicSubmitBusiService;
    @Autowired
    private FscBillInvoiceApplyBusiService fscBillInvoiceApplyBusiService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Value(value="${FSC_INVOICE_APLLY_TOPIC:FSC_INVOICE_APLLY_TOPIC}")
    private String FSC_INVOICE_APLLY_TOPIC;
    @Value(value="${FSC_INVOICE_APPLY_TAG:*}")
    private String FSC_INVOICE_APPLY_TAG;
    @Resource(name="fscInvoiceApplyProvider")
    private ProxyMessageProducer fscInvoiceApplyProvider;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private UccbBatchQryCatalogRelListAbilityService uccbBatchQryCatalogRelListAbilityService;
    @Autowired
    private FscOrderMapEditBusiService fscOrderMapEditBusiService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private FscOrderMapMapper fscOrderMapMapper;

    @BigDecimalConvert(value=2)
    @FscDuplicateCommitLimit
    @PostMapping(value={"dealInvoiceApply"})
    public FscBillInvoiceApplyAbilityRspBO dealInvoiceApply(@RequestBody FscBillInvoiceApplyAbilityReqBO reqBO) {
        this.val(reqBO);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.valConfig(reqBO);
        for (Long orderId : reqBO.getOrderIds()) {
            String date = sdf.format(new Date());
            String redisKey = "sendHx" + orderId;
            Long nxResult = this.cacheClient.setnx(redisKey, (Object)date);
            if (nxResult != 1L) {
                Object dateObj = this.cacheClient.get(redisKey);
                Date setDate = DateUtil.strToDate((String)dateObj.toString(), (String)"yyyy-MM-dd HH:mm:ss");
                log.info("\u8bbe\u7f6e\u7684\u65f6\u95f4====={}", (Object)setDate);
                Date nowDate = new Date();
                long diffInMillis = nowDate.getTime() - setDate.getTime();
                long diffInSeconds = diffInMillis / 1000L;
                if (diffInSeconds > 30L) {
                    this.cacheClient.delete(redisKey);
                } else {
                    throw new FscBusinessException("191008", "\u8bf7\u52ff\u9891\u7e41\u7533\u8bf7\u5f00\u7968");
                }
            }
            this.cacheClient.expire(redisKey, 30);
            FscOrderPO fscOrderPo = new FscOrderPO();
            fscOrderPo.setFscOrderId(orderId);
            fscOrderPo.setSysTenantId(reqBO.getSysTenantId());
            FscOrderPO modelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
            if (null == modelBy) {
                throw new FscBusinessException("191008", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a");
            }
            if (modelBy.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER)) {
                throw new FscBusinessException("191008", "\u5f00\u7968\u65b9\u4e0d\u80fd\u4e3a\u4f9b\u5e94\u5546");
            }
            FscOrderMapPO fscOrderMapPo = new FscOrderMapPO();
            fscOrderMapPo.setFscOrderId(orderId);
            fscOrderMapPo.setFieldCode("reApplyInvoiceFlag");
            fscOrderMapPo.setSysTenantId(reqBO.getSysTenantId());
            fscOrderMapPo = this.fscOrderMapMapper.getModelBy(fscOrderMapPo);
            Boolean reApplyInvoiceFlag = false;
            if (null != fscOrderMapPo && "1".equals(fscOrderMapPo.getFieldValue())) {
                reApplyInvoiceFlag = true;
            }
            if (!(modelBy.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILLING_CANCEL) || modelBy.getOrderState().equals(FscConstants.FscInvoiceOrderState.SUBMITTING) || modelBy.getOrderFlow().equals(FscConstants.OrderFlow.MONTH_SERVICE_FEE) || modelBy.getInvStatus() == 2 || reApplyInvoiceFlag.booleanValue())) {
                throw new FscBusinessException("191008", "\u5f53\u524d\u72b6\u6001[" + FscBillStatus.getInstance((Integer)modelBy.getOrderState()).getDescr() + "]\u4e0d\u80fd\u5904\u7406\u5f00\u7968\u7533\u8bf7");
            }
            FscCrcInvoicSubmitBusiReqBO fscCrcInvoicSubmitBusiReqBO = (FscCrcInvoicSubmitBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscCrcInvoicSubmitBusiReqBO.class));
            fscCrcInvoicSubmitBusiReqBO.setOrderId(orderId);
            if (modelBy.getOrderFlow().equals(FscConstants.OrderFlow.INVOICE)) {
                fscCrcInvoicSubmitBusiReqBO.setServiceFee(false);
            } else {
                fscCrcInvoicSubmitBusiReqBO.setServiceFee(true);
            }
            fscCrcInvoicSubmitBusiReqBO.setInvStatus(modelBy.getInvStatus());
            FscCrcInvoicSubmitBusiRspBO fscCrcInvoicSubmitBusiRspBO = this.fscCrcInvoicSubmitBusiService.InvoicSubmit(fscCrcInvoicSubmitBusiReqBO);
            if (!"0000".equals(fscCrcInvoicSubmitBusiRspBO.getRespCode())) {
                throw new FscBusinessException("191008", fscCrcInvoicSubmitBusiRspBO.getRespDesc());
            }
            if (modelBy.getInvStatus() == 0) {
                FscBillInvoiceApplyBusiRspBO fscBillInvoiceApplyBusiRspBO;
                FscBillInvoiceApplyBusiReqBO fscBillInvoiceApplyBusiReqBO = new FscBillInvoiceApplyBusiReqBO();
                fscBillInvoiceApplyBusiReqBO.setOrderId(orderId);
                fscBillInvoiceApplyBusiReqBO.setOrderState(modelBy.getOrderState());
                fscBillInvoiceApplyBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
                if (modelBy.getOrderFlow().equals(FscConstants.OrderFlow.MONTH_SERVICE_FEE)) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("directFlag", "1");
                    fscBillInvoiceApplyBusiReqBO.setParamMap(params);
                }
                if (!"0000".equals((fscBillInvoiceApplyBusiRspBO = this.fscBillInvoiceApplyBusiService.dealInvoiceApply(fscBillInvoiceApplyBusiReqBO)).getRespCode())) {
                    throw new FscBusinessException("191008", fscBillInvoiceApplyBusiRspBO.getRespDesc());
                }
            }
            if (null != fscOrderMapPo) {
                FscOrderMapEditBusiReqBO mapEditBusiReqBO = new FscOrderMapEditBusiReqBO();
                mapEditBusiReqBO.setFscOrderId(orderId);
                mapEditBusiReqBO.setFieldCode("reApplyInvoiceFlag");
                mapEditBusiReqBO.setFieldName("\u7533\u8bf7\u91cd\u5f00\u53d1\u7968\u6807\u8bc6(1.\u662f 0.\u5426)");
                mapEditBusiReqBO.setFieldValue("0");
                mapEditBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
                this.fscOrderMapEditBusiService.fscOrderMapEdit(mapEditBusiReqBO);
            }
            this.sendMq(orderId, reqBO);
        }
        return new FscBillInvoiceApplyAbilityRspBO();
    }

    private void val(FscBillInvoiceApplyAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderIds()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderIds]\u4e3a\u7a7a");
        }
    }

    private void valConfig(FscBillInvoiceApplyAbilityReqBO reqBO) {
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        if (!ObjectUtil.isEmpty((Object)reqBO.getOrderId())) {
            fscOrderIds.add(reqBO.getOrderId());
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getOrderIds())) {
            fscOrderIds.addAll(reqBO.getOrderIds());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(fscOrderIds);
        fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
        boolean mark = false;
        for (FscOrderPO item : fscOrderPOList) {
            if (!FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(item.getOrderFlow())) continue;
            mark = true;
            break;
        }
        if (!mark) {
            fscOrderItemPO.setFscOrderIdList(fscOrderIds);
            fscOrderItemPO.setSysTenantId(reqBO.getSysTenantId());
            List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
            if (ObjectUtil.isEmpty((Object)fscOrderItemPOList)) {
                throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5173\u8054\u7684\u5546\u54c1");
            }
            List catelogNameList = fscOrderItemPOList.stream().map(FscOrderItemPO::getL1CatalogName).collect(Collectors.toList());
            UccbBatchQryCatalogRelListAbilityReqBO relListAbilityReqBO = new UccbBatchQryCatalogRelListAbilityReqBO();
            relListAbilityReqBO.setCatalogNames(catelogNameList);
            log.info("\u63a8\u9001\u7a0e\u63a7-\u67e5\u8be2\u4e1a\u52a1\u5c0f\u7c7b\u5165\u53c2:{}", (Object)relListAbilityReqBO);
            UccbBatchQryCatalogRelListAbilityRspBO rspBO = this.uccbBatchQryCatalogRelListAbilityService.batchQryCatalogRelList(relListAbilityReqBO);
            log.info("\u63a8\u9001\u7a0e\u63a7-\u67e5\u8be2\u4e1a\u52a1\u5c0f\u7c7b\u51fa\u53c2:{}", (Object)rspBO);
            if (ObjectUtil.isEmpty((Object)rspBO.getRows())) {
                throw new FscBusinessException("191000", "\u914d\u7f6e\u9879\u201cZFJS33\u5546\u54c1\u4e00\u7ea7\u7269\u6599\u5206\u7c7b\u4e0e\u62a5\u8d26\u7c7b\u76ee\u5bf9\u5e94\u5173\u7cfb\u201d\u6570\u636e\u4e0d\u5b8c\u6574\u3002");
            }
            for (UccbBatchQryCatalogRelListBO item : rspBO.getRows()) {
                if (!ObjectUtil.isEmpty((Object)item.getSalesReceiptsStatement()) && !ObjectUtil.isEmpty((Object)item.getCatalogIn()) && !ObjectUtil.isEmpty((Object)item.getCatalogOut())) continue;
                throw new FscBusinessException("191000", "\u914d\u7f6e\u9879\u201cZFJS33\u5546\u54c1\u4e00\u7ea7\u7269\u6599\u5206\u7c7b\u4e0e\u62a5\u8d26\u7c7b\u76ee\u5bf9\u5e94\u5173\u7cfb\u201d\u6570\u636e\u4e0d\u5b8c\u6574\u3002");
            }
        }
    }

    private void sendMq(Long orderId, FscBillInvoiceApplyAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(orderId);
        fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscComOrderListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

