/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.ability.api.FscBillSupCheckConfirmAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderFeedbackAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSupCheckConfirmAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSupCheckConfirmAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillSupCheckConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSupCheckConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSupCheckConfirmBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillSupCheckConfirmAbilityService"})
public class FscBillSupCheckConfirmAbilityServiceImpl
implements FscBillSupCheckConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSupCheckConfirmAbilityServiceImpl.class);
    @Autowired
    private FscBillSupCheckConfirmBusiService fscBillSupCheckConfirmBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Resource(name="fscFeedBackDownProvider")
    private ProxyMessageProducer fscFeedBackDownProvider;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Value(value="${FSC_FEED_BACK_DOWN_TOPIC:FSC_FEED_BACK_DOWN_TOPIC}")
    private String FSC_FEED_BACK_DOWN_TOPIC;
    @Value(value="${FSC_FEED_BACK_DOWN_TAG:*}")
    private String FSC_FEED_BACK_DOWN_TAG;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealSupCheckConfirm"})
    public FscBillSupCheckConfirmAbilityRspBO dealSupCheckConfirm(@RequestBody FscBillSupCheckConfirmAbilityReqBO reqBO) {
        this.verify(reqBO);
        FscBillSupCheckConfirmBusiReqBO busiReqBO = (FscBillSupCheckConfirmBusiReqBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillSupCheckConfirmBusiReqBO.class));
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            this.dealOrderCheck(busiReqBO, fscOrderPO);
        }
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setResult(reqBO.getResult());
        busiReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscBillSupCheckConfirmBusiRspBO busiRspBO = this.fscBillSupCheckConfirmBusiService.dealSupCheckConfirm(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191023", busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        this.feedBackDown(busiRspBO.getFscOrderPO(), busiRspBO.getAccepteOrderIdList(), reqBO.getSysTenantId());
        return new FscBillSupCheckConfirmAbilityRspBO();
    }

    private void verify(FscBillSupCheckConfirmAbilityReqBO reqBO) {
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getResult()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[result]\u4e3a\u7a7a");
        }
    }

    private void feedBackDown(FscOrderPO fscOrder, List<Long> accepteOrderIdList, Long sysTenantId) {
        if (FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrder.getMakeType()) && FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrder.getReceiveType())) {
            FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
            fscOrderRelationPo.setAcceptOrderIds(accepteOrderIdList);
            fscOrderRelationPo.setSysTenantId(sysTenantId);
            List fscOrderRelationPoList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
            if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPoList)) {
                HashSet<Long> fscOrderIdSet = new HashSet<Long>();
                for (FscOrderRelationPO fscOrderRelationPO : fscOrderRelationPoList) {
                    fscOrderIdSet.add(fscOrderRelationPO.getFscOrderId());
                }
                FscOrderPO fscOrderPo = new FscOrderPO();
                fscOrderPo.setFscOrderIds(new ArrayList(fscOrderIdSet));
                fscOrderPo.setSysTenantId(sysTenantId);
                List fscOrderPoList = this.fscOrderMapper.getList(fscOrderPo);
                if (!CollectionUtils.isEmpty((Collection)fscOrderPoList)) {
                    fscOrderPoList.forEach(fscOrderPO -> {
                        if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscBillStatus.PENDING_FEEDBACK.getCode().equals(fscOrderPO.getOrderState())) {
                            FscBillOrderFeedbackAbilityReqBO feedbackAbilityReqBO = new FscBillOrderFeedbackAbilityReqBO();
                            feedbackAbilityReqBO.setOrderId(fscOrderPO.getFscOrderId());
                            feedbackAbilityReqBO.setSysTenantId(fscOrderPO.getSysTenantId());
                            feedbackAbilityReqBO.setSysTenantName(fscOrderPO.getSysTenantName());
                            this.fscFeedBackDownProvider.send(new ProxyMessage(this.FSC_FEED_BACK_DOWN_TOPIC, this.FSC_FEED_BACK_DOWN_TAG, JSON.toJSONString((Object)feedbackAbilityReqBO)));
                        }
                    });
                }
            }
        }
    }

    private void sendMq(FscBillSupCheckConfirmAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscComOrderListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void dealOrderCheck(FscBillSupCheckConfirmBusiReqBO busiReqBO, FscOrderPO fscOrderPO) {
        FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
        fscAcceptOrderListQueryAtomReqBO.setRelId(Convert.toStr((Object)fscOrderPO.getFscOrderId()));
        FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
        if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
            throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
        }
        this.dealAccountRule(busiReqBO, fscOrderPO, fscAcceptOrderListQueryAtomRspBO);
    }

    private void dealAccountRule(FscBillSupCheckConfirmBusiReqBO busiReqBO, FscOrderPO fscOrderPO, FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO) {
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
            FscOrderInfoBO fscOrderInfoBO = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime)).get();
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
            FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
            fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
            fscShouldPayBO.setShouldPayNo(fscOrderPO.getOrderNo());
            fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
            fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
            fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
            fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
            fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
            fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
            fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
            fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
            fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
            fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
            fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
            fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
            fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO, fscOrderPO.getOrderSource()));
            fscShouldPayBOS.add(fscShouldPayBO);
            busiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            busiReqBO.setCreateShouldPayFlag(true);
        }
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO, Integer orderSource) {
        Calendar now = Calendar.getInstance();
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayNodeAccountDays()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayNodeAccountDays());
        }
        return now.getTime();
    }
}

