/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bill.ability.api.FscBillTaxDeaInvoiceAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillTaxDealInvoiceAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxDealInvoiceAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxDealInvoiceDetailBO;
import com.tydic.fsc.bill.ability.bo.FscInvoiceCallBackSourceInfoBO;
import com.tydic.fsc.bill.atom.api.FscSendFeeServiceOrderAtomService;
import com.tydic.fsc.bill.atom.api.FscSendSaleOrderAtomService;
import com.tydic.fsc.bill.atom.api.FscSendStockOrderAtomService;
import com.tydic.fsc.bill.atom.bo.FscSendFeeServiceOrderAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscSendFeeServiceOrderAtomRspBO;
import com.tydic.fsc.bill.atom.bo.FscSendSaleOrderAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscSendSaleOrderAtomRspBO;
import com.tydic.fsc.bill.atom.bo.FscSendStockOrderAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscSendStockOrderAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceUploadCrcExtBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscInvoiceInfoBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.busibase.atom.api.FscSendInvoiceMessageAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendMessageAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.SendMessageBO;
import com.tydic.fsc.busibase.atom.bo.SendMessageReceiverBO;
import com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillMailListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.FileUpLoad;
import com.tydic.umc.general.ability.api.UmcDycMemberQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityRspBO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillTaxDeaInvoiceAbilityService"})
public class FscBillTaxDeaInvoiceAbilityServiceImpl
implements FscBillTaxDeaInvoiceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillTaxDeaInvoiceAbilityServiceImpl.class);
    @Value(value="${changeSwitch:on}")
    private String changeSwitch;
    @Value(value="${beforeChangeUrl}")
    private String beforeChangeUrl;
    @Value(value="${afterChangeUrl}")
    private String afterChangeUrl;
    @Autowired
    private FileUpLoad fileUpLoad;
    @Autowired
    private FscBillInvoiceUploadCrcExtBusiService fscBillInvoiceUploadCrcExtBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillMailSyncAbilityService fscBillMailSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscSendStockOrderAtomService fscSendStockOrderAtomService;
    @Autowired
    private FscSendSaleOrderAtomService fscSendSaleOrderAtomService;
    @Autowired
    private FscSendFeeServiceOrderAtomService fscSendFeeServiceOrderAtomService;
    @Value(value="${secondOrgId.xh}")
    private Long SECONDORGID_XH;
    @Value(value="${TYPE_SWITCH:true}")
    private Boolean TYPE_SWITCH;
    @Autowired
    private UmcDycMemberQryDetailAbilityService umcDycMemberQryDetailAbilityService;
    @Autowired
    private FscSendInvoiceMessageAtomService fscSendInvoiceMessageAtomService;
    @Resource(name="fscSendStockOrderAtomProducer")
    private ProxyMessageProducer fscSendStockOrderAtomProducer;
    @Value(value="${SEND_STOCK_ORDER_ATOM_TOPIC:RSEND_STOCK_ORDER_ATOM_TOPIC}")
    private String SEND_STOCK_ORDER_ATOM_TOPIC;
    @Value(value="${SEND_STOCK_ORDER_ATOM_TAG:SEND_STOCK_ORDER_ATOM_TAG}")
    private String SEND_STOCK_ORDER_ATOM_TAG;
    @Resource(name="fscSendSaleOrderAtomProducer")
    private ProxyMessageProducer fscSendSaleOrderAtomProducer;
    @Value(value="${SEND_SALE_ORDER_ATOM_TOPIC:RSEND_SALE_ORDER_ATOM_TOPIC}")
    private String SEND_SALE_ORDER_ATOM_TOPIC;
    @Value(value="${SEND_SALE_ORDER_ATOM_TAG:SEND_SALE_ORDER_ATOM_TAG}")
    private String SEND_SALE_ORDER_ATOM_TAG;

    @PostMapping(value={"dealBillTaxReturnInvoice"})
    public FscBillTaxDealInvoiceAbilityRspBO dealBillTaxReturnInvoice(@RequestBody FscBillTaxDealInvoiceAbilityReqBO reqBO) {
        log.info("\u534e\u6da6\u7a0e\u63a7\u5f00\u7968\u56de\u8c03\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        this.val(reqBO, true);
        this.createDigitalElectricity(reqBO);
        return new FscBillTaxDealInvoiceAbilityRspBO();
    }

    private void val(FscBillTaxDealInvoiceAbilityReqBO reqBO, Boolean digitalElectricity) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getTaxNo())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[taxNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOldOrderNo() && !digitalElectricity.booleanValue()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[oldOrderNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderNo()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceDate()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDate]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCode()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceCode]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceNum()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceNum]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceDetail() || reqBO.getInvoiceDetail().size() == 0) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e3a\u7a7a");
        }
        List detail = reqBO.getInvoiceDetail();
        for (FscBillTaxDealInvoiceDetailBO fscBillTaxDealInvoiceDetailBO : detail) {
            if (StringUtils.isEmpty((CharSequence)fscBillTaxDealInvoiceDetailBO.getAmount())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]amount");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getItemName()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684itemName\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getItemNum()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684itemNum\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getItemPrice()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684itemPrice\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getItemTaxCode()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684itemTaxCode\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getItemUnit()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684itemUnit\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getTax()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684tax\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getTaxRate()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684taxRate\u4e3a\u7a7a");
            }
            if (digitalElectricity.booleanValue()) continue;
            if (CollectionUtils.isEmpty((Collection)fscBillTaxDealInvoiceDetailBO.getSourceInfoList())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684tax\u4e3a\u7a7a");
            }
            if (null != ((FscInvoiceCallBackSourceInfoBO)fscBillTaxDealInvoiceDetailBO.getSourceInfoList().get(0)).getRowId()) continue;
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684sourceInfoList\u7684RowId\u4e3a\u7a7a");
        }
    }

    private void sendMq(Long fscOrderId, Long sysTenantId, String sysTenantName) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        fscComOrderListSyncAbilityReqBO.setSysTenantId(sysTenantId);
        fscComOrderListSyncAbilityReqBO.setSysTenantName(sysTenantName);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscBillMailListSyncAbilityReqBO fscBillMailListSyncAbilityReqBO = new FscBillMailListSyncAbilityReqBO();
        fscBillMailListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        fscBillMailListSyncAbilityReqBO.setSysTenantId(sysTenantId);
        fscBillMailListSyncAbilityReqBO.setSysTenantName(sysTenantName);
        this.fscBillMailSyncAbilityService.syncBillMail(fscBillMailListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        fscComInvoiceListSyncAbilityReqBO.setSysTenantId(sysTenantId);
        fscComInvoiceListSyncAbilityReqBO.setSysTenantName(sysTenantName);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
    }

    private String upload(String url, String type) {
        url = url.replace(this.beforeChangeUrl, this.afterChangeUrl);
        URL urlBean = null;
        try {
            urlBean = new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfUrl\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)urlBean.openConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdf\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\uff1a" + e.getMessage());
        }
        conn.setConnectTimeout(3000);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = null;
        try {
            inputStream = conn.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        try {
            int ch;
            while ((ch = inputStream.read(buff, 0, 1024)) > 0) {
                byteArrayOutputStream.write(buff, 0, ch);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage());
            }
            throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        byte[] b = byteArrayOutputStream.toByteArray();
        String fileUrl = this.fileUpLoad.upload("\u7535\u5b50\u53d1\u7968-" + System.currentTimeMillis(), b, "." + type);
        log.info("fastdfs\u8fd4\u56defileUrl:" + fileUrl);
        return fileUrl;
    }

    private void createNormal(FscBillTaxDealInvoiceAbilityReqBO reqBO) {
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = new FscBillInvoiceUploadBusiReqBO();
        fscBillInvoiceUploadBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        ArrayList<FscInvoiceInfoBO> fscInvoiceInfoBOS = new ArrayList<FscInvoiceInfoBO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setOrderNo(reqBO.getOldOrderNo());
        fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        Long fscOrderId = fscOrderPO.getFscOrderId();
        fscOrderIds.add(fscOrderId);
        fscBillInvoiceUploadBusiReqBO.setFscOrderId(fscOrderId);
        fscBillInvoiceUploadBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        FscInvoiceInfoBO fscInvoiceInfoBO = new FscInvoiceInfoBO();
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(fscOrderId);
        fscOrderInvoicePO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        fscInvoiceInfoBO.setBuyName(fscOrderInvoicePO.getBuyName());
        fscInvoiceInfoBO.setTaxNo(fscOrderInvoicePO.getTaxNo());
        fscInvoiceInfoBO.setBank(fscOrderInvoicePO.getBank());
        fscInvoiceInfoBO.setAccount(fscOrderInvoicePO.getAccount());
        fscInvoiceInfoBO.setPhone(fscOrderInvoicePO.getPhone());
        fscInvoiceInfoBO.setAddress(fscOrderInvoicePO.getAddress());
        fscInvoiceInfoBO.setFscOrderId(fscOrderId);
        fscInvoiceInfoBO.setInvoiceNo(reqBO.getInvoiceNum());
        fscInvoiceInfoBO.setInvoiceCode(reqBO.getInvoiceCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String billDate = sdf.format(reqBO.getInvoiceDate());
        fscInvoiceInfoBO.setBillDate(billDate);
        fscInvoiceInfoBO.setInvoiceOutNo(reqBO.getOrderNo());
        BigDecimal totalsAmount = new BigDecimal(0);
        BigDecimal taxAmt = new BigDecimal(0);
        for (Object fscBillTaxDealInvoiceDetailBO : reqBO.getInvoiceDetail()) {
            taxAmt = taxAmt.add(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTax()));
            totalsAmount = totalsAmount.add(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getAmount()));
        }
        fscInvoiceInfoBO.setUntaxAmt(totalsAmount);
        fscInvoiceInfoBO.setTaxAmt(taxAmt);
        fscInvoiceInfoBO.setAmt(totalsAmount.add(taxAmt));
        fscInvoiceInfoBO.setInvoiceCategory(fscOrderInvoicePO.getInvoiceCategory());
        fscInvoiceInfoBO.setInvoiceType(fscOrderInvoicePO.getInvoiceType());
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            ArrayList<InvoiceItemBO> invoiceItemBOS = new ArrayList<InvoiceItemBO>();
            for (FscBillTaxDealInvoiceDetailBO fscBillTaxDealInvoiceDetailBO : reqBO.getInvoiceDetail()) {
                String[] rowIds;
                for (String rowId : rowIds = ((FscInvoiceCallBackSourceInfoBO)fscBillTaxDealInvoiceDetailBO.getSourceInfoList().get(0)).getRowId().split(",")) {
                    FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
                    fscOrderItemPO.setFscOrderId(fscOrderId);
                    fscOrderItemPO.setId(Long.valueOf(Long.parseLong(rowId)));
                    fscOrderItemPO.setSysTenantId(reqBO.getSysTenantId());
                    fscOrderItemPO = this.fscOrderItemMapper.getModelBy(fscOrderItemPO);
                    if (ObjectUtil.isEmpty((Object)fscOrderItemPO)) continue;
                    InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                    invoiceItemBO.setOrderId(fscOrderItemPO.getOrderId());
                    invoiceItemBO.setSkuId(fscOrderItemPO.getSkuId());
                    invoiceItemBO.setAcceptOrderId(fscOrderItemPO.getAcceptOrderId());
                    invoiceItemBO.setSkuName(fscBillTaxDealInvoiceDetailBO.getItemName());
                    invoiceItemBO.setModel(fscOrderItemPO.getModel());
                    invoiceItemBO.setSpec(fscOrderItemPO.getSpec());
                    invoiceItemBO.setUnit(fscBillTaxDealInvoiceDetailBO.getItemUnit());
                    invoiceItemBO.setNum(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getItemNum()));
                    invoiceItemBO.setPrice(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getItemPrice()));
                    invoiceItemBO.setOrderItemId(fscOrderItemPO.getOrderItemId());
                    invoiceItemBO.setAmt(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getAmount()).add(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTax())));
                    invoiceItemBO.setUntaxAmt(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getAmount()));
                    invoiceItemBO.setTaxAmt(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTax()));
                    invoiceItemBO.setTax(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTaxRate()));
                    invoiceItemBO.setTaxCode(fscBillTaxDealInvoiceDetailBO.getItemTaxCode());
                    invoiceItemBOS.add(invoiceItemBO);
                }
            }
            fscInvoiceInfoBO.setInvoiceItemBOS(invoiceItemBOS);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPdfUrl())) {
            if (this.changeSwitch.equals("on")) {
                reqBO.setPdfUrl(this.upload(reqBO.getPdfUrl(), "pdf"));
            }
            AttachmentBO attachmentBO = new AttachmentBO();
            attachmentBO.setAttachmentUrl(reqBO.getPdfUrl());
            attachmentBO.setAttachmentName("\u53d1\u7968\u9644\u4ef6");
            ArrayList<AttachmentBO> attachmentList = new ArrayList<AttachmentBO>(1);
            attachmentList.add(attachmentBO);
            fscInvoiceInfoBO.setAttachmentList(attachmentList);
        }
        fscInvoiceInfoBOS.add(fscInvoiceInfoBO);
        fscBillInvoiceUploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBOS);
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadCrcExtBusiService.dealInvoiceUpload(fscBillInvoiceUploadBusiReqBO);
        if (!fscBillInvoiceUploadBusiRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("191026", fscBillInvoiceUploadBusiRspBO.getRespDesc());
        }
        if (fscBillInvoiceUploadBusiRspBO.getIsFinish().booleanValue()) {
            FscOrderPO fscOrderPO1 = new FscOrderPO();
            fscOrderPO1.setFscOrderId(fscBillInvoiceUploadBusiReqBO.getFscOrderId());
            fscOrderPO1.setSysTenantId(reqBO.getSysTenantId());
            fscOrderPO1 = this.fscOrderMapper.getModelBy(fscOrderPO1);
            if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPO1.getOrderFlow())) {
                FscSendFeeServiceOrderAtomReqBO fscSendFeeServiceOrderAtomReqBO = (FscSendFeeServiceOrderAtomReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSendFeeServiceOrderAtomReqBO.class));
                fscSendFeeServiceOrderAtomReqBO.setFscOrderId(fscBillInvoiceUploadBusiReqBO.getFscOrderId());
                log.info("\u63a8\u9001\u6570\u63a7\u5b8c\u6210-\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u5165\u53c2:{}", (Object)fscSendFeeServiceOrderAtomReqBO);
                FscSendFeeServiceOrderAtomRspBO fscSendFeeServiceOrderAtomRspBO = this.fscSendFeeServiceOrderAtomService.sendFeeServiceOrder(fscSendFeeServiceOrderAtomReqBO);
                if (!"0000".equals(fscSendFeeServiceOrderAtomRspBO.getRespCode())) {
                    log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u5931\u8d25:{},\u7ed3\u7b97\u5355\u53f7\uff1a{}", (Object)fscBillInvoiceUploadBusiReqBO.getFscOrderId());
                }
            } else {
                this.sendMessage(fscBillInvoiceUploadBusiReqBO.getFscOrderId(), reqBO.getSysTenantId());
                FscSendSaleOrderAtomReqBO fscSendSaleOrderAtomReqBO = (FscSendSaleOrderAtomReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSendSaleOrderAtomReqBO.class));
                fscSendSaleOrderAtomReqBO.setFscOrderId(fscBillInvoiceUploadBusiReqBO.getFscOrderId());
                log.info("\u63a8\u9001\u6570\u63a7\u5b8c\u6210-\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9500\u552e\u7ed3\u7b97\u5355\u5165\u53c2:{}", (Object)fscSendSaleOrderAtomReqBO);
                FscSendSaleOrderAtomRspBO fscSendSaleOrderAtomRspBO = this.fscSendSaleOrderAtomService.sendSaleOrderToFinancialSharing(fscSendSaleOrderAtomReqBO);
                if (!"0000".equals(fscSendSaleOrderAtomRspBO.getRespCode())) {
                    log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9500\u552e\u7ed3\u7b97\u5355\u5931\u8d25:{},\u7ed3\u7b97\u5355\u53f7\uff1a{}", (Object)fscBillInvoiceUploadBusiReqBO.getFscOrderId());
                }
                FscSendStockOrderAtomReqBO fscSendStockOrderAtomReqBO = (FscSendStockOrderAtomReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSendStockOrderAtomReqBO.class));
                fscSendStockOrderAtomReqBO.setFscOrderId(fscBillInvoiceUploadBusiReqBO.getFscOrderId());
                log.info("\u63a8\u9001\u6570\u63a7\u5b8c\u6210-\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9500\u552e\u51fa\u5165\u5e93\u5355\u5165\u53c2:{}", (Object)fscSendStockOrderAtomReqBO);
                FscSendStockOrderAtomRspBO fscSendStockOrderAtomRspBO = this.fscSendStockOrderAtomService.sendStockOrderToFinancialSharing(fscSendStockOrderAtomReqBO);
                if (!"0000".equals(fscSendStockOrderAtomRspBO.getRespCode())) {
                    log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9500\u552e\u51fa\u5165\u5e93\u5355\u5931\u8d25:{},\u7ed3\u7b97\u5355\u53f7\uff1a{}", (Object)fscBillInvoiceUploadBusiReqBO.getFscOrderId());
                }
            }
        }
        for (Long each : fscOrderIds) {
            this.sendMq(each, reqBO.getSysTenantId(), reqBO.getSysTenantName());
        }
    }

    private void createDigitalElectricity(FscBillTaxDealInvoiceAbilityReqBO reqBO) {
        AttachmentBO attachmentBO;
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = new FscBillInvoiceUploadBusiReqBO();
        fscBillInvoiceUploadBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        ArrayList<FscInvoiceInfoBO> fscInvoiceInfoBOS = new ArrayList<FscInvoiceInfoBO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        FscOrderPO fscOrderPO = new FscOrderPO();
        String orderNo = "";
        String[] orderStr = reqBO.getOrderNo().split("-");
        orderNo = orderStr.length > 3 ? orderStr[0] + "-" + orderStr[1] + "-" + orderStr[2] : (orderStr.length == 3 ? reqBO.getOrderNo() : (orderStr.length == 2 ? orderStr[0] : reqBO.getOrderNo()));
        fscOrderPO.setOrderNo(orderNo);
        fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("199998", "\u5f53\u524d\u5e93\u65e0\u6570\u636e");
        }
        Long fscOrderId = fscOrderPO.getFscOrderId();
        fscOrderIds.add(fscOrderId);
        fscBillInvoiceUploadBusiReqBO.setFscOrderId(fscOrderId);
        fscBillInvoiceUploadBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        FscInvoiceInfoBO fscInvoiceInfoBO = new FscInvoiceInfoBO();
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(fscOrderId);
        fscOrderInvoicePO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        fscInvoiceInfoBO.setBuyName(fscOrderInvoicePO.getBuyName());
        fscInvoiceInfoBO.setTaxNo(fscOrderInvoicePO.getTaxNo());
        fscInvoiceInfoBO.setBank(fscOrderInvoicePO.getBank());
        fscInvoiceInfoBO.setAccount(fscOrderInvoicePO.getAccount());
        fscInvoiceInfoBO.setPhone(fscOrderInvoicePO.getPhone());
        fscInvoiceInfoBO.setAddress(fscOrderInvoicePO.getAddress());
        fscInvoiceInfoBO.setFscOrderId(fscOrderId);
        fscInvoiceInfoBO.setInvoiceNo(reqBO.getDigitalInvoiceNum());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String billDate = sdf.format(reqBO.getInvoiceDate());
        fscInvoiceInfoBO.setBillDate(billDate);
        fscInvoiceInfoBO.setInvoiceOutNo(reqBO.getOrderNo());
        BigDecimal totalsAmount = new BigDecimal(0);
        BigDecimal taxAmt = new BigDecimal(0);
        for (Object fscBillTaxDealInvoiceDetailBO : reqBO.getInvoiceDetail()) {
            taxAmt = taxAmt.add(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTax()));
            totalsAmount = totalsAmount.add(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getAmount()));
        }
        fscInvoiceInfoBO.setUntaxAmt(totalsAmount);
        fscInvoiceInfoBO.setTaxAmt(taxAmt);
        fscInvoiceInfoBO.setAmt(totalsAmount.add(taxAmt));
        fscInvoiceInfoBO.setInvoiceCategory(fscOrderInvoicePO.getInvoiceCategory());
        fscInvoiceInfoBO.setInvoiceType(fscOrderInvoicePO.getInvoiceType());
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            ArrayList<InvoiceItemBO> invoiceItemBOS = new ArrayList<InvoiceItemBO>();
            for (FscBillTaxDealInvoiceDetailBO fscBillTaxDealInvoiceDetailBO : reqBO.getInvoiceDetail()) {
                FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
                fscOrderItemPO.setFscOrderId(fscOrderId);
                fscOrderItemPO.setId(Long.valueOf(Long.parseLong(fscBillTaxDealInvoiceDetailBO.getRowId())));
                fscOrderItemPO.setSysTenantId(reqBO.getSysTenantId());
                fscOrderItemPO = this.fscOrderItemMapper.getModelBy(fscOrderItemPO);
                if (ObjectUtil.isEmpty((Object)fscOrderItemPO)) continue;
                InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                invoiceItemBO.setOrderId(fscOrderItemPO.getOrderId());
                invoiceItemBO.setSkuId(fscOrderItemPO.getSkuId());
                invoiceItemBO.setAcceptOrderId(fscOrderItemPO.getAcceptOrderId());
                invoiceItemBO.setSkuName(fscBillTaxDealInvoiceDetailBO.getItemName());
                invoiceItemBO.setModel(fscOrderItemPO.getModel());
                invoiceItemBO.setSpec(fscOrderItemPO.getSpec());
                invoiceItemBO.setUnit(fscBillTaxDealInvoiceDetailBO.getItemUnit());
                invoiceItemBO.setNum(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getItemNum()));
                invoiceItemBO.setPrice(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getItemPrice()));
                invoiceItemBO.setOrderItemId(fscOrderItemPO.getOrderItemId());
                invoiceItemBO.setAmt(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getAmount()).add(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTax())));
                invoiceItemBO.setUntaxAmt(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getAmount()));
                invoiceItemBO.setTaxAmt(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTax()));
                invoiceItemBO.setTax(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTaxRate()));
                invoiceItemBO.setTaxCode(fscBillTaxDealInvoiceDetailBO.getItemTaxCode());
                invoiceItemBO.setXcCategory(fscOrderItemPO.getXcCategory());
                invoiceItemBO.setXcSku(fscOrderItemPO.getXcSku());
                invoiceItemBOS.add(invoiceItemBO);
            }
            fscInvoiceInfoBO.setInvoiceItemBOS(invoiceItemBOS);
        }
        ArrayList<AttachmentBO> attachmentList = new ArrayList<AttachmentBO>(1);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPdfUrl())) {
            if (this.changeSwitch.equals("on")) {
                reqBO.setPdfUrl(this.upload(reqBO.getPdfUrl(), "pdf"));
            }
            attachmentBO = new AttachmentBO();
            attachmentBO.setAttachmentUrl(reqBO.getPdfUrl());
            log.info("\u53d1\u7968pdf--url:{}", (Object)reqBO.getPdfUrl());
            attachmentBO.setAttachmentType(FscConstants.AttachmentType.INVOICE);
            attachmentBO.setAttachmentName("\u53d1\u7968pdf\u9644\u4ef6");
            if (attachmentBO.getAttachmentUrl().indexOf("/null") != -1) {
                throw new FscBusinessException("191031", "\u53d1\u7968\u9644\u4ef6\u5730\u5740\u4e0a\u4f20\u9519\u8bef");
            }
            attachmentList.add(attachmentBO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOfdUrl())) {
            if (this.changeSwitch.equals("on")) {
                reqBO.setOfdUrl(this.upload(reqBO.getOfdUrl(), "ofd"));
            }
            attachmentBO = new AttachmentBO();
            attachmentBO.setAttachmentUrl(reqBO.getOfdUrl());
            log.info("\u53d1\u7968ofd--url:{}", (Object)reqBO.getOfdUrl());
            attachmentBO.setAttachmentType(FscConstants.AttachmentType.OFD);
            attachmentBO.setAttachmentName("\u53d1\u7968ofd\u9644\u4ef6");
            if (attachmentBO.getAttachmentUrl().indexOf("/null") != -1) {
                throw new FscBusinessException("191031", "\u53d1\u7968\u9644\u4ef6\u5730\u5740\u4e0a\u4f20\u9519\u8bef");
            }
            attachmentList.add(attachmentBO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getXmlUrl())) {
            if (this.changeSwitch.equals("on")) {
                reqBO.setXmlUrl(this.upload(reqBO.getXmlUrl(), "zip"));
            }
            attachmentBO = new AttachmentBO();
            attachmentBO.setAttachmentUrl(reqBO.getXmlUrl());
            log.info("\u53d1\u7968xml--url:{}", (Object)reqBO.getXmlUrl());
            attachmentBO.setAttachmentName("\u53d1\u7968xml\u9644\u4ef6");
            if (attachmentBO.getAttachmentUrl().indexOf("/null") != -1) {
                throw new FscBusinessException("191031", "\u53d1\u7968\u9644\u4ef6\u5730\u5740\u4e0a\u4f20\u9519\u8bef");
            }
            attachmentBO.setAttachmentType(FscConstants.AttachmentType.XML);
            attachmentList.add(attachmentBO);
        }
        if (!ObjectUtil.isEmpty(attachmentList)) {
            fscInvoiceInfoBO.setAttachmentList(attachmentList);
        }
        fscInvoiceInfoBOS.add(fscInvoiceInfoBO);
        fscBillInvoiceUploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBOS);
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadCrcExtBusiService.dealInvoiceUpload(fscBillInvoiceUploadBusiReqBO);
        if (!fscBillInvoiceUploadBusiRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("191026", fscBillInvoiceUploadBusiRspBO.getRespDesc());
        }
        if (fscBillInvoiceUploadBusiRspBO.getIsFinish().booleanValue()) {
            FscOrderPO fscOrderPO1 = new FscOrderPO();
            fscOrderPO1.setFscOrderId(fscBillInvoiceUploadBusiReqBO.getFscOrderId());
            fscOrderPO1.setSysTenantId(reqBO.getSysTenantId());
            fscOrderPO1 = this.fscOrderMapper.getModelBy(fscOrderPO1);
            if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPO1.getOrderFlow())) {
                FscSendFeeServiceOrderAtomReqBO fscSendFeeServiceOrderAtomReqBO = (FscSendFeeServiceOrderAtomReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSendFeeServiceOrderAtomReqBO.class));
                fscSendFeeServiceOrderAtomReqBO.setFscOrderId(fscBillInvoiceUploadBusiReqBO.getFscOrderId());
                log.info("\u63a8\u9001\u6570\u63a7\u5b8c\u6210-\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u5165\u53c2:{}", (Object)fscSendFeeServiceOrderAtomReqBO);
                FscSendFeeServiceOrderAtomRspBO fscSendFeeServiceOrderAtomRspBO = this.fscSendFeeServiceOrderAtomService.sendFeeServiceOrder(fscSendFeeServiceOrderAtomReqBO);
                if (!"0000".equals(fscSendFeeServiceOrderAtomRspBO.getRespCode())) {
                    log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u5931\u8d25:{},\u7ed3\u7b97\u5355\u53f7\uff1a{}", (Object)fscBillInvoiceUploadBusiReqBO.getFscOrderId());
                }
            } else {
                this.sendMessage(fscBillInvoiceUploadBusiReqBO.getFscOrderId(), reqBO.getSysTenantId());
                FscSendSaleOrderAtomReqBO fscSendSaleOrderAtomReqBO = (FscSendSaleOrderAtomReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSendSaleOrderAtomReqBO.class));
                fscSendSaleOrderAtomReqBO.setFscOrderId(fscBillInvoiceUploadBusiReqBO.getFscOrderId());
                log.info("\u63a8\u9001\u6570\u63a7\u5b8c\u6210-\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9500\u552e\u7ed3\u7b97\u5355\u5165\u53c2:{}", (Object)fscSendSaleOrderAtomReqBO);
                ProxySendResult proxySendResult = this.fscSendSaleOrderAtomProducer.send(new ProxyMessage(this.SEND_SALE_ORDER_ATOM_TOPIC, this.SEND_SALE_ORDER_ATOM_TAG, JSONObject.toJSONString((Object)((Object)fscSendSaleOrderAtomReqBO))));
                if (!"SEND_OK".equals(proxySendResult.getStatus())) {
                    log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9500\u552e\u7ed3\u7b97\u5355MQ\u5931\u8d25");
                }
                FscSendStockOrderAtomReqBO fscSendStockOrderAtomReqBO = (FscSendStockOrderAtomReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSendStockOrderAtomReqBO.class));
                fscSendStockOrderAtomReqBO.setFscOrderId(fscBillInvoiceUploadBusiReqBO.getFscOrderId());
                log.info("\u63a8\u9001\u6570\u63a7\u5b8c\u6210-\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9500\u552e\u51fa\u5165\u5e93\u5355\u5165\u53c2:{}", (Object)fscSendStockOrderAtomReqBO);
                ProxySendResult proxySendResult1 = this.fscSendStockOrderAtomProducer.send(new ProxyMessage(this.SEND_STOCK_ORDER_ATOM_TOPIC, this.SEND_STOCK_ORDER_ATOM_TAG, JSONObject.toJSONString((Object)((Object)fscSendStockOrderAtomReqBO))));
                if (!"SEND_OK".equals(proxySendResult1.getStatus())) {
                    log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9500\u552e\u51fa\u5165\u5e93\u5355MQ\u5931\u8d25");
                }
            }
        }
        for (Long each : fscOrderIds) {
            this.sendMq(each, reqBO.getSysTenantId(), reqBO.getSysTenantName());
        }
    }

    private void sendMessage(Long fscOrderId, Long sysTenantId) {
        FscOrderPO selectPo = new FscOrderPO();
        selectPo.setFscOrderId(fscOrderId);
        selectPo.setSysTenantId(sysTenantId);
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(selectPo);
        log.info("\u5f00\u7968\u5b8c\u6210\u90ae\u4ef6\u7ed3\u7b97\u5355\u53c2\u6570:{}", (Object)fscOrderPO.getOrderState());
        FscSendMessageAtomReqBO fscSendMessageAtomReqBO = new FscSendMessageAtomReqBO();
        ArrayList<SendMessageBO> sendMessageBOList = new ArrayList<SendMessageBO>();
        SendMessageBO sendMessageBO = new SendMessageBO();
        sendMessageBO.setFscOrderNo(fscOrderPO.getOrderNo());
        sendMessageBO.setPurchaserName(fscOrderPO.getPurchaserName());
        sendMessageBO.setSupplierName(fscOrderPO.getSupplierName());
        sendMessageBO.setTaskCode("INVOICE_FINISH_NOTICE");
        sendMessageBO.setSendId("1");
        sendMessageBO.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        Long receiverId = ObjectUtil.isEmpty((Object)fscOrderPO.getSwapUserId()) ? fscOrderPO.getCreateOperId() : fscOrderPO.getSwapUserId();
        UmcDycMemberQryDetailAbilityReqBO umcDycMemberQryDetailAbilityReqBO = new UmcDycMemberQryDetailAbilityReqBO();
        umcDycMemberQryDetailAbilityReqBO.setMemId(receiverId);
        UmcDycMemberQryDetailAbilityRspBO umcDycMemberQryDetailAbilityRspBO = this.umcDycMemberQryDetailAbilityService.qryMemberDetail(umcDycMemberQryDetailAbilityReqBO);
        if (!ObjectUtil.isEmpty((Object)umcDycMemberQryDetailAbilityRspBO.getMemberBO().getRegEmail())) {
            ArrayList<SendMessageReceiverBO> sendMessageReceiverBOList = new ArrayList<SendMessageReceiverBO>();
            SendMessageReceiverBO sendMessageReceiverBO = new SendMessageReceiverBO();
            sendMessageReceiverBO.setReceiverId(String.valueOf(receiverId));
            sendMessageReceiverBO.setReceiverName(fscOrderPO.getCreateOperName());
            sendMessageReceiverBO.setEMail(umcDycMemberQryDetailAbilityRspBO.getMemberBO().getRegEmail());
            sendMessageReceiverBOList.add(sendMessageReceiverBO);
            sendMessageBO.setReceiverBOList(sendMessageReceiverBOList);
            sendMessageBOList.add(sendMessageBO);
            fscSendMessageAtomReqBO.setSendMessageBOList(sendMessageBOList);
            fscSendMessageAtomReqBO.setSysTenantId(sysTenantId);
            log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscSendMessageAtomReqBO));
            this.fscSendInvoiceMessageAtomService.sendMessageAtomService(fscSendMessageAtomReqBO);
        } else {
            log.info("\u4e3a\u67e5\u8be2\u5230\u90ae\u7bb1:\u7ed3\u7b97\u5355\uff1a{}", (Object)fscOrderPO.getOrderNo());
        }
    }
}

