/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.bill.ability.api.FscBillAutoSignAbilityService;
import com.tydic.fsc.bill.ability.api.FscGetInvoiceDataAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillAutoSignAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGetInvoiceDataAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGetInvoiceDataAbilityRspBO;
import com.tydic.fsc.bill.atom.api.FscFileUploadOSSByUrlAtomService;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceUploadBusiService;
import com.tydic.fsc.bill.busi.api.FscBillOrderDescUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderDescUpdateBusiReqBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscInvoiceInfoBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.busibase.atom.api.FscSendInvoiceMessageAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendMessageAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.SendMessageBO;
import com.tydic.fsc.busibase.atom.bo.SendMessageReceiverBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemSkuRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoListRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.busibase.external.api.esb.FscGetInvoiceInfoExternalService;
import com.tydic.fsc.busibase.external.api.esb.FscGetInvoiceInfoItemExternalService;
import com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceDeleteSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillMailListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceDeleteSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.umc.general.ability.api.UmcDycMemberQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscGetInvoiceDataAbilityService"})
public class FscGetInvoiceDataAbilityServiceImpl
implements FscGetInvoiceDataAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscGetInvoiceDataAbilityServiceImpl.class);
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComInvoiceDeleteSyncAbilityService fscComInvoiceDeleteSyncAbilityService;
    @Autowired
    private FscBillInvoiceUploadBusiService fscBillInvoiceUploadBusiService;
    @Autowired
    private FscGetInvoiceInfoExternalService fscGetInvoiceInfoExternalService;
    @Autowired
    private FscGetInvoiceInfoItemExternalService fscGetInvoiceInfoItemExternalService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscBillMailSyncAbilityService fscBillMailSyncAbilityService;
    @Autowired
    private FscBillAutoSignAbilityService fscBillAutoSignAbilityService;
    @Autowired
    private FscBillOrderDescUpdateBusiService fscBillOrderDescUpdateBusiService;
    @Autowired
    private FscFileUploadOSSByUrlAtomService fscFileUploadOSSByUrlAtomService;
    @Autowired
    private FscSendInvoiceMessageAtomService fscSendInvoiceMessageAtomService;
    @Value(value="#{'${ecom.invoice.convertUrl.supplierId:}'.split(',')}")
    private List<String> convertUrlSupplierIds;
    @Value(value="${JD_SUP_ID:100055}")
    private Long JD_SUP_ID;
    @Autowired
    private UmcDycMemberQryDetailAbilityService umcDycMemberQryDetailAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    private static final String AUTO_SIGN = "0";
    private static final String BUSI_NAME = "\u83b7\u53d6\u7535\u5546\u53d1\u7968";
    private static final String NOT_NEED_INVOICE_INFO = "0";

    @PostMapping(value={"getInvoiceData"})
    public FscGetInvoiceDataAbilityRspBO getInvoiceData(@RequestBody FscGetInvoiceDataAbilityReqBO reqBO) {
        this.val(reqBO);
        FscGetInvoiceInfoReqBO fscGetInvoiceInfoReqBO = new FscGetInvoiceInfoReqBO();
        if (reqBO.getSourceType() == 0) {
            fscGetInvoiceInfoReqBO.setMarkId(String.valueOf(reqBO.getFscOrderId()));
        } else {
            fscGetInvoiceInfoReqBO.setMarkId(reqBO.getRedInvoiceApplyId());
        }
        fscGetInvoiceInfoReqBO.setSupplierId(String.valueOf(reqBO.getSupplierId()));
        fscGetInvoiceInfoReqBO.setProOrgId(String.valueOf(reqBO.getProOrgId()));
        fscGetInvoiceInfoReqBO.setPurchaseId(String.valueOf(reqBO.getPurchaseId()));
        fscGetInvoiceInfoReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscGetInvoiceInfoRspBO invoiceInfo = this.fscGetInvoiceInfoExternalService.getInvoiceInfo(fscGetInvoiceInfoReqBO);
        if (!"0000".equals(invoiceInfo.getRespCode())) {
            throw new FscBusinessException("191031", invoiceInfo.getRespDesc());
        }
        List invoiceInfoResultList = invoiceInfo.getResult();
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePo.setSysTenantId(reqBO.getSysTenantId());
        fscOrderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
        if (null == fscOrderInvoicePo) {
            throw new FscBusinessException("191031", "\u67e5\u8be2\u4e3b\u5355\u53d1\u7968\u4e3a\u7a7a");
        }
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderItemPo.setSysTenantId(reqBO.getSysTenantId());
        List fscOrderItemPos = this.fscOrderItemMapper.getListBySkuNumNotZero(fscOrderItemPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemPos)) {
            throw new FscBusinessException("191031", "\u67e5\u8be2\u4e3b\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        Boolean isAutoSign = this.isAutoSign(reqBO);
        ArrayList<FscInvoiceInfoBO> fscInvoiceInfoBos = new ArrayList<FscInvoiceInfoBO>();
        if (!CollectionUtils.isEmpty((Collection)invoiceInfoResultList)) {
            for (FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO : invoiceInfoResultList) {
                FscInvoiceInfoBO fscInvoiceInfoBO = this.createEntity(fscGetInvoiceInfoListRspBO, reqBO, fscOrderInvoicePo, fscOrderItemPos);
                fscInvoiceInfoBos.add(fscInvoiceInfoBO);
            }
        }
        FscOrderPO sendMessageFscOrderPO = new FscOrderPO();
        sendMessageFscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        sendMessageFscOrderPO = this.fscOrderMapper.getModelBy(sendMessageFscOrderPO);
        Boolean isModifyOrderSate = true;
        if (1002 != sendMessageFscOrderPO.getOrderState() && 1003 != sendMessageFscOrderPO.getOrderState()) {
            isModifyOrderSate = this.checkCfcParam(fscInvoiceInfoBos, sendMessageFscOrderPO, fscOrderItemPos, reqBO.getSysTenantId());
        }
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = new FscBillInvoiceUploadBusiReqBO();
        fscBillInvoiceUploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBos);
        fscBillInvoiceUploadBusiReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscBillInvoiceUploadBusiReqBO.setIsModifyOrderSate(isModifyOrderSate);
        fscBillInvoiceUploadBusiReqBO.setBusiName(BUSI_NAME);
        fscBillInvoiceUploadBusiReqBO.setCurStatus(FscBillStatus.INVOICING_SUBMISSION.getCode());
        fscBillInvoiceUploadBusiReqBO.setSourceType(reqBO.getSourceType());
        fscBillInvoiceUploadBusiReqBO.setRedInvoiceApplyId(reqBO.getRedInvoiceApplyId());
        fscBillInvoiceUploadBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadBusiService.dealInvoiceUpload(fscBillInvoiceUploadBusiReqBO);
        if (!"0000".equals(fscBillInvoiceUploadBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191031", fscBillInvoiceUploadBusiRspBO.getRespDesc());
        }
        this.updateOrderDesc(reqBO.getFscOrderId(), FscConstants.ORDER_INVOICING_STATE.SUCCESS, "", reqBO.getSysTenantId());
        this.sendMq(reqBO);
        this.sendMessage(sendMessageFscOrderPO);
        if (isAutoSign.booleanValue()) {
            this.autoSign(reqBO);
        }
        return new FscGetInvoiceDataAbilityRspBO();
    }

    private void autoSign(FscGetInvoiceDataAbilityReqBO reqBO) {
        FscBillAutoSignAbilityReqBO fscBillAutoSignAbilityReqBO = new FscBillAutoSignAbilityReqBO();
        fscBillAutoSignAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscBillAutoSignAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
        this.fscBillAutoSignAbilityService.dealAutoSign(fscBillAutoSignAbilityReqBO);
    }

    private boolean isAutoSign(FscGetInvoiceDataAbilityReqBO reqBO) {
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
            FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
            fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("operinvoice_sign");
            fscCfcUniteParamQryListDetailExternalReqBO.setRelId(String.valueOf(reqBO.getProOrgId()));
            fscCfcUniteParamQryListDetailExternalReqBO.setSysTenantId(reqBO.getSysTenantId());
            FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
            if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
                throw new FscBusinessException("191031", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
            }
            if (StringUtils.isBlank((String)fscCfcUniteParamQryListDetailExternalRspBO.getReqSign())) {
                throw new FscBusinessException("191031", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[operinvoice_sign]\u8fd4\u56de[reqSign]\u4e3a\u7a7a");
            }
            return "0".equals(fscCfcUniteParamQryListDetailExternalRspBO.getReqSign());
        }
        return false;
    }

    private boolean needInvoiceInfos(Long sysTenantId) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_upload_details_2");
        fscCfcUniteParamQryListDetailExternalReqBO.setSysTenantId(sysTenantId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191031", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getReqDetailed())) {
            String reqDetailed = fscCfcUniteParamQryListDetailExternalRspBO.getReqDetailed();
            return !"0".equals(reqDetailed);
        }
        return true;
    }

    private void val(FscGetInvoiceDataAbilityReqBO reqBO) {
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getReceiveType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[receiveType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getMakeType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[makeType]\u4e3a\u7a7a");
        }
    }

    private FscInvoiceInfoBO createEntity(FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO, FscGetInvoiceDataAbilityReqBO reqBO, FscOrderInvoicePO fscOrderInvoicePo, List<FscOrderItemPO> fscOrderItemPos) {
        AttachmentBO attachmentBo;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        FscInvoiceInfoBO fscInvoiceInfoBO = new FscInvoiceInfoBO();
        ArrayList invoiceItemBOList = new ArrayList();
        if (!this.needInvoiceInfos(reqBO.getSysTenantId())) {
            fscOrderItemPos.forEach(fscOrderItemPo -> {
                InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                invoiceItemBO.setFscOrderId(fscOrderItemPo.getFscOrderId());
                invoiceItemBO.setAcceptOrderId(fscOrderItemPo.getAcceptOrderId());
                invoiceItemBO.setOrderId(fscOrderItemPo.getOrderId());
                invoiceItemBO.setOrderItemId(fscOrderItemPo.getOrderItemId());
                invoiceItemBO.setSkuId(fscOrderItemPo.getSkuId());
                invoiceItemBO.setSkuName(fscOrderItemPo.getSkuName());
                invoiceItemBO.setSpec(fscOrderItemPo.getSpec());
                invoiceItemBO.setModel(fscOrderItemPo.getModel());
                invoiceItemBO.setPrice(fscOrderItemPo.getPrice());
                invoiceItemBO.setTaxAmt(fscOrderItemPo.getTaxAmt());
                invoiceItemBO.setUnit(fscOrderItemPo.getUnit());
                invoiceItemBO.setTaxCode(fscOrderItemPo.getTaxCode());
                invoiceItemBO.setNum(fscOrderItemPo.getNum());
                invoiceItemBO.setAmt(fscOrderItemPo.getAmt());
                invoiceItemBO.setUntaxAmt(fscOrderItemPo.getUntaxAmt());
                invoiceItemBO.setTax(fscOrderItemPo.getTaxRate());
                invoiceItemBOList.add(invoiceItemBO);
            });
        } else {
            FscGetInvoiceInfoItemReqBO fscGetInvoiceInfoItemReqBO = new FscGetInvoiceInfoItemReqBO();
            fscGetInvoiceInfoItemReqBO.setInvoiceCode(fscGetInvoiceInfoListRspBO.getInvoiceCode());
            fscGetInvoiceInfoItemReqBO.setInvoiceId(fscGetInvoiceInfoListRspBO.getInvoiceId());
            fscGetInvoiceInfoItemReqBO.setSupplierId(String.valueOf(reqBO.getSupplierId()));
            fscGetInvoiceInfoItemReqBO.setProOrgId(String.valueOf(reqBO.getProOrgId()));
            fscGetInvoiceInfoItemReqBO.setSysTenantId(reqBO.getSysTenantId());
            FscGetInvoiceInfoItemRspBO invoiceInfoItem = this.fscGetInvoiceInfoItemExternalService.getInvoiceInfoItem(fscGetInvoiceInfoItemReqBO);
            if (!"0000".equals(invoiceInfoItem.getRespCode())) {
                throw new FscBusinessException("191031", invoiceInfoItem.getRespDesc());
            }
            List skuEntity = invoiceInfoItem.getResult().getSkuEntity();
            if (CollectionUtils.isEmpty((Collection)skuEntity)) {
                throw new FscBusinessException("191031", "\u83b7\u53d6\u7535\u5546\u53d1\u7968Sku\u5217\u8868\u4e3a\u7a7a");
            }
            skuEntity.forEach(item -> item.setExtSkuId(item.getSkuId()));
            log.info("\u7535\u5546\u53d1\u7968\u4fe1\u606f\u8fd4\u56de\u51fa\u53c2:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)skuEntity));
            Map<String, FscGetInvoiceInfoItemSkuRspBO> extInvoiceItemMap = skuEntity.stream().collect(Collectors.toMap(e -> e.getExtSkuId() + e.getEOrderId() + e.getNum().setScale(6), v -> v, (k1, k2) -> k1));
            if (!this.JD_SUP_ID.equals(reqBO.getSupplierId())) {
                if (!CollectionUtils.isEmpty(extInvoiceItemMap)) {
                    log.info("fscOrderItemPos:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString(fscOrderItemPos));
                    fscOrderItemPos.forEach(fscOrderItemPo -> {
                        if (extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt() + fscOrderItemPo.getOrderId() + fscOrderItemPo.getNum().setScale(6)) != null) {
                            InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                            invoiceItemBO.setFscOrderId(fscOrderItemPo.getFscOrderId());
                            invoiceItemBO.setAcceptOrderId(fscOrderItemPo.getAcceptOrderId());
                            invoiceItemBO.setOrderId(fscOrderItemPo.getOrderId());
                            invoiceItemBO.setOrderItemId(fscOrderItemPo.getOrderItemId());
                            invoiceItemBO.setSkuId(fscOrderItemPo.getSkuId());
                            invoiceItemBO.setSkuName(fscOrderItemPo.getSkuName());
                            invoiceItemBO.setSpec(fscOrderItemPo.getSpec());
                            invoiceItemBO.setModel(fscOrderItemPo.getModel());
                            invoiceItemBO.setPrice(fscOrderItemPo.getPrice());
                            invoiceItemBO.setTaxAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt() + fscOrderItemPo.getOrderId() + fscOrderItemPo.getNum().setScale(6))).getTaxAmount());
                            invoiceItemBO.setUnit(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt() + fscOrderItemPo.getOrderId() + fscOrderItemPo.getNum().setScale(6))).getSettleUnit());
                            invoiceItemBO.setTaxCode(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt() + fscOrderItemPo.getOrderId() + fscOrderItemPo.getNum().setScale(6))).getTaxId());
                            invoiceItemBO.setNum(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt() + fscOrderItemPo.getOrderId() + fscOrderItemPo.getNum().setScale(6))).getNum());
                            invoiceItemBO.setAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt() + fscOrderItemPo.getOrderId() + fscOrderItemPo.getNum().setScale(6))).getAmount());
                            invoiceItemBO.setUntaxAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt() + fscOrderItemPo.getOrderId() + fscOrderItemPo.getNum().setScale(6))).getAmountUnTax());
                            if (StringUtils.isEmpty((String)((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt() + fscOrderItemPo.getOrderId() + fscOrderItemPo.getNum().setScale(6))).getTax())) {
                                throw new ZTBusinessException("\u7535\u5546\u7a0e\u7387\u8fd4\u56de\u4e3a\u7a7a");
                            }
                            invoiceItemBO.setTax(new BigDecimal(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt() + fscOrderItemPo.getOrderId() + fscOrderItemPo.getNum().setScale(6))).getTax()));
                            invoiceItemBOList.add(invoiceItemBO);
                        }
                    });
                }
            } else if (!CollectionUtils.isEmpty(extInvoiceItemMap)) {
                FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
                fscOrderRelationPo.setFscOrderId(reqBO.getFscOrderId());
                fscOrderRelationPo.setSysTenantId(reqBO.getSysTenantId());
                List fscOrderRelationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
                Map<String, Long> extOrderIdMap = fscOrderRelationPOList.stream().collect(Collectors.toMap(FscOrderRelationPO::getExtOrderNo, FscOrderRelationPO::getOrderId, (v1, v2) -> v1));
                Map<String, FscOrderItemPO> fscOrderItemMap = fscOrderItemPos.stream().collect(Collectors.toMap(e -> e.getSkuIdExt() + e.getOrderId(), o -> o));
                extInvoiceItemMap.values().forEach(fscGetInvoiceInfoItemSkuRspBO -> {
                    if (fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + extOrderIdMap.get(fscGetInvoiceInfoItemSkuRspBO.getEOrderId())) != null) {
                        InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                        invoiceItemBO.setFscOrderId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + extOrderIdMap.get(fscGetInvoiceInfoItemSkuRspBO.getEOrderId()))).getFscOrderId());
                        invoiceItemBO.setAcceptOrderId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + extOrderIdMap.get(fscGetInvoiceInfoItemSkuRspBO.getEOrderId()))).getAcceptOrderId());
                        invoiceItemBO.setOrderId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + extOrderIdMap.get(fscGetInvoiceInfoItemSkuRspBO.getEOrderId()))).getOrderId());
                        invoiceItemBO.setOrderItemId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + extOrderIdMap.get(fscGetInvoiceInfoItemSkuRspBO.getEOrderId()))).getOrderItemId());
                        invoiceItemBO.setSkuId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + extOrderIdMap.get(fscGetInvoiceInfoItemSkuRspBO.getEOrderId()))).getSkuId());
                        invoiceItemBO.setSkuName(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + extOrderIdMap.get(fscGetInvoiceInfoItemSkuRspBO.getEOrderId()))).getSkuName());
                        invoiceItemBO.setSpec(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + extOrderIdMap.get(fscGetInvoiceInfoItemSkuRspBO.getEOrderId()))).getSpec());
                        invoiceItemBO.setModel(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + extOrderIdMap.get(fscGetInvoiceInfoItemSkuRspBO.getEOrderId()))).getModel());
                        invoiceItemBO.setPrice(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + extOrderIdMap.get(fscGetInvoiceInfoItemSkuRspBO.getEOrderId()))).getPrice());
                        if (!StringUtils.isEmpty((String)fscGetInvoiceInfoItemSkuRspBO.getTax())) {
                            invoiceItemBO.setTax(new BigDecimal(fscGetInvoiceInfoItemSkuRspBO.getTax()));
                        } else {
                            invoiceItemBO.setTax(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + extOrderIdMap.get(fscGetInvoiceInfoItemSkuRspBO.getEOrderId()))).getTaxRate());
                        }
                        invoiceItemBO.setTaxAmt(fscGetInvoiceInfoItemSkuRspBO.getTaxAmount());
                        invoiceItemBO.setUnit(fscGetInvoiceInfoItemSkuRspBO.getSettleUnit());
                        invoiceItemBO.setTaxCode(fscGetInvoiceInfoItemSkuRspBO.getTaxId());
                        invoiceItemBO.setNum(fscGetInvoiceInfoItemSkuRspBO.getNum());
                        invoiceItemBO.setAmt(fscGetInvoiceInfoItemSkuRspBO.getAmount());
                        invoiceItemBO.setUntaxAmt(fscGetInvoiceInfoItemSkuRspBO.getAmountUnTax());
                        invoiceItemBOList.add(invoiceItemBO);
                    }
                });
            }
        }
        fscInvoiceInfoBO.setInvoiceItemBOS(invoiceItemBOList);
        fscInvoiceInfoBO.setFscOrderId(reqBO.getFscOrderId());
        fscInvoiceInfoBO.setInvoiceType(fscOrderInvoicePo.getInvoiceType());
        fscInvoiceInfoBO.setInvoiceCategory(fscOrderInvoicePo.getInvoiceCategory());
        fscInvoiceInfoBO.setCreateTime(fscOrderInvoicePo.getBillTime());
        fscInvoiceInfoBO.setCreateOperId(fscOrderInvoicePo.getBillOperId());
        fscInvoiceInfoBO.setCreateOperName(fscOrderInvoicePo.getBillOperName());
        fscInvoiceInfoBO.setBank(fscGetInvoiceInfoListRspBO.getBank());
        fscInvoiceInfoBO.setInvoiceCode(fscGetInvoiceInfoListRspBO.getInvoiceCode());
        fscInvoiceInfoBO.setInvoiceNo(fscGetInvoiceInfoListRspBO.getInvoiceId());
        fscInvoiceInfoBO.setBillDate(simpleDateFormat.format(fscGetInvoiceInfoListRspBO.getInvoiceDate()));
        fscInvoiceInfoBO.setUntaxAmt(fscGetInvoiceInfoListRspBO.getInvoiceNakedAmount());
        fscInvoiceInfoBO.setTax(fscGetInvoiceInfoListRspBO.getInvoiceTaxRate());
        fscInvoiceInfoBO.setTaxAmt(fscGetInvoiceInfoListRspBO.getInvoiceTaxAmount());
        fscInvoiceInfoBO.setAmt(fscGetInvoiceInfoListRspBO.getInvoiceAmount());
        fscInvoiceInfoBO.setBuyName(fscGetInvoiceInfoListRspBO.getTitle());
        fscInvoiceInfoBO.setTaxNo(fscGetInvoiceInfoListRspBO.getEnterpriseTaxpayer());
        fscInvoiceInfoBO.setAddress(fscGetInvoiceInfoListRspBO.getAddress());
        fscInvoiceInfoBO.setPhone(fscGetInvoiceInfoListRspBO.getTel());
        fscInvoiceInfoBO.setAccount(fscGetInvoiceInfoListRspBO.getAccount());
        ArrayList<AttachmentBO> attachmentBos = new ArrayList<AttachmentBO>();
        log.info("fscGetInvoiceInfoListRspBO:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)fscGetInvoiceInfoListRspBO));
        if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getFileUrl())) {
            attachmentBo = new AttachmentBO();
            attachmentBo.setAttachmentType(FscConstants.AttachmentType.INVOICE);
            if (this.convertUrlSupplierIds.contains(reqBO.getSupplierId().toString())) {
                attachmentBo.setAttachmentUrl(this.getFileUrl(fscGetInvoiceInfoListRspBO.getFileUrl(), reqBO.getSysTenantId()));
                attachmentBo.setAttachmentUrlSource(fscGetInvoiceInfoListRspBO.getFileUrl());
            } else {
                attachmentBo.setAttachmentUrl(fscGetInvoiceInfoListRspBO.getFileUrl());
            }
            if (attachmentBo.getAttachmentUrl().indexOf("/null") != -1) {
                throw new FscBusinessException("191031", "\u53d1\u7968\u9644\u4ef6\u5730\u5740\u4e0a\u4f20\u9519\u8bef");
            }
            attachmentBos.add(attachmentBo);
        }
        if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getPdfUrl())) {
            attachmentBo = new AttachmentBO();
            attachmentBo.setAttachmentType(FscConstants.AttachmentType.INVOICE);
            if (this.convertUrlSupplierIds.contains(reqBO.getSupplierId().toString())) {
                attachmentBo.setAttachmentUrl(this.getFileUrl(fscGetInvoiceInfoListRspBO.getPdfUrl(), reqBO.getSysTenantId()));
                attachmentBo.setAttachmentUrlSource(fscGetInvoiceInfoListRspBO.getPdfUrl());
            } else {
                attachmentBo.setAttachmentUrl(fscGetInvoiceInfoListRspBO.getPdfUrl());
            }
            attachmentBos.add(attachmentBo);
        }
        if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getXmlUrl()) || !StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getXmlSourceFileUrl())) {
            attachmentBo = new AttachmentBO();
            attachmentBo.setAttachmentType(FscConstants.AttachmentType.XML);
            attachmentBo.setAttachmentUrl(StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getXmlUrl()) ? fscGetInvoiceInfoListRspBO.getXmlSourceFileUrl() : fscGetInvoiceInfoListRspBO.getXmlUrl());
            attachmentBos.add(attachmentBo);
        }
        if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getOfdUrl()) || !StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getOfdFileUrl())) {
            attachmentBo = new AttachmentBO();
            attachmentBo.setAttachmentType(FscConstants.AttachmentType.OFD);
            attachmentBo.setAttachmentUrl(StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getOfdUrl()) ? fscGetInvoiceInfoListRspBO.getOfdFileUrl() : fscGetInvoiceInfoListRspBO.getOfdUrl());
            attachmentBos.add(attachmentBo);
        }
        if (!ObjectUtil.isEmpty(attachmentBos)) {
            fscInvoiceInfoBO.setAttachmentList(attachmentBos);
        }
        return fscInvoiceInfoBO;
    }

    private String getFileUrl(String fileUrl, Long sysTenantId) {
        FscFileUploadOSSByUrlAtomReqBO fscFileUploadOSSByUrlAtomReqBO = new FscFileUploadOSSByUrlAtomReqBO();
        fscFileUploadOSSByUrlAtomReqBO.setOldUrl(fileUrl);
        fscFileUploadOSSByUrlAtomReqBO.setSysTenantId(sysTenantId);
        FscFileUploadOSSByUrlAtomRspBO fscFileUploadOSSByUrlAtomRspBO = this.fscFileUploadOSSByUrlAtomService.uploadFileByBrl(fscFileUploadOSSByUrlAtomReqBO);
        if (!"0000".equals(fscFileUploadOSSByUrlAtomRspBO.getRespCode())) {
            throw new FscBusinessException(fscFileUploadOSSByUrlAtomRspBO.getRespCode(), fscFileUploadOSSByUrlAtomRspBO.getRespDesc());
        }
        return fscFileUploadOSSByUrlAtomRspBO.getInnerFileUrl();
    }

    private void sendMq(FscGetInvoiceDataAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscComOrderListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceDeleteSyncAbilityReqBO fscComInvoiceDeleteSyncAbilityReqBO = new FscComInvoiceDeleteSyncAbilityReqBO();
        fscComInvoiceDeleteSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscComInvoiceDeleteSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscComInvoiceDeleteSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscComInvoiceDeleteSyncAbilityService.deleteComInvoiceSyncEs(fscComInvoiceDeleteSyncAbilityReqBO);
        this.fscComInvoiceDeleteSyncAbilityService.deleteComInvoiceSyncEs(fscComInvoiceDeleteSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscComInvoiceListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscComInvoiceListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
            FscBillMailListSyncAbilityReqBO fscBillMailListSyncAbilityReqBO = new FscBillMailListSyncAbilityReqBO();
            fscBillMailListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
            fscBillMailListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
            fscBillMailListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
            this.fscBillMailSyncAbilityService.syncBillMail(fscBillMailListSyncAbilityReqBO);
        }
    }

    private void updateOrderDesc(Long fscOrderId, Integer invoicingState, String invoicingFailReason, Long sysTenantId) {
        FscBillOrderDescUpdateBusiReqBO fscBillOrderDescUpdateBusiReqBO = new FscBillOrderDescUpdateBusiReqBO();
        fscBillOrderDescUpdateBusiReqBO.setFscOrderId(fscOrderId);
        fscBillOrderDescUpdateBusiReqBO.setSuccessRetransFlag("1");
        fscBillOrderDescUpdateBusiReqBO.setInvoicingState(invoicingState);
        fscBillOrderDescUpdateBusiReqBO.setInvoicingFailReason(invoicingFailReason);
        fscBillOrderDescUpdateBusiReqBO.setSysTenantId(sysTenantId);
        this.fscBillOrderDescUpdateBusiService.dealOrderDesc(fscBillOrderDescUpdateBusiReqBO);
    }

    private void syncOrderEs(Long fscOrderId, FscGetInvoiceDataAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscComOrderListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void sendMessage(FscOrderPO fscOrderPO) {
        FscSendMessageAtomReqBO fscSendMessageAtomReqBO = new FscSendMessageAtomReqBO();
        ArrayList<SendMessageBO> sendMessageBOList = new ArrayList<SendMessageBO>();
        SendMessageBO sendMessageBO = new SendMessageBO();
        sendMessageBO.setFscOrderNo(fscOrderPO.getOrderNo());
        sendMessageBO.setPurchaserName(fscOrderPO.getPurchaserName());
        sendMessageBO.setSupplierName(fscOrderPO.getSupplierName());
        sendMessageBO.setTaskCode("INVOICE_FINISH_NOTICE");
        sendMessageBO.setSendId("1");
        sendMessageBO.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        Long receiverId = ObjectUtil.isEmpty((Object)fscOrderPO.getSwapUserId()) ? fscOrderPO.getCreateOperId() : fscOrderPO.getSwapUserId();
        UmcDycMemberQryDetailAbilityReqBO umcDycMemberQryDetailAbilityReqBO = new UmcDycMemberQryDetailAbilityReqBO();
        umcDycMemberQryDetailAbilityReqBO.setMemId(receiverId);
        UmcDycMemberQryDetailAbilityRspBO umcDycMemberQryDetailAbilityRspBO = this.umcDycMemberQryDetailAbilityService.qryMemberDetail(umcDycMemberQryDetailAbilityReqBO);
        if (!ObjectUtil.isEmpty((Object)umcDycMemberQryDetailAbilityRspBO.getMemberBO().getRegEmail())) {
            ArrayList<SendMessageReceiverBO> sendMessageReceiverBOList = new ArrayList<SendMessageReceiverBO>();
            SendMessageReceiverBO sendMessageReceiverBO = new SendMessageReceiverBO();
            sendMessageReceiverBO.setReceiverId(String.valueOf(receiverId));
            sendMessageReceiverBO.setReceiverName(fscOrderPO.getCreateOperName());
            sendMessageReceiverBO.setEMail(umcDycMemberQryDetailAbilityRspBO.getMemberBO().getRegEmail());
            sendMessageReceiverBOList.add(sendMessageReceiverBO);
            sendMessageBO.setReceiverBOList(sendMessageReceiverBOList);
            sendMessageBOList.add(sendMessageBO);
            fscSendMessageAtomReqBO.setSendMessageBOList(sendMessageBOList);
            fscSendMessageAtomReqBO.setSysTenantId(fscOrderPO.getSysTenantId());
            log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscSendMessageAtomReqBO));
            this.fscSendInvoiceMessageAtomService.sendMessageAtomService(fscSendMessageAtomReqBO);
        } else {
            log.info("\u4e3a\u67e5\u8be2\u5230\u90ae\u7bb1:\u7ed3\u7b97\u5355\uff1a{}", (Object)fscOrderPO.getOrderNo());
        }
    }

    private Boolean checkCfcParam(List<FscInvoiceInfoBO> fscInvoiceInfoBos, FscOrderPO fscOrderPO, List<FscOrderItemPO> fscOrderItemPos, Long sysTenantId) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_check_" + fscOrderPO.getOrderSource());
        fscCfcUniteParamQryListDetailExternalReqBO.setSysTenantId(sysTenantId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        BigDecimal invoiceAmt = BigDecimal.ZERO;
        BigDecimal invoiceUnTaxAmt = BigDecimal.ZERO;
        BigDecimal invoiceTax = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(fscInvoiceInfoBos)) {
            invoiceAmt = fscInvoiceInfoBos.stream().map(InvoiceBO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            invoiceUnTaxAmt = fscInvoiceInfoBos.stream().map(InvoiceBO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            invoiceTax = fscInvoiceInfoBos.stream().map(InvoiceBO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if ("1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountCheck()) && invoiceAmt.compareTo(fscOrderPO.getTotalCharge()) < 0) {
            return false;
        }
        if ("1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExCheck()) && !StringUtils.isBlank((String)fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck())) {
            BigDecimal diffUntaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck());
            BigDecimal diffUntaxAmt1 = diffUntaxAmt.divide(BigDecimal.valueOf(100L));
            BigDecimal orderUntaxAmt = fscOrderItemPos.stream().map(FscOrderItemPO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (invoiceUnTaxAmt.add(diffUntaxAmt1).compareTo(orderUntaxAmt) < 0) {
                return false;
            }
        }
        if ("1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountCheck()) && !StringUtils.isBlank((String)fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck())) {
            BigDecimal diffTaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck());
            BigDecimal diffTaxAmt1 = diffTaxAmt.divide(BigDecimal.valueOf(100L));
            BigDecimal orderTaxAmt = fscOrderItemPos.stream().map(FscOrderItemPO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (invoiceTax.add(diffTaxAmt1).compareTo(orderTaxAmt) < 0) {
                return false;
            }
        }
        return true;
    }
}

