/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscGoodsDeductionAdjustCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscGoodsDeductionAdjustCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGoodsDeductionAdjustCreateAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscGoodsDeductionAdjustCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscGoodsDeductionAdjustCreateBusiBO;
import com.tydic.fsc.bill.busi.bo.FscGoodsDeductionAdjustCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscGoodsDeductionAdjustCreateBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscGoodsDeductionRecordUpdateBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscGoodsDeductionRecordMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscGoodsDeductionRecordPO;
import com.tydic.fsc.util.FscRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscGoodsDeductionAdjustCreateAbilityService"})
public class FscGoodsDeductionAdjustCreateAbilityServiceimpl
implements FscGoodsDeductionAdjustCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscGoodsDeductionAdjustCreateAbilityServiceimpl.class);
    @Autowired
    private FscGoodsDeductionAdjustCreateBusiService fscGoodsDeductionAdjustCreateBusiService;
    @Autowired
    private FscGoodsDeductionRecordMapper fscGoodsDeductionRecordMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @PostMapping(value={"createFscGoodsDeductionAdjust"})
    public FscGoodsDeductionAdjustCreateAbilityRspBO createFscGoodsDeductionAdjust(@RequestBody FscGoodsDeductionAdjustCreateAbilityReqBO reqBO) {
        FscGoodsDeductionAdjustCreateAbilityRspBO rspBO = (FscGoodsDeductionAdjustCreateAbilityRspBO)FscRu.success(FscGoodsDeductionAdjustCreateAbilityRspBO.class);
        FscGoodsDeductionRecordPO fscGoodsDeductionRecordPo = (FscGoodsDeductionRecordPO)FscRu.js((Object)reqBO, FscGoodsDeductionRecordPO.class);
        fscGoodsDeductionRecordPo.setStatus(FscConstants.GoodsRecordStatus.NO_DEAL);
        fscGoodsDeductionRecordPo.setSysTenantId(reqBO.getSysTenantId());
        List recordPOList = this.fscGoodsDeductionRecordMapper.getList(fscGoodsDeductionRecordPo);
        if (ObjectUtil.isNotEmpty((Object)recordPOList)) {
            Map<String, List<FscGoodsDeductionRecordPO>> recordPOListMap = recordPOList.stream().collect(Collectors.groupingBy(bo -> bo.getEditYear() + "-" + bo.getEditMonth() + "-" + bo.getSupplierId() + "-" + bo.getPurchaseId()));
            List<String> serialNoList = this.getSerial(recordPOListMap.size(), reqBO.getSysTenantId());
            int[] serialNo = new int[]{0};
            ArrayList<FscGoodsDeductionAdjustCreateBusiBO> adjustCreateBusiBOList = new ArrayList<FscGoodsDeductionAdjustCreateBusiBO>();
            ArrayList<FscGoodsDeductionRecordUpdateBO> recordBusiBOList = new ArrayList<FscGoodsDeductionRecordUpdateBO>();
            recordPOListMap.forEach((key, value) -> {
                FscGoodsDeductionAdjustCreateBusiBO createBusiBO = (FscGoodsDeductionAdjustCreateBusiBO)FscRu.js(value.get(0), FscGoodsDeductionAdjustCreateBusiBO.class);
                int n = serialNo[0];
                serialNo[0] = n + 1;
                createBusiBO.setFscAdjustNo((String)serialNoList.get(n));
                createBusiBO.setFscAdjustId(Sequence.getInstance().nextId());
                createBusiBO.setRecordTotalNum(new BigDecimal(value.size()));
                createBusiBO.setFscAdjustAmount(value.stream().map(FscGoodsDeductionRecordPO::getSummaryAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                createBusiBO.setStatus(FscConstants.GoodsAdjustStatus.TO_COMFIR);
                createBusiBO.setCreateDate(new Date());
                createBusiBO.setCreateOperUserId(null != reqBO.getUserId() ? reqBO.getUserId() : 1L);
                createBusiBO.setCreateOperUserName(null != reqBO.getName() ? reqBO.getName() : "\u81ea\u52a8\u751f\u6210");
                createBusiBO.setCreateOrgId(reqBO.getOrgId());
                createBusiBO.setCreateOrgName(reqBO.getOrgName());
                adjustCreateBusiBOList.add(createBusiBO);
                value.forEach(bo -> {
                    FscGoodsDeductionRecordUpdateBO recordUpdateBO = new FscGoodsDeductionRecordUpdateBO();
                    recordUpdateBO.setAdjustSummaryId(bo.getAdjustSummaryId());
                    recordUpdateBO.setManualAdjustmentNo(createBusiBO.getFscAdjustNo());
                    recordUpdateBO.setManualAdjustmentId(createBusiBO.getFscAdjustId());
                    recordUpdateBO.setStatus(FscConstants.GoodsRecordStatus.DEALED);
                    recordBusiBOList.add(recordUpdateBO);
                });
            });
            FscGoodsDeductionAdjustCreateBusiReqBO busiReqBO = (FscGoodsDeductionAdjustCreateBusiReqBO)((Object)FscRu.js((Object)reqBO, FscGoodsDeductionAdjustCreateBusiReqBO.class));
            busiReqBO.setAdjustCreateBusiBOList(adjustCreateBusiBOList);
            busiReqBO.setRecordBusiBOList(recordBusiBOList);
            FscGoodsDeductionAdjustCreateBusiRspBO busiRspBO = this.fscGoodsDeductionAdjustCreateBusiService.createFscGoodsDeductionAdjust(busiReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new FscBusinessException("194202", rspBO.getRespDesc());
            }
            rspBO = (FscGoodsDeductionAdjustCreateAbilityRspBO)FscRu.js((Object)((Object)busiRspBO), FscGoodsDeductionAdjustCreateAbilityRspBO.class);
        }
        return rspBO;
    }

    private void validate(FscGoodsDeductionAdjustCreateAbilityReqBO reqBo) {
        if (null == reqBo) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
    }

    private List<String> getSerial(Integer num, Long sysTenantId) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("FSC_ADJUST_CODE");
        encodedSerialGetServiceReqBO.setNum(num);
        encodedSerialGetServiceReqBO.setSysTenantId(sysTenantId);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return encodedSerialGetServiceRspBO.getSerialNoList();
    }
}

