/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.api.FscGoodsRecordItemListQryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscGoodsDeductionRecordItemBO;
import com.tydic.fsc.bill.ability.bo.FscGoodsRecordItemListQryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGoodsRecordItemListQryAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscGoodsDeductionRecordItemMapper;
import com.tydic.fsc.dao.FscGoodsDeductionRecordMapper;
import com.tydic.fsc.po.FscGoodsDeductionRecordItemPO;
import com.tydic.fsc.po.FscGoodsDeductionRecordPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscGoodsRecordItemListQryAbilityService"})
public class FscGoodsRecordItemListQryAbilityServiceImpl
implements FscGoodsRecordItemListQryAbilityService {
    @Autowired
    private FscGoodsDeductionRecordItemMapper fscGoodsDeductionRecordItemMapper;
    @Autowired
    private FscGoodsDeductionRecordMapper fscGoodsDeductionRecordMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryGoodsRecordItemList"})
    public FscGoodsRecordItemListQryAbilityRspBO qryGoodsRecordItemList(@RequestBody FscGoodsRecordItemListQryAbilityReqBO reqBO) {
        Object goodsDeductionRecordPOList;
        FscGoodsDeductionRecordItemPO fscItemPO = (FscGoodsDeductionRecordItemPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscGoodsDeductionRecordItemPO.class);
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        fscItemPO.setOrderBy(" a1.createDate desc");
        List fscItemPageList = this.fscGoodsDeductionRecordItemMapper.getListPage(fscItemPO, page);
        if (CollectionUtils.isEmpty((Collection)fscItemPageList)) {
            return new FscGoodsRecordItemListQryAbilityRspBO();
        }
        List fscItemBOList = JSON.parseArray((String)JSON.toJSONString((Object)fscItemPageList), FscGoodsDeductionRecordItemBO.class);
        List adjustSummaryIdList = fscItemPageList.stream().filter(bo -> null != bo.getAdjustSummaryId()).map(FscGoodsDeductionRecordItemPO::getAdjustSummaryId).collect(Collectors.toList());
        Map<Object, Object> recordStatusMap = new HashMap();
        if (ObjectUtil.isNotEmpty(adjustSummaryIdList)) {
            FscGoodsDeductionRecordPO fscGoodsDeductionRecordPo = new FscGoodsDeductionRecordPO();
            fscGoodsDeductionRecordPo.setAdjustSummaryIdList(adjustSummaryIdList);
            fscGoodsDeductionRecordPo.setSysTenantId(reqBO.getSysTenantId());
            goodsDeductionRecordPOList = this.fscGoodsDeductionRecordMapper.getList(fscGoodsDeductionRecordPo);
            recordStatusMap = goodsDeductionRecordPOList.stream().collect(Collectors.toMap(FscGoodsDeductionRecordPO::getAdjustSummaryId, FscGoodsDeductionRecordPO::getStatus));
        }
        Map financialSyncState = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_GOODS_RECORD_STATE", reqBO.getSysTenantId());
        goodsDeductionRecordPOList = fscItemBOList.iterator();
        while (goodsDeductionRecordPOList.hasNext()) {
            FscGoodsDeductionRecordItemBO fscItemBO;
            fscItemBO.setRecordStatusStr(ObjectUtil.isEmpty(recordStatusMap.get((fscItemBO = (FscGoodsDeductionRecordItemBO)goodsDeductionRecordPOList.next()).getAdjustSummaryId())) ? "\u672a\u5904\u7406" : (String)financialSyncState.get(((Integer)recordStatusMap.get(fscItemBO.getAdjustSummaryId())).toString()));
            if (!ObjectUtil.isNotEmpty((Object)fscItemBO.getTaxRate()) || fscItemBO.getTaxRate().compareTo(BigDecimal.ONE) >= 0) continue;
            fscItemBO.setTaxRate(fscItemBO.getTaxRate().multiply(new BigDecimal(100)));
        }
        FscGoodsRecordItemListQryAbilityRspBO rspBO = new FscGoodsRecordItemListQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(fscItemBOList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }
}

