/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.cfc.ability.api.CrcQryPaymentBehalfReverseAbilityService;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfReverseAbilityReqBO;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfReverseAbilityRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.fsc.bill.ability.api.FscOrderDataTransferService;
import com.tydic.fsc.bill.ability.bo.FscOrderDataTransferExtReqBo;
import com.tydic.fsc.bill.ability.bo.FscOrderDataTransferExtRsqBo;
import com.tydic.fsc.bill.busi.api.FscPayPartialVerificationBankCheckFileBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.umc.general.ability.api.UmcQryCorportionIdsBySbuIdsAbilityService;
import com.tydic.umc.general.ability.bo.SbuCorporationBO;
import com.tydic.umc.general.ability.bo.UmcQryCorportionIdsBySbuIdsAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryCorportionIdsBySbuIdsAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscOrderDataTransferService"})
public class FscOrderDataTransferServiceImpl
implements FscOrderDataTransferService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderDataTransferServiceImpl.class);
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private CrcQryPaymentBehalfReverseAbilityService crcQryPaymentBehalfReverseAbilityService;
    @Autowired
    private UmcQryCorportionIdsBySbuIdsAbilityService umcQryCorportionIdsBySbuIdsAbilityService;
    @Autowired
    private FscPayPartialVerificationBankCheckFileBusiService fscPayPartialVerificationBankCheckFileBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Value(value="${secondOrgId.zd}")
    private Long SECONDORGID_ZD;

    @PostMapping(value={"orderDataTransfer"})
    public FscOrderDataTransferExtRsqBo orderDataTransfer(@RequestBody FscOrderDataTransferExtReqBo reqBO) {
        this.val(reqBO);
        FscOrderDataTransferExtRsqBo rsqBo = new FscOrderDataTransferExtRsqBo();
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setCreateOperId(reqBO.getTransferUserId());
        fscOrderPo.setPurchaserIdList(reqBO.getTransferCompanyIdList().stream().map(bo -> Long.parseLong(bo)).collect(Collectors.toList()));
        fscOrderPo.setSysTenantId(reqBO.getSysTenantId());
        List fscOrderIdList = this.fscOrderMapper.getListBySwap(fscOrderPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderIdList)) {
            return rsqBo;
        }
        FscOrderPO set = new FscOrderPO();
        set.setSwapUserId(reqBO.getSwapUserId());
        set.setSwapOrgId(reqBO.getSwapOrgId());
        set.setSwapOrgName(reqBO.getSwapOrgName());
        set.setSwapOrgPath(reqBO.getSwapOrgPath());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(fscOrderIdList);
        where.setSysTenantId(reqBO.getSysTenantId());
        this.fscOrderMapper.updateBy(set, where);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderIdS(fscOrderIdList);
        fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscComOrderListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        return rsqBo;
    }

    private List<Long> getPaymentId(List<Long> payerIds) {
        ArrayList<Long> toPayPayerIds = new ArrayList<Long>();
        ArrayList toPayPayerSecondOrgIds = new ArrayList();
        CrcQryPaymentBehalfReverseAbilityReqBO crcQryPaymentBehalfReverseAbilityReqBO = new CrcQryPaymentBehalfReverseAbilityReqBO();
        crcQryPaymentBehalfReverseAbilityReqBO.setPaymentIdList(payerIds);
        log.info("\u67e5\u4e0b\u914d\u7f6e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)crcQryPaymentBehalfReverseAbilityReqBO));
        CrcQryPaymentBehalfReverseAbilityRspBO crcQryPaymentBehalfReverseAbilityRspBO = this.crcQryPaymentBehalfReverseAbilityService.qryPaymentBehalfReverse(crcQryPaymentBehalfReverseAbilityReqBO);
        log.info("\u67e5\u4e0b\u914d\u7f6e\u7c97\u60e8:{}", (Object)JSON.toJSONString((Object)crcQryPaymentBehalfReverseAbilityRspBO));
        if (!ObjectUtil.isEmpty((Object)crcQryPaymentBehalfReverseAbilityRspBO.getPaymentBehalfMap())) {
            for (Long payerId : payerIds) {
                List cfcUniteParamBOList = ObjectUtil.isEmpty(crcQryPaymentBehalfReverseAbilityRspBO.getPaymentBehalfMap().get(payerId)) ? new ArrayList() : (List)crcQryPaymentBehalfReverseAbilityRspBO.getPaymentBehalfMap().get(payerId);
                if (ObjectUtil.isEmpty(cfcUniteParamBOList)) continue;
                cfcUniteParamBOList.forEach(item -> {
                    if (item.getRelType().equals("1")) {
                        toPayPayerSecondOrgIds.add(Long.parseLong(item.getRelId()));
                    } else {
                        toPayPayerIds.add(Long.parseLong(item.getRelId()));
                    }
                });
            }
        }
        if (!ObjectUtil.isEmpty(toPayPayerSecondOrgIds)) {
            UmcQryCorportionIdsBySbuIdsAbilityReqBO umcQryCorportionIdsBySbuIdsAbilityReqBO = new UmcQryCorportionIdsBySbuIdsAbilityReqBO();
            umcQryCorportionIdsBySbuIdsAbilityReqBO.setOrgIds(toPayPayerSecondOrgIds);
            UmcQryCorportionIdsBySbuIdsAbilityRspBO umcQryCorportionIdsBySbuIdsAbilityRspBO = this.umcQryCorportionIdsBySbuIdsAbilityService.qryCorportionIdsBySbuIds(umcQryCorportionIdsBySbuIdsAbilityReqBO);
            if (!ObjectUtil.isEmpty((Object)umcQryCorportionIdsBySbuIdsAbilityRspBO.getSbuCorporationBOS())) {
                for (SbuCorporationBO sbuCorporationBO : umcQryCorportionIdsBySbuIdsAbilityRspBO.getSbuCorporationBOS()) {
                    toPayPayerIds.addAll(sbuCorporationBO.getCorporationIds());
                }
            }
        }
        return toPayPayerIds;
    }

    private void syncOrderStatus1(Long fscPayOrderId, Long sysTenantId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId, sysTenantId);
        Map<Long, FscShouldPayPO> fscShouldPayPOMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getObjectId, FscShouldPayPO2 -> FscShouldPayPO2));
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            return;
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(fscShouldPayPOList.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
        fscOrderPo.setSysTenantId(sysTenantId);
        List orderList = this.fscOrderMapper.getList(fscOrderPo);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return;
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderIds(orderList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList()));
        fscOrderRelationPo.setSysTenantId(sysTenantId);
        List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBO = new FscUocProOrderPaymentCallbackAbilityReqBO();
            fscUocProOrderPaymentCallbackAbilityReqBO.setSysTenantId(sysTenantId);
            fscUocProOrderPaymentCallbackAbilityReqBO.setUocPaymentCallbackBOS(fscOrderRelationPOs.stream().map(fscPaySuccessCallBackOrderBO -> {
                FscUocProOrderPaymentCallbackAbilityBO fscUocProOrderPaymentCallbackAbilityBO = new FscUocProOrderPaymentCallbackAbilityBO();
                fscUocProOrderPaymentCallbackAbilityBO.setSaleOrderId(fscPaySuccessCallBackOrderBO.getOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setObjectId(fscPaySuccessCallBackOrderBO.getAcceptOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayerType(FscConstants.FscOrderReceiveType.PURCHASE.equals(((FscOrderPO)orderList.get(0)).getReceiveType()) ? "pur" : "pro");
                fscUocProOrderPaymentCallbackAbilityBO.setPayMod(Integer.valueOf(30));
                fscUocProOrderPaymentCallbackAbilityBO.setPayResult(Boolean.valueOf(true));
                fscUocProOrderPaymentCallbackAbilityBO.setShouldPayMoney(fscPaySuccessCallBackOrderBO.getOrderTotalCharge());
                fscUocProOrderPaymentCallbackAbilityBO.setFscShouldPayId(((FscShouldPayPO)fscShouldPayPOMap.get(fscPaySuccessCallBackOrderBO.getFscOrderId())).getShouldPayId());
                return fscUocProOrderPaymentCallbackAbilityBO;
            }).collect(Collectors.toList()));
            this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBO);
        }
    }

    private void val(FscOrderDataTransferExtReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getTransferUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8f6c\u4ea4\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSwapUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4ea4\u63a5\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

