/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.fsc.bill.ability.api.FscPayQueryWithdrawalBankCheckFileAbilityService;
import com.tydic.fsc.bill.ability.bo.FscPayQueryBankCheckFileAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscPayQueryWithdrawalBankCheckFileAbilityReqBO;
import com.tydic.fsc.bill.atom.api.FscFileUploadOSSByUrlAtomService;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscPayBillWithdrawalBankCheckFileBusiService;
import com.tydic.fsc.bill.busi.bo.FscBankCheckFileBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillWithdrawalBankCheckFileBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscWithdrawalBankCheckFileItemBO;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankDownLoadCheckFileService;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankQueryCheckFileService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankDownLoadCheckFileReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankDownLoadCheckFileRspBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankQueryCheckFileReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankQueryCheckFileRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscWithdrawalBankCheckFileMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscWithdrawalBankCheckFilePO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscPayQueryWithdrawalBankCheckFileAbilityService"})
public class FscPayQueryWithdrawalBankCheckFileAbilityServiceImpl
implements FscPayQueryWithdrawalBankCheckFileAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayQueryWithdrawalBankCheckFileAbilityServiceImpl.class);
    @Autowired
    private FscWithdrawalBankCheckFileMapper fscWithdrawalBankCheckFileMapper;
    @Autowired
    private FscBToBPingAnBankQueryCheckFileService fscBToBPingAnBankQueryCheckFileService;
    @Autowired
    private FscPayBillWithdrawalBankCheckFileBusiService fscPayBillWithdrawalBankCheckFileBusiService;
    @Autowired
    private FscBToBPingAnBankDownLoadCheckFileService fscBToBPingAnBankDownLoadCheckFileService;
    @Autowired
    private FscFileUploadOSSByUrlAtomService fscFileUploadOSSByUrlAtomService;
    @Autowired
    private FileClient fileClient;

    @FscDuplicateCommitLimit
    @PostMapping(value={"qryWithdrawalBankCheckFile"})
    public FscPayQueryBankCheckFileAbilityRspBO qryWithdrawalBankCheckFile(@RequestBody FscPayQueryWithdrawalBankCheckFileAbilityReqBO abilityReqBO) {
        Date curSysDate = new Date();
        ArrayList<String> fileDateList = new ArrayList<String>();
        ArrayList<FscBankCheckFileBO> fscBankCheckFileBOs = new ArrayList<FscBankCheckFileBO>();
        FscBToBPingAnBankQueryCheckFileReqBO bankReqBO = new FscBToBPingAnBankQueryCheckFileReqBO();
        if (!StringUtils.isEmpty((Object)abilityReqBO.getFileDate())) {
            fileDateList.add(abilityReqBO.getFileDate());
        } else if (null != abilityReqBO.getFileDateStar() && null != abilityReqBO.getFileDateEnd()) {
            Calendar curDateStart = Calendar.getInstance();
            curDateStart.setTime(abilityReqBO.getFileDateStar());
            Calendar curDateEnd = Calendar.getInstance();
            curDateEnd.setTime(abilityReqBO.getFileDateEnd());
            Long diffDay = (curDateEnd.getTimeInMillis() - curDateStart.getTimeInMillis()) / 86400000L;
            int i = 0;
            while ((long)i < diffDay) {
                curDateStart.add(5, 1);
                fileDateList.add(DateUtil.dateToStrYYYYMMdd((Date)curDateStart.getTime()));
                ++i;
            }
        } else {
            Calendar curDate = Calendar.getInstance();
            curDate.setTime(new Date());
            curDate.add(5, -1);
            fileDateList.add(DateUtil.dateToStrYYYYMMdd((Date)curDate.getTime()));
        }
        bankReqBO.setFileType("TX");
        bankReqBO.setSysTenantId(abilityReqBO.getSysTenantId());
        String failReason = "\u672a\u83b7\u53d6\u5230\u5bf9\u8d26\u6587\u4ef6";
        if (!ObjectUtils.isEmpty(fileDateList)) {
            for (String fileDate : fileDateList) {
                bankReqBO.setFileDate(fileDate);
                FscBToBPingAnBankQueryCheckFileRspBO bankRspBO = this.fscBToBPingAnBankQueryCheckFileService.checkAmountFile(bankReqBO);
                if ("0000".equals(bankRspBO.getRespCode())) {
                    failReason = bankRspBO.getRespDesc();
                }
                if (null == bankRspBO || CollectionUtils.isEmpty((Collection)bankRspBO.getTranItemArray())) continue;
                bankRspBO.getTranItemArray().forEach(row -> {
                    if (row.getFileName().indexOf(".txt.enc") > 0) {
                        FscBankCheckFileBO fscBankCheckFileBO = new FscBankCheckFileBO();
                        fscBankCheckFileBO.setFileName(row.getFileName());
                        fscBankCheckFileBO.setFilePath(row.getFilePath());
                        fscBankCheckFileBO.setRandomPassword(row.getRandomPassword());
                        fscBankCheckFileBO.setDrawCode(row.getDrawCode());
                        fscBankCheckFileBOs.add(fscBankCheckFileBO);
                    }
                });
            }
        }
        FscPayBillWithdrawalBankCheckFileBusiReqBO fscPayBillBankCheckFileBusiInsertReqBO = new FscPayBillWithdrawalBankCheckFileBusiReqBO();
        if (!CollectionUtils.isEmpty(fscBankCheckFileBOs)) {
            fscPayBillBankCheckFileBusiInsertReqBO.setFscBankCheckFileBOs(fscBankCheckFileBOs);
        } else {
            FscBankCheckFileBO fscBankCheckFileBO = new FscBankCheckFileBO();
            fscBankCheckFileBO.setFileName("TX" + bankReqBO.getFileDate() + "42321");
            fscBankCheckFileBO.setAttachmentName(failReason);
            fscBankCheckFileBO.setStatus(FscConstants.BANK_CHECK_STATUS.QUERY_FAIL);
            fscBankCheckFileBOs.add(fscBankCheckFileBO);
            fscPayBillBankCheckFileBusiInsertReqBO.setFscBankCheckFileBOs(fscBankCheckFileBOs);
        }
        fscPayBillBankCheckFileBusiInsertReqBO.setOperType(FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE);
        fscPayBillBankCheckFileBusiInsertReqBO.setSysTenantId(abilityReqBO.getSysTenantId());
        FscPayBillBankCheckFileBusiRspBO fscPayBillBankCheckFileBusiInsertRspBO = this.fscPayBillWithdrawalBankCheckFileBusiService.bankCheckFile(fscPayBillBankCheckFileBusiInsertReqBO);
        if (!"0000".equals(fscPayBillBankCheckFileBusiInsertRspBO.getRespCode())) {
            throw new FscBusinessException("193130", fscPayBillBankCheckFileBusiInsertRspBO.getRespDesc());
        }
        FscWithdrawalBankCheckFilePO fscBankCheckFilePO = new FscWithdrawalBankCheckFilePO();
        fscBankCheckFilePO.setStatus(FscConstants.BANK_CHECK_STATUS.NO);
        fscBankCheckFilePO.setSysTenantId(abilityReqBO.getSysTenantId());
        List fscBankCheckFilePOList = this.fscWithdrawalBankCheckFileMapper.getList(fscBankCheckFilePO);
        if (!CollectionUtils.isEmpty((Collection)fscBankCheckFilePOList)) {
            for (FscWithdrawalBankCheckFilePO fscBankCheckFilePOFor : fscBankCheckFilePOList) {
                FscBToBPingAnBankDownLoadCheckFileReqBO downLoadCheckFileReqBO = new FscBToBPingAnBankDownLoadCheckFileReqBO();
                downLoadCheckFileReqBO.setFileName(fscBankCheckFilePOFor.getFileName());
                downLoadCheckFileReqBO.setFilePath(fscBankCheckFilePOFor.getFilePath());
                downLoadCheckFileReqBO.setDecryptKey(fscBankCheckFilePOFor.getRandomPassword());
                downLoadCheckFileReqBO.setSysTenantId(abilityReqBO.getSysTenantId());
                FscBToBPingAnBankDownLoadCheckFileRspBO dlRspBO = null;
                try {
                    dlRspBO = this.fscBToBPingAnBankDownLoadCheckFileService.downLoadCheckFile(downLoadCheckFileReqBO);
                }
                catch (FscBusinessException e) {
                    e.printStackTrace();
                    log.debug("\u8bfb\u53d6\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\u9519\u8bef");
                    continue;
                }
                FscFileUploadOSSByUrlAtomReqBO fscFileUploadOSSByUrlAtomReqBO = new FscFileUploadOSSByUrlAtomReqBO();
                fscFileUploadOSSByUrlAtomReqBO.setLocalUrl(dlRspBO.getLocalFilePath());
                fscFileUploadOSSByUrlAtomReqBO.setSysTenantId(abilityReqBO.getSysTenantId());
                FscFileUploadOSSByUrlAtomRspBO uploadRspBO = null;
                try {
                    uploadRspBO = this.fscFileUploadOSSByUrlAtomService.uploadFileByBrl(fscFileUploadOSSByUrlAtomReqBO);
                }
                catch (FscBusinessException e) {
                    e.printStackTrace();
                    log.debug("\u8bfb\u53d6\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\u9519\u8bef");
                    continue;
                }
                int updateResult = this.updateBankFileStatus(FscConstants.BANK_CHECK_STATUS.DOWNLOAD, fscBankCheckFilePOFor.getFileName(), uploadRspBO);
                if (updateResult >= 1) continue;
                log.debug("\u66f4\u65b0\u6587\u4ef6\uff1a{}\u72b6\u6001\u4e3a\u5df2\u4e0b\u8f7d\u9519\u8bef", (Object)fscBankCheckFilePOFor.getFileName());
            }
        }
        FscWithdrawalBankCheckFilePO downloadCheckFile = new FscWithdrawalBankCheckFilePO();
        downloadCheckFile.setStatus(FscConstants.BANK_CHECK_STATUS.DOWNLOAD);
        downloadCheckFile.setSysTenantId(abilityReqBO.getSysTenantId());
        List downloadCheckFileList = this.fscWithdrawalBankCheckFileMapper.getList(downloadCheckFile);
        log.info("\u5df2\u4e0b\u8f7d\u6587\u4ef6\uff1a{}", (Object)downloadCheckFileList);
        for (FscWithdrawalBankCheckFilePO downloadFile : downloadCheckFileList) {
            ArrayList<FscWithdrawalBankCheckFileItemBO> fscBankCheckFileItemBOList = new ArrayList<FscWithdrawalBankCheckFileItemBO>();
            try {
                String[] pad = downloadFile.getAttachmentUrl().split("group1");
                String filePath = "group1" + pad[1].replaceFirst("/", ",");
                InputStream in = this.fileClient.downLoadToInputStream(filePath);
                log.error("in___________=" + in);
                InputStreamReader insr = new InputStreamReader(in, "GBK");
                BufferedReader reader = new BufferedReader(insr);
                String str = null;
                String tempStr = "";
                int readCount = 0;
                while ((str = reader.readLine()) != null) {
                    log.info("\u8bfb\u53d6\u6b21\u6570\uff1a{}", (Object)readCount++);
                    if (StringUtils.isEmpty((Object)str)) continue;
                    log.info("\u89e3\u6790\u524d\u884c\u6570\u636e--\u524d\uff1a{}", (Object)str);
                    if (!ObjectUtils.isEmpty((Object)tempStr)) {
                        str = new StringBuilder(str).insert(0, tempStr).toString();
                    }
                    log.info("\u89e3\u6790\u524d\u884c\u6570\u636e\uff1a{}", (Object)str);
                    String[] newStr = str.split("&");
                    log.info("\u5b57\u7b26\u4e32\u957f\u5ea6:{}", (Object)newStr.length);
                    if (newStr.length < 12) {
                        tempStr = str;
                        log.info("\u4e34\u65f6\u5b57\u7b26\u4e32\uff1a{}", (Object)tempStr);
                        continue;
                    }
                    FscWithdrawalBankCheckFileItemBO fscBankCheckFileItemBO = new FscWithdrawalBankCheckFileItemBO();
                    fscBankCheckFileItemBO.setWithdrawalCheckId(Sequence.getInstance().nextId());
                    fscBankCheckFileItemBO.setFileName(downloadFile.getFileName());
                    fscBankCheckFileItemBO.setSortNo(newStr[0]);
                    Long payeeId = Long.parseLong(newStr[1]);
                    fscBankCheckFileItemBO.setOrgId(payeeId);
                    fscBankCheckFileItemBO.setSubAccountNo(newStr[2]);
                    fscBankCheckFileItemBO.setOrgName(newStr[3]);
                    if (!StringUtils.isEmpty((Object)newStr[4])) {
                        fscBankCheckFileItemBO.setTradeAmt(new BigDecimal(newStr[4]));
                    }
                    if (!StringUtils.isEmpty((Object)newStr[5])) {
                        fscBankCheckFileItemBO.setHandlingFee(new BigDecimal(newStr[5]));
                    }
                    fscBankCheckFileItemBO.setTradeDate(newStr[6]);
                    fscBankCheckFileItemBO.setTradeTime(newStr[7]);
                    fscBankCheckFileItemBO.setBankWitnessSeq(newStr[8]);
                    fscBankCheckFileItemBO.setBankTradeSeq(newStr[9]);
                    fscBankCheckFileItemBO.setMemo(newStr[10]);
                    fscBankCheckFileItemBO.setAccountingType(newStr[11]);
                    fscBankCheckFileItemBOList.add(fscBankCheckFileItemBO);
                    tempStr = "";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.debug("\u8bfb\u53d6\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\u9519\u8bef");
                int updateResult = this.updateBankFileStatus(FscConstants.BANK_CHECK_STATUS.RESOLVING_FAIL, downloadFile.getFileName(), abilityReqBO.getSysTenantId());
                if (updateResult >= 1) continue;
                log.debug("\u66f4\u65b0\u6587\u4ef6\uff1a{}\u72b6\u6001\u4e3a\u89e3\u6790\u9519\u8bef", (Object)downloadFile.getFileName());
                continue;
            }
            if (CollectionUtils.isEmpty(fscBankCheckFileItemBOList)) continue;
            FscPayBillWithdrawalBankCheckFileBusiReqBO fscPayBillBankCheckFileBusiReqBO = new FscPayBillWithdrawalBankCheckFileBusiReqBO();
            fscPayBillBankCheckFileBusiReqBO.setFileName(downloadFile.getFileName());
            fscPayBillBankCheckFileBusiReqBO.setAttachmentUrl(downloadFile.getAttachmentUrl());
            fscPayBillBankCheckFileBusiReqBO.setAttachmentName(downloadFile.getFileName());
            fscPayBillBankCheckFileBusiReqBO.setStatus(FscConstants.BANK_CHECK_STATUS.YES);
            fscPayBillBankCheckFileBusiReqBO.setFscBankCheckFileItemBOs(fscBankCheckFileItemBOList);
            fscPayBillBankCheckFileBusiReqBO.setOperType(FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE_ITEM);
            fscPayBillBankCheckFileBusiReqBO.setSysTenantId(abilityReqBO.getSysTenantId());
            try {
                this.fscPayBillWithdrawalBankCheckFileBusiService.bankCheckFile(fscPayBillBankCheckFileBusiReqBO);
            }
            catch (FscBusinessException e) {
                e.printStackTrace();
                log.debug("\u5199\u5bf9\u8d26\u6587\u4ef6\u660e\u7ec6\u5931\u8d25");
            }
        }
        return new FscPayQueryBankCheckFileAbilityRspBO();
    }

    public int updateBankFileStatus(Integer status, String fileName, Long sysTenantId) {
        FscWithdrawalBankCheckFilePO setParams = new FscWithdrawalBankCheckFilePO();
        setParams.setStatus(status);
        FscWithdrawalBankCheckFilePO whereParams = new FscWithdrawalBankCheckFilePO();
        whereParams.setFileName(fileName);
        whereParams.setSysTenantId(sysTenantId);
        int updateResult = this.fscWithdrawalBankCheckFileMapper.updateBy(setParams, whereParams);
        return updateResult;
    }

    public int updateBankFileStatus(Integer status, String fileName, FscFileUploadOSSByUrlAtomRspBO uploadRspBO) {
        FscWithdrawalBankCheckFilePO setParams = new FscWithdrawalBankCheckFilePO();
        setParams.setStatus(status);
        setParams.setAttachmentName(fileName.replace(".enc", ""));
        setParams.setAttachmentUrl(uploadRspBO.getInnerFileUrl());
        FscWithdrawalBankCheckFilePO whereParams = new FscWithdrawalBankCheckFilePO();
        whereParams.setFileName(fileName);
        whereParams.setSysTenantId(uploadRspBO.getSysTenantId());
        int updateResult = this.fscWithdrawalBankCheckFileMapper.updateBy(setParams, whereParams);
        return updateResult;
    }
}

