/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.fsc.bill.atom.api.FscBatchSaveStockAtomService;
import com.tydic.fsc.bill.atom.bo.FscBatchSaveStockAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBatchSaveStockAtomRspBO;
import com.tydic.fsc.busibase.atom.api.FscStockOperAtomService;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscStockItemMapper;
import com.tydic.fsc.dao.FscStockMapper;
import com.tydic.fsc.dao.FscStockRelationMapper;
import com.tydic.fsc.po.FscStockItemPO;
import com.tydic.fsc.po.FscStockPO;
import com.tydic.fsc.po.FscStockRelationPO;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBatchSaveStockAtomServiceImpl
implements FscBatchSaveStockAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscBatchSaveStockAtomServiceImpl.class);
    @Autowired
    private FscStockMapper fscStockMapper;
    @Autowired
    private FscStockRelationMapper fscStockRelationMapper;
    @Autowired
    private FscStockItemMapper fscStockItemMapper;
    @Autowired
    private FscStockOperAtomService fscStockOperAtomService;

    @Override
    public FscBatchSaveStockAtomRspBO batchSaveStock(FscBatchSaveStockAtomReqBO reqBO) {
        log.info("\u521b\u5efa\u51fa\u5165\u5e93\u5355\u5165\u53c2");
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscStockPO fscStockPO = new FscStockPO();
            fscStockPO.setFscOrderId(fscOrderId);
            fscStockPO.setSysTenantId(reqBO.getSysTenantId());
            List fscStockPOList = this.fscStockMapper.getList(fscStockPO);
            if (!ObjectUtil.isEmpty((Object)fscStockPOList)) {
                List stockIds = fscStockPOList.stream().map(FscStockPO::getId).collect(Collectors.toList());
                FscStockPO fscStockPO1 = new FscStockPO();
                fscStockPO1.setStockIds(stockIds);
                fscStockPO1.setSysTenantId(reqBO.getSysTenantId());
                List fscStockPOList1 = this.fscStockMapper.getListByStockItemId(fscStockPO1);
                if (!ObjectUtil.isEmpty((Object)fscStockPOList1)) {
                    List stockItemIds = fscStockPOList1.stream().map(FscStockPO::getStockItemId).collect(Collectors.toList());
                    if (!ObjectUtil.isEmpty(stockIds)) {
                        FscStockPO deleteStockPO = new FscStockPO();
                        deleteStockPO.setStockIds(stockIds);
                        deleteStockPO.setSysTenantId(reqBO.getSysTenantId());
                        this.fscStockMapper.deleteBy(deleteStockPO);
                    }
                    if (!ObjectUtil.isEmpty(stockItemIds)) {
                        FscStockRelationPO fscStockRelationPO = new FscStockRelationPO();
                        fscStockRelationPO.setStockItemIds(stockItemIds);
                        fscStockRelationPO.setSysTenantId(reqBO.getSysTenantId());
                        this.fscStockRelationMapper.deleteBy(fscStockRelationPO);
                        FscStockItemPO fscStockItemPO = new FscStockItemPO();
                        fscStockItemPO.setIds(stockItemIds);
                        fscStockItemPO.setSysTenantId(reqBO.getSysTenantId());
                        this.fscStockItemMapper.deleteBy(fscStockItemPO);
                    }
                }
            }
            for (int i = 1; i < 3; ++i) {
                FscStockOperAtomReqBO fscStockOperAtomReqBO = new FscStockOperAtomReqBO();
                fscStockOperAtomReqBO.setOperType(Integer.valueOf(i));
                fscStockOperAtomReqBO.setFscOrderId(fscOrderId);
                fscStockOperAtomReqBO.setSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.UNSYNC);
                fscStockOperAtomReqBO.setSysTenantId(reqBO.getSysTenantId());
                FscStockOperAtomRspBO fscStockOperAtomRspBO = this.fscStockOperAtomService.dealStockOper(fscStockOperAtomReqBO);
            }
        }
        return new FscBatchSaveStockAtomRspBO();
    }
}

