/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBatchAutoCreateGcOrderBusiService;
import com.tydic.fsc.bill.busi.bo.FscBatchAutoCreateGcOrderBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBatchAutoCreateGcOrderBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscUocProQryAcceptOrderListAtomService;
import com.tydic.fsc.busibase.atom.bo.FscQrySaleOrderListRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocQryAcceptOrderListReqBO;
import com.tydic.fsc.busibase.atom.bo.FscUocSaleOrderCommodityInfoBO;
import com.tydic.fsc.busibase.atom.bo.FscUocSaleOrderInfoBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.common.ability.api.FscComInvoiceDeleteSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.dao.FscGcInvoiceMapper;
import com.tydic.fsc.dao.FscGcOrderItemMapper;
import com.tydic.fsc.dao.FscGcOrderMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscGcInvoicePO;
import com.tydic.fsc.po.FscGcOrderItemPO;
import com.tydic.fsc.po.FscGcOrderPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderMapPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.umc.general.ability.api.CrcQryCorporationListPageAbilityService;
import com.tydic.umc.general.ability.api.CrcUmcQryCommodityTypeSupplierListPageAbilityService;
import com.tydic.umc.general.ability.api.UmcDycMemberQryDetailAbilityService;
import com.tydic.umc.general.ability.api.UmcQryMemLegalOrgInfoAbilityService;
import com.tydic.umc.general.ability.bo.CrcQryCorporationListPageAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryCorporationListPageAbilityRspBO;
import com.tydic.umc.general.ability.bo.CrcUmcQryCommodityTypeSupplierListPageAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcUmcQryCommodityTypeSupplierListPageAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcCommoditySupplierInfoBO;
import com.tydic.umc.general.ability.bo.UmcCorporationInfoBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBatchAutoCreateGcOrderBusiServiceImpl
implements FscBatchAutoCreateGcOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBatchAutoCreateGcOrderBusiServiceImpl.class);
    @Autowired
    private FscGcOrderMapper fscGcOrderMapper;
    @Autowired
    private FscGcOrderItemMapper fscGcOrderItemMapper;
    @Autowired
    private FscGcInvoiceMapper fscGcInvoiceMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapMapper fscOrderMapMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Value(value="${crc.sys.tenant.id:305775845729763327}")
    private Long crcSysTenantId;
    @Value(value="${opertionWithdrawalOrgId}")
    private Long operOrgId;
    @Autowired
    private FscUocProQryAcceptOrderListAtomService fscUocProQryAcceptOrderListAtomService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComInvoiceDeleteSyncAbilityService fscComInvoiceDeleteSyncAbilityService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;
    @Autowired
    private UmcDycMemberQryDetailAbilityService umcDycMemberQryDetailAbilityService;
    @Autowired
    private UmcQryMemLegalOrgInfoAbilityService umcQryMemLegalOrgInfoAbilityService;
    @Autowired
    private CrcUmcQryCommodityTypeSupplierListPageAbilityService crcUmcQryCommodityTypeSupplierListPageAbilityService;
    @Autowired
    private CrcQryCorporationListPageAbilityService crcQryCorporationListPageAbilityService;

    @Override
    public FscBatchAutoCreateGcOrderBusiRspBO batchAutoCreateGcOrder(FscBatchAutoCreateGcOrderBusiReqBO reqBO) {
        FscBatchAutoCreateGcOrderBusiRspBO rspBO = new FscBatchAutoCreateGcOrderBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscGcOrderPO info = new FscGcOrderPO();
        info.setFscOrderId(reqBO.getGcFscOrderId());
        log.info("\u67e5\u8be2\u4e2a\u91c7\u8ba2\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)info));
        info = this.fscGcOrderMapper.getModelBy(info);
        log.info("\u67e5\u8be2\u4e2a\u91c7\u8ba2\u5355\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)info));
        FscGcOrderItemPO fscGcOrderItemPO = new FscGcOrderItemPO();
        fscGcOrderItemPO.setFscOrderId(reqBO.getGcFscOrderId());
        List fscGcOrderItemPOList = this.fscGcOrderItemMapper.getList(fscGcOrderItemPO);
        if (ObjectUtil.isEmpty((Object)fscGcOrderItemPOList)) {
            return rspBO;
        }
        UmcQryMemLegalOrgInfoAbilityServiceReqBO umcReqBO = new UmcQryMemLegalOrgInfoAbilityServiceReqBO();
        umcReqBO.setRegAccount(info.getApplyLdapNo().toLowerCase());
        UmcQryMemLegalOrgInfoAbilityServiceRspBO umcRspBO = this.umcQryMemLegalOrgInfoAbilityService.qryMemLegalOrgInfo(umcReqBO);
        if (!"0000".equals(umcRspBO.getRespCode())) {
            this.updateGcOrderState(info, "9", "\u8d26\u53f7\u4e0d\u5b58\u5728\uff1a" + info.getApplyLdapNo(), null);
            return rspBO;
        }
        reqBO.setOrgId(umcRspBO.getMemInformation().getOrgId());
        reqBO.setOrgName(umcRspBO.getMemInformation().getOrgName());
        reqBO.setUserId(umcRspBO.getMemInformation().getMemId());
        reqBO.setName(umcRspBO.getMemInformation().getMemName2());
        CrcUmcQryCommodityTypeSupplierListPageAbilityReqBO supInfoReqBO = new CrcUmcQryCommodityTypeSupplierListPageAbilityReqBO();
        supInfoReqBO.setSupplierName(info.getPayeeName());
        CrcUmcQryCommodityTypeSupplierListPageAbilityRspBO abilityRspBO = this.crcUmcQryCommodityTypeSupplierListPageAbilityService.qryCommodityTypeSupplierListPage(supInfoReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            this.updateGcOrderState(info, "9", "\u6536\u6b3e\u65b9\u4e0d\u5b58\u5728\uff1a" + info.getPayeeName(), null);
            return rspBO;
        }
        info.setPayeeId(((UmcCommoditySupplierInfoBO)abilityRspBO.getRows().get(0)).getSupplierId());
        CrcQryCorporationListPageAbilityReqBO crcQryCorporationListPageAbilityReqBO = new CrcQryCorporationListPageAbilityReqBO();
        crcQryCorporationListPageAbilityReqBO.setCorporationNameExact(info.getPayerName());
        CrcQryCorporationListPageAbilityRspBO crcQryCorporationListPageAbilityRspBO = this.crcQryCorporationListPageAbilityService.qryCorporationListPage(crcQryCorporationListPageAbilityReqBO);
        if (!"0000".equals(crcQryCorporationListPageAbilityRspBO.getRespCode())) {
            this.updateGcOrderState(info, "9", "\u4ed8\u6b3e\u65b9\u4e0d\u5b58\u5728\uff1a" + info.getPayerName(), null);
            return rspBO;
        }
        info.setPayerId(((UmcCorporationInfoBO)crcQryCorporationListPageAbilityRspBO.getRows().get(0)).getCorporationId());
        Map<String, FscGcOrderItemPO> fscGcOrderItemPOMap = fscGcOrderItemPOList.stream().filter(o -> !ObjectUtil.isEmpty((Object)o.getSkuNo())).collect(Collectors.toMap(FscGcOrderItemPO::getSkuNo, o -> o, (k1, k2) -> k1));
        List<FscUocSaleOrderInfoBO> inspectionList = this.getAcceptOrderList(((FscGcOrderItemPO)fscGcOrderItemPOList.get(0)).getOrderId());
        if (!ObjectUtil.isEmpty((Object)fscGcOrderItemPOList)) {
            FscGcInvoicePO fscGcInvoicePO = new FscGcInvoicePO();
            fscGcInvoicePO.setFscOrderId(reqBO.getGcFscOrderId());
            List fscGcInvoicePOList = this.fscGcInvoiceMapper.getList(fscGcInvoicePO);
            FscOrderPO fscOrderPO = this.createSaleFscOrder(reqBO, info, inspectionList.get(0));
            Long fscOrderId = fscOrderPO.getFscOrderId();
            for (FscUocSaleOrderInfoBO inspBO : inspectionList) {
                this.createFscOrderRelation(fscOrderId, inspBO, info);
            }
            this.createFscInvoice(fscOrderId, fscGcInvoicePOList);
            this.createFscOrderItem(fscOrderId, fscGcOrderItemPOList, inspectionList);
            this.createFscShouldPay(fscOrderPO, info);
            this.createFscOrderMap(fscOrderPO);
            this.updateGcOrderState(info, "3", "\u7ed3\u7b97\u5355\u5df2\u521b\u5efa\uff1a" + fscOrderPO.getOrderNo(), fscOrderPO);
            this.sendMq(fscOrderId);
        }
        return null;
    }

    private List<FscUocSaleOrderInfoBO> getAcceptOrderList(Long orderIds) {
        FscUocQryAcceptOrderListReqBO fscUocQryAcceptOrderListReqBO = new FscUocQryAcceptOrderListReqBO();
        fscUocQryAcceptOrderListReqBO.setSize(Integer.valueOf(1000));
        fscUocQryAcceptOrderListReqBO.setOrderId(orderIds);
        fscUocQryAcceptOrderListReqBO.setCode("951184533233897472");
        log.info("\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscUocQryAcceptOrderListReqBO));
        FscQrySaleOrderListRspBO fscQryAcceptOrderListRspBO = this.fscUocProQryAcceptOrderListAtomService.qrySaleOrderList(fscUocQryAcceptOrderListReqBO);
        log.debug("\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscQryAcceptOrderListRspBO));
        if (!"0000".equals(fscQryAcceptOrderListRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9a8c\u6536\u5355\u5f02\u5e38");
        }
        if (!ObjectUtil.isEmpty((Object)fscQryAcceptOrderListRspBO.getRows())) {
            return fscQryAcceptOrderListRspBO.getRows();
        }
        return new ArrayList<FscUocSaleOrderInfoBO>();
    }

    private FscOrderPO createSaleFscOrder(FscBatchAutoCreateGcOrderBusiReqBO reqBO, FscGcOrderPO info, FscUocSaleOrderInfoBO orderInfoBO) {
        Long fscOrderId = Sequence.getInstance().nextId();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setSysTenantId(this.crcSysTenantId);
        fscOrderPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setMakeType(FscConstants.FscOrderMakeType.OPERTION);
        fscOrderPO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
        fscOrderPO.setOrderFlowKey(FscOrderFlowProcKeyEnum.INVOICE.getDescr());
        fscOrderPO.setOrderNo(this.getOrderNo(FscConstants.FscOrderReceiveType.PURCHASE, orderInfoBO.getOrderSource()));
        fscOrderPO.setOrderSource(Integer.valueOf(Integer.parseInt(orderInfoBO.getOrderSource())));
        fscOrderPO.setTotalCharge(info.getTotalCharge());
        fscOrderPO.setCurrency(Integer.valueOf(0));
        fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.BILLED);
        fscOrderPO.setSupplierId(info.getPayeeId());
        fscOrderPO.setSupplierName(info.getPayeeName());
        fscOrderPO.setPurOrgPath(orderInfoBO.getPurOrgPath());
        fscOrderPO.setPurchaserId(info.getPayerId());
        fscOrderPO.setPurchaserName(info.getPayerName());
        fscOrderPO.setProOrgId(this.operOrgId);
        fscOrderPO.setProOrgName("\u534e\u6da6\u5b88\u6b63\u62db\u6807\u6709\u9650\u516c\u53f8");
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateOperId(info.getCreateOperId());
        fscOrderPO.setCreateOperName(info.getCreateOperName());
        fscOrderPO.setCreateOrgId(reqBO.getOrgId());
        fscOrderPO.setCreateOrgName(reqBO.getOrgName());
        fscOrderPO.setPayerId(info.getPayerId());
        fscOrderPO.setPayerName(info.getPayerName());
        fscOrderPO.setPayeeId(info.getPayeeId());
        fscOrderPO.setPayeeName(info.getPayeeName());
        fscOrderPO.setBuildAction(Integer.valueOf(1));
        fscOrderPO.setAdjustAmount(BigDecimal.ZERO);
        fscOrderPO.setActualAmount(fscOrderPO.getTotalCharge());
        fscOrderPO.setOrderNum(Integer.valueOf(1));
        fscOrderPO.setLastPayDate(new Date());
        fscOrderPO.setFscBusiType(null);
        fscOrderPO.setFscBusiTypeName(null);
        fscOrderPO.setSecondOrgId(orderInfoBO.getSecondOrgId());
        fscOrderPO.setSecondOrgName(orderInfoBO.getSecondOrgName());
        fscOrderPO.setInvStatus(Integer.valueOf(0));
        fscOrderPO.setSwapUserId(fscOrderPO.getCreateOperId());
        fscOrderPO.setSwapOrgId(fscOrderPO.getCreateOrgId());
        fscOrderPO.setSwapOrgName(fscOrderPO.getCreateOrgName());
        this.fscOrderMapper.insert(fscOrderPO);
        return fscOrderPO;
    }

    private void createFscOrderRelation(Long fscOrderId, FscUocSaleOrderInfoBO inspBO, FscGcOrderPO info) {
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setSysTenantId(this.crcSysTenantId);
        fscOrderRelationPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
        fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderRelationPO.setOrderId(inspBO.getSaleOrderId());
        fscOrderRelationPO.setAcceptOrderId(inspBO.getAcceptOrderId());
        fscOrderRelationPO.setFscOrderId(fscOrderId);
        fscOrderRelationPO.setOrderNo(inspBO.getSaleOrderNo());
        fscOrderRelationPO.setExtOrderNo(inspBO.getSaleOrderNoExt());
        fscOrderRelationPO.setAcceptOrderNo(inspBO.getSaleOrderNoExt());
        fscOrderRelationPO.setOrderCreateTime(inspBO.getCreateTime());
        fscOrderRelationPO.setAcceptCreateTime(null);
        fscOrderRelationPO.setOrderCreateOperId(inspBO.getOrderCreateOperId());
        fscOrderRelationPO.setOrderCreateOperName(inspBO.getOrderCreateOperName() + "/" + inspBO.getOrderCreateLoginName());
        fscOrderRelationPO.setOrderTotalCharge(inspBO.getSaleOrderTotalAmtAmount());
        fscOrderRelationPO.setLastArriveTime(inspBO.getLastArriveTime());
        fscOrderRelationPO.setSupplierId(info.getPayeeId());
        fscOrderRelationPO.setSupplierName(inspBO.getSupplierName());
        fscOrderRelationPO.setPayRule(Integer.valueOf(2));
        fscOrderRelationPO.setRelType(Integer.valueOf(0));
        fscOrderRelationPO.setWholeOrderNo(inspBO.getOrderNo());
        fscOrderRelationPO.setWholeOrderId(inspBO.getOrderId());
        fscOrderRelationPO.setOrderSysTenantId(this.crcSysTenantId);
        fscOrderRelationPO.setOrderSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
        this.fscOrderRelationMapper.insert(fscOrderRelationPO);
    }

    private void createFscOrderItem(Long fscOrderId, List<FscGcOrderItemPO> fscGcOrderItemPOList, List<FscUocSaleOrderInfoBO> inspectionList) {
        HashMap<String, FscUocSaleOrderInfoBO> orderInfoBOMap = new HashMap<String, FscUocSaleOrderInfoBO>();
        HashMap<String, FscUocSaleOrderCommodityInfoBO> orderListMap = new HashMap<String, FscUocSaleOrderCommodityInfoBO>();
        if (!ObjectUtil.isEmpty(inspectionList)) {
            for (FscUocSaleOrderInfoBO fscUocAcceptOrderInfoBO : inspectionList) {
                if (!ObjectUtil.isNotEmpty((Object)fscUocAcceptOrderInfoBO.getCommodityInfos())) continue;
                for (FscUocSaleOrderCommodityInfoBO fscUocAcceptOrderCommodityInfoBO : fscUocAcceptOrderInfoBO.getCommodityInfos()) {
                    orderInfoBOMap.put(fscUocAcceptOrderCommodityInfoBO.getSkuId(), fscUocAcceptOrderInfoBO);
                    orderListMap.put(fscUocAcceptOrderCommodityInfoBO.getSkuId(), fscUocAcceptOrderCommodityInfoBO);
                }
            }
        }
        ArrayList<FscOrderItemPO> orderItemList = new ArrayList<FscOrderItemPO>();
        for (FscGcOrderItemPO item : fscGcOrderItemPOList) {
            FscUocSaleOrderCommodityInfoBO orderItemInfoBO;
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            FscUocSaleOrderInfoBO orderInfoBO = (FscUocSaleOrderInfoBO)orderInfoBOMap.get(String.valueOf(item.getSkuId()));
            if (null == orderInfoBO) {
                orderInfoBO = new FscUocSaleOrderInfoBO();
            }
            if (null == (orderItemInfoBO = (FscUocSaleOrderCommodityInfoBO)orderListMap.get(String.valueOf(item.getSkuId())))) {
                orderItemInfoBO = new FscUocSaleOrderCommodityInfoBO();
            }
            BeanUtils.copyProperties((Object)item, (Object)fscOrderItemPO);
            fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderItemPO.setFscOrderId(fscOrderId);
            fscOrderItemPO.setOrderId(orderInfoBO.getSaleOrderId());
            fscOrderItemPO.setOrderItemId(orderItemInfoBO.getSaleOrderItemId());
            fscOrderItemPO.setAcceptOrderId(null);
            fscOrderItemPO.setOrderBusiType(item.getPurBusiTypeCode());
            fscOrderItemPO.setOrderBusiTypeName(item.getPurBusiTypeName());
            fscOrderItemPO.setAccountEndDate(new Date());
            orderItemList.add(fscOrderItemPO);
        }
        this.fscOrderItemMapper.insertBatch(orderItemList);
    }

    private void createFscInvoice(Long fscOrderId, List<FscGcInvoicePO> fscGcInvoicePOList) {
        if (!ObjectUtil.isEmpty(fscGcInvoicePOList)) {
            ArrayList<FscInvoicePO> invoiceList = new ArrayList<FscInvoicePO>();
            for (FscGcInvoicePO gcInvoicePO : fscGcInvoicePOList) {
                FscInvoicePO invoiceTemp = new FscInvoicePO();
                BeanUtils.copyProperties((Object)gcInvoicePO, (Object)invoiceTemp);
                invoiceTemp.setSysTenantId(this.crcSysTenantId);
                invoiceTemp.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
                invoiceTemp.setInvoiceId(Long.valueOf(Sequence.getInstance().nextId()));
                invoiceTemp.setFscOrderId(fscOrderId);
                invoiceTemp.setRedInvoiceStatus(Integer.valueOf(0));
                invoiceTemp.setInvType(Integer.valueOf(0));
                invoiceTemp.setCreateTime(new Date());
                invoiceList.add(invoiceTemp);
            }
            this.fscInvoiceMapper.insertBatch(invoiceList);
            FscGcInvoicePO info = fscGcInvoicePOList.get(0);
            fscGcInvoicePOList.get(0);
            FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
            fscOrderInvoicePO.setSysTenantId(this.crcSysTenantId);
            fscOrderInvoicePO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
            fscOrderInvoicePO.setFscOrderId(fscOrderId);
            fscOrderInvoicePO.setBuyName(info.getBuyName());
            fscOrderInvoicePO.setTaxNo(info.getTaxNo());
            fscOrderInvoicePO.setInvoiceType("00");
            fscOrderInvoicePO.setInvoiceCategory(Integer.valueOf(2));
            fscOrderInvoicePO.setBank(info.getBank());
            fscOrderInvoicePO.setAccount(info.getAccount());
            fscOrderInvoicePO.setAddress(info.getAddress());
            fscOrderInvoicePO.setPhone(info.getPhone());
            fscOrderInvoicePO.setBillDate(info.getBillDate());
            fscOrderInvoicePO.setBillTime(info.getBillTime());
            this.fscOrderInvoiceMapper.insert(fscOrderInvoicePO);
        }
    }

    private void createFscShouldPay(FscOrderPO fscOrderPO, FscGcOrderPO fscGcOrderPO) {
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        Long shouldPayId = Sequence.getInstance().nextId();
        fscShouldPayPO.setShouldPayId(shouldPayId);
        fscShouldPayPO.setCreateId(fscOrderPO.getCreateOperId());
        fscShouldPayPO.setCreateName(fscOrderPO.getCreateOperName());
        fscShouldPayPO.setCreateAccount(fscGcOrderPO.getApplyLdapNo());
        fscShouldPayPO.setCreateTime(new Date());
        fscShouldPayPO.setCreateCompanyId(fscOrderPO.getPayerId());
        fscShouldPayPO.setCreateCompanyName(fscOrderPO.getPayerName());
        fscShouldPayPO.setCreateOrgId(fscOrderPO.getCreateOrgId());
        fscShouldPayPO.setCreateOrgName(fscOrderPO.getCreateOrgName());
        fscShouldPayPO.setPayingAmount(new BigDecimal(0));
        fscShouldPayPO.setPaidAmount(new BigDecimal(0));
        fscShouldPayPO.setToPayAmount(fscOrderPO.getTotalCharge());
        fscShouldPayPO.setPenalty(new BigDecimal(0));
        fscShouldPayPO.setOriginalAmount(fscOrderPO.getTotalCharge());
        fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
        if (StringUtils.isEmpty((String)fscShouldPayPO.getShouldPayNo())) {
            fscShouldPayPO.setShouldPayNo(fscOrderPO.getOrderNo());
        }
        fscShouldPayPO.setSysTenantId(fscOrderPO.getSysTenantId());
        fscShouldPayPO.setSysTenantName(fscOrderPO.getSysTenantName());
        this.fscShouldPayMapper.insert(fscShouldPayPO);
    }

    private void createFscOrderMap(FscOrderPO fscOrderPO) {
        FscOrderMapPO isWelfareBO = new FscOrderMapPO();
        isWelfareBO.setId(fscOrderPO.getFscOrderId());
        isWelfareBO.setFscOrderId(fscOrderPO.getFscOrderId());
        isWelfareBO.setSysTenantId(fscOrderPO.getSysTenantId());
        isWelfareBO.setSysTenantName(fscOrderPO.getSysTenantName());
        isWelfareBO.setCreateTime(fscOrderPO.getCreateTime());
        isWelfareBO.setFieldCode("isWelfare");
        isWelfareBO.setFieldName("\u662f\u5426\u662f\u5458\u5de5\u798f\u5229\u9a8c\u6536\u5355");
        isWelfareBO.setFieldValue("YES");
        this.fscOrderMapMapper.insert(isWelfareBO);
    }

    private void createPayOrder(FscOrderPO fscOrderPO) {
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setSysTenantId(this.crcSysTenantId);
        fscShouldPayPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
        fscShouldPayPO.setShouldPayId(Long.valueOf(Sequence.getInstance().nextId()));
        fscShouldPayPO.setShouldPayNo("GC-");
    }

    private void updateGcOrderState(FscGcOrderPO info, String state, String reason, FscOrderPO fscOrderPO) {
        FscGcOrderPO where = new FscGcOrderPO();
        where.setFscOrderId(info.getFscOrderId());
        FscGcOrderPO set = new FscGcOrderPO();
        set.setDealState(state);
        set.setDealFailReason(reason);
        set.setUpdateTime(new Date());
        if (null != fscOrderPO) {
            set.setNewFscOrderId(fscOrderPO.getFscOrderId());
        }
        this.fscGcOrderMapper.updateBy(set, where);
    }

    private String getOrderNo(Integer receiveType, String orderSource) {
        StringBuilder keySb = new StringBuilder();
        keySb.append(receiveType);
        keySb.append(FscConstants.FscBusiModel.TRADE);
        keySb.append(orderSource);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)keySb.toString()).getDesc());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setSysTenantId(this.crcSysTenantId);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        fscComOrderListSyncAbilityReqBO.setSysTenantId(this.crcSysTenantId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        fscComInvoiceListSyncAbilityReqBO.setSysTenantId(this.crcSysTenantId);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
    }
}

