/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillAdjustInvoiceSignBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillAdjustInvoiceSignBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiRspBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscStockOperAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscGoodsDeductionAdjustMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscGoodsDeductionAdjustPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillAdjustInvoiceSignBusiServiceImpl
implements FscBillAdjustInvoiceSignBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillAdjustInvoiceSignBusiServiceImpl.class);
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    @Autowired
    private FscStockOperAtomService fscStockOperAtomService;
    @Autowired
    private FscGoodsDeductionAdjustMapper fscGoodsDeductionAdjustMapper;

    @Override
    public FscBillOrderInvoiceSignBusiRspBO dealAdjustInvoiceSign(FscBillAdjustInvoiceSignBusiReqBO reqBO) {
        FscGoodsDeductionAdjustPO fscOrderInvoicePoSet = new FscGoodsDeductionAdjustPO();
        if (null != reqBO.getUserId()) {
            fscOrderInvoicePoSet.setInvoiceSignUserId(reqBO.getUserId());
        }
        fscOrderInvoicePoSet.setInvoiceSignUserName(reqBO.getName());
        fscOrderInvoicePoSet.setSignDate(new Date());
        fscOrderInvoicePoSet.setStatus(FscConstants.GoodsAdjustStatus.INVOICE_SIGN);
        FscGoodsDeductionAdjustPO fscOrderInvoicePowhere = new FscGoodsDeductionAdjustPO();
        fscOrderInvoicePowhere.setFscAdjustId(reqBO.getFscAdjustId());
        fscOrderInvoicePowhere.setSysTenantId(reqBO.getSysTenantId());
        this.fscGoodsDeductionAdjustMapper.updateBy(fscOrderInvoicePoSet, fscOrderInvoicePowhere);
        return new FscBillOrderInvoiceSignBusiRspBO();
    }

    private void syncOrderStatus(Long fscOrderId, Long sysTenantId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.SIGN);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        fscUocOrderRelUpdateAtomReqBO.setSysTenantId(sysTenantId);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscBillOrderInvoiceSignBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            fscPayShouldPayCreateAtomReqBO.setSysTenantId(reqBO.getSysTenantId());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private void inStock(Long fscOrderId, Integer stockFlag, Long sysTenantId) {
        FscStockOperAtomReqBO fscStockOperAtomReqBO = new FscStockOperAtomReqBO();
        fscStockOperAtomReqBO.setOperType(stockFlag);
        fscStockOperAtomReqBO.setFscOrderId(fscOrderId);
        fscStockOperAtomReqBO.setSysTenantId(sysTenantId);
        FscStockOperAtomRspBO fscStockOperAtomRspBO = this.fscStockOperAtomService.dealStockOper(fscStockOperAtomReqBO);
        if (!"0000".equals(fscStockOperAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscStockOperAtomRspBO.getRespDesc());
        }
    }
}

