/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.atom.api.FscBatchSaveStockAtomService;
import com.tydic.fsc.bill.atom.bo.FscBatchSaveStockAtomReqBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceMaintainBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceAttachmentBusiBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceMaintainBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceMaintainBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceMaintainItemBusiBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePostMapper;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePostPO;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderMapPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class FscBillInvoiceMaintainBusiServiceImpl
implements FscBillInvoiceMaintainBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillInvoiceMaintainBusiServiceImpl.class);
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoicePostMapper fscInvoicePostMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscBatchSaveStockAtomService fscBatchSaveStockAtomService;
    @Resource(name="fscOrderStatusSyncServiceProvider")
    private ProxyMessageProducer fscOrderStatusSyncServiceProvider;
    @Value(value="${FSC_ORDER_STATUS_SYNC_ORDER_TOPIC:FSC_ORDER_STATUS_SYNC_ORDER_TOPIC}")
    private String fscOrderStatusSyncOrderTopic;
    @Value(value="${FSC_ORDER_STATUS_SYNC_ORDER_TAG:FSC_ORDER_STATUS_SYNC_ORDER_TAG}")
    private String fscOrderStatusSyncOrderTag;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderMapMapper fscOrderMapMapper;

    @Override
    public FscBillInvoiceMaintainBusiRspBO dealInvoiceUpload(FscBillInvoiceMaintainBusiReqBO reqBO) {
        FscOrderPO whereStatusPo;
        FscOrderPO setStatusPo;
        FscInvoicePO fscInvoicePo = new FscInvoicePO();
        fscInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        fscInvoicePo.setUnEditInvoiceIds(ObjectUtils.isEmpty(reqBO.getUnEditInvoiceIds()) ? null : reqBO.getUnEditInvoiceIds());
        fscInvoicePo.setSysTenantId(reqBO.getSysTenantId());
        List fscInvoicePOS = this.fscInvoiceMapper.getList(fscInvoicePo);
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
            List invoiceIds = fscInvoicePOS.stream().map(FscInvoicePO::getInvoiceId).collect(Collectors.toList());
            FscInvoicePO deleteInvoicePO = new FscInvoicePO();
            deleteInvoicePO.setFscOrderId(reqBO.getFscOrderId());
            deleteInvoicePO.setInvoiceIds(invoiceIds);
            deleteInvoicePO.setSysTenantId(reqBO.getSysTenantId());
            this.fscInvoiceMapper.deleteBy(deleteInvoicePO);
            List mailIds = fscInvoicePOS.stream().map(FscInvoicePO::getMailId).collect(Collectors.toList());
            FscInvoicePostPO fscInvoicePostPo = new FscInvoicePostPO();
            fscInvoicePostPo.setIds(mailIds);
            fscInvoicePostPo.setSysTenantId(reqBO.getSysTenantId());
            fscInvoicePostPo = this.fscInvoicePostMapper.getModelBy(fscInvoicePostPo);
            if (null != fscInvoicePostPo) {
                this.fscInvoicePostMapper.deleteBy(fscInvoicePostPo);
            }
        }
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setFscOrderId(reqBO.getFscOrderId());
        fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.INVOICE);
        fscAttachmentPo.setSysTenantId(reqBO.getSysTenantId());
        fscAttachmentPo.setUnEditAttachmentIds(ObjectUtils.isEmpty(reqBO.getUnEditAttachmentIds()) ? null : reqBO.getUnEditAttachmentIds());
        List fscAttachmentPOS = this.fscAttachmentMapper.getList(fscAttachmentPo);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
            List attachmentIds = fscAttachmentPOS.stream().map(FscAttachmentPO::getAttachmentId).collect(Collectors.toList());
            FscAttachmentPO deleteAttachmentPO = new FscAttachmentPO();
            fscAttachmentPo.setFscOrderId(reqBO.getFscOrderId());
            fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.INVOICE);
            deleteAttachmentPO.setAttachmentIds(attachmentIds);
            this.fscAttachmentMapper.deleteBy(fscAttachmentPo);
        }
        ArrayList<FscInvoicePO> fscInvoicePOList = new ArrayList<FscInvoicePO>();
        ArrayList fscInvoiceItemPOList = new ArrayList();
        ArrayList<FscAttachmentPO> fscAttachmentPOList = new ArrayList<FscAttachmentPO>();
        ArrayList<FscInvoiceRulePO> fscInvoiceRulePOList = new ArrayList<FscInvoiceRulePO>();
        Long mailId = Sequence.getInstance().nextId();
        BigDecimal totalInvoiceAmt = BigDecimal.ZERO;
        for (FscBillInvoiceMaintainItemBusiBO fscBillInvoiceMaintainItemBusiBO : reqBO.getBillInvoiceMaintainItemBusiBOS()) {
            totalInvoiceAmt = totalInvoiceAmt.add(fscBillInvoiceMaintainItemBusiBO.getAmt());
            if (reqBO.getUnEditInvoiceIds().contains(fscBillInvoiceMaintainItemBusiBO.getInvoiceId())) continue;
            fscInvoicePo = (FscInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscBillInvoiceMaintainItemBusiBO), FscInvoicePO.class);
            fscInvoicePo.setCreateCompanyId(reqBO.getCompanyId());
            fscInvoicePo.setCreateCompanyName(reqBO.getCompanyName());
            if (null != reqBO.getUserId()) {
                fscInvoicePo.setCreateOperId(reqBO.getUserId().toString());
            }
            fscInvoicePo.setCreateOrgId(reqBO.getOrgId());
            fscInvoicePo.setCreateOrgName(reqBO.getOrgName());
            fscInvoicePo.setCreateTime(new Date());
            fscInvoicePo.setStatus(FscConstants.FscInvoiceStatus.VALID);
            fscInvoicePo.setInvoiceId(Long.valueOf(Sequence.getInstance().nextId()));
            fscInvoicePo.setFscOrderId(reqBO.getFscOrderId());
            fscInvoicePo.setMailId(mailId);
            fscInvoicePo.setBillDate(DateUtil.dateToStr((Date)new Date()));
            fscInvoicePo.setSysTenantId(reqBO.getSysTenantId());
            fscInvoicePo.setSysTenantName(reqBO.getSysTenantName());
            if (ObjectUtils.isEmpty((Object)fscInvoicePo.getBuyName()) || ObjectUtils.isEmpty((Object)fscInvoicePo.getTaxNo())) {
                FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
                fscOrderInvoicePO.setFscOrderId(fscInvoicePo.getFscOrderId());
                fscOrderInvoicePO.setSysTenantId(reqBO.getSysTenantId());
                List fscOrderInvoicePOS = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePO);
                if (!ObjectUtils.isEmpty((Object)fscOrderInvoicePOS)) {
                    fscInvoicePo.setBuyName(((FscOrderInvoicePO)fscOrderInvoicePOS.get(0)).getBuyName());
                    fscInvoicePo.setTaxNo(((FscOrderInvoicePO)fscOrderInvoicePOS.get(0)).getTaxNo());
                }
            }
            fscInvoicePOList.add(fscInvoicePo);
            FscInvoiceRulePO fscInvoiceRulePO2 = new FscInvoiceRulePO();
            fscInvoiceRulePO2.setFscOrderId(reqBO.getFscOrderId());
            fscInvoiceRulePO2.setDataStatus(FscConstants.FscInvoiceRuleStatus.YES);
            fscInvoiceRulePO2.setInvoiceId(fscInvoicePo.getInvoiceId());
            if (ObjectUtils.isEmpty(fscBillInvoiceMaintainItemBusiBO.getFscBillInvoiceAttachmentBOList())) continue;
            for (FscBillInvoiceAttachmentBusiBO attachmentItem : fscBillInvoiceMaintainItemBusiBO.getFscBillInvoiceAttachmentBOList()) {
                fscAttachmentPo = new FscAttachmentPO();
                fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPo.setAttachmentUrl(attachmentItem.getEInvoiceUrl());
                if (attachmentItem.getEInvoiceUrl().indexOf("http") == -1 || attachmentItem.getEInvoiceUrl().indexOf(".") == -1) {
                    throw new ZTBusinessException("\u53d1\u7968\u9644\u4ef6\u5730\u5740\u4e0d\u7b26\u4f55\u89c4\u5219");
                }
                String end = attachmentItem.getEInvoiceUrl().substring(attachmentItem.getEInvoiceUrl().lastIndexOf("."));
                fscAttachmentPo.setAttachmentName(attachmentItem.getEInvoiceName());
                fscAttachmentPo.setAttachmentType(attachmentItem.getAttachmentType());
                fscAttachmentPo.setObjId(fscInvoicePo.getInvoiceId());
                fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.INVOICE);
                fscAttachmentPo.setFscOrderId(reqBO.getFscOrderId());
                fscAttachmentPo.setAttachmentUrlSource(ObjectUtils.isEmpty((Object)attachmentItem.getAttachmentUrlSource()) ? "0" : attachmentItem.getAttachmentUrlSource());
                fscAttachmentPo.setSysTenantId(reqBO.getSysTenantId());
                fscAttachmentPo.setSysTenantName(reqBO.getSysTenantName());
                fscAttachmentPOList.add(fscAttachmentPo);
                fscInvoiceRulePO2.setElecStatus(FscConstants.FscInvoiceRuleStatus.YES);
                fscInvoiceRulePOList.add(fscInvoiceRulePO2);
            }
        }
        if (CollectionUtils.isEmpty(fscInvoicePOList)) {
            throw new FscBusinessException("8888", "\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a");
        }
        log.info("\u4fdd\u5b58\u53d1\u7968\u4fe1\u606f\u5165\u53c2\uff1a{}", fscInvoicePOList);
        this.fscInvoiceMapper.insertBatch(fscInvoicePOList);
        if (!CollectionUtils.isEmpty(fscAttachmentPOList)) {
            log.info("\u4fdd\u5b58\u53d1\u7968\u9644\u4ef6\u4fe1\u606f\u5165\u53c2\uff1a{}", fscAttachmentPOList);
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOList);
        }
        if (!CollectionUtils.isEmpty(fscInvoiceRulePOList)) {
            log.info("\u66f4\u65b0\u53d1\u7968\u89c4\u5219\u5165\u53c2\uff1a{}", fscInvoiceRulePOList);
            fscInvoiceRulePOList.forEach(fscInvoiceRulePO -> this.fscInvoiceRuleMapper.updateById(fscInvoiceRulePO));
        }
        this.insertInvoicePost(reqBO.getFscOrderId(), mailId, reqBO.getSysTenantId());
        log.info("\u53d1\u7968\u6c47\u603b\u91d1\u989d\uff1a{},\u7ed3\u7b97\u91d1\u989d\uff1a{}", (Object)totalInvoiceAmt, (Object)reqBO.getFscOrderTotalCharge());
        if (totalInvoiceAmt.compareTo(reqBO.getFscOrderTotalCharge()) == -1) {
            if ((FscConstants.FscInvoiceOrderState.SUBMITTING.equals(reqBO.getOrderState()) || FscConstants.FscInvoiceOrderState.UNBILLED.equals(reqBO.getOrderState())) && !ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
                setStatusPo = new FscOrderPO();
                setStatusPo.setOrderState(FscConstants.FscInvoiceOrderState.BILLING);
                whereStatusPo = new FscOrderPO();
                whereStatusPo.setFscOrderId(reqBO.getFscOrderId());
                whereStatusPo.setSysTenantId(reqBO.getSysTenantId());
                log.info("\u66f4\u65b0\u7ed3\u7b97\u5355\u72b6\u6001\u5165\u53c2\uff1a{},\u6761\u4ef6:{}", (Object)JSON.toJSONString((Object)setStatusPo), (Object)JSON.toJSONString((Object)whereStatusPo));
                this.fscOrderMapper.updateBy(setStatusPo, whereStatusPo);
            }
        } else if (totalInvoiceAmt.compareTo(reqBO.getFscOrderTotalCharge()) == 0) {
            if ((FscConstants.FscInvoiceOrderState.SUBMITTING.equals(reqBO.getOrderState()) || FscConstants.FscInvoiceOrderState.UNBILLED.equals(reqBO.getOrderState())) && !ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
                setStatusPo = new FscOrderPO();
                setStatusPo.setOrderState(FscConstants.FscInvoiceOrderState.BILLED);
                whereStatusPo = new FscOrderPO();
                whereStatusPo.setFscOrderId(reqBO.getFscOrderId());
                whereStatusPo.setSysTenantId(reqBO.getSysTenantId());
                log.info("\u66f4\u65b0\u7ed3\u7b97\u5355\u72b6\u6001\u5165\u53c2\uff1a{},\u6761\u4ef6:{}", (Object)JSON.toJSONString((Object)setStatusPo), (Object)JSON.toJSONString((Object)whereStatusPo));
                this.fscOrderMapper.updateBy(setStatusPo, whereStatusPo);
            }
            if ((FscConstants.FscInvoiceOrderState.BILLING.equals(reqBO.getOrderState()) || FscConstants.FscInvoiceOrderState.BILLING_SUP.equals(reqBO.getOrderState())) && !ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
                setStatusPo = new FscOrderPO();
                setStatusPo.setOrderState(FscConstants.FscInvoiceOrderState.BILLED);
                whereStatusPo = new FscOrderPO();
                whereStatusPo.setFscOrderId(reqBO.getFscOrderId());
                whereStatusPo.setSysTenantId(reqBO.getSysTenantId());
                log.info("\u66f4\u65b0\u7ed3\u7b97\u5355\u72b6\u6001\u5165\u53c2\uff1a{},\u6761\u4ef6:{}", (Object)JSON.toJSONString((Object)setStatusPo), (Object)JSON.toJSONString((Object)whereStatusPo));
                this.fscOrderMapper.updateBy(setStatusPo, whereStatusPo);
            }
        }
        FscOrderMapPO fscOrderMapPo = new FscOrderMapPO();
        fscOrderMapPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderMapPo.setFieldCode("reApplyInvoiceFlag");
        fscOrderMapPo.setSysTenantId(reqBO.getSysTenantId());
        fscOrderMapPo = this.fscOrderMapMapper.getModelBy(fscOrderMapPo);
        if (null != fscOrderMapPo) {
            fscOrderMapPo.setFieldValue("0");
            fscOrderMapPo.setUpdateTime(new Date());
            fscOrderMapPo.setUpdateOperId(null != reqBO.getUserId() ? reqBO.getUserId().toString() : "");
            FscOrderMapPO mapWhere = new FscOrderMapPO();
            mapWhere.setId(fscOrderMapPo.getId());
            mapWhere.setSysTenantId(reqBO.getSysTenantId());
            this.fscOrderMapMapper.updateBy(fscOrderMapPo, mapWhere);
        }
        this.syncOrderStatus(reqBO.getFscOrderId(), reqBO);
        if (totalInvoiceAmt.compareTo(reqBO.getFscOrderTotalCharge()) == 0) {
            FscBatchSaveStockAtomReqBO fscBatchSaveStockAtomReqBO = new FscBatchSaveStockAtomReqBO();
            fscBatchSaveStockAtomReqBO.setFscOrderIds(Arrays.asList(reqBO.getFscOrderId()));
            fscBatchSaveStockAtomReqBO.setSysTenantId(reqBO.getSysTenantId());
            this.fscBatchSaveStockAtomService.batchSaveStock(fscBatchSaveStockAtomReqBO);
        }
        return new FscBillInvoiceMaintainBusiRspBO();
    }

    private void insertInvoicePost(Long fscOrderId, Long mailId, Long sysTenantId) {
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(fscOrderId);
        fscOrderInvoicePO.setSysTenantId(sysTenantId);
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        if (null == fscOrderInvoicePO) {
            throw new FscBusinessException("193007", "\u67e5\u8be2\u7ed3\u7b97\u5355\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a");
        }
        FscInvoicePostPO fscInvoicePostPO = (FscInvoicePostPO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderInvoicePO), FscInvoicePostPO.class);
        fscInvoicePostPO.setId(mailId);
        fscInvoicePostPO.setSendStatus("2");
        fscInvoicePostPO.setAddress(fscOrderInvoicePO.getReceiveAddr());
        this.fscInvoicePostMapper.insert(fscInvoicePostPO);
    }

    private void syncOrderStatus(Long fscOrderId, FscBillInvoiceMaintainBusiReqBO reqBO) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.BILLED);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        fscUocOrderRelUpdateAtomReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscUocOrderRelUpdateAtomReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscOrderStatusSyncServiceProvider.send(new ProxyMessage(this.fscOrderStatusSyncOrderTopic, this.fscOrderStatusSyncOrderTag, JSON.toJSONString((Object)fscUocOrderRelUpdateAtomReqBO)));
    }
}

