/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.bill.busi.api.FscBillOrderResubmitApprovalCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderResubmitApprovalCreateReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderResubmitApprovalCreateRspBO;
import com.tydic.fsc.busibase.atom.api.FscAuditOrderCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscGeneralBusiRuleExecAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscGeneralBusiRuleExecAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscGeneralBusiRuleExecAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillOrderResubmitApprovalCreateBusiServiceImpl
implements FscBillOrderResubmitApprovalCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderResubmitApprovalCreateBusiServiceImpl.class);
    @Autowired
    private FscAuditOrderCreateAtomService fscAuditOrderCreateAtomService;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Autowired
    private FscGeneralBusiRuleExecAtomService fscGeneralBusiRuleExecAtomService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    private static final String NO_NEED_AUDIT = "noNeedAudit";

    @Override
    public FscBillOrderResubmitApprovalCreateRspBO resubmitApprovalCreate(FscBillOrderResubmitApprovalCreateReqBO reqBO) {
        FscBillOrderResubmitApprovalCreateRspBO fscBillOrderResubmitApprovalCreateRspBO = new FscBillOrderResubmitApprovalCreateRspBO();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        FscOrderPO orderInfo = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (ObjectUtils.isEmpty((Object)orderInfo)) {
            log.info("\u7ed3\u7b97\u5ba1\u6279\u5355\u4e0d\u4e0d\u5b58\u5728:{}", (Object)reqBO);
            throw new ZTBusinessException("\u7ed3\u7b97\u5ba1\u6279\u5355\u4e0d\u5b58\u5728");
        }
        FscGeneralBusiRuleExecAtomReqBO fscGeneralBusiRuleExecAtomReqBO = new FscGeneralBusiRuleExecAtomReqBO();
        fscGeneralBusiRuleExecAtomReqBO.setServiceCode("FSC002");
        JSONObject jsonObj = JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)));
        jsonObj.put("orgId", (Object)jsonObj.getString("orgId"));
        fscGeneralBusiRuleExecAtomReqBO.setParamJsonStr(JSON.toJSONString((Object)jsonObj));
        fscGeneralBusiRuleExecAtomReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscGeneralBusiRuleExecAtomRspBO fscGeneralBusiRuleExecAtomRspBO = this.fscGeneralBusiRuleExecAtomService.dealGeneralBusiRuleExec(fscGeneralBusiRuleExecAtomReqBO);
        if (!StringUtils.hasText((String)fscGeneralBusiRuleExecAtomRspBO.getBusiRuleExecResult())) {
            throw new FscBusinessException("193208", "\u6ca1\u6709\u914d\u7f6e\u7ed3\u7b97\u5ba1\u6279\u6d41\u89c4\u5219");
        }
        log.info("\u7ed3\u7b97\u5ba1\u6279\u914d\u7f6e\u89c4\u5219:{}", (Object)fscGeneralBusiRuleExecAtomRspBO);
        JSONObject callRuleRspJsonObj = JSON.parseObject((String)fscGeneralBusiRuleExecAtomRspBO.getBusiRuleExecResult());
        String createEvaProcessKey = callRuleRspJsonObj.getString("processKey");
        if (createEvaProcessKey.equals(NO_NEED_AUDIT)) {
            reqBO.setApproval(false);
        }
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
        HashMap<String, Number> paramMap = new HashMap<String, Number>(2);
        if (reqBO.getApproval().booleanValue()) {
            paramMap.put("auditFlag", FscConstants.APPROVAL_ORDER_STATUS.NEXT);
        } else {
            paramMap.put("auditFlag", FscConstants.APPROVAL_ORDER_STATUS.ACCESS);
        }
        paramMap.put("auditObjId", reqBO.getFscOrderId());
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        fscOrderStatusStartAtomReqBO.setOrderId(reqBO.getFscOrderId());
        log.info("\u521b\u5efa\u7ed3\u7b97\u5ba1\u6279\u4e3b\u6d41\u7a0b\u5165\u53c2:{}", (Object)fscOrderStatusStartAtomReqBO);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
        if (reqBO.getApproval().booleanValue()) {
            try {
                this.createApproval(orderInfo, reqBO, "invoice_flow_approval_key");
            }
            catch (FscBusinessException e) {
                log.info("\u6ca1\u67e5\u8be2\u5230\u914d\u7f6e\u5ba1\u6279\u6d41\u7a0b");
            }
        }
        List<Long> fscOrderIds = Arrays.asList(orderInfo.getFscOrderId());
        this.syncOrderStatus(fscOrderIds, orderInfo.getMakeType(), reqBO.getSysTenantId());
        fscBillOrderResubmitApprovalCreateRspBO.setRespCode("0000");
        fscBillOrderResubmitApprovalCreateRspBO.setRespDesc("\u6210\u529f");
        return fscBillOrderResubmitApprovalCreateRspBO;
    }

    private void syncOrderStatus(List<Long> fscOrderIds, Integer makeType, Long sysTenantId) {
        fscOrderIds.forEach(fscOrderId -> {
            FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
            fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            fscUocOrderRelUpdateAtomReqBO.setMakeType(makeType);
            fscUocOrderRelUpdateAtomReqBO.setSysTenantId(sysTenantId);
            this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        });
    }

    private void createApproval(FscOrderPO orderInfo, FscBillOrderResubmitApprovalCreateReqBO reqBO, String key) {
        log.info("\u521b\u5efa\u7ed3\u7b97\u5ba1\u6279\u5165\u53c2:{},\u7ed3\u7b97\u5355\u5165\u53c2:{}", (Object)reqBO, (Object)orderInfo);
        FscAuditOrderCreateAtomReqBO fscAuditOrderCreateAtomReqBO = new FscAuditOrderCreateAtomReqBO();
        fscAuditOrderCreateAtomReqBO.setOrderId(orderInfo.getFscOrderId());
        fscAuditOrderCreateAtomReqBO.setObjId(orderInfo.getFscOrderId());
        fscAuditOrderCreateAtomReqBO.setObjType(FscConstants.OBJ_TYPE.FSC_ORDER);
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(orderInfo.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
        }
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(orderInfo.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
        }
        if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(orderInfo.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
        }
        if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(orderInfo.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
        }
        if (FscConstants.OrderFlow.INVOICE_APPROVAL.equals(orderInfo.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.APPROVAL_ORDER_INVOICE);
        }
        fscAuditOrderCreateAtomReqBO.setUserId(reqBO.getUserId());
        fscAuditOrderCreateAtomReqBO.setUserName(reqBO.getName());
        fscAuditOrderCreateAtomReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscAuditOrderCreateAtomRspBO atomRspBO = this.fscAuditOrderCreateAtomService.dealAuditOrderCreate(fscAuditOrderCreateAtomReqBO);
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = (EacStartProjectAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), EacStartProjectAbilityReqBO.class);
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(key);
        eacStartProjectAbilityReqBO.setPartitionKey(orderInfo.getFscOrderId().toString());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("auditId", atomRspBO.getAuditOrderId());
        variables.put("todoOrderNo", orderInfo.getOrderNo());
        variables.put("sysTenantId", reqBO.getSysTenantId());
        eacStartProjectAbilityReqBO.setVariables(variables);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(orderInfo.getFscOrderId().toString());
        eacStartProjectAbilityReqBO.setBusinessIdList(strings);
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        eacStartProjectAbilityReqBO.setSysTenantId(reqBO.getSysTenantId().toString());
        eacStartProjectAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
    }
}

