/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillRedInvoiceSaveToSzBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillRedInvoiceSaveToSzBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillRedInvoiceSaveToSzBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoiceQryAttachmentToSzBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class FscBillRedInvoiceSaveToSzBusiServiceImpl
implements FscBillRedInvoiceSaveToSzBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillRedInvoiceSaveToSzBusiServiceImpl.class);
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @Override
    public FscBillRedInvoiceSaveToSzBusiRspBO redInvoiceSaveToSz(FscBillRedInvoiceSaveToSzBusiReqBO reqBO) {
        FscBillRedInvoiceSaveToSzBusiRspBO rspBO = new FscBillRedInvoiceSaveToSzBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscInvoicePO oldInvoiceInfo = new FscInvoicePO();
        oldInvoiceInfo.setInvoiceId(reqBO.getInvoiceId());
        oldInvoiceInfo.setSysTenantId(reqBO.getSysTenantId());
        oldInvoiceInfo = this.fscInvoiceMapper.getModelBy(oldInvoiceInfo);
        FscInvoiceItemPO fscInvoiceItemPO = new FscInvoiceItemPO();
        fscInvoiceItemPO.setInvoiceId(reqBO.getInvoiceId());
        fscInvoiceItemPO.setSysTenantId(reqBO.getSysTenantId());
        List oldInvoiceItemPOList = this.fscInvoiceItemMapper.getList(fscInvoiceItemPO);
        Map<Long, FscInvoiceItemPO> oldInvoiceItemMap = oldInvoiceItemPOList.stream().collect(Collectors.toMap(FscInvoiceItemPO::getId, o -> o, (k1, k2) -> k1));
        Long newInvoiceId = Sequence.getInstance().nextId();
        ArrayList<FscInvoiceItemPO> newInvoiceItemPOList = new ArrayList<FscInvoiceItemPO>();
        for (FscInvoiceItemPO invoiceItemPO : oldInvoiceItemPOList) {
            FscInvoiceItemPO newInvoiceItemPO = new FscInvoiceItemPO();
            BeanUtils.copyProperties((Object)invoiceItemPO, (Object)newInvoiceItemPO);
            newInvoiceItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            newInvoiceItemPO.setInvoiceId(newInvoiceId);
            newInvoiceItemPO.setAmt(invoiceItemPO.getAmt().negate());
            newInvoiceItemPO.setUntaxAmt(invoiceItemPO.getUntaxAmt().negate());
            newInvoiceItemPO.setTaxAmt(invoiceItemPO.getTaxAmt().negate());
            newInvoiceItemPO.setNum(invoiceItemPO.getNum().negate());
            log.info("\u4fdd\u5b58\u7ea2\u5b57\u53d1\u7968\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)newInvoiceItemPO));
            newInvoiceItemPOList.add(newInvoiceItemPO);
        }
        if (!ObjectUtil.isEmpty(newInvoiceItemPOList)) {
            this.fscInvoiceItemMapper.insertBatch(newInvoiceItemPOList);
        }
        BigDecimal taxAmt = reqBO.getElectricInvoiceDetails().stream().map(o -> o.getGoodsTotalTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amt = reqBO.getElectricInvoiceDetails().stream().map(o -> o.getGoodsTotalPriceTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal unTaxAmt = amt.subtract(taxAmt);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        BeanUtils.copyProperties((Object)oldInvoiceInfo, (Object)fscInvoicePO);
        fscInvoicePO.setInvoiceId(newInvoiceId);
        fscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String billDate = sdf.format(reqBO.getInvoiceDate());
        fscInvoicePO.setBillDate(billDate);
        fscInvoicePO.setTaxAmt(taxAmt.setScale(4, RoundingMode.HALF_UP));
        fscInvoicePO.setAmt(amt.setScale(4, RoundingMode.HALF_UP));
        fscInvoicePO.setUntaxAmt(amt.subtract(taxAmt).setScale(4, RoundingMode.HALF_UP));
        fscInvoicePO.setTax(reqBO.getElectricInvoiceDetails().get(0).getGoodsTaxRate().toString());
        fscInvoicePO.setInvoiceCode(reqBO.getInvoiceNo());
        fscInvoicePO.setInvoiceNo(reqBO.getInvoiceNo());
        fscInvoicePO.setCreateTime(new Date());
        fscInvoicePO.setRedInvoiceStatus(Integer.valueOf(3));
        fscInvoicePO.setInvType(Integer.valueOf(1));
        fscInvoicePO.setInvoiceRelNo(reqBO.getOriginalInvoiceNo());
        fscInvoicePO.setInvoiceRelId(reqBO.getInvoiceId());
        log.info("\u4fdd\u5b58\u7ea2\u5b57\u53d1\u7968\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscInvoicePO));
        this.fscInvoiceMapper.insert(fscInvoicePO);
        oldInvoiceInfo.setRedInvoiceStatus(Integer.valueOf(3));
        oldInvoiceInfo.setInvoiceRelId(newInvoiceId);
        oldInvoiceInfo.setInvoiceRelNo(reqBO.getInvoiceNo());
        this.fscInvoiceMapper.updateById(oldInvoiceInfo);
        List<FscAttachmentPO> attachmentList = this.getAttachmentList(reqBO.getAdditionalDetails(), newInvoiceId, reqBO.getFscOrderId(), reqBO.getSysTenantId(), reqBO.getSysTenantName());
        if (!ObjectUtil.isEmpty(attachmentList)) {
            log.info("\u4fdd\u5b58\u7ea2\u5b57\u53d1\u7968\u9644\u4ef6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(attachmentList));
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        FscOrderPO setFscOrderPO = new FscOrderPO();
        setFscOrderPO.setInvStatus(Integer.valueOf(2));
        setFscOrderPO.setInvoicingState(Integer.valueOf(1));
        FscOrderPO whereFscOrderPO = new FscOrderPO();
        whereFscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        whereFscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        if (!ObjectUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            this.fscOrderMapper.updateBy(setFscOrderPO, whereFscOrderPO);
        }
        return rspBO;
    }

    private List<FscAttachmentPO> getAttachmentList(List<FscCrcInvoiceQryAttachmentToSzBO> additionalDetails, Long newInvoiceId, Long fscOrderId, Long sysTenantId, String sysTenantName) {
        ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>(6);
        for (FscCrcInvoiceQryAttachmentToSzBO additionalDetail : additionalDetails) {
            FscAttachmentPO attachmentBO;
            if (StringUtils.isNotBlank((CharSequence)additionalDetail.getPdfXml())) {
                attachmentBO = new FscAttachmentPO();
                attachmentBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentBO.setAttachmentUrl(additionalDetail.getPdfXml());
                attachmentBO.setAttachmentType(FscConstants.AttachmentType.RED_INVOICE);
                attachmentBO.setAttachmentName("\u7ea2\u5b57\u53d1\u7968pdf\u9644\u4ef6");
                attachmentBO.setObjId(newInvoiceId);
                attachmentBO.setObjType(FscConstants.AttachmentObjType.INVOICE);
                attachmentBO.setFscOrderId(fscOrderId);
                attachmentBO.setSysTenantId(sysTenantId);
                attachmentBO.setSysTenantName(sysTenantName);
                attachmentList.add(attachmentBO);
            }
            if (StringUtils.isNotBlank((CharSequence)additionalDetail.getOfdURL())) {
                attachmentBO = new FscAttachmentPO();
                attachmentBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentBO.setAttachmentUrl(additionalDetail.getOfdURL());
                attachmentBO.setAttachmentType(FscConstants.AttachmentType.RED_OFD);
                attachmentBO.setAttachmentName("\u7ea2\u5b57\u53d1\u7968ofd\u9644\u4ef6");
                attachmentBO.setObjId(newInvoiceId);
                attachmentBO.setObjType(FscConstants.AttachmentObjType.INVOICE);
                attachmentBO.setFscOrderId(fscOrderId);
                attachmentBO.setSysTenantId(sysTenantId);
                attachmentBO.setSysTenantName(sysTenantName);
                attachmentList.add(attachmentBO);
            }
            if (StringUtils.isNotBlank((CharSequence)additionalDetail.getXmlUrl())) {
                attachmentBO = new FscAttachmentPO();
                attachmentBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentBO.setAttachmentUrl(additionalDetail.getXmlUrl());
                attachmentBO.setAttachmentName("\u7ea2\u5b57\u53d1\u7968xml\u9644\u4ef6");
                attachmentBO.setAttachmentType(FscConstants.AttachmentType.RED_XML);
                attachmentBO.setObjId(newInvoiceId);
                attachmentBO.setObjType(FscConstants.AttachmentObjType.INVOICE);
                attachmentBO.setFscOrderId(fscOrderId);
                attachmentBO.setSysTenantId(sysTenantId);
                attachmentBO.setSysTenantName(sysTenantName);
                attachmentList.add(attachmentBO);
            }
            if (StringUtils.isNotBlank((CharSequence)additionalDetail.getBwPdfUrl())) {
                attachmentBO = new FscAttachmentPO();
                attachmentBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentBO.setAttachmentUrl(additionalDetail.getBwPdfUrl());
                attachmentBO.setAttachmentName("\u7ea2\u5b57\u53d1\u7968bw_pdf\u9644\u4ef6");
                attachmentBO.setAttachmentType(FscConstants.AttachmentType.BW_RED_INVOICE);
                attachmentBO.setObjId(newInvoiceId);
                attachmentBO.setObjType(FscConstants.AttachmentObjType.INVOICE);
                attachmentBO.setFscOrderId(fscOrderId);
                attachmentBO.setSysTenantId(sysTenantId);
                attachmentBO.setSysTenantName(sysTenantName);
                attachmentList.add(attachmentBO);
            }
            if (StringUtils.isNotBlank((CharSequence)additionalDetail.getBwOfdURL())) {
                attachmentBO = new FscAttachmentPO();
                attachmentBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentBO.setAttachmentUrl(additionalDetail.getBwOfdURL());
                attachmentBO.setAttachmentName("\u7ea2\u5b57\u53d1\u7968bw_ofd\u9644\u4ef6");
                attachmentBO.setAttachmentType(FscConstants.AttachmentType.BW_RED_OFD);
                attachmentBO.setObjId(newInvoiceId);
                attachmentBO.setObjType(FscConstants.AttachmentObjType.INVOICE);
                attachmentBO.setFscOrderId(fscOrderId);
                attachmentBO.setSysTenantId(sysTenantId);
                attachmentBO.setSysTenantName(sysTenantName);
                attachmentList.add(attachmentBO);
            }
            if (!StringUtils.isNotBlank((CharSequence)additionalDetail.getBwXmlUrl())) continue;
            attachmentBO = new FscAttachmentPO();
            attachmentBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            attachmentBO.setAttachmentUrl(additionalDetail.getBwXmlUrl());
            attachmentBO.setAttachmentName("\u7ea2\u5b57\u53d1\u7968bw_xml\u9644\u4ef6");
            attachmentBO.setAttachmentType(FscConstants.AttachmentType.BW_RED_XML);
            attachmentBO.setObjId(newInvoiceId);
            attachmentBO.setObjType(FscConstants.AttachmentObjType.INVOICE);
            attachmentBO.setFscOrderId(fscOrderId);
            attachmentBO.setSysTenantId(sysTenantId);
            attachmentBO.setSysTenantName(sysTenantName);
            attachmentList.add(attachmentBO);
        }
        return attachmentList;
    }
}

