/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CrcQryDealServiceFeeAbilityService;
import com.tydic.cfc.ability.bo.CrcQryDealServiceFeeAbilityReqBO;
import com.tydic.cfc.ability.bo.CrcQryDealServiceFeeAbilityRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceUploadCrcExtBusiService;
import com.tydic.fsc.bill.busi.api.FscCrcInvoiceQryToSzBusiService;
import com.tydic.fsc.bill.busi.api.FscCrcInvoiceSubmitToSzBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoiceDetailsToSzListBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoiceQryAttachmentToSzBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoiceQryToSzBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoiceQryToSzBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoiceSubmitReturnToSzBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoiceSubmitToSzBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoiceSubmitToSzBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscInvoiceInfoBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscLogOrdBusiMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscLogOrdBusiPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.SSLClient;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscCrcInvoiceSubmitToSzBusiServiceImpl
implements FscCrcInvoiceSubmitToSzBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscCrcInvoiceSubmitToSzBusiServiceImpl.class);
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscLogOrdBusiMapper fscLogOrdBusiMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private CrcQryDealServiceFeeAbilityService crcQryDealServiceFeeAbilityService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Value(value="${invoiceSplitNum}")
    private Integer invoiceSplitNum;
    @Value(value="${SZ_SUBMIT_INVOICE_URL}")
    private String SZ_SUBMIT_INVOICE_URL;
    @Autowired
    private FscBillInvoiceUploadCrcExtBusiService fscBillInvoiceUploadCrcExtBusiService;
    @Autowired
    private FscCrcInvoiceQryToSzBusiService fscCrcInvoiceQryToSzBusiService;

    @Override
    public FscCrcInvoiceSubmitToSzBusiRspBO invoiceSubmitToSz(FscCrcInvoiceSubmitToSzBusiReqBO reqBO) {
        FscCrcInvoiceSubmitToSzBusiRspBO rspBO = new FscCrcInvoiceSubmitToSzBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderPO temp = new FscOrderPO();
        temp.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(temp);
        if (fscOrderPO == null) {
            throw new BaseBusinessException("8888", "\u6ca1\u6709id\u4e3a\uff1a" + reqBO.getOrderId() + "\u7684\u7ed3\u7b97\u5355");
        }
        this.writeLog(reqBO);
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getOrderId());
        fscOrderItemPO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderItemPO.setOrderBy("id desc");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List fscOrderItemPOList = this.fscOrderItemMapper.getListPage(fscOrderItemPO, page);
        if (ObjectUtil.isEmpty((Object)fscOrderItemPOList)) {
            throw new BaseBusinessException("8888", "\u7ed3\u7b97\u5355\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a");
        }
        String orderNo = reqBO.getOrderNo();
        String reqStr = this.initPostStr(reqBO, fscOrderPO, orderNo, fscOrderItemPOList);
        log.info("\u5b88\u6b63\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u5730\u5740:{}", (Object)this.SZ_SUBMIT_INVOICE_URL);
        log.info("\u5b88\u6b63\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u53c2\u6570:{}", (Object)reqStr);
        String returnString = SSLClient.doPost((String)this.SZ_SUBMIT_INVOICE_URL, (String)reqStr);
        log.info("\u5b88\u6b63ESB\u63a5\u53e3\u7a0e\u63a7\u63d0\u4ea4\u54cd\u5e94\u62a5\u6587:{}", (Object)returnString);
        if (ObjectUtil.isEmpty((Object)returnString)) {
            throw new BaseBusinessException("8888", "\u5b88\u6b63ESB\u63a5\u53e3\u7a0e\u63a7\u63d0\u4ea4\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        this.resolveRsp(returnString, reqBO, orderNo, fscOrderItemPOList, fscOrderPO);
        return rspBO;
    }

    public static List<List<FscOrderItemPO>> splitListStream(List<FscOrderItemPO> list, int chunkSize) {
        return IntStream.range(0, (list.size() + chunkSize - 1) / chunkSize).mapToObj(i -> list.subList(i * chunkSize, Math.min(list.size(), (i + 1) * chunkSize))).collect(Collectors.toList());
    }

    private void writeLog(FscCrcInvoiceSubmitToSzBusiReqBO reqBO) {
        FscLogOrdBusiPO fscLogOrdBusiPO = new FscLogOrdBusiPO();
        fscLogOrdBusiPO.setFscOrderId(reqBO.getOrderId());
        fscLogOrdBusiPO.setBusiName("\u9500\u552e\u7ed3\u7b97\u5355\u63a8\u9001\u7a0e\u63a7");
        fscLogOrdBusiPO.setBusiType(Integer.valueOf(99));
        fscLogOrdBusiPO.setCreateTime(new Date());
        fscLogOrdBusiPO.setCreateOperId(reqBO.getUserId());
        fscLogOrdBusiPO.setCreateOperName(reqBO.getUserName());
        fscLogOrdBusiPO.setCreateCompanyId(reqBO.getOrgId());
        fscLogOrdBusiPO.setCreateOrgId(reqBO.getOrgId());
        fscLogOrdBusiPO.setCreateCompanyName(reqBO.getCompanyName());
        fscLogOrdBusiPO.setCreateOrgName(reqBO.getCompanyName());
        fscLogOrdBusiPO.setSysTenantId(reqBO.getSysTenantId());
        fscLogOrdBusiPO.setSysTenantName(reqBO.getSysTenantName());
        this.fscLogOrdBusiMapper.insert(fscLogOrdBusiPO);
    }

    private String initPostStr(FscCrcInvoiceSubmitToSzBusiReqBO reqBO, FscOrderPO fscOrderPO, String orderNo, List<FscOrderItemPO> fscOrderItemPOList) {
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(reqBO.getOrderId());
        fscOrderInvoicePO.setSysTenantId(reqBO.getSysTenantId());
        FscOrderInvoicePO orderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        if (orderInvoicePO == null) {
            throw new FscBusinessException("8888", "\u7ed3\u7b97\u5355\u53d1\u7968\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put("taxNo", (Object)"\u53d6\u5b88\u6b63\u7a0e\u53f7\u914d\u7f6e");
        if ("00".equals(orderInvoicePO.getInvoiceType())) {
            reqJson.put("invoiceTypeCode", (Object)"01");
        } else if ("01".equals(orderInvoicePO.getInvoiceType())) {
            reqJson.put("invoiceTypeCode", (Object)"02");
        } else {
            throw new FscBusinessException("8888", "\u63a8\u9001\u7a0e\u63a7\u9519\u8bef\uff1a\u6ca1\u6709\u5bf9\u5e94\u7684\u53d1\u7968\u7c7b\u578b\uff1a" + JSON.toJSONString((Object)orderInvoicePO));
        }
        reqJson.put("serialNo", (Object)orderNo);
        if (!ObjectUtil.isEmpty((Object)orderInvoicePO.getTaxNo())) {
            reqJson.put("buyerTaxNo", (Object)orderInvoicePO.getTaxNo());
        }
        reqJson.put("buyerName", (Object)orderInvoicePO.getBuyName());
        reqJson.put("buyerAddressPhone", (Object)orderInvoicePO.getBuyName());
        if (!ObjectUtil.isEmpty((Object)orderInvoicePO.getMemo()) && orderInvoicePO.getMemo().length() > 200) {
            throw new ZTBusinessException("\u53d1\u7968\u5907\u6ce8\u957f\u5ea6\u4e0d\u5927\u4e8e200\u5b57\u7b26");
        }
        reqJson.put("remarks", (Object)(ObjectUtil.isEmpty((Object)orderInvoicePO.getMemo()) ? "" : orderInvoicePO.getMemo()));
        JSONArray invoiceDetailsList = new JSONArray();
        int goodsLineNo = 1;
        if (reqBO.getServiceFee().booleanValue()) {
            FscOrderPO sFeefscOrderPO = new FscOrderPO();
            sFeefscOrderPO.setFscOrderId(reqBO.getOrderId());
            sFeefscOrderPO.setSysTenantId(reqBO.getSysTenantId());
            sFeefscOrderPO = this.fscOrderMapper.getModelBy(sFeefscOrderPO);
            CrcQryDealServiceFeeAbilityReqBO crcQryDealServiceFeeAbilityReqBO = new CrcQryDealServiceFeeAbilityReqBO();
            crcQryDealServiceFeeAbilityReqBO.setSupplierId(sFeefscOrderPO.getSupplierId());
            CrcQryDealServiceFeeAbilityRspBO rspBO = this.crcQryDealServiceFeeAbilityService.qryDealServiceFee(crcQryDealServiceFeeAbilityReqBO);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("goodsLineNo", (Object)goodsLineNo);
            jsonObject.put("goodsName", (Object)"\u5e73\u53f0\u670d\u52a1\u8d39");
            jsonObject.put("goodsCode", (Object)rspBO.getTaxCatalog());
            jsonObject.put("goodsPrice", (Object)"");
            jsonObject.put("goodsUnit", (Object)"");
            jsonObject.put("goodsQuantity", (Object)1);
            jsonObject.put("goodsTotalPrice", (Object)fscOrderPO.getActualAmount().setScale(2, RoundingMode.HALF_UP));
            jsonObject.put("goodsTaxRate", (Object)new BigDecimal(rspBO.getTaxRate()).divide(new BigDecimal(100)).setScale(2).toString());
            jsonObject.put("goodsTotalTax", (Object)"");
            jsonObject.put("priceTaxMark", (Object)"1");
            jsonObject.put("goodsSpecification", (Object)"");
            ++goodsLineNo;
            invoiceDetailsList.add((Object)jsonObject);
        } else {
            for (FscOrderItemPO each : fscOrderItemPOList) {
                if (ObjectUtil.isEmpty((Object)each.getNum()) || each.getNum().compareTo(BigDecimal.ZERO) <= 0 || ObjectUtil.isEmpty((Object)each.getAmt()) || each.getAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("goodsLineNo", (Object)goodsLineNo);
                each.setGoodsLineNo(Integer.valueOf(goodsLineNo));
                if (!StringUtils.isEmpty((Object)each.getSkuName())) {
                    each.setSkuName(this.limitLength(each.getSkuName(), 92));
                }
                jsonObject.put("goodsName", (Object)each.getSkuName());
                if (StringUtils.isEmpty((Object)each.getTaxCode())) {
                    throw new FscBusinessException("8888", each.getSkuName() + "\uff0c\u6b64\u5546\u54c1\u6ca1\u6709\u7a0e\u6536\u5206\u7c7b\u7f16\u7801");
                }
                jsonObject.put("goodsCode", (Object)each.getTaxCode());
                jsonObject.put("goodsPrice", (Object)each.getPrice());
                jsonObject.put("goodsUnit", (Object)(ObjectUtil.isEmpty((Object)each.getUnit()) ? "" : each.getUnit()));
                jsonObject.put("goodsQuantity", (Object)each.getNum());
                jsonObject.put("goodsTotalPrice", (Object)each.getAmt());
                jsonObject.put("goodsTaxRate", (Object)each.getTaxRate().setScale(2).toString());
                jsonObject.put("goodsTotalTax", (Object)each.getTaxAmt());
                jsonObject.put("priceTaxMark", (Object)"1");
                if (!StringUtils.isEmpty((Object)each.getSpec()) && !StringUtils.isEmpty((Object)each.getSpec())) {
                    if ((each.getSpec() + "/" + each.getModel()).getBytes(StandardCharsets.UTF_8).length <= 36) {
                        jsonObject.put("goodsSpecification", (Object)(each.getSpec() + "/" + each.getModel()));
                    } else {
                        byte[] bytes = new byte[40];
                        System.arraycopy((each.getSpec() + "/" + each.getModel()).getBytes(StandardCharsets.UTF_8), 0, bytes, 0, 40);
                        jsonObject.put("goodsSpecification", (Object)new String(bytes));
                    }
                }
                ++goodsLineNo;
                invoiceDetailsList.add((Object)jsonObject);
            }
        }
        reqJson.put("invoiceDetailsList", (Object)invoiceDetailsList);
        log.info("\u5b88\u6b63\u5f00\u7968\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqJson));
        return reqJson.toString();
    }

    private String limitLength(String value, int length) {
        int valueLength = 0;
        StringBuilder newValue = new StringBuilder("");
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            valueLength = temp.matches(chinese) ? (valueLength += 3) : ++valueLength;
            if (valueLength > length) {
                return newValue.toString();
            }
            newValue.append(temp);
        }
        return newValue.toString();
    }

    private void resolveRsp(String returnString, FscCrcInvoiceSubmitToSzBusiReqBO reqBO, String orderNo, List<FscOrderItemPO> fscOrderItemPOList, FscOrderPO fscOrderPO) {
        FscCrcInvoiceSubmitReturnToSzBO fscCrcInvoicSubmitReturnBO;
        try {
            fscCrcInvoicSubmitReturnBO = (FscCrcInvoiceSubmitReturnToSzBO)JSONObject.parseObject((String)returnString, FscCrcInvoiceSubmitReturnToSzBO.class);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
        ArrayList<FscInvoicePO> list = new ArrayList<FscInvoicePO>();
        Date createTime = new Date(System.currentTimeMillis());
        List<FscCrcInvoiceDetailsToSzListBO> datas = fscCrcInvoicSubmitReturnBO.getInvoiceDetailsList();
        for (int i = 0; i < datas.size(); ++i) {
            FscInvoicePO fscInvoicePO = new FscInvoicePO();
            fscInvoicePO.setInvoiceId(Long.valueOf(this.sequence.nextId()));
            fscInvoicePO.setFscOrderId(reqBO.getOrderId());
            fscInvoicePO.setCreateTime(createTime);
            fscInvoicePO.setCallBackStatus(Integer.valueOf(2));
            fscInvoicePO.setInvoiceOutNo(orderNo);
            fscInvoicePO.setCreateOperId(reqBO.getUserId().toString());
            fscInvoicePO.setCreateOperName(reqBO.getName());
            fscInvoicePO.setSysTenantId(reqBO.getSysTenantId());
            fscInvoicePO.setSysTenantName(reqBO.getSysTenantName());
            list.add(fscInvoicePO);
        }
        this.fscInvoiceMapper.insertBatch(list);
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = this.createInvoiceSaveBO(fscOrderPO, fscCrcInvoicSubmitReturnBO, orderNo, fscOrderItemPOList);
        fscBillInvoiceUploadBusiReqBO.setSysTenantId(fscOrderPO.getSysTenantId());
        fscBillInvoiceUploadBusiReqBO.setSysTenantName(fscOrderPO.getSysTenantName());
        log.info("\u4fdd\u5b58\u5b88\u6b63\u5f00\u7968\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)fscBillInvoiceUploadBusiReqBO)));
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadCrcExtBusiService.dealInvoiceUpload(fscBillInvoiceUploadBusiReqBO);
        if (reqBO.getInvStatus() == 2) {
            FscOrderPO setOrderPO = new FscOrderPO();
            setOrderPO.setInvStatus(Integer.valueOf(3));
            FscOrderPO whereOrderPO = new FscOrderPO();
            whereOrderPO.setFscOrderId(reqBO.getOrderId());
            whereOrderPO.setSysTenantId(reqBO.getSysTenantId());
            this.fscOrderMapper.updateBy(setOrderPO, whereOrderPO);
        }
    }

    private FscBillInvoiceUploadBusiReqBO createInvoiceSaveBO(FscOrderPO fscOrderInfo, FscCrcInvoiceSubmitReturnToSzBO invoiceInfoToSz, String orderNo, List<FscOrderItemPO> fscOrderItemPOList) {
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = new FscBillInvoiceUploadBusiReqBO();
        fscBillInvoiceUploadBusiReqBO.setFscOrderId(fscOrderInfo.getFscOrderId());
        fscBillInvoiceUploadBusiReqBO.setCurStatus(fscOrderInfo.getOrderState());
        ArrayList<FscInvoiceInfoBO> fscInvoiceInfoBOS = new ArrayList<FscInvoiceInfoBO>();
        FscInvoiceInfoBO fscInvoiceInfoBO = new FscInvoiceInfoBO();
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(fscOrderInfo.getFscOrderId());
        fscOrderInvoicePO.setSysTenantId(fscOrderInfo.getSysTenantId());
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        fscInvoiceInfoBO.setBuyName(fscOrderInvoicePO.getBuyName());
        fscInvoiceInfoBO.setTaxNo(fscOrderInvoicePO.getTaxNo());
        fscInvoiceInfoBO.setBank(fscOrderInvoicePO.getBank());
        fscInvoiceInfoBO.setAccount(fscOrderInvoicePO.getAccount());
        fscInvoiceInfoBO.setPhone(fscOrderInvoicePO.getPhone());
        fscInvoiceInfoBO.setAddress(fscOrderInvoicePO.getAddress());
        fscInvoiceInfoBO.setFscOrderId(fscOrderInfo.getFscOrderId());
        fscInvoiceInfoBO.setInvoiceNo(invoiceInfoToSz.getInvoiceNo());
        fscInvoiceInfoBO.setInvoiceCode(invoiceInfoToSz.getInvoiceCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String billDate = sdf.format(invoiceInfoToSz.getInvoiceDate());
        fscInvoiceInfoBO.setBillDate(billDate);
        fscInvoiceInfoBO.setInvoiceOutNo(orderNo);
        BigDecimal totalsAmount = new BigDecimal(0);
        BigDecimal taxAmt = new BigDecimal(0);
        for (FscCrcInvoiceDetailsToSzListBO invoiceDetailsToSzListBO : invoiceInfoToSz.getInvoiceDetailsList()) {
            taxAmt = taxAmt.add(invoiceDetailsToSzListBO.getGoodsTotalTax());
            totalsAmount = totalsAmount.add(invoiceDetailsToSzListBO.getGoodsTotalPrice());
        }
        fscInvoiceInfoBO.setUntaxAmt(totalsAmount);
        fscInvoiceInfoBO.setTaxAmt(taxAmt);
        fscInvoiceInfoBO.setAmt(totalsAmount.add(taxAmt));
        fscInvoiceInfoBO.setInvoiceCategory(fscOrderInvoicePO.getInvoiceCategory());
        fscInvoiceInfoBO.setInvoiceType(fscOrderInvoicePO.getInvoiceType());
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderInfo.getOrderFlow())) {
            ArrayList<InvoiceItemBO> invoiceItemBOS = new ArrayList<InvoiceItemBO>();
            Map<Integer, FscOrderItemPO> orderItemMap = fscOrderItemPOList.stream().collect(Collectors.toMap(FscOrderItemPO::getGoodsLineNo, o -> o, (k1, k2) -> k2));
            for (FscCrcInvoiceDetailsToSzListBO invoiceDetailsToSzListBO : invoiceInfoToSz.getInvoiceDetailsList()) {
                if (ObjectUtil.isEmpty((Object)orderItemMap.get(invoiceDetailsToSzListBO.getGoodsLineNo()))) continue;
                FscOrderItemPO fscOrderItemPO = orderItemMap.get(invoiceDetailsToSzListBO.getGoodsLineNo());
                InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                invoiceItemBO.setOrderId(fscOrderItemPO.getOrderId());
                invoiceItemBO.setSkuId(fscOrderItemPO.getSkuId());
                invoiceItemBO.setAcceptOrderId(fscOrderItemPO.getAcceptOrderId());
                invoiceItemBO.setSkuName(invoiceDetailsToSzListBO.getGoodsName());
                invoiceItemBO.setModel(fscOrderItemPO.getModel());
                invoiceItemBO.setSpec(fscOrderItemPO.getSpec());
                invoiceItemBO.setUnit(invoiceDetailsToSzListBO.getGoodsUnit());
                invoiceItemBO.setNum(invoiceDetailsToSzListBO.getGoodsQuantity());
                invoiceItemBO.setPrice(invoiceDetailsToSzListBO.getGoodsPrice());
                invoiceItemBO.setOrderItemId(fscOrderItemPO.getOrderItemId());
                invoiceItemBO.setAmt(invoiceDetailsToSzListBO.getGoodsTotalPrice());
                invoiceItemBO.setUntaxAmt(invoiceDetailsToSzListBO.getGoodsTotalPrice().subtract(invoiceDetailsToSzListBO.getGoodsTotalTax()));
                invoiceItemBO.setTaxAmt(invoiceDetailsToSzListBO.getGoodsTotalTax());
                invoiceItemBO.setTax(invoiceDetailsToSzListBO.getGoodsTaxRate());
                invoiceItemBO.setTaxCode(fscOrderItemPO.getTaxCode());
                invoiceItemBOS.add(invoiceItemBO);
            }
            fscInvoiceInfoBO.setInvoiceItemBOS(invoiceItemBOS);
        }
        FscCrcInvoiceQryToSzBusiReqBO fscCrcInvoiceQryToSzBusiReqBO = new FscCrcInvoiceQryToSzBusiReqBO();
        fscCrcInvoiceQryToSzBusiReqBO.setSerialNo(orderNo);
        FscCrcInvoiceQryToSzBusiRspBO attachmentToSzBusiRspBO = this.fscCrcInvoiceQryToSzBusiService.invoiceQryToSz(fscCrcInvoiceQryToSzBusiReqBO);
        if (!ObjectUtil.isEmpty(attachmentToSzBusiRspBO.getAdditionalDetails())) {
            ArrayList<AttachmentBO> attachmentList = new ArrayList<AttachmentBO>(6);
            for (FscCrcInvoiceQryAttachmentToSzBO additionalDetail : attachmentToSzBusiRspBO.getAdditionalDetails()) {
                AttachmentBO attachmentBO;
                if (!StringUtils.isEmpty((Object)additionalDetail.getPdfXml())) {
                    attachmentBO = new AttachmentBO();
                    attachmentBO.setAttachmentUrl(additionalDetail.getPdfXml());
                    attachmentBO.setAttachmentName("\u53d1\u7968pdf\u9644\u4ef6");
                    attachmentBO.setAttachmentType(FscConstants.AttachmentType.INVOICE);
                    attachmentList.add(attachmentBO);
                }
                if (!StringUtils.isEmpty((Object)additionalDetail.getXmlUrl())) {
                    attachmentBO = new AttachmentBO();
                    attachmentBO.setAttachmentUrl(additionalDetail.getXmlUrl());
                    attachmentBO.setAttachmentName("\u53d1\u7968xml\u9644\u4ef6");
                    attachmentBO.setAttachmentType(FscConstants.AttachmentType.XML);
                    attachmentList.add(attachmentBO);
                }
                if (!StringUtils.isEmpty((Object)additionalDetail.getOfdURL())) {
                    attachmentBO = new AttachmentBO();
                    attachmentBO.setAttachmentUrl(additionalDetail.getOfdURL());
                    attachmentBO.setAttachmentName("\u53d1\u7968ofd\u9644\u4ef6");
                    attachmentBO.setAttachmentType(FscConstants.AttachmentType.OFD);
                    attachmentList.add(attachmentBO);
                }
                if (!StringUtils.isEmpty((Object)additionalDetail.getBwXmlUrl())) {
                    attachmentBO = new AttachmentBO();
                    attachmentBO.setAttachmentUrl(additionalDetail.getBwXmlUrl());
                    attachmentBO.setAttachmentName("\u53d1\u7968\u767e\u671bxml\u9644\u4ef6");
                    attachmentBO.setAttachmentType(FscConstants.AttachmentType.BW_XML);
                    attachmentList.add(attachmentBO);
                }
                if (!StringUtils.isEmpty((Object)additionalDetail.getBwPdfUrl())) {
                    attachmentBO = new AttachmentBO();
                    attachmentBO.setAttachmentUrl(additionalDetail.getBwPdfUrl());
                    attachmentBO.setAttachmentType(FscConstants.AttachmentType.BW_INVOICE);
                    attachmentBO.setAttachmentName("\u53d1\u7968\u767e\u671bpdf\u9644\u4ef6");
                    attachmentList.add(attachmentBO);
                }
                if (!StringUtils.isEmpty((Object)additionalDetail.getBwOfdURL())) {
                    attachmentBO = new AttachmentBO();
                    attachmentBO.setAttachmentUrl(additionalDetail.getBwOfdURL());
                    attachmentBO.setAttachmentType(FscConstants.AttachmentType.BW_OFD);
                    attachmentBO.setAttachmentName("\u53d1\u7968\u767e\u671bofd\u9644\u4ef6");
                    attachmentList.add(attachmentBO);
                }
                fscInvoiceInfoBO.setAttachmentList(attachmentList);
            }
        }
        fscInvoiceInfoBOS.add(fscInvoiceInfoBO);
        fscBillInvoiceUploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBOS);
        return fscBillInvoiceUploadBusiReqBO;
    }
}

