/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.busi.api.FscSendMqInvoiceSubmitToSzBusiService;
import com.tydic.fsc.bill.busi.bo.FscSendMqInvoiceSubmitToSzBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscSendMqInvoiceSubmitToSzBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscSubmitInvoiceSzLogMapper;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscSubmitInvoiceSzLogPO;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscSendMqInvoiceSubmitToSzBusiServiceImpl
implements FscSendMqInvoiceSubmitToSzBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscSendMqInvoiceSubmitToSzBusiServiceImpl.class);
    @Autowired
    private FscSubmitInvoiceSzLogMapper fscSubmitInvoiceSzLogMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Value(value="${invoiceSplitNum}")
    private Integer invoiceSplitNum;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Resource(name="invoiceSubmitToSzProducer")
    private ProxyMessageProducer invoiceSubmitToSzProducer;
    @Value(value="${INVOICE_SUBMIT_TO_SZ_TOPIC:INVOICE_SUBMIT_TO_SZ_TOPIC}")
    private String INVOICE_SUBMIT_TO_SZ_TOPIC;
    @Value(value="${INVOICE_SUBMIT_TO_SZ_TAG:INVOICE_SUBMIT_TO_SZ_TAG}")
    private String INVOICE_SUBMIT_TO_SZ_TAG;

    @Override
    public FscSendMqInvoiceSubmitToSzBusiRspBO sendMqInvoiceSubmitToSz(FscSendMqInvoiceSubmitToSzBusiReqBO reqBO) {
        FscSendMqInvoiceSubmitToSzBusiRspBO rspBO = new FscSendMqInvoiceSubmitToSzBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getOrderId());
        fscOrderItemPO.setSysTenantId(reqBO.getSysTenantId());
        int allCount = this.fscOrderItemMapper.getCheckBy(fscOrderItemPO);
        FscOrderPO temp = new FscOrderPO();
        temp.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(temp);
        if (ObjectUtil.isEmpty((Object)fscOrderPO)) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5f00\u7968\u7ed3\u7b97\u5355");
            rspBO.setRespCode("190000");
            return rspBO;
        }
        if (!fscOrderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILLING)) {
            rspBO.setRespDesc("\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u5f00\u7968");
            rspBO.setRespCode("190000");
            return rspBO;
        }
        if (!reqBO.getServiceFee().booleanValue() && allCount > this.invoiceSplitNum) {
            int index = allCount / this.invoiceSplitNum + 1;
            for (int i = 1; i <= index; ++i) {
                reqBO.setPageNo(i);
                int lastMark = 0;
                if (i == index) {
                    lastMark = 1;
                }
                reqBO.setPageSize(this.invoiceSplitNum);
                int number = ThreadLocalRandom.current().nextInt(1000, 10000);
                String orderNo = fscOrderPO.getOrderNo() + "_" + number;
                reqBO.setOrderNo(orderNo);
                reqBO.setInvoiceLogId(Sequence.getInstance().nextId());
                log.info("\u62c6\u5206-\u5b88\u6b63\u5f00\u7968\u53d1\u9001\u6d88\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
                ProxyMessage proxyMess = new ProxyMessage(this.INVOICE_SUBMIT_TO_SZ_TOPIC, this.INVOICE_SUBMIT_TO_SZ_TAG, JSON.toJSONString((Object)((Object)reqBO)));
                this.invoiceSubmitToSzProducer.send(proxyMess);
                this.saveLog(reqBO, lastMark);
            }
        } else {
            int number = ThreadLocalRandom.current().nextInt(1000, 10000);
            String orderNo = fscOrderPO.getOrderNo() + "_" + number;
            reqBO.setOrderNo(orderNo);
            reqBO.setPageNo(1);
            reqBO.setPageSize(this.invoiceSplitNum);
            log.info("\u4e0d\u62c6\u5206-\u5b88\u6b63\u5f00\u7968\u53d1\u9001\u6d88\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
            ProxyMessage proxyMess = new ProxyMessage(this.INVOICE_SUBMIT_TO_SZ_TOPIC, this.INVOICE_SUBMIT_TO_SZ_TAG, JSON.toJSONString((Object)((Object)reqBO)));
            this.invoiceSubmitToSzProducer.send(proxyMess);
            this.saveLog(reqBO, 1);
        }
        return rspBO;
    }

    private void saveLog(FscSendMqInvoiceSubmitToSzBusiReqBO reqBO, Integer lastMark) {
        FscSubmitInvoiceSzLogPO fscSubmitInvoiceSzLogPO = new FscSubmitInvoiceSzLogPO();
        fscSubmitInvoiceSzLogPO.setId(reqBO.getInvoiceLogId());
        fscSubmitInvoiceSzLogPO.setFscOrderId(reqBO.getOrderId());
        fscSubmitInvoiceSzLogPO.setSerialNo(reqBO.getOrderNo());
        fscSubmitInvoiceSzLogPO.setSubmitParams(JSON.toJSONString((Object)((Object)reqBO)));
        fscSubmitInvoiceSzLogPO.setLastMark(lastMark);
        fscSubmitInvoiceSzLogPO.setStatus(Integer.valueOf(0));
        fscSubmitInvoiceSzLogPO.setCreateTime(new Date());
        fscSubmitInvoiceSzLogPO.setSysTenantName(reqBO.getSysTenantName());
        fscSubmitInvoiceSzLogPO.setSysTenantId(reqBO.getSysTenantId());
        fscSubmitInvoiceSzLogPO.setInvoiceType(Integer.valueOf(0));
        this.fscSubmitInvoiceSzLogMapper.insert(fscSubmitInvoiceSzLogPO);
    }
}

