/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.consumer;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.bill.busi.api.FscCreateFscBalanceBusiService;
import com.tydic.fsc.bo.FscBalanceBO;
import com.tydic.fsc.bo.FscCreateFscBalanceBusiReqBO;
import com.tydic.fsc.bo.FscCreateFscBalanceBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscBankCheckItemSyncEsAtomService;
import com.tydic.fsc.busibase.atom.bo.FscBankCheckItemSyncEsAtomReqBO;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class FscCreateFscBalanceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscCreateFscBalanceConsumer.class);
    @Autowired
    private FscCreateFscBalanceBusiService fscCreateFscBalanceBusiService;
    @Value(value="${crc.sys.tenant.id:305775845729763327}")
    private Long crcSysTenantId;
    @Autowired
    private FscBankCheckItemSyncEsAtomService fscBankCheckItemSyncEsAtomService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.info("---------------\u5199\u5165\u4f59\u989d\u8868\u6d88\u8d39\u5f00\u59cb---------------");
        log.info("\u5199\u5165\u4f59\u989d\u8868\u6d88\u8d39\u5165\u53c2{}", (Object)JSON.toJSONString((Object)message.getContent()));
        FscCreateFscBalanceBusiReqBO reqBO = (FscCreateFscBalanceBusiReqBO)JSON.parseObject((String)message.getContent(), FscCreateFscBalanceBusiReqBO.class);
        log.info("\u5199\u5165\u4f59\u989d\u8868\u6d88\u8d39\u5165\u53c2{}", (Object)JSON.toJSONString((Object)reqBO));
        reqBO.setSysTenantId(this.crcSysTenantId);
        try {
            FscCreateFscBalanceBusiRspBO fscCreateFscBalanceBusiRspBO = this.fscCreateFscBalanceBusiService.createFscBalance(reqBO);
        }
        catch (Exception e) {
            log.error("\u5199\u5165\u4f59\u989d\u8868\u6d88\u8d39\u8005\u62a5\u9519\uff1a", (Throwable)e);
        }
        if (null != reqBO && ObjectUtil.isNotEmpty((Object)reqBO.getFscBalanceList())) {
            FscBankCheckItemSyncEsAtomReqBO syncEsReqBO = new FscBankCheckItemSyncEsAtomReqBO();
            syncEsReqBO.setSysTenantId(((FscBalanceBO)reqBO.getFscBalanceList().get(0)).getSysTenantId());
            syncEsReqBO.setBankCheckIdList(reqBO.getFscBalanceList().stream().map(FscBalanceBO::getBankCheckId).collect(Collectors.toList()));
            this.fscBankCheckItemSyncEsAtomService.bankCheckItemSyncEs(syncEsReqBO);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

