/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.mock;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.bo.FscProRpcMockAtomRemoteReqBO;
import com.tydic.fsc.busibase.atom.bo.FscProRpcMockAtomRemoteRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FscProRpcMockAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscProRpcMockAtomService.class);
    @Value(value="${fsc.mock.rpc.url:http://39.105.66.173:10130/deploy/federate/noauth/rpc}")
    private String rpcCallUrl;
    private static final String SUCCESS_CODE = "0";

    public <T> T rpcMockData(String interClassName, String methodName, Object data, Class<T> returnClass, Long sysTenantId) {
        this.validateArg(interClassName, methodName, data, returnClass);
        FscProRpcMockAtomRemoteReqBO remoteReqBo = new FscProRpcMockAtomRemoteReqBO();
        remoteReqBo.setInterClass(interClassName);
        remoteReqBo.setMethod(methodName);
        remoteReqBo.setData(data);
        remoteReqBo.setSysTenantId(sysTenantId);
        String jsonStr = JSON.toJSONString((Object)remoteReqBo);
        String body = HttpRequest.post((String)this.rpcCallUrl).body(jsonStr).timeout(60000).execute().body();
        FscProRpcMockAtomRemoteRspBO remoteRspBo = (FscProRpcMockAtomRemoteRspBO)JSON.parseObject((String)body, FscProRpcMockAtomRemoteRspBO.class);
        String code = remoteRspBo.getCode();
        if (SUCCESS_CODE.equals(code)) {
            Object rspObj = JSON.parseObject((String)remoteRspBo.getData(), returnClass);
            return (T)rspObj;
        }
        log.error("RPC\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u5931\u8d25\u4fe1\u606f\uff1a" + remoteRspBo.getMessage() + ",\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)remoteRspBo));
        throw new FscBusinessException("198888", "RPC\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u5931\u8d25\u4fe1\u606f\uff1a" + remoteRspBo.getMessage());
    }

    private void validateArg(String interClassName, String methodName, Object data, Class returnClass) {
        if (ObjectUtil.isEmpty((Object)interClassName)) {
            throw new FscBusinessException("191000", "[interClassName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)methodName)) {
            throw new FscBusinessException("191000", "[methodName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)data)) {
            throw new FscBusinessException("191000", "[data]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)returnClass)) {
            throw new FscBusinessException("191000", "[returnClass]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

