/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.cfc.ability.api.CfcUniteParamQryListPageAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityRspBO;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import com.tydic.fsc.busibase.busi.api.FscBillWithdrawalOrderPdfBusiService;
import com.tydic.fsc.busibase.busi.bo.FscBillWithdrawalOrderPdfBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscBillWithdrawalOrderPdfBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscIntelligentPaymentDetailsMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscIntelligentPaymentDetailsPO;
import com.tydic.fsc.util.DateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscBillWithdrawalOrderPdfBusiServiceImpl
implements FscBillWithdrawalOrderPdfBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillWithdrawalOrderPdfBusiServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${pdf.reuploadCount}")
    private Integer reuploadCount;
    @Autowired
    private FscIntelligentPaymentDetailsMapper fscIntelligentPaymentDetailsMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private CfcUniteParamQryListPageAbilityService cfcUniteParamQryListPageAbilityService;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Value(value="${opertionWithdrawalOrgId}")
    private Long opertionWithdrawalOrgId;

    @Override
    public FscBillWithdrawalOrderPdfBusiRspBO createWithdrawalOrderPdf(FscBillWithdrawalOrderPdfBusiReqBO reqBO) {
        FscBillWithdrawalOrderPdfBusiRspBO rspBO = new FscBillWithdrawalOrderPdfBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.val(reqBO);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A2.rotate(), 10.0f, 10.0f, 15.0f, 20.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        Font titleFont = this.getFont("titleFont");
        String orderPdfTitle = "\u4ea4\u6613\u6d41\u6c34\u660e\u7ec6-" + reqBO.getFrontSeqNo();
        Paragraph paragraph = new Paragraph(orderPdfTitle, titleFont);
        paragraph.setAlignment(1);
        paragraph.setLeading(30.0f);
        paragraph.setSpacingAfter(30.0f);
        try {
            document.add((Element)paragraph);
        }
        catch (DocumentException e) {
            log.info("\u6dfb\u52a0\u9519\u8bef");
        }
        FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPO.setBankCheckIdS(reqBO.getBankCheckIds());
        fscBankCheckFileItemPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscBankCheckFileItemPO> fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(fscBankCheckFileItemPO);
        Map<Long, FscBankCheckFileItemPO> fscBankCheckFileItemPOListMap = fscBankCheckFileItemPOList.stream().collect(Collectors.toMap(FscBankCheckFileItemPO::getBankCheckId, v -> v, (k1, k2) -> k1));
        FscIntelligentPaymentDetailsPO fscIntelligentPaymentDetailsPO = new FscIntelligentPaymentDetailsPO();
        fscIntelligentPaymentDetailsPO.setBankCheckIdList(reqBO.getBankCheckIds());
        fscIntelligentPaymentDetailsPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscIntelligentPaymentDetailsPO> fscIntelligentPaymentDetailsPOS = this.fscIntelligentPaymentDetailsMapper.getList(fscIntelligentPaymentDetailsPO);
        Font contentFont = this.getFont("contentFont");
        if (!ObjectUtil.isEmpty(fscIntelligentPaymentDetailsPOS)) {
            PdfPTable itemTable = new PdfPTable(new float[]{25.0f, 25.0f, 25.0f, 25.0f, 25.0f, 25.0f, 25.0f, 25.0f, 25.0f, 25.0f, 25.0f, 25.0f});
            itemTable.setTotalWidth(1600.0f);
            itemTable.setLockedWidth(true);
            itemTable.setHorizontalAlignment(1);
            itemTable.getDefaultCell().setBorder(1);
            CfcUniteParamQryListPageAbilityReqBO cfcUniteParamQryListPageAbilityReqBO1 = new CfcUniteParamQryListPageAbilityReqBO();
            cfcUniteParamQryListPageAbilityReqBO1.setId(FscConstants.TRADE_MODEL.SALE_ORDER_FEE);
            CfcUniteParamQryListPageAbilityRspBO cfcUniteParamQryListPageAbilityRspBO1 = this.cfcUniteParamQryListPageAbilityService.qryUniteParamListPage(cfcUniteParamQryListPageAbilityReqBO1);
            log.info("\u83b7\u53d6\u8fd0\u8425\u63d0\u73b0\u914d\u7f6e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)cfcUniteParamQryListPageAbilityRspBO1.getRows()));
            FscAccountPO fscAccountPO = new FscAccountPO();
            fscAccountPO.setOrgId(this.opertionWithdrawalOrgId);
            fscAccountPO.setRecvSubLedgerAcctNo(((JSONObject)cfcUniteParamQryListPageAbilityRspBO1.getRows().get(0)).get((Object)"payeeAccountNo").toString());
            fscAccountPO.setStatus(1);
            fscAccountPO.setSysTenantId(reqBO.getSysTenantId());
            List<FscAccountPO> accountPOList = this.fscAccountMapper.getList(fscAccountPO);
            String recvSubLedgerBankName = ObjectUtil.isEmpty(accountPOList) ? "" : accountPOList.get(0).getRecvSubLedgerBankName();
            for (FscIntelligentPaymentDetailsPO item : fscIntelligentPaymentDetailsPOS) {
                itemTable.addCell(this.createCell("\u5f00\u6237\u94f6\u884c", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u94f6\u884c\u8d26\u6237", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u8d26\u6237\u540d\u79f0", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u4ea4\u6613\u91d1\u989d", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u4ea4\u6613\u65e5\u671f", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u5bf9\u65b9\u94f6\u884c", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u5bf9\u65b9\u8d26\u6237", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u5bf9\u65b9\u8d26\u6237\u540d\u79f0", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u5e01\u79cd", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u4f59\u989d", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u6458\u8981", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u94f6\u884c\u89c1\u8bc1\u6d41\u6c34\u53f7", contentFont, 0, true));
                itemTable.addCell(this.createCell(recvSubLedgerBankName, contentFont, true));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)item.getInAcctNo()) ? "" : item.getInAcctNo(), contentFont, true));
                FscBankCheckFileItemPO bankItemPO = fscBankCheckFileItemPOListMap.get(item.getBankCheckId());
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)bankItemPO.getPayeeAccountName()) ? "" : bankItemPO.getPayeeAccountName(), contentFont, true));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)item.getTranAmount()) ? "" : item.getTranAmount().setScale(2, RoundingMode.HALF_UP).toString(), contentFont, true));
                String date = DateUtil.dateToStrLong((Date)DateUtil.strToDateyyyyMMddHHmmss((String)(item.getHostDate() + item.getTxTime())));
                String[] dateList = date.split(" ");
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)dateList[0]) ? "" : dateList[0], contentFont, true));
                FscAccountPO fscAccountPo = new FscAccountPO();
                fscAccountPo.setAccountNo(item.getOutAcctNo());
                fscAccountPo.setOrgId(bankItemPO.getPayerId());
                fscAccountPo.setStatus(1);
                fscAccountPo.setSysTenantId(reqBO.getSysTenantId());
                List<FscAccountPO> fscAccountPoList = this.fscAccountMapper.getList(fscAccountPo);
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty(fscAccountPoList) ? "" : fscAccountPoList.get(0).getDepositBankName(), contentFont, true));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)item.getOutAcctNo()) ? "" : item.getOutAcctNo(), contentFont, true));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)item.getOutAcctName()) ? "" : item.getOutAcctName(), contentFont, true));
                itemTable.addCell(this.createCell("CNY-\u4eba\u6c11\u5e01", contentFont, true));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)item.getAcctBalance()) ? "" : item.getAcctBalance().setScale(2, RoundingMode.HALF_UP).toString(), contentFont, true));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)item.getPurpose()) ? "" : item.getPurpose(), contentFont, true));
                String bankWitnessSeq = item.getHostTrace() + "_" + item.getDetailSerialNo() + "_" + item.getAcctDate();
                itemTable.addCell(this.createCell(bankWitnessSeq, contentFont, true));
            }
            try {
                document.add((Element)itemTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u7ed3\u7b97\u8ba2\u5355\u5ba1\u6279\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7ed3\u7b97\u8ba2\u5355\u5ba1\u6279\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            }
        }
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        log.info("pdf\u4e0a\u4f20\u8def\u5f84:{}", (Object)path);
        String fileUrl = null;
        String innerFileUrl = null;
        for (int count = 0; count < this.reuploadCount; ++count) {
            if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":")) + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            if (fileUrl.indexOf("null") == -1) break;
        }
        log.info("innerFileUrl:{}", innerFileUrl);
        log.info("fileUrl:{}", fileUrl);
        rspBO.setFileUrl(fileUrl);
        fscAttachmentPO.setObjId(Long.getLong(reqBO.getFrontSeqNo()));
        fscAttachmentPO.setFscOrderId(Long.getLong(reqBO.getFrontSeqNo()));
        fscAttachmentPO.setObjType(0);
        fscAttachmentPO.setAttachmentId(Sequence.getInstance().nextId());
        fileName = "\u4ea4\u6613\u6d41\u6c34\u660e\u7ec6-\u201d" + reqBO.getFrontSeqNo() + "\u201c";
        fscAttachmentPO.setAttachmentName(fileName);
        fscAttachmentPO.setAttachmentUrl(fileUrl);
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER_PDF);
        log.info("\u9644\u4ef6\u4fdd\u5b58\u5165\u53c2:{}", (Object)fscAttachmentPO);
        return rspBO;
    }

    private void val(FscBillWithdrawalOrderPdfBusiReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO.getBankCheckIds())) {
            throw new ZTBusinessException("\u63d0\u73b0\u6d41\u6c34\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public PdfPCell createCell(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(250, 191, 28));
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    private Font getFont(String type) {
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u5b57\u4f53\u9519\u8bef");
        }
        Font titleFont = new Font(baseFont, 20.0f, 1);
        Font contentFont = new Font(baseFont, 18.0f, 0);
        switch (type) {
            case "titleFont": {
                return titleFont;
            }
            case "contentFont": {
                return contentFont;
            }
        }
        return null;
    }

    public PdfPCell createCell(String title, Font font, boolean isFirst) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isFirst) {
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
        }
        return cell;
    }
}

