/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.draw.DottedLineSeparator;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.authority.busi.api.SelectAlreadyUser;
import com.tydic.authority.busi.bo.HasUserListBO;
import com.tydic.authority.busi.bo.RoleUserBO;
import com.tydic.authority.busi.bo.SelectAlreadyAndNorUsersReqBO;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import com.tydic.commodity.common.ability.api.UccbBatchQryCatalogRelListAbilityService;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListBO;
import com.tydic.fsc.bo.FscStockBO;
import com.tydic.fsc.bo.FscStockItemBO;
import com.tydic.fsc.busibase.busi.api.FscStockOrderCreatePdfBusiService;
import com.tydic.fsc.busibase.busi.bo.FscStockOrderCreatePdfBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscStockOrderCreatePdfBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderPO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class FscStockOrderCreatePdfBusiServiceImpl
implements FscStockOrderCreatePdfBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscStockOrderCreatePdfBusiServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UccbBatchQryCatalogRelListAbilityService uccbBatchQryCatalogRelListAbilityService;
    @Value(value="${saleOrderCreateUserId}")
    private Long saleOrderCreateUserId;
    @Value(value="${saleOrderCreateUserName}")
    private String saleOrderCreateUserName;
    @Value(value="${saleOrderCreateUserLdap}")
    private String saleOrderCreateUserLdap;
    @Value(value="${saleOrderCreateUserPhone}")
    private String saleOrderCreateUserPhone;
    @Autowired
    private SelectAlreadyUser selectAlreadyUser;

    @Override
    public FscStockOrderCreatePdfBusiRspBO stockOrderCreatePdf(FscStockOrderCreatePdfBusiReqBO reqBO) {
        String creatorName = null;
        SelectAlreadyAndNorUsersReqBO umcReqBO = new SelectAlreadyAndNorUsersReqBO();
        umcReqBO.setRoleId(Long.valueOf(1068606837863706624L));
        umcReqBO.setOrgId(Long.valueOf(305775845729763327L));
        HasUserListBO hasUserListBO = this.selectAlreadyUser.selectAlreadyDistributeUser(umcReqBO);
        if (null != hasUserListBO && ObjectUtil.isNotEmpty((Object)hasUserListBO.getAllUser())) {
            creatorName = ((RoleUserBO)hasUserListBO.getAllUser().get(0)).getName();
        }
        log.info("fscStockBO\u5165\u53c2:{}", (Object)reqBO.getFscStockBO());
        log.info("fscStockItemBOS\u5165\u53c2:{}", reqBO.getFscStockItemBOS());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        FscStockBO fscStockBO = reqBO.getFscStockBO();
        List<FscStockItemBO> fscStockItemBOS = reqBO.getFscStockItemBOS();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscStockBO.getFscOrderId());
        fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        String subTitle = "";
        String subTitleOrderNo = "";
        String subTitleFscOrderNo = "";
        String subTitleTime = "";
        FscAttachmentPO fscAttachmentDelPO = new FscAttachmentPO();
        fscAttachmentDelPO.setSysTenantId(reqBO.getSysTenantId());
        if (fscStockBO.getStockFlag().equals(FscConstants.STOCK_FLAG_TEYP.STOCK_OUT)) {
            fscAttachmentDelPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscAttachmentDelPO.setObjId(reqBO.getStockId());
            fscAttachmentDelPO.setAttachmentType(FscConstants.AttachmentType.FSC_SALE_STOCK_ORDER_PDF);
        } else {
            fscAttachmentDelPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscAttachmentDelPO.setObjId(reqBO.getStockId());
            fscAttachmentDelPO.setAttachmentType(FscConstants.AttachmentType.FSC_PURCHASER_STOCK_ORDER_PDF);
        }
        this.fscAttachmentMapper.deleteBy(fscAttachmentDelPO);
        if (fscStockBO.getStockFlag().equals(FscConstants.STOCK_FLAG_TEYP.STOCK_OUT)) {
            subTitle = "\u9500\u552e\u51fa\u5e93\u5355";
            subTitleOrderNo = "\u9500\u552e\u51fa\u5e93\u5355\u53f7\uff1a";
            subTitleFscOrderNo = "\u9500\u552e\u7ed3\u7b97\u5355\u53f7\uff1a";
            subTitleTime = "\u9500\u552e\u51fa\u5e93\u65f6\u95f4\uff1a";
        } else {
            subTitle = "\u5546\u54c1\u91c7\u8d2d\u5165\u5e93\u5355";
            subTitleOrderNo = "\u91c7\u8d2d\u5165\u5e93\u5355\u53f7\uff1a";
            subTitleFscOrderNo = "\u9500\u552e\u7ed3\u7b97\u5355\u53f7\uff1a";
            subTitleTime = "\u91c7\u8d2d\u5165\u5e93\u65f6\u95f4\uff1a";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Font titleFont = this.getFont("titleFont");
        Font contentFont = this.getFont("contentFont");
        Font lagerFont = this.getFont("lagerFont");
        Font contentFontRed = this.getFontRed("contentFont");
        Document document = new Document(PageSize.A4.rotate(), 75.0f, 75.0f, 15.0f, 40.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        Paragraph paragraph = new Paragraph(subTitle, titleFont);
        paragraph.setAlignment(1);
        paragraph.setLeading(30.0f);
        try {
            document.add((Element)paragraph);
        }
        catch (DocumentException e) {
            log.info("\u6807\u9898\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("\u6807\u9898\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable lineOne = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
        lineOne.setTotalWidth(700.0f);
        lineOne.addCell(this.createCellRight(subTitleOrderNo, contentFont, 0, false));
        lineOne.addCell(this.createCellLeft(fscStockBO.getStockNo(), contentFont, 0, false));
        lineOne.addCell(this.createCellRight(subTitleFscOrderNo, contentFont, 0, false));
        lineOne.addCell(this.createCellLeft(fscStockBO.getFscOrderNo(), contentFont, 0, false));
        lineOne.addCell(this.createCellRight(subTitleTime, contentFont, 0, false));
        lineOne.addCell(this.createCellLeft(sdf.format(fscStockBO.getCreateTime()), contentFont, 0, false));
        if (fscStockBO.getStockFlag().equals(FscConstants.STOCK_FLAG_TEYP.STOCK_OUT)) {
            lineOne.addCell(this.createCellRight("\u91c7\u8d2d\u5355\u4f4d\u540d\u79f0\uff1a", contentFont, 0, false));
            lineOne.addCell(this.createCellLeft(fscStockBO.getPurchaserName(), contentFont, 0, false));
        } else {
            lineOne.addCell(this.createCellRight("\u4f9b\u5e94\u5546\u540d\u79f0\uff1a", contentFont, 0, false));
            lineOne.addCell(this.createCellLeft(fscStockBO.getSupplierName(), contentFont, 0, false));
        }
        lineOne.addCell(this.createCellRight("\u5165\u5e93\u5355\u72b6\u6001\uff1a", contentFont, 0, false));
        lineOne.addCell(this.createCellLeft(fscStockBO.getStockStatus() == 0 ? "\u6709\u6548" : "\u5df2\u4f5c\u5e9f", fscStockBO.getStockStatus() == 0 ? contentFont : contentFontRed, 0, false));
        try {
            document.add((Element)lineOne);
        }
        catch (DocumentException e) {
            log.info("\u6807\u9898\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("\u6807\u9898\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable lineOneTemp = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
        lineOneTemp.setTotalWidth(700.0f);
        String untaxAmtStr = ObjectUtils.isEmpty((Object)fscStockBO.getUntaxAmt()) ? "" : fscStockBO.getUntaxAmt().setScale(2).toString();
        lineOneTemp.addCell(this.createCellRight("\u603b\u4ef7\u6b3e\uff08\u5143\uff09\uff1a", contentFont, 0, false));
        lineOneTemp.addCell(this.createCellLeft(untaxAmtStr, contentFont, 0, false));
        String taxAmtStr = ObjectUtils.isEmpty((Object)fscStockBO.getTaxAmt()) ? "" : fscStockBO.getTaxAmt().setScale(2).toString();
        lineOneTemp.addCell(this.createCellRight("\u603b\u7a0e\u6b3e\uff08\u5143\uff09\uff1a", contentFont, 0, false));
        lineOneTemp.addCell(this.createCellLeft(taxAmtStr, contentFont, 0, false));
        String totalAmt = ObjectUtils.isEmpty((Object)fscStockBO.getTotalAmt()) ? "" : fscStockBO.getTotalAmt().setScale(2).toString();
        lineOneTemp.addCell(this.createCellRight("\u4ef7\u7a0e\u5408\u8ba1\uff08\u5143\uff09\uff1a", contentFont, 0, false));
        lineOneTemp.addCell(this.createCellLeft(totalAmt, contentFont, 0, false));
        lineOneTemp.addCell(this.createCellRight("\u5e01\u79cd\uff1a", contentFont, 0, false));
        lineOneTemp.addCell(this.createCellLeft("\u4eba\u6c11\u5e01", contentFont, 0, false));
        lineOneTemp.addCell(this.createCellRight("\u7ecf\u529e\u4eba\uff1a", contentFont, 0, false));
        lineOneTemp.addCell(this.createCellLeft(ObjectUtil.isEmpty((Object)creatorName) ? this.saleOrderCreateUserName : creatorName, contentFont, 0, false));
        try {
            document.add((Element)lineOneTemp);
        }
        catch (DocumentException e) {
            log.info("\u6807\u9898\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("\u6807\u9898\u65b0\u589e\u9519\u8bef");
        }
        Paragraph p2 = new Paragraph();
        p2.add((Element)new Chunk((DrawInterface)new DottedLineSeparator()));
        p2.setLeading(20.0f);
        Paragraph orderSummaryTitle = new Paragraph("\u4e1a\u52a1\u5c0f\u7c7b\u6c47\u603b", titleFont);
        orderSummaryTitle.setAlignment(0);
        orderSummaryTitle.setLeading(30.0f);
        try {
            document.add((Element)orderSummaryTitle);
        }
        catch (DocumentException e) {
            log.info("pdf\u9500\u552e\u51fa\u5e93\u5355\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u9500\u552e\u51fa\u5e93\u5355\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
        }
        try {
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable nullTable1 = new PdfPTable(1);
        nullTable1.addCell(this.createCell("", contentFont, 0, false));
        try {
            document.add((Element)nullTable1);
        }
        catch (DocumentException e) {
            log.info("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
        }
        if (!ObjectUtils.isEmpty(fscStockItemBOS)) {
            PdfPTable orderSummaryTable = new PdfPTable(new float[]{10.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f});
            orderSummaryTable.setTotalWidth(700.0f);
            orderSummaryTable.setLockedWidth(true);
            orderSummaryTable.setHorizontalAlignment(1);
            orderSummaryTable.getDefaultCell().setBorder(1);
            orderSummaryTable.addCell(this.createCell("\u5e8f\u53f7", lagerFont, 0, true));
            orderSummaryTable.addCell(this.createCell("\u4e1a\u52a1\u5c0f\u7c7b", lagerFont, 0, true));
            if (fscStockBO.getStockFlag().equals(FscConstants.STOCK_FLAG_TEYP.STOCK_OUT)) {
                orderSummaryTable.addCell(this.createCell("\u9500\u552e\u5546\u54c1\u5165\u5e93\u51fa\u5e93\u5355-\u51fa\u5e93\u5c0f\u7c7b", lagerFont, 0, true));
            } else {
                orderSummaryTable.addCell(this.createCell("\u9500\u552e\u5546\u54c1\u5165\u5e93\u51fa\u5e93\u5355-\u5165\u5e93\u5c0f\u7c7b", lagerFont, 0, true));
            }
            orderSummaryTable.addCell(this.createCell("\u7a0e\u7387\uff08%\uff09", lagerFont, 0, true));
            orderSummaryTable.addCell(this.createCell("\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\uff08\u5143\uff09", lagerFont, 0, true));
            orderSummaryTable.addCell(this.createCell("\u603b\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\uff08\u5143\uff09", lagerFont, 0, true));
            orderSummaryTable.addCell(this.createCell("\u7a0e\u989d\uff08\u5143\uff09", lagerFont, 0, true));
            fscStockItemBOS.forEach(item -> {
                if (ObjectUtil.isEmpty((Object)item.getL1CatalogName())) {
                    item.setL1CatalogName("");
                }
            });
            List catalogNameList = fscStockItemBOS.stream().map(FscStockItemBO::getL1CatalogName).collect(Collectors.toList());
            UccbBatchQryCatalogRelListAbilityReqBO relListAbilityReqBO = new UccbBatchQryCatalogRelListAbilityReqBO();
            relListAbilityReqBO.setCatalogNames(catalogNameList);
            log.info("\u63a8\u9001\u7a0e\u63a7-\u67e5\u8be2\u4e1a\u52a1\u5c0f\u7c7b\u5165\u53c2:{}", (Object)relListAbilityReqBO);
            UccbBatchQryCatalogRelListAbilityRspBO rspBO = this.uccbBatchQryCatalogRelListAbilityService.batchQryCatalogRelList(relListAbilityReqBO);
            log.info("\u63a8\u9001\u7a0e\u63a7-\u67e5\u8be2\u4e1a\u52a1\u5c0f\u7c7b\u51fa\u53c2:{}", (Object)rspBO);
            if (!ObjectUtil.isEmpty((Object)rspBO.getRows())) {
                Map<String, List<UccbBatchQryCatalogRelListBO>> uccbBatchQryCatalogRelListBOList = rspBO.getRows().stream().collect(Collectors.groupingBy(UccbBatchQryCatalogRelListBO::getCatalogName));
                fscStockItemBOS.forEach(item -> {
                    if (!ObjectUtil.isEmpty(uccbBatchQryCatalogRelListBOList.get(item.getL1CatalogName()))) {
                        item.setCatalogIn(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(item.getL1CatalogName())).get(0)).getCatalogIn());
                        item.setCatalogOut(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(item.getL1CatalogName())).get(0)).getCatalogOut());
                        item.setSalesReceiptsStatement(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(item.getL1CatalogName())).get(0)).getSalesReceiptsStatement());
                        item.setBussiCatalogName(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(item.getL1CatalogName())).get(0)).getBussiCatalogName());
                    }
                });
            }
            Map<String, List<FscStockItemBO>> fscStock1CatalogNameMap = fscStockItemBOS.stream().collect(Collectors.groupingBy(o -> o.getBussiCatalogName() + o.getTaxRate()));
            AtomicInteger catalogNameSort = new AtomicInteger(1);
            BigDecimal allPrice = fscStockItemBOS.stream().map(FscStockItemBO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal allUntaxAmt = fscStockItemBOS.stream().map(FscStockItemBO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal allTaxAmt = fscStockItemBOS.stream().map(FscStockItemBO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            fscStock1CatalogNameMap.forEach((key, value) -> {
                BigDecimal amtTemp = value.stream().map(FscStockItemBO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal untaxAmtTemp = value.stream().map(FscStockItemBO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxAmt = value.stream().map(FscStockItemBO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                orderSummaryTable.addCell(this.createCell("(" + catalogNameSort.get() + ")", contentFont, true));
                orderSummaryTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)((FscStockItemBO)value.get(0)).getBussiCatalogName()) ? "" : ((FscStockItemBO)value.get(0)).getBussiCatalogName(), contentFont, false));
                if (fscStockBO.getStockFlag().equals(FscConstants.STOCK_FLAG_TEYP.STOCK_OUT)) {
                    orderSummaryTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)((FscStockItemBO)value.get(0)).getCatalogOut()) ? "" : ((FscStockItemBO)value.get(0)).getCatalogOut(), contentFont, false));
                } else {
                    orderSummaryTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)((FscStockItemBO)value.get(0)).getCatalogIn()) ? "" : ((FscStockItemBO)value.get(0)).getCatalogIn(), contentFont, false));
                }
                Double tempTax = Double.valueOf(((FscStockItemBO)value.get(0)).getTaxRate().toString());
                if (tempTax > 1.0) {
                    orderSummaryTable.addCell(this.createCell(((FscStockItemBO)value.get(0)).getTaxRate().setScale(0).toString() + "%", contentFont, false));
                } else {
                    orderSummaryTable.addCell(this.createCell(((FscStockItemBO)value.get(0)).getTaxRate().multiply(new BigDecimal("100")).setScale(0).toString() + "%", contentFont, false));
                }
                orderSummaryTable.addCell(this.createCell(amtTemp.setScale(2, 4).toString(), contentFont, false));
                orderSummaryTable.addCell(this.createCell(untaxAmtTemp.setScale(2, 4).toString(), contentFont, false));
                orderSummaryTable.addCell(this.createCell(taxAmt.setScale(2, 4).toString(), contentFont, false));
                catalogNameSort.getAndIncrement();
            });
            orderSummaryTable.addCell(this.createCell("\u5408\u8ba1", lagerFont));
            orderSummaryTable.addCell(this.createCell("", lagerFont));
            orderSummaryTable.addCell(this.createCell("", lagerFont));
            orderSummaryTable.addCell(this.createCell("", lagerFont));
            orderSummaryTable.addCell(this.createCell(allPrice.setScale(2, 4).toString(), lagerFont));
            orderSummaryTable.addCell(this.createCell(allUntaxAmt.setScale(2, 4).toString(), lagerFont));
            orderSummaryTable.addCell(this.createCell(allTaxAmt.setScale(2, 4).toString(), lagerFont));
            try {
                document.add((Element)orderSummaryTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u8bbe\u7f6e\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603b\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u8bbe\u7f6e\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603b\u65b0\u589e\u9519\u8bef");
            }
        }
        Paragraph orderItemParagraph = new Paragraph(subTitle + "\u660e\u7ec6", titleFont);
        orderItemParagraph.setAlignment(0);
        orderItemParagraph.setLeading(30.0f);
        try {
            document.add((Element)orderItemParagraph);
        }
        catch (DocumentException e) {
            log.info("pdf\u9500\u552e\u51fa\u5e93\u5355\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u9500\u552e\u51fa\u5e93\u5355\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
        }
        if (!ObjectUtils.isEmpty(fscStockItemBOS)) {
            try {
                document.add((Element)p2);
            }
            catch (DocumentException e) {
                log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            }
            PdfPTable nullTable = new PdfPTable(1);
            nullTable.addCell(this.createCell("", contentFont, 0, false));
            try {
                document.add((Element)nullTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
            }
            PdfPTable itemTable = new PdfPTable(new float[]{4.0f, 14.0f, 8.0f, 8.0f, 8.0f, 10.0f, 10.0f, 10.0f, 12.0f, 8.0f, 12.0f, 12.0f, 10.0f, 10.0f, 10.0f});
            itemTable.setTotalWidth(700.0f);
            itemTable.setLockedWidth(true);
            itemTable.setHorizontalAlignment(1);
            itemTable.getDefaultCell().setBorder(1);
            itemTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u5355\u54c1\u540d\u79f0", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u7269\u6599\u540d\u79f0", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u89c4\u683c", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u578b\u53f7", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u4e00\u7ea7\u7c7b\u76ee", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u8ba1\u91cf\u5355\u4f4d", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u9a8c\u6536\u6570\u91cf", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u91c7\u8d2d\u5355\u4ef7\uff08\u542b\u7a0e\uff09\uff08\u5143\uff09", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u7a0e\u7387\uff08%\uff09", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u91c7\u8d2d\u91d1\u989d\uff08\u542b\u7a0e\uff09\uff08\u5143\uff09", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u91c7\u8d2d\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\uff08\u5143\uff09", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u7a0e\u989d\uff08\u5143\uff09", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u7ba1\u63a7\u54c1\u7c7b", lagerFont, 0, true));
            itemTable.addCell(this.createCell("\u4fe1\u521b\u5546\u54c1", lagerFont, 0, true));
            int itemCount = 1;
            for (FscStockItemBO fscStockItemBO : fscStockItemBOS) {
                itemTable.addCell(this.createCell(itemCount > 9 ? String.valueOf(itemCount) : "0" + itemCount, contentFont, false));
                itemTable.addCell(this.createCell(fscStockItemBO.getSkuName(), contentFont, false));
                itemTable.addCell(this.createCell("", contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)fscStockItemBO.getSpec()) ? "" : fscStockItemBO.getSpec(), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)fscStockItemBO.getModel()) ? "" : fscStockItemBO.getModel(), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)fscStockItemBO.getL1CatalogName()) ? "" : fscStockItemBO.getL1CatalogName(), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)fscStockItemBO.getUnit()) ? "" : fscStockItemBO.getUnit(), contentFont, false));
                if (fscStockBO.getStockFlag().equals(FscConstants.STOCK_FLAG_TEYP.STOCK_OUT)) {
                    itemTable.addCell(this.createCell(fscStockItemBO.getOutNum().toString(), contentFont, false));
                } else {
                    itemTable.addCell(this.createCell(fscStockItemBO.getInNum().toString(), contentFont, false));
                }
                itemTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)fscStockItemBO.getPrice()) ? "" : fscStockItemBO.getPrice().setScale(2).toString(), contentFont, false));
                BigDecimal price = ObjectUtils.isEmpty((Object)fscStockItemBO.getPrice()) ? BigDecimal.ZERO : fscStockItemBO.getPrice().setScale(2);
                BigDecimal tax = ObjectUtils.isEmpty((Object)fscStockItemBO.getTaxRate()) ? BigDecimal.ZERO : fscStockItemBO.getTaxRate().setScale(2);
                BigDecimal unPriceTax = BigDecimal.ZERO;
                unPriceTax = tax.compareTo(BigDecimal.ZERO) > 1 ? new BigDecimal("1").add(tax.divide(new BigDecimal("100"), 2, 4)) : new BigDecimal("1").add(tax);
                BigDecimal unPrice = price.divide(unPriceTax, 2, 4);
                Double tempTax = Double.valueOf(tax.toString());
                if (tempTax > 1.0) {
                    itemTable.addCell(this.createCell(tax.toString() + "%", contentFont, false));
                } else {
                    itemTable.addCell(this.createCell(tax.multiply(new BigDecimal("100")).setScale(0).toString() + "%", contentFont, false));
                }
                itemTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)fscStockItemBO.getAmt()) ? "" : fscStockItemBO.getAmt().setScale(2).toString(), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)fscStockItemBO.getUntaxAmt()) ? "" : fscStockItemBO.getUntaxAmt().setScale(2).toString(), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)fscStockItemBO.getTaxAmt()) ? "" : fscStockItemBO.getTaxAmt().setScale(2).toString(), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtils.isEmpty((Object)fscStockItemBO.getXcCategory()) ? "" : ("0".equals(fscStockItemBO.getXcCategory()) ? "\u5426" : "\u662f"), contentFont, false));
                String xcSkuStr = ObjectUtil.isEmpty((Object)fscStockItemBO.getXcSku()) ? "" : ("0".equals(fscStockItemBO.getXcCategory()) ? "-" : ("0".equals(fscStockItemBO.getXcSku()) ? "\u5426" : "\u662f"));
                itemTable.addCell(this.createCell(xcSkuStr, contentFont, false));
                ++itemCount;
            }
            try {
                document.add((Element)itemTable);
            }
            catch (DocumentException e) {
                log.info(subTitle + "pdf\u751f\u6210\u9519\u8bef");
                throw new ZTBusinessException(subTitle + "pdf\u751f\u6210\u9519\u8bef");
            }
        }
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        log.info("pdf\u4e0a\u4f20\u8def\u5f84:{}", (Object)path);
        String fileUrl = null;
        String innerFileUrl = null;
        if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
            innerFileUrl = this.accessUrl + path;
            fileUrl = this.ossFileUrl + path;
        } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":")) + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        log.info("innerFileUrl:{}", (Object)innerFileUrl);
        log.info("fileUrl:{}", (Object)fileUrl);
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setObjId(fscStockBO.getId());
        fscAttachmentPO.setFscOrderId(fscStockBO.getFscOrderId());
        fscAttachmentPO.setAttachmentId(Sequence.getInstance().nextId());
        fileName = fscStockBO.getStockFlag().equals(FscConstants.STOCK_FLAG_TEYP.STOCK_OUT) ? "\u5546\u54c1\u9500\u552e\u51fa\u5e93\u5355.pdf" : "\u5546\u54c1\u91c7\u8d2d\u5165\u5e93\u5355.pdf";
        fscAttachmentPO.setAttachmentName(fileName);
        fscAttachmentPO.setAttachmentUrl(fileUrl);
        if (fscStockBO.getStockFlag().equals(FscConstants.STOCK_FLAG_TEYP.STOCK_OUT)) {
            fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_SALE_STOCK_ORDER_PDF);
        } else {
            fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_PURCHASER_STOCK_ORDER_PDF);
        }
        log.info("\u9644\u4ef6\u4fdd\u5b58\u5165\u53c2:{}", (Object)fscAttachmentPO);
        FscStockOrderCreatePdfBusiRspBO fscStockOrderCreatePdfBusiRspBO = new FscStockOrderCreatePdfBusiRspBO();
        fscAttachmentPO.setSysTenantId(reqBO.getSysTenantId());
        fscAttachmentPO.setSysTenantName(reqBO.getSysTenantName());
        try {
            this.fscAttachmentMapper.insert(fscAttachmentPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4fdd\u5b58\u51fa\u5165\u5e93\u5355\u9644\u4ef6\u5931\u8d25:{}", (Object)fscAttachmentPO);
            fscStockOrderCreatePdfBusiRspBO.setRespCode("190000");
            fscStockOrderCreatePdfBusiRspBO.setRespDesc("\u5931\u8d25");
            return fscStockOrderCreatePdfBusiRspBO;
        }
        fscStockOrderCreatePdfBusiRspBO.setRespCode("0000");
        fscStockOrderCreatePdfBusiRspBO.setRespDesc("\u6210\u529f");
        fscStockOrderCreatePdfBusiRspBO.setAttachmentUrl(fscAttachmentPO.getAttachmentUrl());
        return fscStockOrderCreatePdfBusiRspBO;
    }

    private Font getFont(String type) {
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u5b57\u4f53\u9519\u8bef");
        }
        Font titleFont = new Font(baseFont, 10.0f, 1);
        Font lagerFont = new Font(baseFont, 9.0f, 1);
        Font contentFont = new Font(baseFont, 7.0f, 0);
        switch (type) {
            case "titleFont": {
                return titleFont;
            }
            case "lagerFont": {
                return lagerFont;
            }
            case "contentFont": {
                return contentFont;
            }
        }
        return null;
    }

    private Font getFontRed(String type) {
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u5b57\u4f53\u9519\u8bef");
        }
        Font titleFont = new Font(baseFont, 10.0f, 1, BaseColor.RED);
        Font lagerFont = new Font(baseFont, 9.0f, 1, BaseColor.RED);
        Font contentFont = new Font(baseFont, 7.0f, 0, BaseColor.RED);
        switch (type) {
            case "titleFont": {
                return titleFont;
            }
            case "lagerFont": {
                return lagerFont;
            }
            case "contentFont": {
                return contentFont;
            }
        }
        return null;
    }

    public PdfPCell createCell(String title, Font font, int colspan, boolean isColor, int horizontalAlignment) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(horizontalAlignment);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(250, 191, 28));
        } else {
            cell.setBorder(0);
        }
        cell.setColspan(colspan);
        return cell;
    }

    public PdfPCell createCell(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(20.0f);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(250, 191, 28));
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    public PdfPCell createCellLeft(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(20.0f);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(250, 191, 28));
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    public PdfPCell createCellRight(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(20.0f);
        cell.setHorizontalAlignment(2);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(250, 191, 28));
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    public PdfPCell createCell(String title, Font font) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(20.0f);
        cell.setHorizontalAlignment(2);
        cell.setVerticalAlignment(5);
        cell.setBackgroundColor(new BaseColor(250, 191, 28));
        return cell;
    }

    public PdfPCell createCell(String title, Font font, boolean isFirst) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(20.0f);
        cell.setHorizontalAlignment(2);
        cell.setVerticalAlignment(5);
        if (isFirst) {
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
        }
        return cell;
    }
}

