/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.fsc.api.DycFscBillOrderBundlCheckService;
import com.tydic.dyc.fsc.api.DycPebExtOrderListQryForFscNewAbilityService;
import com.tydic.dyc.fsc.bo.DycFscBillOrderBundlCheckReqBO;
import com.tydic.dyc.fsc.bo.DycFscBillOrderBundlCheckRspBO;
import com.tydic.dyc.fsc.bo.DycFscUocQryAcceptOrderListReqBO;
import com.tydic.dyc.fsc.bo.DycPebExtOrderListQryForFscRspBO;
import com.tydic.dyc.fsc.bo.DycrelOrderBO;
import com.tydic.dyc.fsc.bo.PayAccountDayRuleBO;
import com.tydic.dyc.fsc.bo.PayNodeRuleBO;
import com.tydic.dyc.fsc.bo.PayRuleBO;
import com.tydic.dyc.fsc.bo.PayTypeBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycFscBillOrderBundlCheckServiceImpl
implements DycFscBillOrderBundlCheckService {
    private static final Logger log = LoggerFactory.getLogger(DycFscBillOrderBundlCheckServiceImpl.class);
    private static final Integer BUND = 1;
    private static final Integer NOT_BUND = 0;
    private static final Integer TAB_ID = 80013;
    private static final Map<Integer, String> PAY_RULE = new HashMap<Integer, String>(4);
    private static final Map<Integer, String> PAY_ACCOUNT_RULE = new HashMap<Integer, String>(4);
    private static final Map<Integer, String> PAY_NODE_RULE = new HashMap<Integer, String>(4);
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;
    @Autowired
    private DycPebExtOrderListQryForFscNewAbilityService dycPebExtOrderListQryForFscNewAbilityService;
    @Value(value="${isMockOrderPro:false}")
    private Boolean isMockOrderPro;

    public DycFscBillOrderBundlCheckRspBO dealBundlCheck(DycFscBillOrderBundlCheckReqBO reqBO) {
        if (reqBO.getRelOrderList().size() == 1) {
            DycFscBillOrderBundlCheckRspBO dycFscBillOrderBundlCheckRspBO = new DycFscBillOrderBundlCheckRspBO();
            dycFscBillOrderBundlCheckRspBO.setBundlFlag(BUND);
            return dycFscBillOrderBundlCheckRspBO;
        }
        this.val(reqBO);
        List relOrderList = reqBO.getRelOrderList();
        List<Long> acceptIdList = relOrderList.stream().map(DycrelOrderBO::getAcceptOrderId).collect(Collectors.toList());
        UocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.getUocInspectionDetailsListPageQueryRspBO(acceptIdList);
        log.info("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)inspectionDetailsList));
        if (!"0000".equals(inspectionDetailsList.getRespCode())) {
            throw new ZTBusinessException(inspectionDetailsList.getRespDesc());
        }
        List uocInspectionDetailsListBos = inspectionDetailsList.getRows();
        if (CollectionUtils.isEmpty((Collection)uocInspectionDetailsListBos)) {
            throw new ZTBusinessException("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u8fd4\u56de\u9a8c\u6536\u5355\u5217\u8868\u4e3a\u7a7a");
        }
        Map<Long, DycrelOrderBO> longDycRelOrderBoMap = this.assembleMap(uocInspectionDetailsListBos, reqBO);
        Map<Long, String> longStringMap = this.checkOrderParam(longDycRelOrderBoMap, reqBO);
        return this.assembleRsp(longStringMap, longDycRelOrderBoMap);
    }

    private UocInspectionDetailsListPageQueryRspBO getUocInspectionDetailsListPageQueryRspBO(List<Long> acceptIdList) {
        UocInspectionDetailsListPageQueryRspBO inspectionDetailsList;
        if (this.isMockOrderPro.booleanValue()) {
            DycFscUocQryAcceptOrderListReqBO dycFscUocQryAcceptOrderListReqBO = new DycFscUocQryAcceptOrderListReqBO();
            dycFscUocQryAcceptOrderListReqBO.setInspOrderIdList(acceptIdList);
            dycFscUocQryAcceptOrderListReqBO.setPageSize(Integer.valueOf(-1));
            dycFscUocQryAcceptOrderListReqBO.setPageNo(Integer.valueOf(-1));
            log.info("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)this.dycPebExtOrderListQryForFscNewAbilityService));
            DycPebExtOrderListQryForFscRspBO orderListByUocPro = this.dycPebExtOrderListQryForFscNewAbilityService.getOrderListByUocPro(dycFscUocQryAcceptOrderListReqBO);
            log.info("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u51fa\u53c2-\u5f3a\u5236\u7c7b\u578b\u8f6c\u6362\u524d\uff1a{}", (Object)JSON.toJSONString((Object)orderListByUocPro));
            orderListByUocPro.getRows().forEach(inspection -> inspection.getInspectionItemInfo().forEach(inInfo -> {
                Long tax = new Double(Double.parseDouble(inInfo.getTax())).longValue();
                inInfo.setTax(tax + "");
            }));
            log.info("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u51fa\u53c2-\u5f3a\u5236\u7c7b\u578b\u8f6c\u6362\u540e\uff1a{}", (Object)JSON.toJSONString((Object)orderListByUocPro));
            inspectionDetailsList = (UocInspectionDetailsListPageQueryRspBO)JSON.parseObject((String)JSON.toJSONString((Object)orderListByUocPro), UocInspectionDetailsListPageQueryRspBO.class);
        } else {
            UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBo = new UocInspectionDetailsListPageQueryReqBO();
            uocInspectionDetailsListPageQueryReqBo.setInspectionVoucherIdList(acceptIdList);
            uocInspectionDetailsListPageQueryReqBo.setIsAfterSales(Boolean.valueOf(false));
            uocInspectionDetailsListPageQueryReqBo.setTabId(TAB_ID);
            uocInspectionDetailsListPageQueryReqBo.setPageSize(-1);
            log.info("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocInspectionDetailsListPageQueryReqBo));
            inspectionDetailsList = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBo);
        }
        inspectionDetailsList.setRespCode("0000");
        return inspectionDetailsList;
    }

    private DycFscBillOrderBundlCheckRspBO assembleRsp(Map<Long, String> longStringMap, Map<Long, DycrelOrderBO> longDycRelOrderBoMap) {
        DycFscBillOrderBundlCheckRspBO dycFscBillOrderBundlCheckRspBO = new DycFscBillOrderBundlCheckRspBO();
        if (CollectionUtils.isEmpty(longStringMap)) {
            dycFscBillOrderBundlCheckRspBO.setBundlFlag(BUND);
        } else {
            dycFscBillOrderBundlCheckRspBO.setBundlFlag(NOT_BUND);
        }
        HashSet payAccountDaySet = new HashSet();
        HashSet payNodeAccountDaysSet = new HashSet();
        HashSet payTypeBoSet = new HashSet();
        HashSet payRuleBoSet = new HashSet();
        HashSet payAccountDayRuleBoSet = new HashSet();
        HashSet payNodeRuleBoSet = new HashSet();
        longDycRelOrderBoMap.values().forEach(dycrelOrderBO -> {
            if (dycrelOrderBO.getPayAccountDay() != null) {
                payAccountDaySet.add(dycrelOrderBO.getPayAccountDay());
            }
            if (dycrelOrderBO.getPayNodeAccountDays() != null) {
                payNodeAccountDaysSet.add(dycrelOrderBO.getPayNodeAccountDays());
            }
            if (dycrelOrderBO.getPayType() != null) {
                PayTypeBO payTypeBO = new PayTypeBO();
                payTypeBO.setPayType(dycrelOrderBO.getPayType());
                payTypeBO.setPayTypeStr(dycrelOrderBO.getPayTypeStr());
                payTypeBoSet.add(payTypeBO);
            }
            if (dycrelOrderBO.getPayRule() != null) {
                PayRuleBO payRuleBO = new PayRuleBO();
                payRuleBO.setPayRule(dycrelOrderBO.getPayRule());
                payRuleBO.setPayRuleStr(dycrelOrderBO.getPayRuleStr());
                payRuleBoSet.add(payRuleBO);
            }
            if (dycrelOrderBO.getPayAccountDayRule() != null) {
                PayAccountDayRuleBO payAccountDayRuleBo = new PayAccountDayRuleBO();
                payAccountDayRuleBo.setPayAccountDayRule(dycrelOrderBO.getPayAccountDayRule());
                payAccountDayRuleBo.setPayAccountDayRuleStr(dycrelOrderBO.getPayAccountDayRuleStr());
                payAccountDayRuleBoSet.add(payAccountDayRuleBo);
            }
            if (dycrelOrderBO.getPayNodeRule() != null) {
                PayNodeRuleBO payNodeRuleBo = new PayNodeRuleBO();
                payNodeRuleBo.setPayNodeRule(dycrelOrderBO.getPayNodeRule());
                payNodeRuleBo.setPayNodeRuleStr(dycrelOrderBO.getPayNodeRuleStr());
                payNodeRuleBoSet.add(payNodeRuleBo);
            }
        });
        dycFscBillOrderBundlCheckRspBO.setPayTypes(new ArrayList(payTypeBoSet));
        dycFscBillOrderBundlCheckRspBO.setPayAccountDayRules(new ArrayList(payAccountDayRuleBoSet));
        dycFscBillOrderBundlCheckRspBO.setPayAccountDays(new ArrayList(payAccountDaySet));
        dycFscBillOrderBundlCheckRspBO.setPayNodeAccountDayList(new ArrayList(payNodeAccountDaysSet));
        dycFscBillOrderBundlCheckRspBO.setPayRules(new ArrayList(payRuleBoSet));
        dycFscBillOrderBundlCheckRspBO.setPayNodeRules(new ArrayList(payNodeRuleBoSet));
        return dycFscBillOrderBundlCheckRspBO;
    }

    private Map<Long, String> checkOrderParam(Map<Long, DycrelOrderBO> longDycRelOrderBOMap, DycFscBillOrderBundlCheckReqBO reqBO) {
        DycrelOrderBO dycrelOrderBO = longDycRelOrderBOMap.get(((DycrelOrderBO)reqBO.getRelOrderList().get(0)).getAcceptOrderId());
        log.info("dycrelOrderBO:{}", (Object)dycrelOrderBO);
        if (null == dycrelOrderBO) {
            throw new ZTBusinessException("\u67e5\u8be2\u8ba2\u5355\u9a8c\u6536\u5355[" + ((DycrelOrderBO)reqBO.getRelOrderList().get(0)).getAcceptOrderId() + "]\u4fe1\u606f\u4e3a\u7a7a");
        }
        HashMap<Long, String> acceptIdMap = new HashMap<Long, String>(16);
        log.info("longDycRelOrderBoEntry:{}", longDycRelOrderBOMap);
        for (Map.Entry<Long, DycrelOrderBO> longDycRelOrderBoEntry : longDycRelOrderBOMap.entrySet()) {
            if (!dycrelOrderBO.getPayType().equals(longDycRelOrderBoEntry.getValue().getPayType())) {
                acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                continue;
            }
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(longDycRelOrderBoEntry.getValue().getPayType())) {
                if (null == dycrelOrderBO.getPayRule() || null == longDycRelOrderBoEntry.getValue().getPayRule()) {
                    throw new ZTBusinessException("\u8ba2\u5355\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u8fd4\u56de\u4e3a\u7a7a");
                }
                if (!dycrelOrderBO.getPayRule().equals(longDycRelOrderBoEntry.getValue().getPayRule())) {
                    acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    continue;
                }
                if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(dycrelOrderBO.getPayRule())) {
                    if (null == dycrelOrderBO.getPayNodeRule() || null == longDycRelOrderBoEntry.getValue().getPayNodeRule()) {
                        throw new ZTBusinessException("\u8ba2\u5355\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\u4e3a\u7a7a");
                    }
                    if (!dycrelOrderBO.getPayNodeRule().equals(longDycRelOrderBoEntry.getValue().getPayNodeRule())) {
                        acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                        continue;
                    }
                    if (null == dycrelOrderBO.getPayAccountDay() || null == longDycRelOrderBoEntry.getValue().getPayAccountDay()) {
                        throw new ZTBusinessException("\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
                    }
                } else if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(dycrelOrderBO.getPayRule())) {
                    if (null == dycrelOrderBO.getPayAccountDayRule() || null == longDycRelOrderBoEntry.getValue().getPayAccountDayRule()) {
                        throw new ZTBusinessException("\u8ba2\u5355\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\u4e3a\u7a7a");
                    }
                    if (!dycrelOrderBO.getPayAccountDayRule().equals(longDycRelOrderBoEntry.getValue().getPayAccountDayRule())) {
                        acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                        continue;
                    }
                    if (null == dycrelOrderBO.getPayAccountDay() || null == longDycRelOrderBoEntry.getValue().getPayAccountDay()) {
                        throw new ZTBusinessException("\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
                    }
                } else {
                    String orderNo = longDycRelOrderBoEntry.getValue().getPurchaseOrderNo();
                    if (FscConstants.FscBusiModel.MATCHING.equals(longDycRelOrderBoEntry.getValue().getTradeMode())) {
                        orderNo = longDycRelOrderBoEntry.getValue().getSaleOrderNo();
                    }
                    acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u8ba2\u5355\u3010" + orderNo + "\u3011\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u3010" + dycrelOrderBO.getPayRule() + "\u3011\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968");
                    continue;
                }
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !dycrelOrderBO.getPurchaserCode().equals(longDycRelOrderBoEntry.getValue().getPurchaserCode())) {
                acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u6536\u7968\u65b9\u4e3a\u91c7\u8d2d\u5355\u4f4d\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u91c7\u8d2d\u5355\u4f4d\u7684\u8ba2\u5355");
                continue;
            }
            if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) || dycrelOrderBO.getSupplierCode().equals(longDycRelOrderBoEntry.getValue().getSupplierCode())) continue;
            acceptIdMap.put(longDycRelOrderBoEntry.getKey(), "\u5f00\u7968\u65b9\u4e3a\u8fd0\u8425\u65b9\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u4f9b\u5e94\u5546\u7684\u8ba2\u5355");
        }
        return acceptIdMap;
    }

    private Map<Long, DycrelOrderBO> assembleMap(List<UocInspectionDetailsListBO> uocInspectionDetailsListBos, DycFscBillOrderBundlCheckReqBO reqBO) {
        HashMap<Long, DycrelOrderBO> dycRelOrderBoHashMap = new HashMap<Long, DycrelOrderBO>(16);
        for (UocInspectionDetailsListBO row : uocInspectionDetailsListBos) {
            DycrelOrderBO dycrelOrderBo = new DycrelOrderBO();
            dycrelOrderBo.setAcceptOrderId(Long.valueOf(Long.parseLong(row.getInspectionVoucherId())));
            dycrelOrderBo.setOrderId(Long.valueOf(Long.parseLong(row.getOrderId())));
            dycrelOrderBo.setPayAccountDay(row.getPayAccountDay());
            dycrelOrderBo.setPayType(row.getPayType());
            dycrelOrderBo.setPayTypeStr(row.getPayTypeStr());
            dycrelOrderBo.setPayRule(row.getPayRule());
            dycrelOrderBo.setPayRuleStr(PAY_RULE.get(row.getPayRule()));
            dycrelOrderBo.setPayAccountDayRule(row.getPayAccountDayRule());
            dycrelOrderBo.setPayAccountDayRuleStr(PAY_ACCOUNT_RULE.get(row.getPayAccountDayRule()));
            dycrelOrderBo.setPayNodeRule(row.getPayNodeRule());
            dycrelOrderBo.setPayNodeRuleStr(PAY_NODE_RULE.get(row.getPayNodeRule()));
            dycrelOrderBo.setSupplierCode(row.getSupNo());
            dycrelOrderBo.setPurchaserCode(row.getPurNo());
            dycrelOrderBo.setPurchaseOrderNo(row.getPurchaseVoucherNo());
            dycrelOrderBo.setSaleOrderNo(row.getSaleVoucherNo());
            dycrelOrderBo.setTradeMode(row.getTradeMode());
            dycrelOrderBo.setPayNodeAccountDays(row.getPaymentDays());
            dycrelOrderBo.setPayAccountDay(row.getPayAccountDay());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                dycrelOrderBo.setOrderNo(row.getSaleVoucherNo());
            }
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                dycrelOrderBo.setOrderNo(row.getPurchaseVoucherNo());
            }
            dycRelOrderBoHashMap.put(dycrelOrderBo.getAcceptOrderId(), dycrelOrderBo);
        }
        return dycRelOrderBoHashMap;
    }

    private void val(DycFscBillOrderBundlCheckReqBO reqBO) {
        Map<String, List<DycrelOrderBO>> ls;
        if (null == reqBO.getMakeType()) {
            throw new ZTBusinessException("\u5165\u53c2[makeType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getReceiveType()) {
            throw new ZTBusinessException("\u5165\u53c2[receiveType]\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getRelOrderList())) {
            throw new ZTBusinessException("\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
        if (FscConstants.FscOrderMakeType.SUPPLIER.equals(reqBO.getMakeType()) && (ls = reqBO.getRelOrderList().stream().filter(dycrelOrderBO -> !StringUtils.isEmpty((Object)dycrelOrderBO.getSupplierCode())).collect(Collectors.groupingBy(DycrelOrderBO::getSupplierCode))).size() > 1) {
            throw new ZTBusinessException("\u4e0d\u540c\u7684\u4f9b\u5e94\u5546,\u4e0d\u80fd\u751f\u6210\u540c\u4e00\u4e2a\u7ed3\u7b97\u5355");
        }
    }

    static {
        PAY_RULE.put(1, "\u6307\u5b9a\u8d26\u671f\u65e5");
        PAY_RULE.put(2, "\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9+\u8d26\u671f\u5929\u6570");
        PAY_ACCOUNT_RULE.put(1, "\u7b7e\u6536\u53d1\u7968");
        PAY_ACCOUNT_RULE.put(2, "\u8ba2\u5355\u9a8c\u6536");
        PAY_ACCOUNT_RULE.put(3, "\u8ba2\u5355\u5230\u8d27");
        PAY_NODE_RULE.put(1, "\u7b7e\u6536\u53d1\u7968\u5f00\u59cb\u8ba1\u7b97");
        PAY_NODE_RULE.put(2, "\u8ba2\u5355\u9a8c\u6536\u5f00\u59cb\u8ba1\u7b97");
        PAY_NODE_RULE.put(3, "\u8ba2\u5355\u5230\u8d27\u5f00\u59cb\u8ba1\u7b97");
    }
}

