/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.fsc.api.DycFscReGetInvoiceDataAbilityService;
import com.tydic.dyc.fsc.bo.DycFscReGetInvoiceDataAbilityReqBO;
import com.tydic.dyc.fsc.bo.DycFscReGetInvoiceDataAbilityRspBO;
import com.tydic.fsc.bill.ability.api.FscGetInvoiceDataAbilityService;
import com.tydic.fsc.bill.ability.bo.FscGetInvoiceDataAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGetInvoiceDataAbilityRspBO;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.common.ability.api.FscComOrderListPageQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycFscReGetInvoiceDataAbilityServiceImpl
implements DycFscReGetInvoiceDataAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DycFscReGetInvoiceDataAbilityServiceImpl.class);
    private static final Long JD_ID = 100055L;
    private static final Integer RECEIVE_TYPE_PURCHASER = 1;
    private static final Integer RECEIVE_TYPE_OPERATION = 2;
    @Autowired
    private FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService;
    @Autowired
    private FscGetInvoiceDataAbilityService fscGetInvoiceDataAbilityService;

    public DycFscReGetInvoiceDataAbilityRspBO getInvoiceData(DycFscReGetInvoiceDataAbilityReqBO reqBO) {
        FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO = new FscComOrderListQueryAbilityReqBO();
        fscComOrderListQueryAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscComOrderListQueryAbilityReqBO.setOrderSource(FscOrderSourceEnum.ELECTRIC_MARKET.getCode());
        FscComOrderListQueryAbilityRspBO queryAbilityRspBO = this.fscComOrderListPageQueryAbilityService.getComOrderListPageQuery(fscComOrderListQueryAbilityReqBO);
        if (!"0000".equals(queryAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(queryAbilityRspBO.getRespDesc());
        }
        List fscOrders = queryAbilityRspBO.getRows();
        if (!CollectionUtils.isEmpty((Collection)fscOrders)) {
            for (FscComOrderListBO fscOrder : fscOrders) {
                if (FscBillStatus.INVOICING_DEALLING.getCode().equals(fscOrder.getOrderState()) || FscBillStatus.INVOICED.getCode().equals(fscOrder.getOrderState())) {
                    FscGetInvoiceDataAbilityReqBO fscGetInvoiceDataAbilityReqBO = new FscGetInvoiceDataAbilityReqBO();
                    Long orgId = FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrder.getReceiveType()) ? fscOrder.getPurchaserId() : fscOrder.getProOrgId();
                    fscGetInvoiceDataAbilityReqBO.setFscOrderId(fscOrder.getFscOrderId());
                    fscGetInvoiceDataAbilityReqBO.setSupplierId(fscOrder.getSupplierId());
                    fscGetInvoiceDataAbilityReqBO.setProOrgId(orgId);
                    fscGetInvoiceDataAbilityReqBO.setReceiveType(fscOrder.getReceiveType());
                    fscGetInvoiceDataAbilityReqBO.setMakeType(fscOrder.getMakeType());
                    FscGetInvoiceDataAbilityRspBO invoiceData = this.fscGetInvoiceDataAbilityService.getInvoiceData(fscGetInvoiceDataAbilityReqBO);
                    if ("0000".equals(invoiceData.getRespCode())) continue;
                    throw new ZTBusinessException(invoiceData.getRespDesc());
                }
                throw new ZTBusinessException("\u53ea\u6709\u5df2\u63d0\u4ea4\u548c\u5df2\u5f00\u7968\u72b6\u6001\u53ef\u4ee5\u91cd\u65b0\u83b7\u53d6\u53d1\u7968");
            }
        } else {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4e3b\u5355\u6570\u636e");
        }
        DycFscReGetInvoiceDataAbilityRspBO rspBO = new DycFscReGetInvoiceDataAbilityRspBO();
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

