/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.cfc.ability.api.CfcQryImportTemplateListAbilityService;
import com.tydic.cfc.ability.bo.CfcImportTemplateBO;
import com.tydic.cfc.ability.bo.CfcQryImportTemplateListAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryImportTemplateListAbilityRspBO;
import com.tydic.dyc.fsc.api.DycFscSupplierReconciliationService;
import com.tydic.dyc.fsc.api.DycPebExtOrderListQryForFscAbilityService;
import com.tydic.dyc.fsc.bo.CellData;
import com.tydic.dyc.fsc.bo.DycFscInspectionDetailsListBO;
import com.tydic.dyc.fsc.bo.DycFscInspectionItemListBO;
import com.tydic.dyc.fsc.bo.DycFscProFscRelInfoBo;
import com.tydic.dyc.fsc.bo.DycPebExtOrderListQryForFscReqBO;
import com.tydic.dyc.fsc.bo.DycPebExtOrderListQryForFscRspBO;
import com.tydic.dyc.fsc.bo.DycSupplierReconciliationExcelExportReqBO;
import com.tydic.fsc.constants.FscConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycFscSupplierReconciliationServiceImpl
implements DycFscSupplierReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(DycFscSupplierReconciliationServiceImpl.class);
    @Autowired
    private DycPebExtOrderListQryForFscAbilityService dycPebExtOrderListQryForFscAbilityService;
    @Autowired
    private CfcQryImportTemplateListAbilityService cfcQryImportTemplateListAbilityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel(HttpServletResponse response, DycSupplierReconciliationExcelExportReqBO reqBO) {
        DycPebExtOrderListQryForFscReqBO dycPebExtOrderListQryForFscReqBO = (DycPebExtOrderListQryForFscReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycPebExtOrderListQryForFscReqBO.class);
        DycPebExtOrderListQryForFscRspBO dycPebExtOrderListQryForFscRspBO = this.dycPebExtOrderListQryForFscAbilityService.getOrderListQryForFsc(dycPebExtOrderListQryForFscReqBO);
        CfcQryImportTemplateListAbilityReqBO cfcQryImportTemplateListAbilityReqBO = new CfcQryImportTemplateListAbilityReqBO();
        cfcQryImportTemplateListAbilityReqBO.setImportTemplateNo("DDJSDDZ");
        CfcQryImportTemplateListAbilityRspBO cfcQryImportTemplateListAbilityRspBO = this.cfcQryImportTemplateListAbilityService.qryImportTemplateList(cfcQryImportTemplateListAbilityReqBO);
        String urlLocation = ((CfcImportTemplateBO)cfcQryImportTemplateListAbilityRspBO.getRows().get(0)).getImportTemplateUrl();
        HttpURLConnection urlConnection = null;
        InputStream is = null;
        try {
            URL url = new URL(urlLocation);
            urlConnection = (HttpURLConnection)url.openConnection();
            is = urlConnection.getInputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(is);
            XSSFSheet sheet = workbook.getSheetAt(0);
            List mergedRegions = sheet.getMergedRegions();
            List<CellData> orderDataListRow1 = this.getCellData(0, 1, 11, workbook);
            List<CellData> itemDataListRow2 = this.getCellData(0, 3, 11, workbook);
            List<CellData> orderDataListRow3 = this.getCellData(0, 2, 11, workbook);
            List<CellData> itemDataListRow4 = this.getCellData(0, 4, 11, workbook);
            if (CollectionUtils.isNotEmpty((Collection)dycPebExtOrderListQryForFscRspBO.getRows())) {
                this.insertDataToSheet(1, dycPebExtOrderListQryForFscRspBO, sheet, orderDataListRow1, itemDataListRow2, orderDataListRow3, itemDataListRow4, mergedRegions, reqBO);
            }
            response.reset();
            response.setContentType("application/x-msdownload");
            String fileName = "\u7ed3\u7b97-\u4f9b\u5e94\u5546\u5bf9\u8d26\u5bfc\u51fa\u529f\u80fd.xlsx";
            String fileNameURL = URLEncoder.encode(fileName, "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileNameURL + ";filename*=utf-8''" + fileNameURL);
            ServletOutputStream output = response.getOutputStream();
            workbook.write((OutputStream)output);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void insertDataToSheet(int startRowIndex, DycPebExtOrderListQryForFscRspBO rows, XSSFSheet sheet, List<CellData> orderDataListRow1, List<CellData> itemDataListRow2, List<CellData> orderDataListRow3, List<CellData> itemDataListRow4, List<CellRangeAddress> mergedRegions, DycSupplierReconciliationExcelExportReqBO reqBO) {
        int index = 0;
        for (DycFscInspectionDetailsListBO row : rows.getRows()) {
            CellData cellData;
            XSSFCell cell;
            int i;
            if (Objects.isNull(sheet.getRow(startRowIndex))) {
                sheet.createRow(startRowIndex);
            }
            XSSFRow startRow = sheet.getRow(startRowIndex);
            startRow.setHeight(orderDataListRow1.get(0).getRowHeight());
            for (i = 0; i < orderDataListRow1.size(); ++i) {
                if (Objects.isNull(orderDataListRow1.get(i))) continue;
                if (Objects.isNull(startRow.getCell(i))) {
                    startRow.createCell(i);
                }
                cell = startRow.getCell(i);
                cellData = orderDataListRow1.get(i);
                cell.setCellStyle((CellStyle)cellData.getStyle());
                cell.setCellValue(cellData.getData());
                startRow.setHeight(cellData.getRowHeight());
                sheet.setColumnWidth(i, cellData.getColumnWeight());
            }
            if (this.isCanMerge(mergedRegions, startRowIndex, startRowIndex, 0, 1)) {
                sheet.addMergedRegion(new CellRangeAddress(startRowIndex, startRowIndex, 0, 1));
            }
            if (Objects.isNull(sheet.getRow(++startRowIndex))) {
                sheet.createRow(startRowIndex);
            }
            startRow = sheet.getRow(startRowIndex);
            block13: for (i = 0; i < orderDataListRow1.size(); ++i) {
                if (Objects.isNull(orderDataListRow3.get(i))) continue;
                if (Objects.isNull(startRow.getCell(i))) {
                    startRow.createCell(i);
                }
                cell = startRow.getCell(i);
                cellData = orderDataListRow3.get(i);
                cell.setCellStyle((CellStyle)cellData.getStyle());
                cell.setCellValue(cellData.getData());
                startRow.setHeight(cellData.getRowHeight());
                sheet.setColumnWidth(i, cellData.getColumnWeight());
                switch (i) {
                    case 0: {
                        cell.setCellValue((double)(index + 1));
                        continue block13;
                    }
                    case 2: {
                        cell.setCellValue(row.getSaleVoucherNo());
                        continue block13;
                    }
                    case 3: {
                        cell.setCellValue(row.getInspectionVoucherCode());
                        continue block13;
                    }
                    case 4: {
                        cell.setCellValue(row.getInspTotalPurchaseMoney().toString());
                        continue block13;
                    }
                    case 6: {
                        cell.setCellValue(row.getOrderCreateTime());
                        continue block13;
                    }
                    case 7: {
                        cell.setCellValue(row.getInspectionTime());
                        continue block13;
                    }
                    case 8: {
                        cell.setCellValue(row.getPurAccountName());
                        continue block13;
                    }
                    case 9: {
                        cell.setCellValue(row.getPurPlaceOrderName() + "/" + row.getPurLogName());
                        continue block13;
                    }
                    case 10: {
                        if (FscConstants.FscBusiModel.TRADE.equals(reqBO.getTradeMode())) {
                            for (DycFscProFscRelInfoBo fscRelInfoBo : row.getFscRelInfoBos()) {
                                if (!FscConstants.FscBusiModel.TRADE.equals(fscRelInfoBo.getRelType())) continue;
                                cell.setCellValue(fscRelInfoBo.getRelStateStr());
                            }
                            continue block13;
                        }
                        for (DycFscProFscRelInfoBo fscRelInfoBo : row.getFscRelInfoBos()) {
                            if (!FscConstants.FscRelType.MATCH_INVOICE.equals(fscRelInfoBo.getRelType())) continue;
                            cell.setCellValue(fscRelInfoBo.getRelStateStr());
                        }
                        continue block13;
                    }
                }
            }
            if (this.isCanMerge(mergedRegions, startRowIndex, startRowIndex, 0, 1)) {
                sheet.addMergedRegion(new CellRangeAddress(startRowIndex, startRowIndex, 0, 1));
            }
            if (Objects.isNull(sheet.getRow(++startRowIndex))) {
                sheet.createRow(startRowIndex);
            }
            startRow = sheet.getRow(startRowIndex);
            startRowIndex = this.insertItemToRow(row, startRow, itemDataListRow2, sheet, itemDataListRow4, startRowIndex);
            ++startRowIndex;
            ++index;
        }
    }

    private boolean isCanMerge(List<CellRangeAddress> mergedRegions, int startRowIndex, int endRowIndex, int startColumnIndex, int endColumnIndex) {
        if (CollectionUtils.isNotEmpty(mergedRegions)) {
            for (CellRangeAddress mergedRegion : mergedRegions) {
                if (mergedRegion.getFirstColumn() != startColumnIndex || mergedRegion.getLastColumn() != endColumnIndex || mergedRegion.getFirstRow() != startRowIndex || mergedRegion.getLastRow() != endRowIndex) continue;
                return false;
            }
        }
        return true;
    }

    private int insertItemToRow(DycFscInspectionDetailsListBO row, XSSFRow startRow, List<CellData> itemDataListRow2, XSSFSheet sheet, List<CellData> itemDataListRow4, int startRowIndex) {
        if (CollectionUtils.isEmpty((Collection)row.getInspectionItemInfo())) {
            return startRowIndex;
        }
        for (int i = 0; i < itemDataListRow2.size(); ++i) {
            if (Objects.isNull(itemDataListRow2.get(i))) continue;
            if (Objects.isNull(startRow.getCell(i))) {
                startRow.createCell(i);
            }
            XSSFCell cell = startRow.getCell(i);
            CellData cellData = itemDataListRow2.get(i);
            cell.setCellStyle((CellStyle)cellData.getStyle());
            cell.setCellValue(cellData.getData());
            startRow.setHeight(cellData.getRowHeight());
            sheet.setColumnWidth(i, cellData.getColumnWeight());
        }
        for (DycFscInspectionItemListBO item : row.getInspectionItemInfo()) {
            if (Objects.isNull(sheet.getRow(++startRowIndex))) {
                sheet.createRow(startRowIndex);
            }
            startRow = sheet.getRow(startRowIndex);
            startRow.getCell(startRowIndex);
            block12: for (int i = 0; i < itemDataListRow2.size(); ++i) {
                if (Objects.isNull(itemDataListRow4.get(i))) continue;
                if (Objects.isNull(startRow.getCell(i))) {
                    startRow.createCell(i);
                }
                XSSFCell cell = startRow.getCell(i);
                CellData cellData = itemDataListRow4.get(i);
                cell.setCellStyle((CellStyle)cellData.getStyle());
                cell.setCellValue(cellData.getData());
                startRow.setHeight(cellData.getRowHeight());
                sheet.setColumnWidth(i, cellData.getColumnWeight());
                switch (i) {
                    case 1: {
                        cell.setCellValue(item.getSkuId());
                        continue block12;
                    }
                    case 2: {
                        cell.setCellValue(item.getSkuName());
                        continue block12;
                    }
                    case 3: {
                        cell.setCellValue(item.getSellingPrice());
                        continue block12;
                    }
                    case 4: {
                        cell.setCellValue(item.getInspectionCount());
                        continue block12;
                    }
                    case 7: {
                        cell.setCellValue(item.getInspSaleMoney());
                        continue block12;
                    }
                    case 8: {
                        cell.setCellValue(item.getUnitName());
                        continue block12;
                    }
                    case 9: {
                        cell.setCellValue(item.getSpec());
                        continue block12;
                    }
                    case 10: {
                        cell.setCellValue(item.getModel());
                        continue block12;
                    }
                }
            }
        }
        return startRowIndex;
    }

    private List<CellData> getCellData(int sheetIndex, int rowIndex, int columnSize, XSSFWorkbook workbook) {
        LinkedList<CellData> cellDataList = new LinkedList<CellData>();
        XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
        for (int i = 0; i < columnSize; ++i) {
            CellData cellData;
            XSSFRow row = sheet.getRow(rowIndex);
            XSSFCell cell = row.getCell(i);
            if (!Objects.isNull(cell)) {
                XSSFCellStyle cellStyle = cell.getCellStyle();
                short rowHeight = row.getHeight();
                int columnWidth = sheet.getColumnWidth(cell.getColumnIndex());
                cell.setCellType(CellType.STRING);
                String cellValue = cell.getStringCellValue();
                cellData = new CellData(rowHeight, columnWidth, cellStyle, cellValue);
            } else {
                cellData = null;
            }
            cellDataList.add(cellData);
        }
        return cellDataList;
    }
}

