/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsRspBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.PoolTypeEnum;
import com.tydic.commodity.base.constant.SkuPoolRelTypeConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.bo.CommodityCategoryForEsBO;
import com.tydic.commodity.busibase.atom.bo.CommodityForEsBO;
import com.tydic.commodity.busibase.atom.bo.CommoditySpecForEsBO;
import com.tydic.commodity.busibase.atom.bo.EsStorageSpuAttrInfoBO;
import com.tydic.commodity.busibase.atom.bo.EsStorageSpuInfoBO;
import com.tydic.commodity.busibase.atom.bo.SkuForEsBO;
import com.tydic.commodity.busibase.atom.bo.UccPoolsLableBo;
import com.tydic.commodity.busibase.comb.api.SearchCommodityService;
import com.tydic.commodity.busibase.comb.bo.CommodityRspBo;
import com.tydic.commodity.busibase.comb.bo.SearchEsReqBO;
import com.tydic.commodity.busibase.comb.bo.SearchEsRspBo;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccActivityPoolChangeMapper;
import com.tydic.commodity.dao.UccActivityPoolMapper;
import com.tydic.commodity.dao.UccActivitySpuChangeMapper;
import com.tydic.commodity.dao.UccActivitySpuMapper;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccChannelDealMapper;
import com.tydic.commodity.dao.UccCommodityLabelMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccMemSkuWhiteRestrictionMapper;
import com.tydic.commodity.dao.UccOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.dao.UccRelChannelPoolMapper;
import com.tydic.commodity.dao.UccRelCommodityLabelPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.po.CommodityForEsPO;
import com.tydic.commodity.po.CommoditySpecForEsPO;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.EmdmCatalogLevelPO;
import com.tydic.commodity.po.SkuForEsPO;
import com.tydic.commodity.po.UccActivityPoolChangePO;
import com.tydic.commodity.po.UccActivityPoolPO;
import com.tydic.commodity.po.UccActivitySpuChangePO;
import com.tydic.commodity.po.UccActivitySpuPO;
import com.tydic.commodity.po.UccCatalogDealPO;
import com.tydic.commodity.po.UccCatalogLevelPo;
import com.tydic.commodity.po.UccChannelDealPO;
import com.tydic.commodity.po.UccCommodityLabelPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccMallBrandRelPO;
import com.tydic.commodity.po.UccMemSkuWhiteRestrictionPo;
import com.tydic.commodity.po.UccOrgSkuWhiteRestrictionPo;
import com.tydic.commodity.po.UccRelChannelPoolPo;
import com.tydic.commodity.po.UccRelCommodityLabelPoolPo;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.osworkflow.approve.ability.EacQueryApproveTaskListAbilityService;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import com.tydic.umc.general.ability.api.CrcCheckTenantCategoryAbilityService;
import com.tydic.umc.general.ability.api.UmcQryCorportionIdsBySbuAbilityService;
import com.tydic.umc.general.ability.bo.CrcCheckTenantCategoryAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcCheckTenantCategoryAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQryCorportionIdsBySbuAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryCorportionIdsBySbuAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcTenantCooperationCategoryAbilityBO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="syncSceneCommodityToEsAtomService")
public class SyncSceneCommodityToEsAtomServiceImpl
implements SyncSceneCommodityToEsAtomService {
    private static final Logger log = LoggerFactory.getLogger(SyncSceneCommodityToEsAtomServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncSceneCommodityToEsAtomServiceImpl.class);
    @Resource(name="lmBatchSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmBatchSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_BATCH_SYNC_TOPIC:LM_UCC_BATCH_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccActivityPoolMapper uccActivityPoolMapper;
    @Autowired
    private UccActivityPoolChangeMapper uccActivityPoolChangeMapper;
    @Autowired
    private UccActivitySpuMapper uccActivitySpuMapper;
    @Autowired
    private UccActivitySpuChangeMapper uccActivitySpuChangeMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private SearchCommodityService searchCommodityService;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccChannelDealMapper uccChannelDealMapper;
    @Autowired
    private UccRelChannelPoolMapper uccRelChannelPoolMapper;
    @Autowired
    private UccCommodityLabelMapper cnncCommodityLabelMapper;
    @Autowired
    private UccRelCommodityLabelPoolMapper cnncRelCommodityLaberPoolMapper;
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private EacQueryApproveTaskListAbilityService eacQueryApproveTaskListAbilityService;
    @Autowired
    private UmcQryCorportionIdsBySbuAbilityService umcQryCorportionIdsBySbuAbilityService;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;
    @Value(value="${syncIgnoreShopId}")
    private String syncIgnoreShopId;
    @Autowired
    private UccOrgSkuWhiteRestrictionMapper uccOrgSkuWhiteRestrictionMapper;
    @Autowired
    private UccMemSkuWhiteRestrictionMapper uccMemSkuWhiteRestrictionMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private CrcCheckTenantCategoryAbilityService crcCheckTenantCategoryAbilityService;
    @Value(value="${HR.sysTenantId}")
    private Long mainSysTenantId;

    @Override
    public SyncSceneCommodityToEsRspBO syncSceneCommodityToEs(SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO) {
        SyncSceneCommodityToEsRspBO rspBO = new SyncSceneCommodityToEsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u6210\u529f!");
        List<String> suplierlist = Arrays.asList(this.syncIgnoreShopId.split("\\|"));
        if (syncSceneCommodityToEsReqBO.getSupplierId() != null && suplierlist.contains(syncSceneCommodityToEsReqBO.getSupplierId().toString()) && syncSceneCommodityToEsReqBO.getSyncType() == 4 && !CollectionUtils.isEmpty((Collection)syncSceneCommodityToEsReqBO.getSkuIds()) && syncSceneCommodityToEsReqBO.getSkuIds().size() == 200) {
            log.info("\u8df3\u8fc7\u6d88\u606f\u5904\u7406\uff1a" + JSONObject.toJSONString((Object)syncSceneCommodityToEsReqBO));
            return rspBO;
        }
        if (syncSceneCommodityToEsReqBO.getSupplierId() == null && syncSceneCommodityToEsReqBO.getRootOrgIdIn() != null) {
            syncSceneCommodityToEsReqBO.setSupplierId(syncSceneCommodityToEsReqBO.getRootOrgIdIn());
        }
        this.validateReqParams(syncSceneCommodityToEsReqBO);
        if (ModelRuleConstant.OPER_ES_ADD_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.syncCommodityToEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_DELETE_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.deleteCommodityInfoFromEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_UPDATE_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.updateCommodityToEs(syncSceneCommodityToEsReqBO);
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b[" + syncSceneCommodityToEsReqBO.getOperType() + "]\u6682\u4e0d\u652f\u6301!");
        }
        return rspBO;
    }

    private void syncCommodityToEs(SyncSceneCommodityToEsReqBO reqBO) {
        List<CommodityForEsBO> commodityForEsBOS;
        Integer count;
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds()) && reqBO.getSupplierId() != null && reqBO.getSupplierId() == 100056L && (count = this.uccSkuMapper.countSkuBySpuId((Long)reqBO.getCommodityIds().get(0))) > 200) {
            Integer amout = count % 200 == 0 ? count / 200 : count / 200 + 1;
            Page page = new Page();
            for (int i = 0; i < amout; ++i) {
                page.setPageNo(i + 1);
                page.setPageSize(200);
                List<Long> skuList = this.uccSkuMapper.pageQryBySpuId((Page<UccSkuPo>)page, (Long)reqBO.getCommodityIds().get(0));
                if (CollectionUtils.isEmpty(skuList)) continue;
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(skuList);
                syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierId());
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmBatchSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                    throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                }
            }
            if (reqBO.getCommodityIds().size() == 1) {
                return;
            }
            reqBO.getCommodityIds().remove(reqBO.getCommodityIds().get(0));
        }
        if ((commodityForEsBOS = this.qryCommodityList(reqBO)) == null || commodityForEsBOS.isEmpty()) {
            LOGGER.error("ES \u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a \u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f->{}" + JSONObject.toJSONString((Object)reqBO));
            return;
        }
        List<Long> commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
        ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
        this.assemblyEsSkuInfo(reqBO, commodityIds, esStorageSpuInfoBOS);
        if (CollectionUtils.isEmpty(commodityIds)) {
            return;
        }
        this.assemblyEsCommodityAndCategoryInfo(reqBO, commodityIds, esStorageSpuInfoBOS, commodityForEsBOS);
        this.syncSkuPoolToES(reqBO, commodityIds, esStorageSpuInfoBOS);
        this.dealChannel(esStorageSpuInfoBOS);
        this.dealLable(esStorageSpuInfoBOS);
        this.applrovalCommodityToEs(esStorageSpuInfoBOS);
        this.syncCommodityInfoToEs(esStorageSpuInfoBOS);
    }

    private void deleteCommodityInfoFromEs(SyncSceneCommodityToEsReqBO reqBO) {
        this.deleteSpuInfoFromEs(reqBO);
    }

    private void updateCommodityToEs(SyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getSingleType() == 0) {
            List<CommodityForEsBO> commodityForEsBOS;
            if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType()) && !CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
                Integer count;
                UccSkuPo skuPo = new UccSkuPo();
                skuPo.setCommodityId((Long)reqBO.getCommodityIds().get(0));
                List<UccSkuPo> skuPoList = this.uccSkuMapper.qerySku(skuPo);
                if (!CollectionUtils.isEmpty(skuPoList) && (count = this.uccSkuMapper.countSkuBySpuId((Long)reqBO.getCommodityIds().get(0))) > 200) {
                    Integer amout = count % 200 == 0 ? count / 200 : count / 200 + 1;
                    Page page = new Page();
                    for (int i = 0; i < amout; ++i) {
                        page.setPageNo(i + 1);
                        page.setPageSize(200);
                        List<Long> skuList = this.uccSkuMapper.pageQryBySpuId((Page<UccSkuPo>)page, (Long)reqBO.getCommodityIds().get(0));
                        if (CollectionUtils.isEmpty((Collection)skuList)) continue;
                        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                        syncSceneCommodityToEsReqBO.setSkuIds((List)skuList);
                        syncSceneCommodityToEsReqBO.setSupplierId(skuPoList.get(0).getSupplierShopId());
                        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                        try {
                            this.lmBatchSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                            throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                        }
                    }
                    if (reqBO.getCommodityIds().size() == 1) {
                        return;
                    }
                    reqBO.getCommodityIds().remove(reqBO.getCommodityIds().get(0));
                }
            }
            if ((commodityForEsBOS = this.qryCommodityList(reqBO)) == null || commodityForEsBOS.isEmpty()) {
                LOGGER.error("\u66f4\u65b0ES\u4e0b\u7684\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u573a\u666f[" + reqBO.getSceneId() + "]\u4e0b\u5173\u8054\u7684\u5546\u54c1\u6570\u636e!");
                return;
            }
            List<Long> commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
            SearchEsReqBO searchEsReqBO = new SearchEsReqBO();
            searchEsReqBO.setCommdIds(commodityIds);
            searchEsReqBO.setSceneId(reqBO.getSceneId());
            searchEsReqBO.setPageNo(1);
            searchEsReqBO.setPageSize(50000);
            SearchEsRspBo searchEsRspBo = this.searchCommodityService.queryByMatch(searchEsReqBO);
            List<Long> esExistCommodityIds = null;
            if (searchEsRspBo != null && searchEsRspBo.getCommodityRspBos() != null && !searchEsRspBo.getCommodityRspBos().isEmpty()) {
                List<CommodityRspBo> commodityRspBos = searchEsRspBo.getCommodityRspBos();
                esExistCommodityIds = commodityRspBos.stream().map(CommodityRspBo::getCommodity_id).collect(Collectors.toList());
            }
            if (esExistCommodityIds == null || esExistCommodityIds.isEmpty()) {
                reqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                reqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                reqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                this.syncCommodityToEs(reqBO);
                return;
            }
            ArrayList<CommodityForEsBO> newCommodityForEsBOS = new ArrayList<CommodityForEsBO>();
            for (CommodityForEsBO commodityForEsBO : commodityForEsBOS) {
                if (!esExistCommodityIds.contains(commodityForEsBO.getCommodityId())) continue;
                newCommodityForEsBOS.add(commodityForEsBO);
            }
            ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
            this.assemblyEsSkuInfo(reqBO, esExistCommodityIds, esStorageSpuInfoBOS);
            if (CollectionUtils.isEmpty(esExistCommodityIds)) {
                return;
            }
            this.assemblyEsCommodityAndCategoryInfo(reqBO, esExistCommodityIds, esStorageSpuInfoBOS, newCommodityForEsBOS);
            this.syncSkuPoolToES(reqBO, commodityIds, esStorageSpuInfoBOS);
            this.dealChannel(esStorageSpuInfoBOS);
            this.applrovalCommodityToEs(esStorageSpuInfoBOS);
            this.syncCommodityInfoToEs(esStorageSpuInfoBOS);
        } else {
            this.searchSku(reqBO);
            if (reqBO.getSingleType() != 1) {
                if (reqBO.getSingleType() == 2) {
                    JSONObject qryobject = new JSONObject();
                    JSONObject qryBoolobject = new JSONObject();
                    JSONObject qryMustobject = new JSONObject();
                    JSONObject qrySkuobject = new JSONObject();
                    JSONObject qrytemrsobject = new JSONObject();
                    qrySkuobject.put("sku_id", (Object)reqBO.getSkuIds());
                    qrytemrsobject.put("terms", (Object)qrySkuobject);
                    qryMustobject.put("must", (Object)qrytemrsobject);
                    qryBoolobject.put("bool", (Object)qryMustobject);
                    qryobject.put("query", (Object)qryBoolobject);
                    String qryRsp = this.elasticsearchUtil.doPostSendQuery(this.esConfig.getIndexName(), this.esConfig.getEsType(), qryobject.toJSONString());
                    if (!StringUtils.isEmpty((CharSequence)qryRsp)) {
                        JSONObject objRsp = JSONObject.parseObject((String)qryRsp);
                        HashSet singleSku = new HashSet(reqBO.getSkuIds());
                        if (objRsp.getJSONObject("hits").getJSONObject("total").getInteger("value").intValue() != singleSku.size()) {
                            reqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                            reqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                            reqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                            this.syncCommodityToEs(reqBO);
                            return;
                        }
                    } else {
                        reqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                        reqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                        reqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                        this.syncCommodityToEs(reqBO);
                        return;
                    }
                    List<UccSkuPo> poList = this.uccSkuMapper.queryBatchSkusLessCloum(reqBO.getSkuIds(), reqBO.getSupplierId());
                    ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
                    EsStorageSpuInfoBO bo = null;
                    ArrayList<Long> commds = new ArrayList<Long>();
                    for (UccSkuPo each : poList) {
                        bo = new EsStorageSpuInfoBO();
                        bo.setSku_id(each.getSkuId());
                        bo.setSku_status(each.getSkuStatus());
                        bo.setCommodity_id(each.getCommodityId());
                        bo.setCreate_time(each.getCreateTime().getTime());
                        bo.setSku_approval_status(each.getApprovalStatus());
                        commds.add(each.getCommodityId());
                        esStorageSpuInfoBOS.add(bo);
                    }
                    List<UccCommodityPo> commodityPoList = this.uccCommodityMapper.queryByCommodityIdLists(commds);
                    if (!CollectionUtils.isEmpty(commodityPoList)) {
                        Map<Long, List<UccCommodityPo>> mapSpu = commodityPoList.stream().collect(Collectors.groupingBy(UccCommodityPo::getCommodityId));
                        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
                            if (!mapSpu.containsKey(esStorageSpuInfoBO.getCommodity_id())) continue;
                            esStorageSpuInfoBO.setCommodity_status(mapSpu.get(esStorageSpuInfoBO.getCommodity_id()).get(0).getCommodityStatus());
                            esStorageSpuInfoBO.setSpu_approval_status(mapSpu.get(esStorageSpuInfoBO.getCommodity_id()).get(0).getApprovalStatus());
                        }
                    }
                    this.applrovalCommodityToEs(esStorageSpuInfoBOS);
                    if (!CollectionUtils.isEmpty(poList)) {
                        for (EsStorageSpuInfoBO each : esStorageSpuInfoBOS) {
                            JSONObject object = new JSONObject();
                            object.put("sku_status", (Object)each.getSku_status());
                            object.put("audit_time", (Object)each.getAudit_time());
                            object.put("on_shelve_time", (Object)each.getOn_shelve_time());
                            object.put("operIds", each.getOperIds());
                            object.put("tache_code", (Object)each.getTache_code());
                            object.put("create_time", (Object)each.getCreate_time());
                            object.put("sku_approval_status", (Object)each.getSku_approval_status());
                            object.put("spu_approval_status", (Object)each.getSpu_approval_status());
                            object.put("commodity_status", (Object)each.getCommodity_status());
                            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), reqBO.getSceneId() == null ? each.getSku_id().toString() : reqBO.getSceneId() + "" + each.getSku_id(), object);
                        }
                    }
                } else if (reqBO.getSingleType() == 3) {
                    List<UccSkuPricePo> pricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBO.getSkuIds(), reqBO.getSupplierId());
                    List<UccLadderPricePO> ladderPricePOS = this.uccLadderPriceMapper.selectBySkuIds(reqBO.getSkuIds(), reqBO.getSupplierId());
                    Map<Object, Object> skuLadderMap = new HashMap();
                    if (CollectionUtils.isEmpty(ladderPricePOS)) {
                        skuLadderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
                    }
                    if (!CollectionUtils.isEmpty(pricePos)) {
                        for (UccSkuPricePo each : pricePos) {
                            JSONObject object = new JSONObject();
                            object.put("sale_price", (Object)each.getSalePrice());
                            object.put("agreement_price", (Object)each.getAgreementPrice());
                            object.put("market_price", (Object)each.getMarketPrice());
                            object.put("member_price1", (Object)each.getMemberPrice1());
                            object.put("member_price2", (Object)each.getMemberPrice2());
                            object.put("member_price3", (Object)each.getMemberPrice3());
                            object.put("member_price4", (Object)each.getMemberPrice4());
                            object.put("member_price5", (Object)each.getMemberPrice5());
                            object.put("discounts", (Object)(each.getSalePrice() / each.getAgreementPrice()));
                            if (skuLadderMap.containsKey(each.getSkuId())) {
                                List ladderPrice = ((List)skuLadderMap.get(each.getSkuId())).stream().map(UccLadderPricePO::getPrice).collect(Collectors.toList());
                                object.put("ladderPrice", ladderPrice);
                            }
                            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), reqBO.getSceneId() == null ? each.getSkuId().toString() : reqBO.getSceneId() + "" + each.getSkuId(), object);
                        }
                    }
                } else {
                    LOGGER.error("\u672a\u77e5\u540c\u6b65\u7c7b\u578b");
                }
            }
        }
    }

    private List<CommodityForEsBO> qryCommodityList(SyncSceneCommodityToEsReqBO reqBO) {
        List<Long> commodityTypeIds;
        List<CommodityForEsBO> commodityForEsBOS = new ArrayList<CommodityForEsBO>();
        List<CommodityForEsPO> forEsPOList = null;
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType())) {
            commodityTypeIds = this.uccCommodityTypeMapper.qryCommodityTypeIdsByCategorys(reqBO.getCategoryIds());
            if (commodityTypeIds == null || commodityTypeIds.isEmpty()) {
                throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u7c7b\u76ee\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u6570\u636e!");
            }
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBO.getRootOrgIdIn(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID.equals(reqBO.getSyncType())) {
            commodityTypeIds = this.uccCatRCommdTypeMapper.queryTypeByGuideCatalogIds(reqBO.getGuiCategoryIds());
            if (commodityTypeIds == null || commodityTypeIds.isEmpty()) {
                throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u7c7b\u76ee\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u6570\u636e!");
            }
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBO.getSupplierId(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType())) {
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, reqBO.getCommodityIds(), reqBO.getSupplierId(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_SKU_ID.equals(reqBO.getSyncType())) {
            List<UccSkuPo> skuPoList = this.uccSkuMapper.queryBatchSkusLessCloum(reqBO.getSkuIds(), reqBO.getSupplierId());
            if (CollectionUtils.isEmpty(skuPoList)) {
                return commodityForEsBOS;
            }
            ArrayList<Long> commodityIds = new ArrayList<Long>();
            for (UccSkuPo uccSkuPo : skuPoList) {
                if (commodityIds.contains(uccSkuPo.getCommodityId())) continue;
                commodityIds.add(uccSkuPo.getCommodityId());
            }
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, commodityIds, reqBO.getSupplierId(), reqBO.getSceneId());
        }
        if (!CollectionUtils.isEmpty(forEsPOList)) {
            commodityForEsBOS = JSONObject.parseArray((String)JSONObject.toJSONString(forEsPOList), CommodityForEsBO.class);
        }
        if (!CollectionUtils.isEmpty(commodityForEsBOS)) {
            ArrayList mergeSameB0s = new ArrayList();
            HashedMap mergeSameMap = new HashedMap();
            for (CommodityForEsBO commodityForEsBO : commodityForEsBOS) {
                CommodityForEsBO bo;
                if (commodityForEsBO.getGuideCataLogId() == null) {
                    bo = new CommodityForEsBO();
                    BeanUtils.copyProperties((Object)commodityForEsBO, (Object)bo);
                    mergeSameMap.put(commodityForEsBO.getCommodityId(), bo);
                    continue;
                }
                if (mergeSameMap.containsKey(commodityForEsBO.getCommodityId())) {
                    ((CommodityForEsBO)mergeSameMap.get(commodityForEsBO.getCommodityId())).getGuideCataLogIds().add(commodityForEsBO.getGuideCataLogId());
                    continue;
                }
                bo = new CommodityForEsBO();
                BeanUtils.copyProperties((Object)commodityForEsBO, (Object)bo);
                bo.setGuideCataLogIds(new ArrayList<Long>(Arrays.asList(commodityForEsBO.getGuideCataLogId())));
                mergeSameMap.put(commodityForEsBO.getCommodityId(), bo);
            }
            commodityForEsBOS = new ArrayList();
            for (Map.Entry entry : mergeSameMap.entrySet()) {
                commodityForEsBOS.add((CommodityForEsBO)entry.getValue());
            }
            commodityForEsBOS.addAll(mergeSameB0s);
        }
        return commodityForEsBOS;
    }

    private void assemblyEsSkuInfo(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        List<UccMemSkuWhiteRestrictionPo> personWhhite;
        List whiteList;
        Map<Long, List<Serializable>> agrWhitepo;
        List<UccLadderPricePO> ladderPricePOS;
        List<UccMallBrandRelPO> mallBrandRelList;
        List skuForEsBOS = null;
        List<Object> skuForEsPOList = new ArrayList();
        skuForEsPOList = reqBO.getSyncType() == 4 && !CollectionUtils.isEmpty((Collection)reqBO.getSkuIds()) ? this.uccSkuMapper.qrySkuAndLowPriceList(reqBO.getSupplierId(), commodityIds, reqBO.getSkuIds()) : this.uccSkuMapper.qrySkuAndLowPriceList(reqBO.getSupplierId(), commodityIds, null);
        List<SkuForEsPO> notNeedSku = skuForEsPOList.stream().filter(e -> e.getSkuStatus() == 6 || e.getSkuStatus() == 0 && e.getSkuSource() == 2).collect(Collectors.toList());
        skuForEsPOList.removeIf(e -> e.getSkuStatus() == 6 || e.getSkuStatus() == 0 && e.getSkuSource() == 2);
        this.sendDeleteMq(notNeedSku);
        if (CollectionUtils.isEmpty(skuForEsPOList)) {
            commodityIds = new ArrayList<Long>();
            log.info(" ES \u540c\u6b65\u5168\u91cf\u5546\u54c1\u8d70\u5220\u9664");
            return;
        }
        skuForEsBOS = JSONObject.parseArray((String)JSONObject.toJSONString(skuForEsPOList), SkuForEsBO.class);
        skuForEsBOS.forEach(sku -> {
            sku.setOriginBrandId(sku.getBrandId());
            sku.setOriginBrandName(sku.getBrandName());
            if (sku.getDiscount() != null && sku.getSignDiscount() != null) {
                sku.setDiscountDifference(sku.getDiscount().subtract(sku.getSignDiscount()));
                if (sku.getTolerance() != null) {
                    if (sku.getDiscountDifference().subtract(sku.getTolerance()).doubleValue() > 0.0) {
                        sku.setIsOverTolerance(2);
                    } else {
                        sku.setIsOverTolerance(1);
                    }
                }
            }
            UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(sku.getCommodityTypeId());
            List<EmdmCatalogLevelPO> emdmCatalogLevelPOS = this.uccEMdmCatalogMapper.queryAllUpperCatalog(uccCommodityTypePo.getCatalogId());
            log.info("emdmCatalogLevelPOS:{}", (Object)JSONObject.toJSONString(emdmCatalogLevelPOS));
            for (EmdmCatalogLevelPO emdmCatalogLevelPO : emdmCatalogLevelPOS) {
                log.info("emdmCatalogLevelPO:{}", (Object)JSONObject.toJSONString((Object)emdmCatalogLevelPO));
                if (emdmCatalogLevelPO.getLevel() == 1) {
                    sku.setCatalogId1(emdmCatalogLevelPO.getCatalogId());
                    sku.setCatalogName1(emdmCatalogLevelPO.getCatalogName());
                    continue;
                }
                if (emdmCatalogLevelPO.getLevel() == 2) {
                    sku.setCatalogId2(emdmCatalogLevelPO.getCatalogId());
                    sku.setCatalogName2(emdmCatalogLevelPO.getCatalogName());
                    continue;
                }
                if (emdmCatalogLevelPO.getLevel() == 3) {
                    sku.setCatalogId3(emdmCatalogLevelPO.getCatalogId());
                    sku.setCatalogName3(emdmCatalogLevelPO.getCatalogName());
                    continue;
                }
                if (emdmCatalogLevelPO.getLevel() != 4) continue;
                sku.setCatalogId4(emdmCatalogLevelPO.getCatalogId());
                sku.setCatalogName4(emdmCatalogLevelPO.getCatalogName());
            }
            if (sku.getAgreementPrice().equals(sku.getSalePrice())) {
                sku.setIncreasePriceType(2);
            } else {
                sku.setIncreasePriceType(1);
            }
        });
        List<Long> brandList = skuForEsBOS.stream().filter(a -> a.getBrandId() != null).map(SkuForEsBO::getBrandId).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(brandList) && !CollectionUtils.isEmpty(mallBrandRelList = this.uccMallBrandRelMapper.getRelByBrandList(brandList))) {
            block0: for (SkuForEsBO sku2 : skuForEsBOS) {
                for (UccMallBrandRelPO uccMallBrandRelPO : mallBrandRelList) {
                    if (sku2.getBrandId() == null || !sku2.getBrandId().equals(uccMallBrandRelPO.getBrandId())) continue;
                    sku2.setBrandId(uccMallBrandRelPO.getMallBrandId());
                    sku2.setBrandName(uccMallBrandRelPO.getMallBrandName());
                    continue block0;
                }
            }
        }
        List<Long> skuIds = skuForEsBOS.stream().map(SkuForEsBO::getSkuId).collect(Collectors.toList());
        UccActivitySpuPO uccActivitySpuPO = new UccActivitySpuPO();
        uccActivitySpuPO.setSourceIds(skuIds);
        uccActivitySpuPO.setSourceType(2);
        List<UccActivitySpuPO> uccActivitySpuPOS = this.uccActivitySpuMapper.getList(uccActivitySpuPO);
        if (!CollectionUtils.isEmpty(uccActivitySpuPOS)) {
            Map<Long, List<UccActivitySpuPO>> collect = uccActivitySpuPOS.stream().collect(Collectors.groupingBy(UccActivitySpuPO::getSourceId));
            for (SkuForEsBO each : skuForEsBOS) {
                List<UccActivitySpuPO> eachList = collect.get(each.getSkuId());
                if (CollectionUtils.isEmpty(eachList)) continue;
                List<Long> activityIds = eachList.stream().map(UccActivitySpuPO::getActivityId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(each.getActivitityIds())) {
                    each.setActivitityIds(activityIds);
                    continue;
                }
                each.getActivitityIds().addAll(activityIds);
            }
        }
        UccActivitySpuChangePO uccActivitySpuChangePO = new UccActivitySpuChangePO();
        uccActivitySpuChangePO.setSourceIds(skuIds);
        uccActivitySpuChangePO.setSourceType(2);
        List<UccActivitySpuChangePO> list = this.uccActivitySpuChangeMapper.getList(uccActivitySpuChangePO);
        if (!CollectionUtils.isEmpty(list)) {
            Map<Long, List<UccActivitySpuChangePO>> collect = list.stream().collect(Collectors.groupingBy(UccActivitySpuChangePO::getSourceId));
            for (SkuForEsBO each : skuForEsBOS) {
                List<UccActivitySpuChangePO> eachList = collect.get(each.getSkuId());
                if (CollectionUtils.isEmpty(eachList)) continue;
                List<Long> ids = eachList.stream().map(UccActivitySpuChangePO::getId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(each.getActivitityChangeIds())) {
                    each.setActivitityChangeIds(ids);
                    continue;
                }
                each.getActivitityChangeIds().addAll(ids);
            }
        }
        List ladderEsBo = skuForEsBOS.stream().filter(a -> a.getSwitchOn() == 1).collect(Collectors.toList());
        List laderSku = null;
        if (!CollectionUtils.isEmpty(ladderEsBo)) {
            laderSku = ladderEsBo.stream().map(SkuForEsBO::getSkuId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(laderSku) && !CollectionUtils.isEmpty(ladderPricePOS = this.uccLadderPriceMapper.selectBySkuIds(reqBO.getSkuIds(), reqBO.getSupplierId()))) {
            Map<Long, List<UccLadderPricePO>> skuLadderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
            skuForEsBOS.forEach(sku -> {
                if (skuLadderMap.containsKey(sku.getSkuId())) {
                    sku.setLadderPrice(((List)skuLadderMap.get(sku.getSkuId())).stream().map(UccLadderPricePO::getPrice).collect(Collectors.toList()));
                }
            });
        }
        HashMap<Long, Long> skuStockPoMap = new HashMap();
        List<UccSaleNumPo> saleNumPos = this.uccSaleNumMapper.qryBySkuIds(skuIds);
        Map<Long, UccSaleNumPo> saleNumPoMap = saleNumPos.stream().collect(Collectors.toMap(UccSaleNumPo::getSkuId, uccSaleNumPo -> uccSaleNumPo));
        List<UccSkuPicPo> skuPicPos = this.uccSkuPicMapper.qeurySkuPicBySkuId(skuIds, 1);
        Map<Long, UccSkuPicPo> skuPicPoMap = skuPicPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, Function.identity(), (v1, v2) -> v1));
        if (!CollectionUtils.isEmpty(skuIds = this.uccSkuMapper.checkInventoryManagement(skuIds, reqBO.getSupplierId()))) {
            SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
            smcsdkQryStockNumReqBO.setSkuIds(skuIds);
            SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
            if ("0000".equals(smcsdkQryStockNumRspBO.getRespCode()) && smcsdkQryStockNumRspBO.getSkuStockNumMap() != null && !smcsdkQryStockNumRspBO.getSkuStockNumMap().isEmpty()) {
                skuStockPoMap = smcsdkQryStockNumRspBO.getSkuStockNumMap();
            }
        }
        HashMap<Long, List<Long>> agrWhite = new HashMap<Long, List<Long>>();
        HashMap<Long, List<Long>> personWhite = new HashMap<Long, List<Long>>();
        HashMap<Long, List<Long>> orgWhite = new HashMap<Long, List<Long>>();
        List<Long> agrId = skuForEsBOS.stream().map(SkuForEsBO::getAgreementId).collect(Collectors.toList());
        List<UccOrgSkuWhiteRestrictionPo> uccOrgSkuWhiteRestrictionPos = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgrDistinct(agrId, 1);
        if (!CollectionUtils.isEmpty(uccOrgSkuWhiteRestrictionPos)) {
            List whiteRestrictionPos;
            List restrictionPoList = uccOrgSkuWhiteRestrictionPos.stream().filter(e -> !Objects.equals(e.getIsWhilteListDown(), 4)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(restrictionPoList)) {
                agrWhitepo = restrictionPoList.stream().collect(Collectors.groupingBy(UccOrgSkuWhiteRestrictionPo::getAgreementId));
                for (Long agr : agrWhitepo.keySet()) {
                    whiteList = agrWhitepo.get(agr).stream().map(UccOrgSkuWhiteRestrictionPo::getOrgId).collect(Collectors.toList());
                    HashSet singleWhiteList = new HashSet();
                    singleWhiteList.addAll(whiteList);
                    whiteList = singleWhiteList.stream().collect(Collectors.toList());
                    if (((UccOrgSkuWhiteRestrictionPo)agrWhitepo.get(agr).get(0)).getIsWhilteListDown() != null && ((UccOrgSkuWhiteRestrictionPo)agrWhitepo.get(agr).get(0)).getIsWhilteListDown() == 1 && !CollectionUtils.isEmpty(whiteList)) {
                        ArrayList secondWhiteList = new ArrayList();
                        for (Long orgId : whiteList) {
                            UmcQryCorportionIdsBySbuAbilityReqBO umcReqBO = new UmcQryCorportionIdsBySbuAbilityReqBO();
                            umcReqBO.setOrgId(orgId);
                            log.info("\u67e5\u8be2\u4f1a\u5458\u4e8c\u7ea7\u5355\u4f4d\u53ca\u5176\u5b50\u673a\u6784\u7684\u6cd5\u4eba\u5355\u4f4d\u5165\u53c2umcReqBO:{}", (Object)JSON.toJSONString((Object)umcReqBO));
                            UmcQryCorportionIdsBySbuAbilityRspBO umcRspBO = this.umcQryCorportionIdsBySbuAbilityService.qryCorportionIdsBySbu(umcReqBO);
                            log.info("\u67e5\u8be2\u4f1a\u5458\u4e8c\u7ea7\u5355\u4f4d\u53ca\u5176\u5b50\u673a\u6784\u7684\u6cd5\u4eba\u5355\u4f4d\u51fa\u53c2umcRspBO:{}", (Object)JSON.toJSONString((Object)umcRspBO));
                            if (CollectionUtils.isEmpty((Collection)umcRspBO.getCorporationIds())) continue;
                            secondWhiteList.addAll(umcRspBO.getCorporationIds());
                        }
                        whiteList = secondWhiteList;
                    }
                    agrWhite.put(agr, whiteList);
                }
            }
            if (!CollectionUtils.isEmpty(whiteRestrictionPos = uccOrgSkuWhiteRestrictionPos.stream().filter(e -> Objects.equals(e.getIsWhilteListDown(), 4)).collect(Collectors.toList()))) {
                Map<Long, List<UccOrgSkuWhiteRestrictionPo>> agrWhitepo2 = whiteRestrictionPos.stream().collect(Collectors.groupingBy(UccOrgSkuWhiteRestrictionPo::getAgreementId));
                for (Long agr : agrWhitepo2.keySet()) {
                    List whiteList2 = agrWhitepo2.get(agr).stream().map(UccOrgSkuWhiteRestrictionPo::getOrgId).collect(Collectors.toList());
                    orgWhite.put(agr, whiteList2);
                }
            }
        }
        if (!CollectionUtils.isEmpty(personWhhite = this.uccMemSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(agrId, 1))) {
            agrWhitepo = personWhhite.stream().collect(Collectors.groupingBy(UccMemSkuWhiteRestrictionPo::getAgreementId));
            for (Long agr : agrWhitepo.keySet()) {
                whiteList = agrWhitepo.get(agr).stream().map(UccMemSkuWhiteRestrictionPo::getMemId).collect(Collectors.toList());
                personWhite.put(agr, whiteList);
            }
        }
        this.buildEsSku(esStorageSpuInfoBOS, skuForEsBOS, skuStockPoMap, saleNumPoMap, skuPicPoMap, agrWhite, personWhite, orgWhite);
    }

    private void buildEsSku(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS, List<SkuForEsBO> skuForEsBOS, Map<Long, Long> skuStockPoMap, Map<Long, UccSaleNumPo> saleNumPoMap, Map<Long, UccSkuPicPo> skuPicPoMap, Map<Long, List<Long>> agrWhite, Map<Long, List<Long>> personWhite, Map<Long, List<Long>> orgWhite) {
        for (SkuForEsBO skuForEsBO : skuForEsBOS) {
            UccSaleNumPo uccSaleNumPo;
            Long stockNum;
            EsStorageSpuInfoBO esStorageSpuInfoBO = new EsStorageSpuInfoBO();
            esStorageSpuInfoBO.setCurrency(skuForEsBO.getCurrency());
            esStorageSpuInfoBO.setDiscount(skuForEsBO.getDiscount());
            esStorageSpuInfoBO.setSign_discount(skuForEsBO.getSignDiscount());
            esStorageSpuInfoBO.setDiscount_difference(skuForEsBO.getDiscountDifference());
            esStorageSpuInfoBO.setTolerance(skuForEsBO.getTolerance());
            if (skuForEsBO.getDiscountDifference() != null && skuForEsBO.getTolerance() != null) {
                esStorageSpuInfoBO.setOver_tolerance_difference(skuForEsBO.getDiscountDifference().subtract(skuForEsBO.getTolerance()));
            }
            esStorageSpuInfoBO.setIs_over_discount(skuForEsBO.getIsOverDiscount());
            esStorageSpuInfoBO.setIs_over_tolerance(skuForEsBO.getIsOverTolerance());
            esStorageSpuInfoBO.setLimit_order(skuForEsBO.getLimitOrder());
            esStorageSpuInfoBO.setAttachment_url(skuForEsBO.getAttachmentUrl());
            esStorageSpuInfoBO.setAttachment_name(skuForEsBO.getAttachmentName());
            esStorageSpuInfoBO.setReason(skuForEsBO.getReason());
            if (skuForEsBO.getPriceUpdateTime() != null) {
                esStorageSpuInfoBO.setPrice_update_time(skuForEsBO.getPriceUpdateTime().getTime());
            }
            esStorageSpuInfoBO.setHr_agreement_type(skuForEsBO.getHrAgreementType());
            esStorageSpuInfoBO.setAgreement_sign_supplier(skuForEsBO.getAgreementSignSupplier());
            esStorageSpuInfoBO.setBatch_create(skuForEsBO.getBatchCreate());
            esStorageSpuInfoBO.setActivitity_ids(skuForEsBO.getActivitityIds());
            esStorageSpuInfoBO.setActivitity_change_ids(skuForEsBO.getActivitityChangeIds());
            esStorageSpuInfoBO.setSourceAssort(skuForEsBO.getSourceAssort());
            esStorageSpuInfoBO.setSys_code(skuForEsBO.getSysCode());
            esStorageSpuInfoBO.setEnt_agreement_code(skuForEsBO.getEntAgreementCode());
            esStorageSpuInfoBO.setSerial_no(skuForEsBO.getSerialNo());
            esStorageSpuInfoBO.setCommodityExpand4(skuForEsBO.getCommodityExpand4());
            esStorageSpuInfoBO.setCommodityExpand8(skuForEsBO.getCommodityExpand8());
            esStorageSpuInfoBO.setCommodityExpand9(skuForEsBO.getCommodityExpand9());
            esStorageSpuInfoBO.setSkuExpand8(skuForEsBO.getSkuExpand8());
            esStorageSpuInfoBO.setSkuExpand9(skuForEsBO.getSkuExpand9());
            esStorageSpuInfoBO.setCommodity_id(skuForEsBO.getCommodityId());
            esStorageSpuInfoBO.setSku_id(skuForEsBO.getSkuId());
            esStorageSpuInfoBO.setSku_name(skuForEsBO.getSkuName());
            esStorageSpuInfoBO.setSearch_name(skuForEsBO.getSkuName());
            esStorageSpuInfoBO.setExt_sku_id(skuForEsBO.getExtSkuId());
            esStorageSpuInfoBO.setSell(skuForEsBO.getSell());
            esStorageSpuInfoBO.setBrand_id(skuForEsBO.getBrandId());
            esStorageSpuInfoBO.setBrand_name(skuForEsBO.getBrandName());
            esStorageSpuInfoBO.setSku_status(skuForEsBO.getSkuStatus());
            esStorageSpuInfoBO.setSku_source(skuForEsBO.getSkuSource());
            esStorageSpuInfoBO.setMfgsku(skuForEsBO.getMfgsku());
            esStorageSpuInfoBO.setUpc(skuForEsBO.getUpcCode());
            esStorageSpuInfoBO.setType_id(skuForEsBO.getCommodityTypeId());
            esStorageSpuInfoBO.setType_name(skuForEsBO.getCommodityTypeName());
            if (skuForEsBO.getOnShelveTime() != null) {
                esStorageSpuInfoBO.setOn_shelve_time(DateUtils.strToDateLong((String)skuForEsBO.getOnShelveTime()).getTime());
            }
            esStorageSpuInfoBO.setAgreement_id(skuForEsBO.getAgreementId());
            esStorageSpuInfoBO.setAgreement_details_id(skuForEsBO.getAgreementDetailsId());
            esStorageSpuInfoBO.setSale_price(skuForEsBO.getSalePrice() == null ? 0.0 : (double)skuForEsBO.getSalePrice().longValue());
            esStorageSpuInfoBO.setAgreement_price(skuForEsBO.getAgreementPrice() == null ? 0.0 : (double)skuForEsBO.getAgreementPrice().longValue());
            esStorageSpuInfoBO.setMarket_price(skuForEsBO.getMarketPrice() == null ? 0.0 : (double)skuForEsBO.getMarketPrice().longValue());
            if (skuForEsBO.getMemberPrice1() != null) {
                esStorageSpuInfoBO.setMember_price1(skuForEsBO.getMemberPrice1() == null ? 0.0 : (double)skuForEsBO.getMemberPrice1().longValue());
            }
            if (skuForEsBO.getMemberPrice2() != null) {
                esStorageSpuInfoBO.setMember_price2(skuForEsBO.getMemberPrice2() == null ? 0.0 : (double)skuForEsBO.getMemberPrice2().longValue());
            }
            esStorageSpuInfoBO.setMember_price3(skuForEsBO.getMemberPrice3() == null ? 0.0 : (double)skuForEsBO.getMemberPrice3().longValue());
            esStorageSpuInfoBO.setMember_price4(skuForEsBO.getMemberPrice4() == null ? 0.0 : (double)skuForEsBO.getMemberPrice4().longValue());
            esStorageSpuInfoBO.setMember_price5(skuForEsBO.getMemberPrice5() == null ? 0.0 : (double)skuForEsBO.getMemberPrice5().longValue());
            esStorageSpuInfoBO.setSupplier_id(skuForEsBO.getSupplierId());
            esStorageSpuInfoBO.setSupplier_shop_id(skuForEsBO.getSupplierShopId());
            esStorageSpuInfoBO.setShop_name(skuForEsBO.getShopName());
            esStorageSpuInfoBO.setSupplier_name(skuForEsBO.getSupplierName());
            String discount = "0";
            if (skuForEsBO.getSalePrice() != null && skuForEsBO.getMarketPrice() != null && skuForEsBO.getMarketPrice() != 0L) {
                discount = String.format("%.2f", (double)skuForEsBO.getSalePrice().longValue() / (double)skuForEsBO.getMarketPrice().longValue());
            }
            esStorageSpuInfoBO.setDiscounts(Double.valueOf(discount));
            esStorageSpuInfoBO.setComment_number(null);
            if (skuStockPoMap.size() > 0 && (stockNum = skuStockPoMap.get(skuForEsBO.getSkuId())) != null) {
                esStorageSpuInfoBO.setComment_number(stockNum);
            }
            esStorageSpuInfoBO.setSold_number(null);
            esStorageSpuInfoBO.setEcommerce_sale(null);
            if (saleNumPoMap.size() > 0 && (uccSaleNumPo = saleNumPoMap.get(skuForEsBO.getSkuId())) != null) {
                if (uccSaleNumPo.getSoldNumber() != null) {
                    esStorageSpuInfoBO.setSold_number(uccSaleNumPo.getSoldNumber().longValue());
                }
                if (uccSaleNumPo.getEcommerceSale() != null) {
                    esStorageSpuInfoBO.setEcommerce_sale(uccSaleNumPo.getEcommerceSale().longValue());
                }
            }
            if (skuPicPoMap.size() > 0) {
                UccSkuPicPo uccSkuPicPo = skuPicPoMap.get(skuForEsBO.getSkuId());
                if (uccSkuPicPo != null) {
                    esStorageSpuInfoBO.setPicture_url(uccSkuPicPo.getSkuPicUrl());
                } else {
                    esStorageSpuInfoBO.setPicture_url(null);
                }
            } else {
                esStorageSpuInfoBO.setPicture_url(null);
            }
            if (!agrWhite.isEmpty()) {
                if (agrWhite.containsKey(skuForEsBO.getAgreementId())) {
                    esStorageSpuInfoBO.setWhitelist(agrWhite.get(skuForEsBO.getAgreementId()));
                } else {
                    esStorageSpuInfoBO.setWhitelist(null);
                }
            }
            if (!personWhite.isEmpty()) {
                if (personWhite.containsKey(skuForEsBO.getAgreementId())) {
                    esStorageSpuInfoBO.setPersonWhite(personWhite.get(skuForEsBO.getAgreementId()));
                } else {
                    esStorageSpuInfoBO.setPersonWhite(null);
                }
            }
            if (!orgWhite.isEmpty()) {
                if (orgWhite.containsKey(skuForEsBO.getAgreementId())) {
                    esStorageSpuInfoBO.setOrgWhite(orgWhite.get(skuForEsBO.getAgreementId()));
                    if (agrWhite.isEmpty()) {
                        esStorageSpuInfoBO.setWhitelist(Arrays.asList(2L));
                    }
                } else {
                    esStorageSpuInfoBO.setOrgWhite(null);
                }
            }
            esStorageSpuInfoBO.setChannel_id(null);
            esStorageSpuInfoBO.setBrand_id_name(null);
            esStorageSpuInfoBO.setDescription(null);
            esStorageSpuInfoBO.setSupplier_id_name(null);
            esStorageSpuInfoBO.setProperties(null);
            esStorageSpuInfoBO.setL4mg_category_id(skuForEsBO.getMgCatalogId());
            esStorageSpuInfoBO.setL4mg_category_name(skuForEsBO.getMgCatalogName());
            esStorageSpuInfoBO.setL4mg_category_code(skuForEsBO.getMgcatalogCode());
            esStorageSpuInfoBO.setMaterial_id(skuForEsBO.getMaterialId());
            if (!StringUtils.isEmpty((CharSequence)skuForEsBO.getMaterialName())) {
                esStorageSpuInfoBO.setMaterial_name(skuForEsBO.getMaterialName());
            } else {
                esStorageSpuInfoBO.setMaterial_name(skuForEsBO.getOrgMaterialName());
            }
            esStorageSpuInfoBO.setMaterial_code(skuForEsBO.getMaterialCode());
            esStorageSpuInfoBO.setModel(skuForEsBO.getModel());
            esStorageSpuInfoBO.setSpec(skuForEsBO.getSpec());
            esStorageSpuInfoBO.setMeasure_name(skuForEsBO.getMeasure());
            esStorageSpuInfoBO.setMeasure_id(skuForEsBO.getMeasureId());
            esStorageSpuInfoBO.setOrigin_brand_id(skuForEsBO.getOriginBrandId());
            esStorageSpuInfoBO.setOrigin_brand_name(skuForEsBO.getOriginBrandName());
            esStorageSpuInfoBO.setInsert_time(System.currentTimeMillis());
            esStorageSpuInfoBO.setSku_code(skuForEsBO.getSkuCode());
            esStorageSpuInfoBO.setSku_approval_status(skuForEsBO.getApprovalStatus());
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setState(1);
            uccSkuPutCirPo.setSkuId(skuForEsBO.getSkuId());
            uccSkuPutCirPo.setSupplierShopId(skuForEsBO.getSupplierShopId());
            List<UccSkuPutCirPo> uccSkuPutCirPos = this.uccSkuPutCirMapper.querySkuPutCir(uccSkuPutCirPo);
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSupplierShopId(skuForEsBO.getSupplierShopId());
            uccSkuPo.setSkuId(skuForEsBO.getSkuId());
            List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
            if (!CollectionUtils.isEmpty(uccSkuPutCirPos) && uccSkuPutCirPos.get(0).getRealDownTime() != null) {
                esStorageSpuInfoBO.setDown_time(uccSkuPutCirPos.get(0).getRealDownTime().getTime());
            }
            if (!CollectionUtils.isEmpty(uccSkuPos) && uccSkuPos.get(0).getOnShelveTime() != null) {
                esStorageSpuInfoBO.setUp_time(uccSkuPos.get(0).getOnShelveTime().getTime());
            }
            esStorageSpuInfoBO.setSupplier_org_id(skuForEsBO.getSupplierOrgId());
            esStorageSpuInfoBO.setSupplier_org_name(skuForEsBO.getSupplierOrgName());
            esStorageSpuInfoBO.setCreate_oper_id(skuForEsBO.getCreateOperId());
            esStorageSpuInfoBO.setCreate_oper_name(skuForEsBO.getCreateOperName());
            esStorageSpuInfoBO.setUpdate_oper_id(skuForEsBO.getUpdateOperId());
            esStorageSpuInfoBO.setUpdate_oper_name(skuForEsBO.getUpdateOperName());
            esStorageSpuInfoBO.setSwitch_on(skuForEsBO.getSwitchOn());
            esStorageSpuInfoBO.setLadderPrice(skuForEsBO.getLadderPrice());
            if (skuForEsBO.getCreateTime() != null) {
                esStorageSpuInfoBO.setCreate_time(skuForEsBO.getCreateTime().getTime());
            }
            if (skuForEsBO.getUpdateTime() != null) {
                esStorageSpuInfoBO.setUpdate_time(skuForEsBO.getUpdateTime().getTime());
            }
            esStorageSpuInfoBO.setMoq(skuForEsBO.getMoq());
            esStorageSpuInfoBO.setMincrement(skuForEsBO.getMincrement());
            esStorageSpuInfoBO.setSales_unit_id(skuForEsBO.getSalesUnitId());
            esStorageSpuInfoBO.setSales_unit_name(skuForEsBO.getSalesUnitName());
            if (skuForEsBO.getPreDeliverDay() != null) {
                esStorageSpuInfoBO.setPre_deliver_day(new BigDecimal(skuForEsBO.getPreDeliverDay()));
            }
            esStorageSpuInfoBO.setSettlement_unit(skuForEsBO.getSettlementUnit());
            esStorageSpuInfoBO.setSku_expand_16(skuForEsBO.getExpand16());
            esStorageSpuInfoBO.setSku_expand_17(skuForEsBO.getExpand17());
            esStorageSpuInfoBO.setStep_id(skuForEsBO.getStep_id());
            esStorageSpuInfoBO.setSame_sku_count(skuForEsBO.getSameSkuCount());
            esStorageSpuInfoBO.setStandard_commodity_id(skuForEsBO.getStandardCommodityId());
            esStorageSpuInfoBO.setGovern_status(skuForEsBO.getGovernStatus());
            esStorageSpuInfoBO.setIncrease_price_type(skuForEsBO.getIncreasePriceType());
            esStorageSpuInfoBO.setMarking_remark(skuForEsBO.getMarkingRemark());
            esStorageSpuInfoBO.setMarking(skuForEsBO.getMarking());
            esStorageSpuInfoBO.setStandard_commodity_name(skuForEsBO.getStandardCommodityName());
            esStorageSpuInfoBO.setCatalog_id_1(skuForEsBO.getCatalogId1());
            esStorageSpuInfoBO.setCatalog_id_2(skuForEsBO.getCatalogId2());
            esStorageSpuInfoBO.setCatalog_id_3(skuForEsBO.getCatalogId3());
            esStorageSpuInfoBO.setCatalog_id_4(skuForEsBO.getCatalogId4());
            esStorageSpuInfoBO.setCatalog_name_1(skuForEsBO.getCatalogName1());
            esStorageSpuInfoBO.setCatalog_name_2(skuForEsBO.getCatalogName2());
            esStorageSpuInfoBO.setCatalog_name_3(skuForEsBO.getCatalogName3());
            esStorageSpuInfoBO.setCatalog_name_4(skuForEsBO.getCatalogName4());
            esStorageSpuInfoBO.setGovern_reason(skuForEsBO.getGovernReason());
            esStorageSpuInfoBO.setSys_tenant_id(skuForEsBO.getSysTenantId());
            esStorageSpuInfoBO.setSys_tenant_name(skuForEsBO.getSysTenantName());
            esStorageSpuInfoBO.setExpand1(skuForEsBO.getSkuExpand1());
            esStorageSpuInfoBO.setExpand4(skuForEsBO.getSkuExpand4());
            esStorageSpuInfoBO.setExpand18(skuForEsBO.getSkuExpand18());
            esStorageSpuInfoBO.setExpand21(skuForEsBO.getSkuExpand21());
            esStorageSpuInfoBO.setExpand22(skuForEsBO.getSkuExpand22());
            esStorageSpuInfoBOS.add(esStorageSpuInfoBO);
        }
    }

    private void assemblyEsCommodityAndCategoryInfo(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS, List<CommodityForEsBO> commodityForEsBOS) {
        Map<Long, CommodityForEsBO> commodityEsBOMap = commodityForEsBOS.stream().collect(Collectors.toMap(CommodityForEsBO::getCommodityId, commodityForEsBO -> commodityForEsBO));
        ArrayList<Long> guiCataLog = new ArrayList<Long>();
        for (CommodityForEsBO each : commodityForEsBOS) {
            if (CollectionUtils.isEmpty(each.getGuideCataLogIds())) continue;
            guiCataLog.addAll(each.getGuideCataLogIds());
        }
        if (!CollectionUtils.isEmpty(guiCataLog)) {
            LinkedHashSet hashSet = new LinkedHashSet(guiCataLog);
            guiCataLog = new ArrayList(hashSet);
        }
        List<Object> catalogLevelPos = new ArrayList();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(guiCataLog)) {
            catalogLevelPos = this.uccCatalogDealMapper.quryCatalogLevel(reqBO.getSceneId(), null, guiCataLog);
        }
        List commoditySpecForEsBOS = new ArrayList();
        List<CommoditySpecForEsPO> specForEsPOS = this.uccSpuSpecMapper.qrySpuSpecList(commodityIds, reqBO.getSupplierId());
        if (!CollectionUtils.isEmpty(specForEsPOS)) {
            commoditySpecForEsBOS = JSONObject.parseArray((String)JSONObject.toJSONString(specForEsPOS), CommoditySpecForEsBO.class);
        }
        Map<Long, CommoditySpecForEsBO> commoditySpecForEsBOMap = commoditySpecForEsBOS.stream().collect(Collectors.toMap(CommoditySpecForEsBO::getCommodityId, commoditySpecForEsBO -> commoditySpecForEsBO));
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            CommoditySpecForEsBO commoditySpecForEsBO2;
            CommodityForEsBO commodityForEsBO2 = commodityEsBOMap.get(esStorageSpuInfoBO.getCommodity_id());
            esStorageSpuInfoBO.setScene_id(reqBO.getSceneId());
            esStorageSpuInfoBO.setCommodity_name(commodityForEsBO2.getCommodityName());
            esStorageSpuInfoBO.setCommodity_status(commodityForEsBO2.getCommodityStatus());
            esStorageSpuInfoBO.setCommd_pic_url(commodityForEsBO2.getCommodityPicUrl());
            if (!CollectionUtils.isEmpty(commodityForEsBO2.getGuideCataLogIds())) {
                esStorageSpuInfoBO.setL3_category_id(commodityForEsBO2.getGuideCataLogIds().stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
            }
            esStorageSpuInfoBO.setVendor_id(commodityForEsBO2.getVendorId());
            esStorageSpuInfoBO.setVendor_name(commodityForEsBO2.getVendorName());
            if (StringUtils.isEmpty((CharSequence)esStorageSpuInfoBO.getPicture_url())) {
                esStorageSpuInfoBO.setPicture_url(commodityForEsBO2.getCommodityPicUrl());
            }
            esStorageSpuInfoBO.setView_order(commodityForEsBO2.getViewOrder());
            esStorageSpuInfoBO.setOther_source_name(commodityForEsBO2.getOtherSourceName());
            esStorageSpuInfoBO.setOther_source_id(commodityForEsBO2.getOtherSourceId());
            esStorageSpuInfoBO.setOther_source_code(commodityForEsBO2.getOtherSourceCode());
            esStorageSpuInfoBO.setTaxRate(commodityForEsBO2.getTaxRate());
            esStorageSpuInfoBO.setTaxCode(commodityForEsBO2.getTaxCatCode());
            esStorageSpuInfoBO.setSpu_approval_status(commodityForEsBO2.getApprovalStatus());
            esStorageSpuInfoBO.setCommodity_code(commodityForEsBO2.getCommodityCode());
            esStorageSpuInfoBO.setExt_spu_id(commodityForEsBO2.getExtSpuId());
            esStorageSpuInfoBO.setCommodity_expand1(commodityForEsBO2.getCommodityExpand1());
            esStorageSpuInfoBO.setCommodityExpand5(commodityForEsBO2.getCommodityExpand5());
            esStorageSpuInfoBO.setPurchase_type(commodityForEsBO2.getPurchaseType());
            esStorageSpuInfoBO.setExpand1(esStorageSpuInfoBO.getExpand1());
            esStorageSpuInfoBO.setExpand4(esStorageSpuInfoBO.getExpand4());
            esStorageSpuInfoBO.setExpand18(esStorageSpuInfoBO.getExpand18());
            esStorageSpuInfoBO.setExpand21(esStorageSpuInfoBO.getExpand21());
            esStorageSpuInfoBO.setExpand22(esStorageSpuInfoBO.getExpand22());
            esStorageSpuInfoBO.setShow_prop_json(null);
            if (!CollectionUtils.isEmpty(catalogLevelPos) && !CollectionUtils.isEmpty(esStorageSpuInfoBO.getL3_category_id())) {
                for (UccCatalogLevelPo uccCatalogLevelPo : catalogLevelPos) {
                    for (String l3_category_id : esStorageSpuInfoBO.getL3_category_id()) {
                        if (!uccCatalogLevelPo.getL3GuideCatalogId().equals(Long.valueOf(l3_category_id))) continue;
                        if (uccCatalogLevelPo.getL1GuideCatalogId() != null) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL1_category_id())) {
                                esStorageSpuInfoBO.setL1_category_id(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL1GuideCatalogId().toString()}));
                            } else if (!esStorageSpuInfoBO.getL1_category_id().contains(String.valueOf(uccCatalogLevelPo.getL1GuideCatalogId()))) {
                                esStorageSpuInfoBO.getL1_category_id().add(String.valueOf(uccCatalogLevelPo.getL1GuideCatalogId()));
                            }
                        }
                        if (uccCatalogLevelPo.getL2GuideCatalogId() != null) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL2_category_id())) {
                                esStorageSpuInfoBO.setL2_category_id(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL2GuideCatalogId().toString()}));
                            } else if (!esStorageSpuInfoBO.getL2_category_id().contains(String.valueOf(uccCatalogLevelPo.getL2GuideCatalogId()))) {
                                esStorageSpuInfoBO.getL2_category_id().add(uccCatalogLevelPo.getL2GuideCatalogId().toString());
                            }
                        }
                        if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL1CatalogName())) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL1_category_name())) {
                                esStorageSpuInfoBO.setL1_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL1CatalogName()}));
                            } else if (!esStorageSpuInfoBO.getL1_category_name().contains(uccCatalogLevelPo.getL1CatalogName())) {
                                esStorageSpuInfoBO.getL1_category_name().add(uccCatalogLevelPo.getL1CatalogName());
                            }
                        }
                        if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL2CatalogName())) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL2_category_name())) {
                                esStorageSpuInfoBO.setL2_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL2CatalogName()}));
                            } else if (!esStorageSpuInfoBO.getL2_category_name().contains(uccCatalogLevelPo.getL2CatalogName())) {
                                esStorageSpuInfoBO.getL2_category_name().add(uccCatalogLevelPo.getL2CatalogName());
                            }
                        }
                        if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL3CatalogName())) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL3_category_name())) {
                                esStorageSpuInfoBO.setL3_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL3CatalogName()}));
                            } else if (!esStorageSpuInfoBO.getL3_category_name().contains(uccCatalogLevelPo.getL3CatalogName())) {
                                esStorageSpuInfoBO.getL3_category_name().add(uccCatalogLevelPo.getL3CatalogName());
                            }
                        }
                        if (uccCatalogLevelPo.getChannelId() == null) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getChannel_id())) {
                            esStorageSpuInfoBO.setChannel_id(Lists.newArrayList((Object[])new Long[]{uccCatalogLevelPo.getChannelId()}));
                            esStorageSpuInfoBO.setChannel_Name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getChannelName()}));
                            continue;
                        }
                        if (!esStorageSpuInfoBO.getChannel_id().contains(uccCatalogLevelPo.getChannelId())) {
                            esStorageSpuInfoBO.getChannel_id().add(uccCatalogLevelPo.getChannelId());
                        }
                        if (esStorageSpuInfoBO.getChannel_Name().contains(uccCatalogLevelPo.getChannelName())) continue;
                        esStorageSpuInfoBO.getChannel_Name().add(uccCatalogLevelPo.getChannelName());
                    }
                }
            }
            if (commoditySpecForEsBOMap.size() > 0 && (commoditySpecForEsBO2 = commoditySpecForEsBOMap.get(esStorageSpuInfoBO.getCommodity_id())) != null) {
                esStorageSpuInfoBO.setShow_prop_json(commoditySpecForEsBO2.getPropJson());
            }
            String properties = this.uccSpuSpecMapper.getSpuSpecProperties(esStorageSpuInfoBO.getSku_id());
            esStorageSpuInfoBO.setProperties(properties);
            esStorageSpuInfoBO.setUnuse_suppliershop_list(null);
        }
    }

    private CommodityCategoryForEsBO assemblyCategoryInfo(CommodityCategoryForEsBO categoryForEsBO, Map<Long, UccCatalogDealPO> upperCatalogDealPOMap) {
        CommodityCategoryForEsBO finalSpuCategoryForEsBO = new CommodityCategoryForEsBO();
        for (int i = 0; i < upperCatalogDealPOMap.size(); ++i) {
            UccCatalogDealPO uccCatalogDealPO;
            if (i == 0 && categoryForEsBO.getUpperGatalogId() == 0L) {
                return categoryForEsBO;
            }
            if (i == 0 && categoryForEsBO.getUpperGatalogId() != 0L) {
                uccCatalogDealPO = upperCatalogDealPOMap.get(categoryForEsBO.getUpperGatalogId());
                finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(categoryForEsBO, uccCatalogDealPO);
                continue;
            }
            if (finalSpuCategoryForEsBO.getUpperGatalogId() == 0L) {
                return finalSpuCategoryForEsBO;
            }
            uccCatalogDealPO = upperCatalogDealPOMap.get(finalSpuCategoryForEsBO.getUpperGatalogId());
            finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(finalSpuCategoryForEsBO, uccCatalogDealPO);
        }
        return finalSpuCategoryForEsBO;
    }

    private CommodityCategoryForEsBO mergeChildAndParentCategory(CommodityCategoryForEsBO childCategory, UccCatalogDealPO parentCategory) {
        CommodityCategoryForEsBO finalCategory = new CommodityCategoryForEsBO();
        finalCategory.setGuideCatalogId(parentCategory.getGuideCatalogId());
        finalCategory.setUpperGatalogId(parentCategory.getUpperCatalogId());
        finalCategory.setCatalogName(parentCategory.getCatalogName());
        finalCategory.setChildCatalog(childCategory);
        return finalCategory;
    }

    private void syncCommodityInfoToEs(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS)) {
            return;
        }
        List typeIds = esStorageSpuInfoBOS.stream().map(EsStorageSpuInfoBO::getType_id).collect(Collectors.toList());
        CrcCheckTenantCategoryAbilityReqBO categoryAbilityReqBO = new CrcCheckTenantCategoryAbilityReqBO();
        categoryAbilityReqBO.setTypeIds(typeIds);
        CrcCheckTenantCategoryAbilityRspBO abilityRspBO = this.crcCheckTenantCategoryAbilityService.getTenantCategoryList(categoryAbilityReqBO);
        HashMap tenantTypeMap = new HashMap();
        if ("0000".equals(abilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
            Map<Long, List<UmcTenantCooperationCategoryAbilityBO>> group = abilityRspBO.getRows().stream().collect(Collectors.groupingBy(UmcTenantCooperationCategoryAbilityBO::getSysTenantId));
            group.keySet().forEach(entry -> tenantTypeMap.put(entry, ((List)group.get(entry)).stream().map(UmcTenantCooperationCategoryAbilityBO::getCommodityTypeCode).collect(Collectors.toList())));
        }
        for (EsStorageSpuInfoBO each : esStorageSpuInfoBOS) {
            if (each.getSys_tenant_id() == null) continue;
            if (this.mainSysTenantId.compareTo(each.getSys_tenant_id()) == 0) {
                if (CollectionUtils.isEmpty(each.getSysTenantIdByPools())) {
                    each.setSysTenantIdByPools(new HashSet<Long>(Arrays.asList(each.getSys_tenant_id())));
                    continue;
                }
                List pools = new ArrayList<Long>(each.getSysTenantIdByPools()).stream().filter(a -> tenantTypeMap.containsKey(a) && ((List)tenantTypeMap.get(a)).contains(each.getType_id())).collect(Collectors.toList());
                each.setSysTenantIdByPools(new HashSet<Long>(pools));
                each.getSysTenantIdByPools().add(each.getSys_tenant_id());
                continue;
            }
            each.setSysTenantIdByPools(new HashSet<Long>(Arrays.asList(each.getSys_tenant_id())));
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            String jsonStr = JSONObject.toJSONString((Object)esStorageSpuInfoBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = "";
            esId = esStorageSpuInfoBO.getScene_id() == null ? String.valueOf(esStorageSpuInfoBO.getSku_id()) : esStorageSpuInfoBO.getScene_id() + String.valueOf(esStorageSpuInfoBO.getSku_id());
            String id = this.elasticsearchUtil.addData(this.esConfig.getIndexName(), this.esConfig.getEsType(), esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            LOGGER.error("\u5546\u54c1\u4fe1\u606f[" + esStorageSpuInfoBO.getScene_id() == null ? "" : esStorageSpuInfoBO.getScene_id() + "|" + esStorageSpuInfoBO.getCommodity_id() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }

    private void syncCommodityAttrToEs(List<EsStorageSpuAttrInfoBO> attrInfoBOS) {
        if (CollectionUtils.isEmpty(attrInfoBOS)) {
            return;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (EsStorageSpuAttrInfoBO each : attrInfoBOS) {
            JSONObject map = JSONObject.parseObject((String)JSON.toJSONString((Object)each));
            list.add((Map<String, Object>)map);
        }
        this.elasticsearchUtil.bulkPutIndex(this.esConfig.getPropIndexName(), this.esConfig.getPropIndexType(), list, "spec_id");
    }

    private void deleteSpuInfoFromEs(SyncSceneCommodityToEsReqBO reqBO) {
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
                LOGGER.error("\u5220\u9664\u6570\u636e\u7c7b\u5bb9\u4e3a\u7a7a" + JSONObject.toJSONString((Object)reqBO));
                return;
            }
            JSONObject delConditionOrderJson = new JSONObject();
            delConditionOrderJson.put("commodity_id", (Object)reqBO.getCommodityIds());
            JSONObject termOrderJson = new JSONObject();
            termOrderJson.put("terms", (Object)delConditionOrderJson);
            JSONObject termAfsJson = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)termOrderJson);
            JSONObject mustJson = new JSONObject();
            mustJson.put("must", (Object)jsonArray);
            JSONObject boolJson = new JSONObject();
            boolJson.put("bool", (Object)mustJson);
            JSONObject qryJson = new JSONObject();
            qryJson.put("query", (Object)boolJson);
            String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_delete_by_query";
            Boolean deleteResult = this.elasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
            if (!deleteResult.booleanValue()) {
                LOGGER.error("\u5546\u54c1\u4fe1\u606f\u5220\u9664\u5931\u8d25!");
            }
        } else if (ModelRuleConstant.SYNC_ES_BY_SKU_ID.equals(reqBO.getSyncType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                LOGGER.error("\u5220\u9664\u6570\u636e\u7c7b\u5bb9\u4e3a\u7a7a" + JSONObject.toJSONString((Object)reqBO));
                return;
            }
            JSONObject delConditionOrderJson = new JSONObject();
            delConditionOrderJson.put("sku_id", (Object)reqBO.getSkuIds());
            JSONObject termOrderJson = new JSONObject();
            termOrderJson.put("terms", (Object)delConditionOrderJson);
            JSONObject termAfsJson = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)termOrderJson);
            JSONObject mustJson = new JSONObject();
            mustJson.put("must", (Object)jsonArray);
            JSONObject boolJson = new JSONObject();
            boolJson.put("bool", (Object)mustJson);
            JSONObject qryJson = new JSONObject();
            qryJson.put("query", (Object)boolJson);
            String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_delete_by_query";
            Boolean deleteResult = this.elasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
            if (!deleteResult.booleanValue()) {
                LOGGER.error("\u5355\u54c1\u4fe1\u606f\u5220\u9664\u5931\u8d25!");
            }
        } else {
            LOGGER.error("\u5220\u9664ES \u6570\u636e\u672a\u77e5\u7684\u5904\u7406\u7c7b\u578b" + JSONObject.toJSONString((Object)reqBO));
        }
    }

    public void searchSku(SyncSceneCommodityToEsReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            return;
        }
        List<Object> skuPoList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getGuiCategoryIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByGuiCataLogs(reqBO.getGuiCategoryIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCategoryIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByCataLogs(reqBO.getCategoryIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByCommoditys(reqBO.getCommodityIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty(skuPoList)) {
            reqBO.setSkuIds(skuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
        }
    }

    private List<EsStorageSpuAttrInfoBO> assemblyCommodityAttrInfo(List<Long> commodityIds) {
        if (CollectionUtils.isEmpty(commodityIds)) {
            return new ArrayList<EsStorageSpuAttrInfoBO>();
        }
        return JSONObject.parseArray((String)JSONObject.toJSONString(this.uccSpuSpecMapper.qryEsAttrList(commodityIds)), EsStorageSpuAttrInfoBO.class);
    }

    private void validateReqParams(SyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getOperType() == null) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getSyncType() == null) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u540c\u6b65\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType()) && (reqBO.getCategoryIds() == null || reqBO.getCategoryIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5173\u8054\u7c7b\u76ee\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID.equals(reqBO.getSyncType()) && (reqBO.getGuiCategoryIds() == null || reqBO.getGuiCategoryIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5173\u8054\u7c7b\u76ee\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType()) && (reqBO.getCommodityIds() == null || reqBO.getCommodityIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5546\u54c1ID\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_ACTIVITY_CONTENT.equals(reqBO.getSyncType()) && (reqBO.getSpuEsForActivityBOS() == null || reqBO.getSpuEsForActivityBOS().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u6d3b\u52a8\u4fe1\u606f\u5230ES\u5931\u8d25\uff1a\u6d3b\u52a8\u76f8\u5173\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private void syncSkuPoolToES(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS) || CollectionUtils.isEmpty(commodityIds)) {
            return;
        }
        List<Object> uccSkuPos = new ArrayList();
        uccSkuPos = reqBO.getSyncType() == 4 && !CollectionUtils.isEmpty((Collection)reqBO.getSkuIds()) ? this.uccSkuMapper.batchQrySkuForPool(reqBO.getSupplierId(), commodityIds, reqBO.getSkuIds()) : this.uccSkuMapper.batchQrySkuForPool(reqBO.getSupplierId(), commodityIds, null);
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u6c60\u4fe1\u606f\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4e0b\u5173\u8054\u7684\u5355\u54c1\u6570\u636e!");
        }
        ArrayList<Long> skuIds = new ArrayList<Long>();
        ArrayList<Long> agrIds = new ArrayList<Long>();
        ArrayList<Long> vendorIds = new ArrayList<Long>();
        ArrayList<Long> typeIds = new ArrayList<Long>();
        ArrayList<Long> spuIds = new ArrayList<Long>();
        uccSkuPos.forEach(each -> {
            if (!skuIds.contains(each.getSkuId())) {
                skuIds.add(each.getSkuId());
            }
            if (!agrIds.contains(each.getAgreementId())) {
                agrIds.add(each.getAgreementId());
            }
            if (!vendorIds.contains(each.getVendorId())) {
                vendorIds.add(each.getVendorId());
            }
            if (!typeIds.contains(each.getCommodityTypeId())) {
                typeIds.add(each.getCommodityTypeId());
            }
            if (!spuIds.contains(each.getCommodityId())) {
                spuIds.add(each.getCommodityId());
            }
        });
        List<Object> uccRelPoolCommodityPosBySku = new ArrayList();
        if (!CollectionUtils.isEmpty(skuIds)) {
            uccRelPoolCommodityPosBySku = this.uccRelPoolCommodityMapper.queryPools(skuIds, SkuPoolRelTypeConstant.REL_BY_SKU);
        }
        List<Object> uccRelPoolCommodityPosByType = new ArrayList();
        if (!CollectionUtils.isEmpty(typeIds)) {
            uccRelPoolCommodityPosByType = this.uccRelPoolCommodityMapper.queryPools(typeIds, SkuPoolRelTypeConstant.REL_BY_COMMODITY_TYPE);
        }
        List<Object> uccRelPoolCommodityPosByVendor = new ArrayList();
        if (!CollectionUtils.isEmpty(vendorIds)) {
            uccRelPoolCommodityPosByVendor = this.uccRelPoolCommodityMapper.queryPools(vendorIds, SkuPoolRelTypeConstant.REL_BY_VENDOR);
        }
        List<Object> uccRelPoolCommodityPosByAgr = new ArrayList();
        if (!CollectionUtils.isEmpty(agrIds)) {
            uccRelPoolCommodityPosByAgr = this.uccRelPoolCommodityMapper.queryPools(agrIds, SkuPoolRelTypeConstant.REL_BY_AGR);
        }
        List<Object> uccRelPoolCommodityPosBySpu = new ArrayList();
        if (!CollectionUtils.isEmpty(spuIds)) {
            uccRelPoolCommodityPosBySpu = this.uccRelPoolCommodityMapper.queryPools(spuIds, SkuPoolRelTypeConstant.REL_BY_SPU);
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosBySku)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosBySku) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getSku_id())) continue;
                    if (PoolTypeEnum.NORMAL.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 2 && (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 1)) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.IDLE_ITEMS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 2) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.WASTE_ITEMS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 3) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.WITHIN_THE_ZONE.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getAgreement_sign_supplier() != 1) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.EMPLOYEE_BENEFITS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 2 && (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 1)) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (!PoolTypeEnum.ONSHELF_NO_SEE.getCode().equals(uccRelPoolCommodityPo.getPoolType())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                    if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                    esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                }
            }
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosByType)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosByType) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getType_id())) continue;
                    if (PoolTypeEnum.NORMAL.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 2 && (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 1)) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.IDLE_ITEMS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 2) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.WASTE_ITEMS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 3) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.WITHIN_THE_ZONE.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getAgreement_sign_supplier() != 1) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.EMPLOYEE_BENEFITS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 2 && (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 1)) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (!PoolTypeEnum.ONSHELF_NO_SEE.getCode().equals(uccRelPoolCommodityPo.getPoolType())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                    if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                    esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                }
            }
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosByVendor)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosByVendor) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getVendor_id())) continue;
                    if (PoolTypeEnum.NORMAL.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 2 && (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 1)) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.IDLE_ITEMS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 2) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.WASTE_ITEMS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 3) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.WITHIN_THE_ZONE.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getAgreement_sign_supplier() != 1) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.EMPLOYEE_BENEFITS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 2 && (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 1)) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (!PoolTypeEnum.ONSHELF_NO_SEE.getCode().equals(uccRelPoolCommodityPo.getPoolType())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                    if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                    esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                }
            }
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosByAgr)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosByAgr) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getAgreement_id())) continue;
                    if (PoolTypeEnum.NORMAL.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 2 && (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 1)) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.IDLE_ITEMS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 2) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.WASTE_ITEMS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 3) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.WITHIN_THE_ZONE.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getAgreement_sign_supplier() != 1) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.EMPLOYEE_BENEFITS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 2 && (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 1)) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (!PoolTypeEnum.ONSHELF_NO_SEE.getCode().equals(uccRelPoolCommodityPo.getPoolType())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                    if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                    esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                }
            }
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosBySpu)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosBySpu) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getCommodity_id())) continue;
                    if (PoolTypeEnum.NORMAL.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 2 && (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 1)) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.IDLE_ITEMS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 2) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.WASTE_ITEMS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 3) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.WITHIN_THE_ZONE.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getAgreement_sign_supplier() != 1) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (PoolTypeEnum.EMPLOYEE_BENEFITS.getCode().equals(uccRelPoolCommodityPo.getPoolType())) {
                        if (esStorageSpuInfoBO.getSku_source() != 2 && (esStorageSpuInfoBO.getSku_source() != 3 || esStorageSpuInfoBO.getHr_agreement_type() != 1)) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                            esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                            if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                            esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                            continue;
                        }
                        esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                        continue;
                    }
                    if (!PoolTypeEnum.ONSHELF_NO_SEE.getCode().equals(uccRelPoolCommodityPo.getPoolType())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                        esStorageSpuInfoBO.setSysTenantIdByPools(new HashSet<Long>(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getSysTenantId()})));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                    if (uccRelPoolCommodityPo.getIsTenantSkuPool() == null || uccRelPoolCommodityPo.getIsTenantSkuPool() != 1) continue;
                    esStorageSpuInfoBO.getSysTenantIdByPools().add(uccRelPoolCommodityPo.getSysTenantId());
                }
            }
            if (!CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                if (log.isDebugEnabled()) {
                    log.debug("es\u5546\u54c1\u540c\u6b65\u5546\u54c1\u6c60\u6570\u636e\u7ec4\u88c5\u5b8c\u6210\uff0c\u5546\u54c1id\uff1a" + esStorageSpuInfoBO.getCommodity_id() + "\u5173\u8054\u7684\u5546\u54c1\u6c60\u6709\uff1a" + JSONObject.toJSONString(esStorageSpuInfoBO.getSkuPoolIds()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug("es\u5546\u54c1\u540c\u6b65\u5546\u54c1\u6c60\u6570\u636e\u7ec4\u88c5\u5b8c\u6210\uff0c\u5546\u54c1id\uff1a" + esStorageSpuInfoBO.getCommodity_id() + "\u5173\u8054\u7684\u5546\u54c1\u6c60\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) continue;
            UccActivityPoolPO uccActivityPoolPO = new UccActivityPoolPO();
            uccActivityPoolPO.setPoolIds(esStorageSpuInfoBO.getSkuPoolIds());
            List<UccActivityPoolPO> list = this.uccActivityPoolMapper.getList(uccActivityPoolPO);
            if (!CollectionUtils.isEmpty(list)) {
                List<Long> activityIds = list.stream().map(UccActivityPoolPO::getActivityId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getActivitity_ids())) {
                    esStorageSpuInfoBO.setActivitity_ids(activityIds);
                } else {
                    esStorageSpuInfoBO.getActivitity_ids().addAll(activityIds);
                }
            }
            UccActivityPoolChangePO uccActivityPoolChangePO = new UccActivityPoolChangePO();
            uccActivityPoolChangePO.setPoolIds(esStorageSpuInfoBO.getSkuPoolIds());
            List<UccActivityPoolChangePO> uccActivityPoolChangePOS = this.uccActivityPoolChangeMapper.getList(uccActivityPoolChangePO);
            if (CollectionUtils.isEmpty(uccActivityPoolChangePOS)) continue;
            List<Long> ids = uccActivityPoolChangePOS.stream().map(UccActivityPoolChangePO::getId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getActivitity_change_ids())) {
                esStorageSpuInfoBO.setActivitity_change_ids(ids);
                continue;
            }
            esStorageSpuInfoBO.getActivitity_change_ids().addAll(ids);
        }
    }

    private void applrovalCommodityToEs(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        List<EacRuTaskPO> list;
        EacRuTaskPO eacRuTaskPO;
        ArrayList skus = new ArrayList();
        HashSet spus = new HashSet();
        esStorageSpuInfoBOS.forEach(bo -> {
            log.info("esStorageSpuInfoBO:{}", (Object)JSON.toJSONString((Object)bo));
            if (bo.getSku_approval_status() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_GO || bo.getSku_approval_status() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO || bo.getSku_approval_status() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO || bo.getSku_approval_status() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO) {
                skus.add(bo.getSku_id());
            } else if (bo.getSku_approval_status() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO) {
                if (bo.getSku_source() == 2) {
                    skus.add(bo.getSku_id());
                } else {
                    spus.add(bo.getCommodity_id());
                }
            }
        });
        if (!skus.isEmpty()) {
            for (Long skuId : skus) {
                eacRuTaskPO = new EacRuTaskPO();
                eacRuTaskPO.setStatus("ACTIVE");
                eacRuTaskPO.setBusinessId(skuId.toString());
                list = this.eacRuTaskMapper.getList(eacRuTaskPO);
                if (CollectionUtils.isEmpty(list)) continue;
                list.sort(Comparator.comparing(EacRuTaskPO::getCreateTime));
                String newestTacheCode = list.get(list.size() - 1).getTacheCode();
                Map<String, List<EacRuTaskPO>> collect = list.stream().collect(Collectors.groupingBy(EacRuTaskPO::getTacheCode));
                if (collect.keySet().size() > 1) {
                    log.error(skuId + "\u5355\u54c1\u4e0b\u6240\u6709\u6fc0\u6d3b\u4efb\u52a1\u7684\u73af\u8282\u7f16\u7801\u4e0d\u7edf\u4e00");
                }
                list.removeIf(e -> !e.getTacheCode().equals(newestTacheCode));
                esStorageSpuInfoBOS.forEach(bo -> {
                    if (skuId.equals(bo.getSku_id())) {
                        bo.setTache_code(((EacRuTaskPO)list.get(0)).getTacheCode());
                        List<String> operIds = list.stream().map(EacRuTaskPO::getUserId).collect(Collectors.toList());
                        operIds.removeIf(StringUtils::isEmpty);
                        bo.setOperIds(operIds);
                    }
                });
            }
        }
        if (skus.isEmpty()) {
            esStorageSpuInfoBOS.forEach(bo -> {
                bo.setOperIds(null);
                bo.setAudit_time(null);
            });
        }
        if (!spus.isEmpty()) {
            for (Long spuId : spus) {
                eacRuTaskPO = new EacRuTaskPO();
                eacRuTaskPO.setStatus("ACTIVE");
                eacRuTaskPO.setObjType(2);
                eacRuTaskPO.setBusinessId(spuId.toString());
                list = this.eacRuTaskMapper.getList(eacRuTaskPO);
                if (CollectionUtils.isEmpty(list)) continue;
                Map<String, List<EacRuTaskPO>> collect = list.stream().collect(Collectors.groupingBy(EacRuTaskPO::getTacheCode));
                if (collect.keySet().size() > 1) {
                    throw new BusinessException("8888", spuId + "\u5546\u54c1\u4e0b\u6240\u6709\u6fc0\u6d3b\u4efb\u52a1\u7684\u73af\u8282\u7f16\u7801\u4e0d\u7edf\u4e00");
                }
                esStorageSpuInfoBOS.forEach(bo -> {
                    if (spuId.equals(bo.getCommodity_id())) {
                        bo.setTache_code(((EacRuTaskPO)list.get(0)).getTacheCode());
                        List<String> operIds = list.stream().map(EacRuTaskPO::getUserId).collect(Collectors.toList());
                        operIds.removeIf(StringUtils::isEmpty);
                        bo.setOperIds(operIds);
                    }
                });
            }
        }
    }

    private void dealLable(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS)) {
            return;
        }
        ArrayList<Long> skuPoos = new ArrayList<Long>();
        HashSet skuPooSet = new HashSet();
        esStorageSpuInfoBOS.stream().filter(s -> !CollectionUtils.isEmpty(s.getSkuPoolIds())).forEach(item -> skuPooSet.addAll(item.getSkuPoolIds()));
        if (CollectionUtils.isEmpty(skuPooSet)) {
            return;
        }
        skuPoos = new ArrayList(skuPooSet);
        List<UccRelCommodityLabelPoolPo> cnncRelCommodityLabelPoolPos = this.cnncRelCommodityLaberPoolMapper.queryAllInfoByPoolList(skuPoos);
        if (CollectionUtils.isEmpty(cnncRelCommodityLabelPoolPos)) {
            return;
        }
        HashSet lableList = new HashSet();
        cnncRelCommodityLabelPoolPos.stream().forEach(item -> lableList.add(item.getLabelId()));
        List<UccCommodityLabelPo> labelPos = this.cnncCommodityLabelMapper.selectLabel(null, new ArrayList<Long>(skuPoos));
        if (CollectionUtils.isEmpty(labelPos)) {
            LOGGER.error("\u5546\u54c1\u540c\u6b65es \uff0c\u6807\u7b7e\u4e0d\u5b58\u5728" + lableList);
            return;
        }
        Map<Long, UccCommodityLabelPo> labelMap = labelPos.stream().collect(Collectors.toMap(UccCommodityLabelPo::getLabelId, CnncCommodityLabelPo -> CnncCommodityLabelPo, (a, b) -> a));
        Map<Long, List<UccRelCommodityLabelPoolPo>> groupByPools = cnncRelCommodityLabelPoolPos.stream().collect(Collectors.groupingBy(UccRelCommodityLabelPoolPo::getPoolId));
        HashMap<Long, UccPoolsLableBo> poolsLableDetailMap = new HashMap<Long, UccPoolsLableBo>();
        for (Map.Entry<Long, List<UccRelCommodityLabelPoolPo>> entry : groupByPools.entrySet()) {
            HashSet<Long> labelIds = new HashSet<Long>();
            HashSet<Long> showLabelIds = new HashSet<Long>();
            HashSet<String> labelNames = new HashSet<String>();
            HashSet<String> showLabelNames = new HashSet<String>();
            UccPoolsLableBo uccPoolsLableBo = new UccPoolsLableBo();
            uccPoolsLableBo.setPoolId(entry.getKey());
            for (UccRelCommodityLabelPoolPo relCommodityLabelPoolPo : entry.getValue()) {
                if (!labelMap.containsKey(relCommodityLabelPoolPo.getLabelId())) continue;
                labelIds.add(relCommodityLabelPoolPo.getLabelId());
                labelNames.add(labelMap.get(relCommodityLabelPoolPo.getLabelId()).getLabelName());
                if (relCommodityLabelPoolPo.getIsShow() != 1) continue;
                showLabelIds.add(relCommodityLabelPoolPo.getLabelId());
                showLabelNames.add(labelMap.get(relCommodityLabelPoolPo.getLabelId()).getLabelName());
            }
            uccPoolsLableBo.setLabelIds(new ArrayList<Long>(labelIds));
            uccPoolsLableBo.setLabelNames(new ArrayList<String>(labelNames));
            uccPoolsLableBo.setShowLabelIds(new ArrayList<Long>(showLabelIds));
            uccPoolsLableBo.setShowLabelNames(new ArrayList<String>(showLabelNames));
            poolsLableDetailMap.put(entry.getKey(), uccPoolsLableBo);
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) continue;
            HashSet<Long> labelIds = new HashSet<Long>();
            HashSet<Long> showLabelIds = new HashSet<Long>();
            HashSet<String> labelNames = new HashSet<String>();
            HashSet<String> showLabelNames = new HashSet<String>();
            for (Long pool : esStorageSpuInfoBO.getSkuPoolIds()) {
                if (poolsLableDetailMap.containsKey(pool)) {
                    labelIds.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getLabelIds());
                    showLabelIds.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getShowLabelIds());
                    labelNames.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getLabelNames());
                    showLabelNames.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getShowLabelNames());
                    continue;
                }
                LOGGER.error("\u672a\u5339\u914d\u5230\u5546\u54c1\u6c60\u8be6\u60c5\u6570\u636e\uff1a" + pool);
            }
            esStorageSpuInfoBO.setLabelIds(new ArrayList<Long>(labelIds));
            esStorageSpuInfoBO.setLabelNames(new ArrayList<String>(labelNames));
            esStorageSpuInfoBO.setShowLabelIds(new ArrayList<Long>(showLabelIds));
            esStorageSpuInfoBO.setShowLabelNames(new ArrayList<String>(showLabelNames));
        }
    }

    private void dealChannel(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS)) {
            return;
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            List<UccRelChannelPoolPo> uccRelChannelPoolPos;
            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getChannel_id())) {
                List<UccRelChannelPoolPo> uccRelChannelPoolPos2;
                if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds()) || CollectionUtils.isEmpty(uccRelChannelPoolPos2 = this.uccRelChannelPoolMapper.getRelListByPools(esStorageSpuInfoBO.getSkuPoolIds()))) continue;
                List channelIdList = uccRelChannelPoolPos2.stream().map(a -> a.getChannelId()).collect(Collectors.toList());
                esStorageSpuInfoBO.setChannel_id(channelIdList);
                List<String> channelNameList = uccRelChannelPoolPos2.stream().map(a -> a.getChannelName()).collect(Collectors.toList());
                esStorageSpuInfoBO.setChannel_Name(channelNameList);
                continue;
            }
            HashSet<Long> channelIdLists = new HashSet<Long>();
            channelIdLists.addAll(esStorageSpuInfoBO.getChannel_id());
            for (Long each : esStorageSpuInfoBO.getChannel_id()) {
                UccChannelDealPO uccChannelDealPO = new UccChannelDealPO();
                uccChannelDealPO.setChannelId(each);
                uccChannelDealPO.setRelatedType(1);
                List<UccChannelDealPO> uccChannelDealPOList = this.uccChannelDealMapper.selectByChannelCode(uccChannelDealPO);
                if (CollectionUtils.isEmpty(uccChannelDealPOList)) continue;
                if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                    channelIdLists.remove(each);
                    esStorageSpuInfoBO.getChannel_Name().remove(uccChannelDealPOList.get(0).getChannelName());
                    continue;
                }
                List<UccRelChannelPoolPo> uccRelChannelPoolPos3 = this.uccRelChannelPoolMapper.getRelListByChannelIds(Lists.newArrayList((Object[])new Long[]{uccChannelDealPOList.get(0).getChannelId()}));
                if (CollectionUtils.isEmpty(uccRelChannelPoolPos3)) {
                    esStorageSpuInfoBO.getChannel_Name().remove(uccChannelDealPOList.get(0).getChannelName());
                    channelIdLists.remove(each);
                    continue;
                }
                boolean contain = false;
                for (UccRelChannelPoolPo uccRelChannelPoolPo : uccRelChannelPoolPos3) {
                    if (!esStorageSpuInfoBO.getSkuPoolIds().contains(uccRelChannelPoolPo.getPoolId())) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                channelIdLists.remove(each);
                esStorageSpuInfoBO.getChannel_Name().remove(uccChannelDealPOList.get(0).getChannelName());
            }
            ArrayList<Long> channelIdListNew = new ArrayList<Long>(channelIdLists);
            esStorageSpuInfoBO.setChannel_id(channelIdListNew);
            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds()) || CollectionUtils.isEmpty(uccRelChannelPoolPos = this.uccRelChannelPoolMapper.getRelListByPools(esStorageSpuInfoBO.getSkuPoolIds()))) continue;
            List channelIdList = uccRelChannelPoolPos.stream().map(a -> a.getChannelId()).collect(Collectors.toList());
            Map<Long, String> channelMap = uccRelChannelPoolPos.stream().collect(Collectors.toMap(a -> a.getChannelId(), b -> b.getChannelName(), (oldValue, newValue) -> newValue));
            for (Long each : channelIdList) {
                if (esStorageSpuInfoBO.getChannel_id().contains(each)) continue;
                esStorageSpuInfoBO.getChannel_id().add(each);
                esStorageSpuInfoBO.getChannel_Name().add(channelMap.get(each));
            }
        }
    }

    private void sendDeleteMq(List<SkuForEsPO> notNeedSku) {
        if (CollectionUtils.isEmpty(notNeedSku)) {
            return;
        }
        Map<Long, List<SkuForEsPO>> notNeedSkuMap = notNeedSku.stream().collect(Collectors.groupingBy(SkuForEsPO::getSupplierShopId));
        for (Map.Entry<Long, List<SkuForEsPO>> entry : notNeedSkuMap.entrySet()) {
            List skuIds = entry.getValue().stream().map(SkuForEsPO::getSkuId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
            syncSceneCommodityToEsReqBO.setSupplierId(entry.getKey());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            try {
                this.lmBatchSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                LOGGER.error("\u540c\u6b65\u5546\u54c1\u72b6\u6001\u548c\u4ef7\u683c\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
    }
}

