/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.bo.Candidate;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspInfoBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccApproveCreationAtomServiceImpl
implements UccApproveCreationAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccApproveCreationAtomServiceImpl.class);
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    @Value(value="${DL_APPROVAL_ID:1}")
    private String dlApprovalId;
    @Value(value="${DL_APPROVAL_NAME:admin}")
    private String dlApprovalName;
    @Value(value="${ON_SHELF_MENU_ID:ESTORE_ON_SHELF_PROCESS_NO_APPROVER}")
    private String onShelfMenuId;
    @Value(value="${OFF_SHELF_MENU_ID:ESTORE_OFF_SHELF_PROCESS_NO_APPROVER}")
    private String offShelfMenuId;
    @Value(value="${REINSTATE_SHELF_MENU_ID:ESTORE_REINSTATE_PROCESS_NO_APPROVER}")
    private String reinstateShelfMenuId;

    @Override
    public UccApproveCreationAtomRspBO createApprove(UccApproveCreationAtomReqBO reqBO) {
        UccApproveCreationAtomRspBO rspBO = new UccApproveCreationAtomRspBO();
        if (CollectionUtils.isEmpty(reqBO.getObjId())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u8bf7\u4f20\u5165\u5ba1\u6279\u5bf9\u8c61\u96c6\u5408");
        }
        if (reqBO.getObjType() == null) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u8bf7\u4f20\u5165\u5ba1\u6279\u7c7b\u578b");
        }
        if (StringUtils.isEmpty((Object)reqBO.getMenuId())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u8bf7\u4f20\u5165\u6d41\u7a0b\u5b9a\u4e49KEY(menuId)");
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccEditProcessOrder.getStep())) {
            if (reqBO.getIsAgreement().booleanValue()) {
                uccSkuPo.setSkuIds(reqBO.getObjId());
            } else {
                uccSkuPo.setCommodityIds(reqBO.getObjId());
            }
        } else {
            uccSkuPo.setSkuIds(reqBO.getObjId());
        }
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
        if (uccSkuPos.get(0).getSysTenantId() == null) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccSkuPos.get(0).getSkuCode() + "\u5355\u54c1\u79df\u6237id\u4e3a\u7a7a");
        }
        List agreementIds = uccSkuPos.stream().map(UccSkuPo::getAgreementId).distinct().collect(Collectors.toList());
        HashMap<Long, AgrAgreementBO> agrAgreementBOMap = new HashMap<Long, AgrAgreementBO>();
        for (Long agreementId : agreementIds) {
            if (null == agreementId) continue;
            AgrQryAgreementSubjectDetailsAbilityReqBO subjectDetailsAbilityReqBO = new AgrQryAgreementSubjectDetailsAbilityReqBO();
            subjectDetailsAbilityReqBO.setAgreementId(agreementId);
            AgrQryAgreementSubjectDetailsAbilityRspBO subjectDetailsAbilityRspBO = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(subjectDetailsAbilityReqBO);
            if (!"0000".equals(subjectDetailsAbilityRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u534f\u8bae\u51fa\u9519\uff1a" + subjectDetailsAbilityRspBO.getRespDesc());
            }
            agrAgreementBOMap.put(agreementId, subjectDetailsAbilityRspBO.getAgrAgreementBO());
        }
        log.info("agrAgreementBOMap:{}", (Object)JSON.toJSONString(agrAgreementBOMap));
        String tacheCode = null;
        Boolean isFinish = null;
        for (Long aLong : reqBO.getObjId()) {
            EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO;
            EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = new EacStartProjectAbilityReqBO();
            eacStartProjectAbilityReqBO.setSysCode("CRC");
            eacStartProjectAbilityReqBO.setProcDefKey(reqBO.getMenuId());
            List<String> businessIdList = Arrays.asList(aLong.toString());
            eacStartProjectAbilityReqBO.setBusinessIdList(businessIdList);
            if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep())) {
                eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccOnShelfProcessOrder.code());
            } else if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep())) {
                eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccOffShelfProcessOrder.code());
            } else if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccReinstateProcessOrder.getStep())) {
                eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccReinstateProcessOrder.code());
            } else if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccEditProcessOrder.getStep())) {
                eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccEditProcessOrder.code());
            }
            eacStartProjectAbilityReqBO.setOrgId(reqBO.getOrgId().toString());
            eacStartProjectAbilityReqBO.setOrgName(reqBO.getOrgName());
            eacStartProjectAbilityReqBO.setUserId(reqBO.getUserId().toString());
            eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
            eacStartProjectAbilityReqBO.setStationCode(null);
            eacStartProjectAbilityReqBO.setStationName(null);
            eacStartProjectAbilityReqBO.setRoleId(null);
            eacStartProjectAbilityReqBO.setRoleName(null);
            if (!StringUtils.isEmpty((Object)reqBO.getAgreementCreateUserId())) {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                ArrayList<Candidate> NEXT_CANDIDATES = new ArrayList<Candidate>();
                Candidate candidate = new Candidate();
                candidate.setName(reqBO.getAgreementCreateUserName());
                candidate.setValue(reqBO.getAgreementCreateUserId());
                NEXT_CANDIDATES.add(candidate);
                variables.put("NEXT_CANDIDATES", JSON.toJSONString(NEXT_CANDIDATES));
                variables.put("sysTenantId", uccSkuPos.get(0).getSysTenantId());
                eacStartProjectAbilityReqBO.setVariables(variables);
            } else {
                Candidate candidate;
                ArrayList<Candidate> NEXT_CANDIDATES;
                HashMap<String, Object> variables;
                UccSkuPo uccSkuPo1 = new UccSkuPo();
                if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccEditProcessOrder.getStep())) {
                    uccSkuPo1.setCommodityId(aLong);
                } else {
                    uccSkuPo1.setSkuId(aLong);
                }
                List<UccSkuPo> qerySku = this.uccSkuMapper.qerySku(uccSkuPo1);
                if (qerySku.get(0).getSkuSource() == 3 && (reqBO.getMenuId().contains("AGR") || reqBO.getMenuId().contains("ARG")) && !CollectionUtils.isEmpty(qerySku) && null != qerySku.get(0).getAgreementId() && agrAgreementBOMap.get(qerySku.get(0).getAgreementId()) != null) {
                    variables = new HashMap<String, Object>();
                    NEXT_CANDIDATES = new ArrayList<Candidate>();
                    candidate = new Candidate();
                    if (((AgrAgreementBO)agrAgreementBOMap.get(qerySku.get(0).getAgreementId())).getAgreementSrc() != null && ((AgrAgreementBO)agrAgreementBOMap.get(qerySku.get(0).getAgreementId())).getAgreementSrc() != 6) {
                        candidate.setName(((AgrAgreementBO)agrAgreementBOMap.get(qerySku.get(0).getAgreementId())).getProducerName());
                        candidate.setValue(((AgrAgreementBO)agrAgreementBOMap.get(qerySku.get(0).getAgreementId())).getProducerId().toString());
                    } else {
                        candidate.setName(this.dlApprovalName);
                        candidate.setValue(this.dlApprovalId);
                    }
                    NEXT_CANDIDATES.add(candidate);
                    if (((AgrAgreementBO)agrAgreementBOMap.get(qerySku.get(0).getAgreementId())).getAgreementClassification() != 5) {
                        variables.put("NEXT_CANDIDATES", JSON.toJSONString(NEXT_CANDIDATES));
                    }
                    variables.put("sysTenantId", uccSkuPos.get(0).getSysTenantId());
                    eacStartProjectAbilityReqBO.setVariables(variables);
                } else if (qerySku.get(0).getSkuSource() == 2 && qerySku.get(0).getAgreementId() != null && !reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccEditProcessOrder.getStep())) {
                    if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep())) {
                        eacStartProjectAbilityReqBO.setProcDefKey(this.offShelfMenuId);
                    } else if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccReinstateProcessOrder.getStep())) {
                        eacStartProjectAbilityReqBO.setProcDefKey(this.reinstateShelfMenuId);
                    } else if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep())) {
                        eacStartProjectAbilityReqBO.setProcDefKey(this.onShelfMenuId);
                    }
                    variables = new HashMap();
                    NEXT_CANDIDATES = new ArrayList();
                    candidate = new Candidate();
                    if (((AgrAgreementBO)agrAgreementBOMap.get(qerySku.get(0).getAgreementId())).getAgreementSrc() != null && ((AgrAgreementBO)agrAgreementBOMap.get(qerySku.get(0).getAgreementId())).getAgreementSrc() != 6) {
                        candidate.setName(((AgrAgreementBO)agrAgreementBOMap.get(qerySku.get(0).getAgreementId())).getProducerName());
                        candidate.setValue(((AgrAgreementBO)agrAgreementBOMap.get(qerySku.get(0).getAgreementId())).getProducerId().toString());
                    } else {
                        candidate.setName(this.dlApprovalName);
                        candidate.setValue(this.dlApprovalId);
                    }
                    NEXT_CANDIDATES.add(candidate);
                    variables.put("NEXT_CANDIDATES", JSON.toJSONString(NEXT_CANDIDATES));
                    variables.put("sysTenantId", uccSkuPos.get(0).getSysTenantId());
                    eacStartProjectAbilityReqBO.setVariables(variables);
                }
            }
            eacStartProjectAbilityReqBO.setSysTenantId(uccSkuPos.get(0).getSysTenantId().toString());
            try {
                log.info("\u521b\u5efa\u5ba1\u6279\u5355\u5165\u53c2eacStartProjectAbilityReqBO:" + JSON.toJSON((Object)eacStartProjectAbilityReqBO));
                eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
                log.info("\u521b\u5efa\u5ba1\u6279\u5355\u51fa\u53c2eacStartProjectAbilityRspBO:" + JSON.toJSON((Object)eacStartProjectAbilityRspBO));
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
            }
            if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
            }
            tacheCode = ((EacStartProjectAbilityRspInfoBO)eacStartProjectAbilityRspBO.getData().get(0)).getTacheCode();
            isFinish = ((EacStartProjectAbilityRspInfoBO)eacStartProjectAbilityRspBO.getData().get(0)).getIsFinish();
        }
        if (ApprovalTypeEnum.uccOffShelfProcessOrder.code().equals(reqBO.getObjType().toString())) {
            for (Long objId : reqBO.getObjId()) {
                UccSkuExpandPo uccSkuExpandPo = new UccSkuExpandPo();
                uccSkuExpandPo.setSkuId(objId);
                uccSkuExpandPo.setSysTenantId(reqBO.getSysTenantId());
                uccSkuExpandPo.setSysTenantName(reqBO.getSysTenantName());
                List<UccSkuExpandPo> uccSkuExpandPos = this.uccSkuExpandMapper.querySkuExpand(uccSkuExpandPo);
                uccSkuExpandPo.setExpand15(reqBO.getFileAnnex());
                uccSkuExpandPo.setExpand16(reqBO.getAuditAdvice());
                if (!CollectionUtils.isEmpty(uccSkuExpandPos)) {
                    this.uccSkuExpandMapper.updateSkuExpand(uccSkuExpandPo);
                    continue;
                }
                List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(objId), null);
                uccSkuExpandPo.setCommodityId(uccSkuPoList.get(0).getCommodityId());
                uccSkuExpandPo.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
                this.uccSkuExpandMapper.insertSkuExpand(uccSkuExpandPo);
            }
        }
        rspBO.setStepId(tacheCode);
        rspBO.setFinish(isFinish);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

