/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.authority.busi.api.SelectUserAlreadyAuthRolesService;
import com.tydic.authority.busi.bo.HasAndNotGrantRoleBO;
import com.tydic.authority.busi.bo.SelectOrgAlreadyRolesRspBO;
import com.tydic.authority.busi.bo.UserAuthReqBO;
import com.tydic.commodity.base.constant.PoolRelatedTypeEnum;
import com.tydic.commodity.base.constant.PoolTypeEnum;
import com.tydic.commodity.busibase.comb.api.SearchCommodityManageCombService;
import com.tydic.commodity.busibase.comb.api.UccQrySkuPoolListCombService;
import com.tydic.commodity.busibase.comb.bo.SearchCommodityManageCombReqBo;
import com.tydic.commodity.busibase.comb.bo.SearchCommodityManageCombRspBo;
import com.tydic.commodity.busibase.comb.bo.UccQrySkuPoolListCombBo;
import com.tydic.commodity.busibase.comb.bo.UccQrySkuPoolListCombReqBo;
import com.tydic.commodity.busibase.comb.bo.UccQrySkuPoolListCombRspBo;
import com.tydic.commodity.dao.UccActivityPoolMapper;
import com.tydic.commodity.dao.UccCommodityLabelMapper;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.po.UccActivityPoolPO;
import com.tydic.commodity.po.UccCommodityLabelPo;
import com.tydic.commodity.po.UccCommodityPoolPO;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.UmcQryMemLegalOrgInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccQrySkuPoolListCombServiceImpl
implements UccQrySkuPoolListCombService {
    private static final Logger log = LoggerFactory.getLogger(UccQrySkuPoolListCombServiceImpl.class);
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;
    @Autowired
    private SearchCommodityManageCombService searchCommodityManageCombService;
    @Autowired
    private UccCommodityLabelMapper cnncCommodityLabelMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccActivityPoolMapper uccActivityPoolMapper;
    @Autowired
    private UmcQryMemLegalOrgInfoAbilityService umcQryMemLegalOrgInfoAbilityService;
    @Autowired
    private SelectUserAlreadyAuthRolesService selectUserAlreadyAuthRolesService;
    @Value(value="${ACTIVITY_POOL_AUTH:tenant:10000:yuangongfulishangpinchiguanliyuan}")
    private String activityPoolAuthIdentity;

    @Override
    public UccQrySkuPoolListCombRspBo qrySkuPoolList(UccQrySkuPoolListCombReqBo reqBo) {
        if (reqBo.getIsTenantSkuPool() == null) {
            throw new BusinessException("8888", "isTenantSkuPool\u662f\u5426\u79df\u6237\u5546\u54c1\u6c60\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSysTenantIdWeb() == null) {
            reqBo.setSysTenantId(null);
        } else {
            reqBo.setSysTenantId(reqBo.getSysTenantIdWeb());
        }
        if (reqBo.getIsTenantSkuPool() == 2) {
            reqBo.setSysTenantId(null);
        }
        UccQrySkuPoolListCombRspBo rspBo = new UccQrySkuPoolListCombRspBo();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        UccCommodityPoolPO uccCommodityPoolPO = new UccCommodityPoolPO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)uccCommodityPoolPO);
        uccCommodityPoolPO.setPoolState(reqBo.getPoolStatus());
        uccCommodityPoolPO.setOrgId(null);
        uccCommodityPoolPO.setOrgName(null);
        if (reqBo.getNeedActiveOrgSplit() != null && reqBo.getNeedActiveOrgSplit() == 1) {
            UmcQryMemLegalOrgInfoAbilityServiceReqBO umcQryMemLegalOrgInfoAbilityServiceReqBO = new UmcQryMemLegalOrgInfoAbilityServiceReqBO();
            umcQryMemLegalOrgInfoAbilityServiceReqBO.setMemId(reqBo.getUserId());
            log.info("\u4f1a\u5458\u5165\u53c2umcQryMemLegalOrgInfoAbilityServiceReqBO" + JSON.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceReqBO));
            UmcQryMemLegalOrgInfoAbilityServiceRspBO umcQryMemLegalOrgInfoAbilityServiceRspBO = this.umcQryMemLegalOrgInfoAbilityService.qryMemLegalOrgInfo(umcQryMemLegalOrgInfoAbilityServiceReqBO);
            log.info("\u4f1a\u5458\u51fa\u53c2umcQryMemLegalOrgInfoAbilityServiceRspBO" + JSON.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceRspBO));
            if (!"0000".equals(umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u4f1a\u5458\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u62a5\u9519\uff1a" + umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespDesc());
            }
            if (umcQryMemLegalOrgInfoAbilityServiceRspBO.getTwoLevelOrgInfo() == null || umcQryMemLegalOrgInfoAbilityServiceRspBO.getTwoLevelOrgInfo().getOrgId() == null) {
                rspBo.setPageNo(1);
                rspBo.setRecordsTotal(0);
                rspBo.setTotal(0);
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
                return rspBo;
            }
            uccCommodityPoolPO.setOrgId(umcQryMemLegalOrgInfoAbilityServiceRspBO.getTwoLevelOrgInfo().getOrgId());
            UserAuthReqBO userAuthReqBo = new UserAuthReqBO();
            userAuthReqBo.setPrarmUserId(reqBo.getUserId());
            userAuthReqBo.setManaOrgTreePath(reqBo.getOrgPath());
            SelectOrgAlreadyRolesRspBO selectOrgAlreadyRolesRspBo = this.selectUserAlreadyAuthRolesService.selectOrgAlreadyRoles(userAuthReqBo);
            List hasGrantRoles = selectOrgAlreadyRolesRspBo.getHasGrantRoles();
            if (!CollectionUtils.isEmpty((Collection)hasGrantRoles)) {
                List stationCode = hasGrantRoles.stream().map(HasAndNotGrantRoleBO::getAuthIdentity).collect(Collectors.toList());
                rspBo.setIsTwoLevalOrg(stationCode.contains(this.activityPoolAuthIdentity));
            }
        }
        List<UccCommodityPoolPO> uccCommodityPoolPOS = this.uccCommodityPoolMapper.queryPageList(page, uccCommodityPoolPO);
        ArrayList cnncQrySkuPoolListAbilityBos = new ArrayList();
        if (!CollectionUtils.isEmpty(uccCommodityPoolPOS)) {
            uccCommodityPoolPOS.forEach(each -> {
                List<UccRelPoolCommodityPo> uccRelPoolCommodityPos;
                Map<Integer, Long> isShowLabelCountMap;
                UccQrySkuPoolListCombBo cnncQrySkuPoolListAbilityBo = new UccQrySkuPoolListCombBo();
                BeanUtils.copyProperties((Object)each, (Object)cnncQrySkuPoolListAbilityBo);
                cnncQrySkuPoolListAbilityBo.setPoolStatus(each.getPoolState());
                if (each.getPoolState() != null) {
                    cnncQrySkuPoolListAbilityBo.setPoolStatusDesc(each.getPoolState() == 1 ? "\u542f\u7528" : "\u505c\u7528");
                }
                cnncQrySkuPoolListAbilityBo.setRelSkuType(each.getPoolRelated());
                if (each.getPoolRelated() != null) {
                    cnncQrySkuPoolListAbilityBo.setRelSkuTypeDesc(PoolRelatedTypeEnum.getPoolRelatedTypeDesc((Integer)each.getPoolRelated()).getDesc());
                }
                if (each.getPoolType() != null) {
                    cnncQrySkuPoolListAbilityBo.setPoolTypeDesc(PoolTypeEnum.getPoolTypeDesc((Integer)each.getPoolType()).getDesc());
                }
                SearchCommodityManageCombReqBo searchCommodityManageAbilityReqBo = new SearchCommodityManageCombReqBo();
                searchCommodityManageAbilityReqBo.setPoolIds(Lists.newArrayList((Object[])new Long[]{each.getPoolId()}));
                searchCommodityManageAbilityReqBo.setIsFieldSku(false);
                SearchCommodityManageCombRspBo searchCommodityManageAbilityRspBo = this.searchCommodityManageCombService.searchCommodity(searchCommodityManageAbilityReqBo);
                try {
                    cnncQrySkuPoolListAbilityBo.setPoolSkuNum(Long.valueOf(searchCommodityManageAbilityRspBo.getRecordsTotal()));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u83b7\u53d6\u603b\u6570\u5931\u8d25\uff01");
                }
                List<UccCommodityLabelPo> cnncCommodityLabelPos = this.cnncCommodityLabelMapper.selectLabel(null, Lists.newArrayList((Object[])new Long[]{each.getPoolId()}));
                if (!CollectionUtils.isEmpty(cnncCommodityLabelPos) && !CollectionUtils.isEmpty(isShowLabelCountMap = cnncCommodityLabelPos.stream().collect(Collectors.groupingBy(UccCommodityLabelPo::getIsShow, Collectors.counting())))) {
                    Long isShowLabelCount = isShowLabelCountMap.get(1);
                    cnncQrySkuPoolListAbilityBo.setConnectLabelNum(cnncCommodityLabelPos.size());
                    cnncQrySkuPoolListAbilityBo.setIsShowLabelNum(isShowLabelCount);
                }
                if (!CollectionUtils.isEmpty(uccRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPoolsRelated(Lists.newArrayList((Object[])new Long[]{each.getPoolId()}), each.getPoolRelated()))) {
                    cnncQrySkuPoolListAbilityBo.setRelNum(uccRelPoolCommodityPos.size());
                } else {
                    cnncQrySkuPoolListAbilityBo.setRelNum(0);
                }
                if (cnncQrySkuPoolListAbilityBo.getPoolType() == 5) {
                    UccActivityPoolPO temp = new UccActivityPoolPO();
                    temp.setPoolId(cnncQrySkuPoolListAbilityBo.getPoolId());
                    List<UccActivityPoolPO> list = this.uccActivityPoolMapper.getList(temp);
                    if (!CollectionUtils.isEmpty(list)) {
                        cnncQrySkuPoolListAbilityBo.setActivityIds(list.stream().map(UccActivityPoolPO::getActivityId).collect(Collectors.toList()));
                    }
                }
                cnncQrySkuPoolListAbilityBos.add(cnncQrySkuPoolListAbilityBo);
            });
        }
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRows(cnncQrySkuPoolListAbilityBos);
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

