/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class UccThreadPoolConfig {
    private static final Logger log = LoggerFactory.getLogger(UccThreadPoolConfig.class);

    @Bean(value={"asyncModifySupNameExecutor"})
    public ThreadPoolTaskExecutor taskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        int processNum = Runtime.getRuntime().availableProcessors();
        int corePoolSize = (int)((double)processNum / 0.8);
        int maxPoolSize = (int)((double)processNum / 0.5);
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize * 1000);
        executor.setQueueCapacity(10);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("ucc-ModifySupExecutor-%d").setPriority(10).setDaemon(false).setUncaughtExceptionHandler((t, e) -> log.error("Error in thread: {}", (Object)t.getName(), (Object)e)).build();
        executor.setThreadFactory(threadFactory);
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setAwaitTerminationSeconds(1800);
        return executor;
    }
}

