/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.common.ability.api.CnncReindexCommodityAddToEsService;
import com.tydic.commodity.common.ability.bo.CnncReindexCommodityAddToEsReqBo;
import com.tydic.commodity.common.ability.bo.CnncReindexCommodityAddToEsRspBo;
import com.tydic.commodity.dao.UccSyncCommodityMapper;
import com.tydic.commodity.po.UccSyncCommodityPO;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.CnncReindexCommodityAddToEsService"})
public class CnncReindexCommodityAddToEsServiceImpl
implements CnncReindexCommodityAddToEsService {
    private static final Logger log = LoggerFactory.getLogger(CnncReindexCommodityAddToEsServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccSyncCommodityMapper uccSyncCommodityMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${es.cluster.address}")
    private String esUrl;

    @PostMapping(value={"reindexDataAddToEs"})
    public CnncReindexCommodityAddToEsRspBo reindexDataAddToEs(@RequestBody CnncReindexCommodityAddToEsReqBo reqBo) {
        CnncReindexCommodityAddToEsRspBo rspBo = new CnncReindexCommodityAddToEsRspBo();
        try {
            JSONObject removeBody = new JSONObject();
            removeBody.put("index", (Object)reqBo.getOldIndex());
            removeBody.put("alias", (Object)"uccaut_alias");
            JSONObject addBody = new JSONObject();
            addBody.put("index", (Object)reqBo.getNewIndex());
            addBody.put("alias", (Object)"uccaut_alias");
            JSONObject remove = new JSONObject();
            remove.put("remove", (Object)removeBody);
            JSONObject add = new JSONObject();
            add.put("add", (Object)addBody);
            JSONArray actions = new JSONArray();
            actions.add((Object)remove);
            actions.add((Object)add);
            JSONObject body = new JSONObject();
            body.put("actions", (Object)actions);
            ResponseEntity postForEntity = this.restTemplate.postForEntity("http://" + this.esUrl + "/_aliases", (Object)body, String.class, new Object[0]);
            log.error("\u8fd4\u56de\u7ed3\u679c\uff1a" + (String)postForEntity.getBody());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        this.cacheClient.set("ucc_sync_commodity_es_record_cache", (Object)0);
        UccSyncCommodityPO uccSyncCommodityPO = new UccSyncCommodityPO();
        List uccSyncCommodityPOS = this.uccSyncCommodityMapper.getList(uccSyncCommodityPO);
        Set<Object> ids = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)uccSyncCommodityPOS)) {
            ids = uccSyncCommodityPOS.stream().map(a -> a.getId()).collect(Collectors.toSet());
            Map<Integer, List<UccSyncCommodityPO>> map = uccSyncCommodityPOS.stream().collect(Collectors.groupingBy(a -> a.getSyncType()));
            for (Map.Entry<Integer, List<UccSyncCommodityPO>> each : map.entrySet()) {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setOperType(Integer.valueOf(0));
                syncSceneCommodityToEsReqBO.setSingleType(0);
                syncSceneCommodityToEsReqBO.setSyncType(each.getKey());
                Set objectIds = each.getValue().stream().map(a -> a.getSyncObject()).collect(Collectors.toSet());
                if (each.getKey() == 0) {
                    syncSceneCommodityToEsReqBO.setCommodityIds((List)Lists.newArrayList(objectIds));
                } else if (each.getKey() == 1) {
                    syncSceneCommodityToEsReqBO.setCategoryIds((List)Lists.newArrayList(objectIds));
                } else if (each.getKey() == 3) {
                    syncSceneCommodityToEsReqBO.setGuiCategoryIds((List)Lists.newArrayList(objectIds));
                } else if (each.getKey() == 4) {
                    syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(objectIds));
                }
                this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
            }
        }
        if (!CollectionUtils.isEmpty(ids)) {
            UccSyncCommodityPO uccSyncCommodityPO1 = new UccSyncCommodityPO();
            uccSyncCommodityPO1.setIds((List)Lists.newArrayList(ids));
            this.uccSyncCommodityMapper.deleteBy(uccSyncCommodityPO1);
        }
        return rspBo;
    }
}

