/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccNotConnectSkuUpdateImportAbilityService;
import com.tydic.commodity.common.ability.bo.FailReasonBO;
import com.tydic.commodity.common.ability.bo.UccNotConnectSkuUpdateImportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccNotConnectSkuUpdateImportAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccNotConnectSkuExcelImportBusiService;
import com.tydic.commodity.common.busi.bo.UccNotConnectSkuExcelImportBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccNotConnectSkuExcelImportBusiRspBO;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccNotConnectSkuUpdateImportAbilityService"})
public class UccNotConnectSkuUpdateImportAbilityServiceImpl
implements UccNotConnectSkuUpdateImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccNotConnectSkuUpdateImportAbilityServiceImpl.class);
    @Autowired
    private UccNotConnectSkuExcelImportBusiService uccNotConnectSkuExcelImportBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"updateImport"})
    public UccNotConnectSkuUpdateImportAbilityRspBO updateImport(@RequestBody UccNotConnectSkuUpdateImportAbilityReqBO reqBO) {
        this.val(reqBO);
        ArrayList<FailReasonBO> failReasonList = new ArrayList<FailReasonBO>();
        List origBOList = reqBO.getSkuImportDateItem();
        List origList = JSON.parseArray((String)JSON.toJSONString((Object)origBOList), UccSkuPo.class);
        log.info("\u5bfc\u5165\u6570\u636e: " + JSON.toJSONString((Object)origList));
        ArrayList<UccSkuPo> newList = new ArrayList<UccSkuPo>();
        List uccSkuPoList = this.uccSkuMapper.qeryImportNotConnectSku(origList);
        List codeList = origList.stream().map(UccSkuPo::getSkuCode).collect(Collectors.toList());
        List uccSkuPoListBycode = this.uccSkuMapper.querySkuByCode(codeList);
        List skuCodeList = uccSkuPoListBycode.stream().map(UccSkuPo::getSkuCode).collect(Collectors.toList());
        HashMap codeMap = uccSkuPoListBycode.stream().collect(HashMap::new, (m, v) -> m.put(v.getSkuCode(), v.getMaterialId()), HashMap::putAll);
        ArrayList<String> collect = new ArrayList<String>();
        for (UccSkuPo uccSkuPo : origList) {
            if (StringUtils.isEmpty((Object)uccSkuPo.getMaterialCode())) continue;
            collect.add(uccSkuPo.getMaterialCode());
        }
        List uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.batchQryByCodes(collect);
        Map<String, Long> map = uccEMdmMaterialPOS.stream().collect(Collectors.toMap(item -> item.getMaterialCode(), item -> item.getMaterialId(), (item1, item2) -> item1));
        for (UccSkuPo uccSkuPo : origList) {
            if (StringUtils.isEmpty((Object)uccSkuPo.getSkuCode())) {
                failReasonList.add(this.Encapsulation(uccSkuPo, "\u5355\u54c1\u7f16\u7801\u4e3a\u7a7a"));
                continue;
            }
            if (StringUtils.isEmpty((Object)uccSkuPo.getMaterialCode())) {
                failReasonList.add(this.Encapsulation(uccSkuPo, "\u5355\u54c1\u672a\u5173\u8054\u5546\u57ce\u7269\u6599"));
                continue;
            }
            if (null == map.get(uccSkuPo.getMaterialCode())) {
                failReasonList.add(this.Encapsulation(uccSkuPo, "\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728"));
                continue;
            }
            uccSkuPo.setMaterialId(String.valueOf(map.get(uccSkuPo.getMaterialCode())));
            if (!skuCodeList.contains(uccSkuPo.getSkuCode())) {
                failReasonList.add(this.Encapsulation(uccSkuPo, "\u5355\u54c1\u7f16\u7801\u4e0d\u5b58\u5728"));
                continue;
            }
            newList.add(uccSkuPo);
        }
        UccNotConnectSkuExcelImportBusiReqBO busiReqBO = new UccNotConnectSkuExcelImportBusiReqBO();
        busiReqBO.setUccSkuPo(newList);
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        UccNotConnectSkuExcelImportBusiRspBO busiRspBO = this.uccNotConnectSkuExcelImportBusiService.notConnectSkuExcelImport(busiReqBO);
        UccNotConnectSkuUpdateImportAbilityRspBO rspBO = new UccNotConnectSkuUpdateImportAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        rspBO.setFailReasonList(failReasonList);
        if (!CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            Map<Long, List<UccSkuPo>> skuMap = uccSkuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long supplierShopId : skuMap.keySet()) {
                List skus = skuMap.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                log.debug("es\u540c\u6b65\u5165\u53c2,sku\u96c6\u5408-----------------------------:{}", (Object)JSON.toJSONString(skus));
                List tempList = Lists.partition(skus, (int)500);
                for (List skuList : tempList) {
                    SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList((Iterable)skuList));
                    syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    try {
                        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                    }
                }
            }
        }
        return rspBO;
    }

    void val(UccNotConnectSkuUpdateImportAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO)) {
            throw new BusinessException("\u5931\u8d25", "\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
    }

    public FailReasonBO Encapsulation(UccSkuPo uccSkuPo, String reason) {
        FailReasonBO failReasonBO = new FailReasonBO();
        String str = "\u5355\u54c1\u7f16\u7801: \u201c" + uccSkuPo.getSkuCode() + "\u201d \u4e0e\u7269\u6599\u7f16\u7801:\u201d" + uccSkuPo.getMaterialCode() + "\u201c\u5339\u914d\u5173\u7cfb\u4fe1\u606f\u5bfc\u5165\u5931\u8d25, \u539f\u56e0\u4e3a: " + reason;
        failReasonBO.setFailReason(str);
        failReasonBO.setLineNum(uccSkuPo.getGluttonLineNum());
        return failReasonBO;
    }
}

