/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.bo.UccOnecodeCatalogQryListBO;
import com.tydic.commodity.common.ability.bo.UccOnecodeShelfAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccOnecodeShelfAddAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccOnecodeShelfAddBusiService;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccOneCodeShelfRuleCatalogMapper;
import com.tydic.commodity.dao.UccOneCodeShelfRuleMapper;
import com.tydic.commodity.po.EmdmCatalogLevelPO;
import com.tydic.commodity.po.UccOneCodeShelfRuleCatalogPO;
import com.tydic.commodity.po.UccOneCodeShelfRulePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccOnecodeShelfAddBusiServiceImpl
implements UccOnecodeShelfAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccOnecodeShelfAddBusiServiceImpl.class);
    @Autowired
    private UccOneCodeShelfRuleMapper uccOneCodeShelfRuleMapper;
    @Autowired
    private UccOneCodeShelfRuleCatalogMapper uccOneCodeShelfRuleCatalogMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccOnecodeShelfAddAbilityRspBO addOnecodeShelf(UccOnecodeShelfAddAbilityReqBO reqBO) {
        UccOnecodeShelfAddAbilityRspBO rspBO = new UccOnecodeShelfAddAbilityRspBO();
        Map<Long, List<UccOnecodeCatalogQryListBO>> addListMap = reqBO.getAddList().stream().collect(Collectors.groupingBy(UccOnecodeCatalogQryListBO::getParentCatalogId));
        List<Long> idList = new ArrayList<Long>();
        ArrayList<UccOneCodeShelfRuleCatalogPO> catalogPOList = new ArrayList<UccOneCodeShelfRuleCatalogPO>();
        Set<Long> parenKey = addListMap.keySet();
        for (Long each : parenKey) {
            try {
                this.inserList(idList, catalogPOList, addListMap.get(each), reqBO);
            }
            catch (Exception e) {
                throw new ZTBusinessException(e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(idList)) {
            UccOneCodeShelfRuleCatalogPO ruleCatalogPO = new UccOneCodeShelfRuleCatalogPO();
            ruleCatalogPO.setIds(idList);
            List codeShelfRuleCatalogPOS = this.uccOneCodeShelfRuleCatalogMapper.getList(ruleCatalogPO);
            if (CollectionUtils.isEmpty((Collection)codeShelfRuleCatalogPOS)) {
                UccOneCodeShelfRulePO shelfRulePO = new UccOneCodeShelfRulePO();
                shelfRulePO.setIds(idList);
                this.uccOneCodeShelfRuleMapper.deleteBy(shelfRulePO);
            } else {
                idList = idList.stream().distinct().collect(Collectors.toList());
                List qryIds = codeShelfRuleCatalogPOS.stream().map(UccOneCodeShelfRuleCatalogPO::getId).distinct().collect(Collectors.toList());
                if (idList.size() != qryIds.size()) {
                    idList.removeAll(qryIds);
                    UccOneCodeShelfRulePO shelfRulePO = new UccOneCodeShelfRulePO();
                    shelfRulePO.setIds(idList);
                    this.uccOneCodeShelfRuleMapper.deleteBy(shelfRulePO);
                }
                UccOneCodeShelfRulePO updateRule = new UccOneCodeShelfRulePO();
                updateRule.setUpdateLoginId(reqBO.getUserId());
                updateRule.setUpdateLoginName(reqBO.getName() + "(" + reqBO.getUsername() + ")");
                updateRule.setUpdateTime(new Date());
                this.uccOneCodeShelfRuleMapper.batchUpdateOper(updateRule, qryIds);
            }
        }
        if (!CollectionUtils.isEmpty(catalogPOList)) {
            this.uccOneCodeShelfRuleCatalogMapper.insertBatch(catalogPOList);
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void inserList(List<Long> idList, List<UccOneCodeShelfRuleCatalogPO> catalogPOList, List<UccOnecodeCatalogQryListBO> reqInfo, UccOnecodeShelfAddAbilityReqBO reqBO) {
        block11: {
            HashSet ruleSet;
            List rulePOList;
            block10: {
                UccOneCodeShelfRulePO shelfRulePO = new UccOneCodeShelfRulePO();
                shelfRulePO.setCatalogId3(((UccOnecodeCatalogQryListBO)reqInfo.get(0)).getParentCatalogId());
                shelfRulePO.setSysTenantId(reqBO.getSysTenantId());
                rulePOList = this.uccOneCodeShelfRuleMapper.getList(shelfRulePO);
                ruleSet = new HashSet();
                reqInfo.stream().forEach(a -> ruleSet.add(a.getRule()));
                if (!CollectionUtils.isEmpty((Collection)rulePOList)) break block10;
                List emdmCatalogLevelPOS = this.uccEMdmCatalogMapper.queryAllUpperCatalog(((UccOnecodeCatalogQryListBO)reqInfo.get(0)).getParentCatalogId());
                if (CollectionUtils.isEmpty((Collection)emdmCatalogLevelPOS) || emdmCatalogLevelPOS.size() != 3) {
                    log.error("\u5546\u54c1\u5206\u7c7b\u4e0d\u5b58\u5728\uff01 catalogId = " + ((UccOnecodeCatalogQryListBO)reqInfo.get(0)).getParentCatalogId());
                    throw new ZTBusinessException("\u5546\u54c1\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
                }
                HashMap<Integer, Long> ruleMap = new HashMap<Integer, Long>();
                for (Integer n : ruleSet) {
                    shelfRulePO = new UccOneCodeShelfRulePO();
                    shelfRulePO.setId(Long.valueOf(this.sequence.nextId()));
                    shelfRulePO.setCatalogId1(((EmdmCatalogLevelPO)emdmCatalogLevelPOS.get(0)).getCatalogId());
                    shelfRulePO.setCatalogId2(((EmdmCatalogLevelPO)emdmCatalogLevelPOS.get(1)).getCatalogId());
                    shelfRulePO.setCatalogId3(((EmdmCatalogLevelPO)emdmCatalogLevelPOS.get(2)).getCatalogId());
                    shelfRulePO.setRule(n);
                    shelfRulePO.setUpdateLoginId(reqBO.getUserId());
                    shelfRulePO.setUpdateLoginName(reqBO.getName() + "(" + reqBO.getUsername() + ")");
                    shelfRulePO.setUpdateTime(new Date());
                    shelfRulePO.setSysTenantId(reqBO.getSysTenantId());
                    shelfRulePO.setSysTenantName(reqBO.getSysTenantName());
                    this.uccOneCodeShelfRuleMapper.insert(shelfRulePO);
                    ruleMap.put(n, shelfRulePO.getId());
                }
                for (UccOnecodeCatalogQryListBO uccOnecodeCatalogQryListBO : reqInfo) {
                    UccOneCodeShelfRuleCatalogPO catalogPO = new UccOneCodeShelfRuleCatalogPO();
                    catalogPO.setId((Long)ruleMap.get(uccOnecodeCatalogQryListBO.getRule()));
                    catalogPO.setCatalogId(uccOnecodeCatalogQryListBO.getCatalogId());
                    catalogPO.setRule(uccOnecodeCatalogQryListBO.getRule());
                    catalogPO.setUpdateLoginId(reqBO.getUserId());
                    catalogPO.setUpdateLoginName(reqBO.getName() + "(" + reqBO.getUsername() + ")");
                    catalogPO.setUpdateTime(new Date());
                    catalogPO.setSysTenantId(reqBO.getSysTenantId());
                    catalogPO.setSysTenantName(reqBO.getSysTenantName());
                    catalogPOList.add(catalogPO);
                }
                break block11;
            }
            List ids = rulePOList.stream().map(UccOneCodeShelfRulePO::getId).collect(Collectors.toList());
            Map<Object, Object> catalogMap = new HashMap();
            UccOneCodeShelfRuleCatalogPO ruleCatalogPO = new UccOneCodeShelfRuleCatalogPO();
            ruleCatalogPO.setIds(ids);
            List list = this.uccOneCodeShelfRuleCatalogMapper.getList(ruleCatalogPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                catalogMap = list.stream().collect(Collectors.toMap(UccOneCodeShelfRuleCatalogPO::getCatalogId, Function.identity()));
            }
            ArrayList<Long> needInsert = new ArrayList<Long>();
            ArrayList<Long> deleteCatalog = new ArrayList<Long>();
            for (UccOnecodeCatalogQryListBO uccOnecodeCatalogQryListBO : reqInfo) {
                if (catalogMap.containsKey(uccOnecodeCatalogQryListBO.getCatalogId())) {
                    if (uccOnecodeCatalogQryListBO.getRule().equals(((UccOneCodeShelfRuleCatalogPO)catalogMap.get(uccOnecodeCatalogQryListBO.getCatalogId())).getRule())) continue;
                    idList.add(((UccOneCodeShelfRuleCatalogPO)catalogMap.get(uccOnecodeCatalogQryListBO.getCatalogId())).getId());
                    deleteCatalog.add(uccOnecodeCatalogQryListBO.getCatalogId());
                    continue;
                }
                needInsert.add(uccOnecodeCatalogQryListBO.getCatalogId());
            }
            if (!CollectionUtils.isEmpty(deleteCatalog)) {
                needInsert.addAll(deleteCatalog);
                this.uccOneCodeShelfRuleCatalogMapper.batchdeleteByCatalog(null, deleteCatalog);
            }
            if (CollectionUtils.isEmpty(needInsert)) break block11;
            reqInfo = reqInfo.stream().filter(a -> needInsert.contains(a.getCatalogId())).collect(Collectors.toList());
            HashMap<Integer, Long> ruleMap = new HashMap<Integer, Long>();
            for (UccOneCodeShelfRulePO uccOneCodeShelfRulePO : rulePOList) {
                ruleMap.put(uccOneCodeShelfRulePO.getRule(), uccOneCodeShelfRulePO.getId());
            }
            for (Integer n : ruleSet) {
                if (ruleMap.containsKey(n)) continue;
                UccOneCodeShelfRulePO shelfRuleOther = new UccOneCodeShelfRulePO();
                BeanUtils.copyProperties(rulePOList.get(0), (Object)shelfRuleOther);
                shelfRuleOther.setRule(n);
                shelfRuleOther.setUpdateLoginId(reqBO.getUserId());
                shelfRuleOther.setUpdateTime(new Date());
                shelfRuleOther.setUpdateLoginName(reqBO.getName() + "(" + reqBO.getUsername() + ")");
                shelfRuleOther.setId(Long.valueOf(this.sequence.nextId()));
                shelfRuleOther.setRemark(null);
                shelfRuleOther.setSysTenantId(reqBO.getSysTenantId());
                shelfRuleOther.setSysTenantName(reqBO.getSysTenantName());
                this.uccOneCodeShelfRuleMapper.insert(shelfRuleOther);
                ruleMap.put(n, shelfRuleOther.getId());
            }
            for (UccOnecodeCatalogQryListBO uccOnecodeCatalogQryListBO : reqInfo) {
                UccOneCodeShelfRuleCatalogPO catalogPO = new UccOneCodeShelfRuleCatalogPO();
                catalogPO.setId((Long)ruleMap.get(uccOnecodeCatalogQryListBO.getRule()));
                catalogPO.setCatalogId(uccOnecodeCatalogQryListBO.getCatalogId());
                catalogPO.setRule(uccOnecodeCatalogQryListBO.getRule());
                catalogPO.setUpdateLoginId(reqBO.getUserId());
                catalogPO.setUpdateLoginName(reqBO.getName() + "(" + reqBO.getUsername() + ")");
                catalogPO.setUpdateTime(new Date());
                catalogPOList.add(catalogPO);
            }
        }
    }
}

