/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.ability.bo.UccSpuControlImportSubmitAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuControlImportSubmitAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccSpuControlImportSubmitBusiService;
import com.tydic.commodity.dao.UccNormSpuControlImportMapper;
import com.tydic.commodity.dao.UccNormSpuControlMapper;
import com.tydic.commodity.po.UccNormSpuControlImportPO;
import com.tydic.commodity.po.UccNormSpuControlPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSpuControlImportSubmitBusiServiceImpl
implements UccSpuControlImportSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuControlImportSubmitBusiServiceImpl.class);
    @Autowired
    private UccNormSpuControlMapper uccNormSpuControlMapper;
    @Autowired
    private UccNormSpuControlImportMapper uccNormSpuControlImportMapper;

    @Override
    public UccSpuControlImportSubmitAbilityRspBO submitSpuControlImport(UccSpuControlImportSubmitAbilityReqBO reqBO) {
        UccSpuControlImportSubmitAbilityRspBO abilityRspBO = new UccSpuControlImportSubmitAbilityRspBO();
        abilityRspBO.setRespCode("0000");
        if (reqBO.getReqId() == null) {
            return abilityRspBO;
        }
        UccNormSpuControlImportPO importPO = new UccNormSpuControlImportPO();
        importPO.setReqId(reqBO.getReqId());
        importPO.setStatus(Integer.valueOf(1));
        List importPOList = this.uccNormSpuControlImportMapper.getList(importPO);
        if (!CollectionUtils.isEmpty((Collection)importPOList)) {
            List vCommodityIds = importPOList.stream().map(UccNormSpuControlImportPO::getVCommodityId).collect(Collectors.toList());
            UccNormSpuControlPO delete = new UccNormSpuControlPO();
            delete.setVCommodityIds(vCommodityIds);
            this.uccNormSpuControlMapper.deleteBy(delete);
            List controlPOS = JSONObject.parseArray((String)JSON.toJSONString((Object)importPOList), UccNormSpuControlPO.class);
            controlPOS.stream().forEach(a -> {
                a.setSysTenantId(reqBO.getSysTenantId());
                a.setSysTenantName(reqBO.getSysTenantName());
                a.setOperTime(new Date());
                a.setOperUserId(reqBO.getUserId());
                a.setOperUserName(reqBO.getName() + "(" + reqBO.getUsername() + ")");
            });
            this.uccNormSpuControlMapper.insertBatch(controlPOS);
        }
        importPO = new UccNormSpuControlImportPO();
        importPO.setReqId(reqBO.getReqId());
        this.uccNormSpuControlImportMapper.deleteBy(importPO);
        return abilityRspBO;
    }
}

