/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccOnecodeShelfQryListAbilityService;
import com.tydic.commodity.common.ability.bo.UccOnecodeShelfQryListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccOnecodeShelfQryListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccOnecodeShelfQryListBO;
import com.tydic.commodity.common.busi.api.UccDicDictionaryService;
import com.tydic.commodity.dao.UccOneCodeShelfRuleCatalogMapper;
import com.tydic.commodity.dao.UccOneCodeShelfRuleMapper;
import com.tydic.commodity.po.UccOneCodeShelfRuleCatalogPO;
import com.tydic.commodity.po.UccOneCodeShelfRulePO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccOnecodeShelfQryListAbilityService"})
public class UccOnecodeShelfQryListAbilityServiceImpl
implements UccOnecodeShelfQryListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccOnecodeShelfQryListAbilityServiceImpl.class);
    @Autowired
    private UccOneCodeShelfRuleMapper uccOneCodeShelfRuleMapper;
    @Autowired
    private UccOneCodeShelfRuleCatalogMapper uccOneCodeShelfRuleCatalogMapper;
    @Autowired
    private UccDicDictionaryService uccDicDictionaryService;

    @PostMapping(value={"qryOnecodeShelfList"})
    public UccOnecodeShelfQryListAbilityRspBO qryOnecodeShelfList(@RequestBody UccOnecodeShelfQryListAbilityReqBO reqBO) {
        Page page;
        List shelfRulePOS;
        UccOnecodeShelfQryListAbilityRspBO abilityRspBO = new UccOnecodeShelfQryListAbilityRspBO();
        UccOneCodeShelfRulePO rulePO = new UccOneCodeShelfRulePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)rulePO);
        if (!StringUtils.isEmpty((Object)reqBO.getCatalogIdName())) {
            List<String> catalogName;
            if (reqBO.getCatalogIdName().contains(",")) {
                catalogName = Arrays.asList(reqBO.getCatalogIdName().split(","));
                rulePO.setCatalogIdName(catalogName);
            } else if (reqBO.getCatalogIdName().contains("\uff0c")) {
                catalogName = Arrays.asList(reqBO.getCatalogIdName().split("\uff0c"));
                rulePO.setCatalogIdName(catalogName);
            } else {
                catalogName = Arrays.asList(reqBO.getCatalogIdName());
                rulePO.setCatalogIdName(catalogName);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(shelfRulePOS = this.uccOneCodeShelfRuleMapper.getListPageByCatalog(rulePO, page = new Page(reqBO.getPageNo(), reqBO.getPageSize()))))) {
            List boList = JSONObject.parseArray((String)JSON.toJSONString((Object)shelfRulePOS), UccOnecodeShelfQryListBO.class);
            List ids = shelfRulePOS.stream().map(UccOneCodeShelfRulePO::getId).collect(Collectors.toList());
            UccOneCodeShelfRuleCatalogPO catalogPO = new UccOneCodeShelfRuleCatalogPO();
            catalogPO.setIds(ids);
            List ruleCatalogPOList = this.uccOneCodeShelfRuleCatalogMapper.getList(catalogPO);
            if (!CollectionUtils.isEmpty((Collection)ruleCatalogPOList)) {
                Map<String, String> ruleMap = this.uccDicDictionaryService.queryBypCodeBackMap("ONE_CODE_SHELF_RULE");
                Map<Long, List<UccOneCodeShelfRuleCatalogPO>> catalogMap = ruleCatalogPOList.stream().collect(Collectors.groupingBy(UccOneCodeShelfRuleCatalogPO::getId));
                for (UccOnecodeShelfQryListBO each : boList) {
                    each.setRuleDesc(ruleMap.get(each.getRule().toString()));
                    if (!catalogMap.containsKey(each.getId())) continue;
                    StringBuilder sb = new StringBuilder("");
                    catalogMap.get(each.getId()).stream().forEach(a -> sb.append(a.getCatalogName()).append(","));
                    String catalogName = sb.toString().substring(0, sb.toString().length() - 1);
                    each.setCatalogIdName(catalogName);
                }
            }
            abilityRspBO.setRows(boList);
        }
        abilityRspBO.setRespCode("0000");
        abilityRspBO.setPageNo(page.getPageNo());
        abilityRspBO.setRecordsTotal(page.getTotalCount());
        abilityRspBO.setTotal(page.getTotalPages());
        return abilityRspBO;
    }
}

