/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccConfigurationparametersAddBusiService;
import com.tydic.commodity.common.busi.bo.UccConfigurationparametersAddBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccConfigurationparametersAddBusiRspBO;
import com.tydic.commodity.dao.UccParamsConfigDetailMapper;
import com.tydic.commodity.dao.UccParamsConfigMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccParamsConfigDetailPO;
import com.tydic.commodity.po.UccParamsConfigPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccConfigurationparametersAddBusiServiceImpl
implements UccConfigurationparametersAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccConfigurationparametersAddBusiServiceImpl.class);
    @Autowired
    private UccParamsConfigMapper uccParamsConfigMapper;
    @Autowired
    private UccParamsConfigDetailMapper uccParamsConfigDetailMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private Sequence sequence = Sequence.getInstance();
    @Resource(name="lOGToleranceSyncProvider")
    private ProxyMessageProducer logToleranceSyncProvider;

    @Override
    public UccConfigurationparametersAddBusiRspBO dealUccConfigurationparametersAdd(UccConfigurationparametersAddBusiReqBO reqBO) {
        UccConfigurationparametersAddBusiRspBO rspBO = new UccConfigurationparametersAddBusiRspBO();
        UccParamsConfigPO uccParamsConfigPO = new UccParamsConfigPO();
        uccParamsConfigPO.setParamsId(reqBO.getParamsId());
        UccParamsConfigPO po = this.uccParamsConfigMapper.getModelBy(uccParamsConfigPO);
        if (po == null) {
            rspBO.setRespCode("0002");
            rspBO.setRespDesc("\u5bf9\u5e94\u53c2\u6570ID\u6570\u636e\u8fd8\u672a\u521b\u5efa");
            return rspBO;
        }
        UccParamsConfigDetailPO uccParamsConfigDetailPO = new UccParamsConfigDetailPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uccParamsConfigDetailPO);
        uccParamsConfigDetailPO.setId(Long.valueOf(this.sequence.nextId()));
        uccParamsConfigDetailPO.setCode(po.getParamsCode());
        uccParamsConfigDetailPO.setUpdateOper(reqBO.getUsername());
        uccParamsConfigDetailPO.setUpdateTime((Date)new Timestamp(System.currentTimeMillis()));
        uccParamsConfigDetailPO.setSysTenantId(reqBO.getSysTenantId());
        uccParamsConfigDetailPO.setSysTenantName(reqBO.getSysTenantName());
        UccParamsConfigDetailPO existsPO = new UccParamsConfigDetailPO();
        existsPO.setBusinessType(reqBO.getBusinessType());
        existsPO.setBusinessName(reqBO.getBusinessName());
        existsPO.setParamsId(po.getParamsId());
        existsPO.setCode(po.getParamsCode());
        UccParamsConfigDetailPO modelBy = this.uccParamsConfigDetailMapper.getModelBy(existsPO);
        if (modelBy != null) {
            throw new BusinessException("8888", "\u5f53\u524d\u4f9b\u5e94\u5546\u5df2\u5b58\u5728:");
        }
        if ("TOLERANCE".equals(po.getParamsCode())) {
            List listByID = this.uccSkuMapper.getListByID(uccParamsConfigDetailPO);
            for (UccSkuPo uccSkuPo : listByID) {
                uccSkuPo.setTolerance(BigDecimal.valueOf(Double.parseDouble(reqBO.getUpWarn())));
                this.uccSkuMapper.updateSkuTolerance(uccSkuPo);
                this.syncES(uccSkuPo);
            }
        } else if ("PRICE_ALERT".equals(po.getParamsCode())) {
            // empty if block
        }
        try {
            this.uccParamsConfigDetailMapper.insert(uccParamsConfigDetailPO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6dfb\u52a0\u5931\u8d25:" + e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncES(UccSkuPo uccSkuPo) {
        try {
            log.debug("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\uff1a " + uccSkuPo);
            this.logToleranceSyncProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)uccSkuPo)));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25: " + e);
        }
    }
}

