/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccAbnormalSkuResultDealBusiService;
import com.tydic.commodity.common.comb.api.UccAbnormalSkuResultNotifyCombService;
import com.tydic.commodity.common.comb.bo.UccAbnormalSkuResultNotifyCombReqBO;
import com.tydic.commodity.common.comb.bo.UccAbnormalSkuResultNotifyCombRspBO;
import com.tydic.commodity.dao.UccSkuDataGovernMapper;
import com.tydic.commodity.po.UccSkuDataGovernPO;
import java.util.Arrays;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccAbnormalSkuResultNotifyCombServiceImpl
implements UccAbnormalSkuResultNotifyCombService {
    private static final Logger log = LoggerFactory.getLogger(UccAbnormalSkuResultNotifyCombServiceImpl.class);
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;
    @Resource(name="lmBatchSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmBatchSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_BATCH_SYNC_TOPIC:LM_UCC_BATCH_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Autowired
    private UccSkuDataGovernMapper uccSkuDataGovernMapper;
    @Autowired
    private UccAbnormalSkuResultDealBusiService uccAbnormalSkuResultDealBusiService;

    @Override
    public UccAbnormalSkuResultNotifyCombRspBO dealAbnormalSkuResultNotify(UccAbnormalSkuResultNotifyCombReqBO reqBO) {
        UccAbnormalSkuResultNotifyCombRspBO rspBO = new UccAbnormalSkuResultNotifyCombRspBO();
        rspBO.setRespCode("0000");
        if (reqBO.getId() == null) {
            return rspBO;
        }
        UccSkuDataGovernPO uccSkuDataGovernPO = new UccSkuDataGovernPO();
        uccSkuDataGovernPO.setId(reqBO.getId());
        uccSkuDataGovernPO = this.uccSkuDataGovernMapper.getModelBy(uccSkuDataGovernPO);
        if (uccSkuDataGovernPO == null || uccSkuDataGovernPO.getStatus() != 0 && uccSkuDataGovernPO.getStatus() != 2) {
            return rspBO;
        }
        reqBO.setUccSkuDataGovernPO(uccSkuDataGovernPO);
        rspBO = this.uccAbnormalSkuResultDealBusiService.dealAbnormalSkuResultNotify(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(Arrays.asList(rspBO.getCommodityId()));
            syncSceneCommodityToEsReqBO.setSupplierId(rspBO.getSupplierShopId());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmBatchSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
        return rspBO;
    }
}

