/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.base.enumType.SkuEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.ability.api.UccQueryMaterialClassifyService;
import com.tydic.commodity.common.ability.api.UccSkuhasBeenapprovalListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccLadderPriceBO;
import com.tydic.commodity.common.ability.bo.UccQueryMaterialClassifyReqBO;
import com.tydic.commodity.common.ability.bo.UccQueryMaterialClassifyRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.commodity.common.ability.bo.UccSkuhasBeenapprovalListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuhasBeenapprovalListQryAbilityRspBO;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccMallBrandRelPO;
import com.tydic.commodity.po.UccSkuManagementPO;
import com.tydic.commodity.po.UccSkuhasBeenapprovalPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.osworkflow.approve.ability.EacQueryApproveTaskListAbilityService;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuhasBeenapprovalListQryAbilityService"})
public class UccSkuhasBeenapprovalListQryAbilityServiceImpl
implements UccSkuhasBeenapprovalListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuhasBeenapprovalListQryAbilityServiceImpl.class);
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private EacQueryApproveTaskListAbilityService eacQueryApproveTaskListAbilityService;
    @Autowired
    private UccQueryMaterialClassifyService uccQueryMaterialClassifyService;

    @PostMapping(value={"gethasBeenapprovalListQry"})
    public UccSkuhasBeenapprovalListQryAbilityRspBO gethasBeenapprovalListQry(@RequestBody UccSkuhasBeenapprovalListQryAbilityReqBO reqBO) {
        UccSkuhasBeenapprovalListQryAbilityRspBO rspBO = new UccSkuhasBeenapprovalListQryAbilityRspBO();
        if (reqBO.getObjType() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("objType\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List<Object> brands = new ArrayList<Long>();
        if (!StringUtils.isEmpty((Object)reqBO.getBrandName())) {
            List brandDealPOS = this.uccBrandDealMapper.querySpuBrandByName(reqBO.getBrandName());
            if (!CollectionUtils.isEmpty((Collection)brandDealPOS)) {
                brands = brandDealPOS.stream().map(UccBrandDealPO::getBrandId).collect(Collectors.toList());
            } else {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
        }
        if (reqBO.getBrandId() != null) {
            brands.add(reqBO.getBrandId());
            UccMallBrandRelPO brandRelPO = new UccMallBrandRelPO();
            brandRelPO.setMallBrandId(reqBO.getBrandId());
            List relPOList = this.uccMallBrandRelMapper.getList(brandRelPO);
            if (!CollectionUtils.isEmpty((Collection)relPOList)) {
                List brandList = relPOList.stream().map(UccMallBrandRelPO::getBrandId).collect(Collectors.toList());
                brands.addAll(brandList);
            }
        }
        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
        eacRuTaskPO.setObjType(reqBO.getObjType());
        eacRuTaskPO.setUserId(reqBO.getUserId().toString());
        eacRuTaskPO.setStatus("COMPLETE");
        eacRuTaskPO.setProcDefKey(reqBO.getProcDefKey());
        if (reqBO.getAuditResult() != null) {
            eacRuTaskPO.setColumn2(reqBO.getAuditResult().toString());
        } else {
            ArrayList<String> tempList = new ArrayList<String>();
            tempList.add("0");
            tempList.add("1");
            eacRuTaskPO.setColumn2List(tempList);
        }
        List list = this.eacRuTaskMapper.getList(eacRuTaskPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List skuIds = list.stream().map(e -> Long.parseLong(e.getBusinessId())).collect(Collectors.toList());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccSkuhasBeenapprovalPO uccSkuhasBeenapprovalPO = new UccSkuhasBeenapprovalPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuhasBeenapprovalPO);
        if (reqBO.getSalePriceStar() != null) {
            uccSkuhasBeenapprovalPO.setSalePriceStar(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getSalePriceStar())));
        }
        if (reqBO.getSalePriceEnd() != null) {
            uccSkuhasBeenapprovalPO.setSalePriceEnd(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getSalePriceEnd())));
        }
        if (reqBO.getMarketPriceStar() != null) {
            uccSkuhasBeenapprovalPO.setMarketPriceStar(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getMarketPriceStar())));
        }
        if (reqBO.getMarketPriceEnd() != null) {
            uccSkuhasBeenapprovalPO.setMarketPriceEnd(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getMarketPriceEnd())));
        }
        if (reqBO.getDiscountStar() != null) {
            uccSkuhasBeenapprovalPO.setDiscountStar(reqBO.getDiscountStar());
        }
        if (reqBO.getDiscountEnd() != null) {
            uccSkuhasBeenapprovalPO.setDiscountEnd(reqBO.getDiscountEnd());
        }
        if (reqBO.getCatalogId4() != null || reqBO.getCatalogId3() != null || reqBO.getCatalogId2() != null || reqBO.getCatalogId1() != null) {
            UccEMdmCatalogPO uccEMdmCatalogPO = new UccEMdmCatalogPO();
            uccEMdmCatalogPO.setCatalogId1(reqBO.getCatalogId1());
            uccEMdmCatalogPO.setCatalogId2(reqBO.getCatalogId2());
            uccEMdmCatalogPO.setCatalogId3(reqBO.getCatalogId3());
            uccEMdmCatalogPO.setCatalogId4(reqBO.getCatalogId4());
            List catalog4Ids = this.uccEMdmCatalogMapper.qryFourLevelCatalog(uccEMdmCatalogPO);
            if (!CollectionUtils.isEmpty((Collection)catalog4Ids)) {
                List commodityTypeIds = this.uccCommodityTypeMapper.qeryTypeIdByCatalogIds(catalog4Ids);
                uccSkuhasBeenapprovalPO.setCommodityTypeIds(commodityTypeIds);
            }
        }
        List uccskuManagementPOList = this.uccSkuMapper.queryHasBeenApprovalSku(skuIds, uccSkuhasBeenapprovalPO, brands, page);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        if (!CollectionUtils.isEmpty((Collection)uccskuManagementPOList)) {
            List uccEMdmCatalogPOList;
            HashSet brandList = new HashSet();
            uccskuManagementPOList.stream().filter(a -> brandList.add(a.getBrandId()));
            Map<Long, List<UccMallBrandRelPO>> goupBrand = null;
            if (!CollectionUtils.isEmpty(brandList)) {
                List getRelByBrandList = this.uccMallBrandRelMapper.getRelByBrandList(new ArrayList(brandList));
                goupBrand = getRelByBrandList.stream().collect(Collectors.groupingBy(UccMallBrandRelPO::getBrandId));
            }
            ArrayList<UccSkuManagementListQryBO> rows = new ArrayList<UccSkuManagementListQryBO>();
            List skus = uccskuManagementPOList.stream().map(UccSkuManagementPO::getSkuId).collect(Collectors.toList());
            List catalogs = uccskuManagementPOList.stream().map(UccSkuManagementPO::getL4mgCategoryId).collect(Collectors.toList());
            Map<Object, Object> catalogMap = new HashMap();
            Map<Object, Object> catalogCodeMap = new HashMap();
            if (!CollectionUtils.isEmpty(catalogs) && !CollectionUtils.isEmpty((Collection)(uccEMdmCatalogPOList = this.uccEMdmCatalogMapper.queryByCatIds(catalogs)))) {
                catalogMap = uccEMdmCatalogPOList.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCatalogId, UccEMdmCatalogPO::getCatalogName));
                catalogCodeMap = uccEMdmCatalogPOList.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCatalogId, UccEMdmCatalogPO::getCatalogCode));
            }
            ArrayList uccSkuStockBOS = new ArrayList();
            Map getStockMap = new HashMap();
            try {
                SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
                smcsdkQryStockNumReqBO.setSkuIds((List)Lists.newArrayList(skus));
                SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
                log.info("\u7b80\u7248\u5e93\u5b58\uff1a" + JSONObject.toJSONString((Object)smcsdkQryStockNumRspBO));
                if (!"0000".equals(smcsdkQryStockNumRspBO.getRespCode())) {
                    log.error("\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
                    throw new BusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_QRY_FAIL.code(), "\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
                }
                getStockMap = smcsdkQryStockNumRspBO.getSkuStockNumMap();
            }
            catch (Exception e2) {
                log.error(e2.getMessage());
                throw new ZTBusinessException(e2.getMessage());
            }
            DicDictionaryPo dicDictionaryPo = null;
            for (UccSkuManagementPO each : uccskuManagementPOList) {
                UccSkuManagementListQryBO bo = new UccSkuManagementListQryBO();
                BeanUtils.copyProperties((Object)each, (Object)bo);
                bo.setCatalogId(each.getL4mgCategoryId());
                if (catalogMap.containsKey(each.getL4mgCategoryId())) {
                    bo.setL4mgCategoryName((String)catalogMap.get(each.getL4mgCategoryId()));
                    UccQueryMaterialClassifyReqBO cnncUccQueryMaterialClassifyReqBO = new UccQueryMaterialClassifyReqBO();
                    cnncUccQueryMaterialClassifyReqBO.setCommodityTypeId(bo.getCommodityTypeId());
                    UccQueryMaterialClassifyRspBO cnncUccQueryMaterialClassifyRspBO = this.uccQueryMaterialClassifyService.queryMaterialClassify(cnncUccQueryMaterialClassifyReqBO);
                    if ("0000".equals(cnncUccQueryMaterialClassifyRspBO.getRespCode())) {
                        bo.setCatalogName(cnncUccQueryMaterialClassifyRspBO.getCatalogName());
                    }
                }
                if (catalogCodeMap.containsKey(each.getL4mgCategoryId())) {
                    bo.setL4mgCategoryCode((String)catalogCodeMap.get(each.getL4mgCategoryId()));
                }
                if (getStockMap != null && !getStockMap.isEmpty() && getStockMap.containsKey(each.getSkuId())) {
                    bo.setTotalNum(MoneyUtils.haoToYuan((Long)((Long)getStockMap.get(each.getSkuId()))));
                }
                if (each.getApprovalStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getApprovalStatus().toString(), SkuEnum.SKU_APPROVAL_STATUS.toString())) != null) {
                    bo.setApprovalStatusDesc(dicDictionaryPo.getTitle());
                }
                if (each.getCommodityStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getCommodityStatus().toString(), CommodityEnum.COMMODITY_STATUS.toString())) != null) {
                    bo.setCommodityStatusDesc(dicDictionaryPo.getTitle());
                }
                if (each.getApprovalStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getApprovalStatus()), SkuEnum.SKU_APPROVAL_STATUS.toString())) != null) {
                    bo.setApprovalStatusDesc(dicDictionaryPo.getTitle());
                }
                if (each.getSkuStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuStatus().toString(), SkuEnum.SKU_STATUS.toString())) != null) {
                    bo.setSkuStatusDesc(dicDictionaryPo.getTitle());
                }
                if (each.getGovernStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getGovernStatus().toString(), SkuEnum.GOVERN_STATUS.toString())) != null) {
                    bo.setGovernStatusStr(dicDictionaryPo.getTitle());
                }
                if (goupBrand != null && !goupBrand.isEmpty() && goupBrand.containsKey(each.getBrandId())) {
                    each.setBrandId(goupBrand.get(each.getBrandId()).get(0).getMallBrandId());
                    each.setBrandName(goupBrand.get(each.getBrandId()).get(0).getMallBrandName());
                }
                if (each.getAgreementPrice() != null) {
                    bo.setAgreementPrice(MoneyUtils.haoToYuan((Long)each.getAgreementPrice()));
                }
                if (each.getSalePrice() != null) {
                    bo.setSalePrice(MoneyUtils.haoToYuan((Long)each.getSalePrice()));
                }
                if (each.getMarketPrice() != null) {
                    bo.setMarketPrice(MoneyUtils.haoToYuan((Long)each.getMarketPrice()));
                }
                if (each.getSwitchOn() == 1 && !CollectionUtils.isEmpty((Collection)each.getLadderPrice())) {
                    ArrayList<UccLadderPriceBO> ladderPrice = new ArrayList<UccLadderPriceBO>();
                    for (UccLadderPricePO price : each.getLadderPrice()) {
                        UccLadderPriceBO uccLadderPriceBO = new UccLadderPriceBO();
                        BeanUtils.copyProperties((Object)price, (Object)uccLadderPriceBO);
                        if (price.getStart() != null) {
                            if (price.getStart() != 0L) {
                                uccLadderPriceBO.setStart(MoneyUtils.haoToYuan((Long)price.getStart()));
                            } else {
                                uccLadderPriceBO.setStart(new BigDecimal("0"));
                            }
                        }
                        if (price.getStop() != null) {
                            uccLadderPriceBO.setStop(MoneyUtils.haoToYuan((Long)price.getStop()));
                        }
                        if (price.getPrice() != null) {
                            uccLadderPriceBO.setPrice(MoneyUtils.haoToYuan((Long)price.getPrice()));
                        }
                        ladderPrice.add(uccLadderPriceBO);
                    }
                    bo.setLadderPriceInfo(ladderPrice);
                } else {
                    bo.setLadderPriceInfo(null);
                }
                if (!StringUtils.isEmpty((Object)each.getMarking())) {
                    bo.setMarkingStr("1".equals(each.getMarking()) ? "\u5df2\u6253\u6807" : "\u672a\u6253\u6807");
                }
                bo.setXcCategory(StringUtils.isEmpty((Object)bo.getExpand8()) ? "0" : bo.getExpand8());
                bo.setXcSku(StringUtils.isEmpty((Object)bo.getExpand9()) ? "0" : bo.getExpand9());
                if (!StringUtils.isEmpty((Object)bo.getXcCategory())) {
                    bo.setXcCategoryStr("1".equals(bo.getXcCategory()) ? "\u662f" : "\u5426");
                }
                if (!StringUtils.isEmpty((Object)bo.getXcSku())) {
                    bo.setXcSkuStr("1".equals(bo.getXcSku()) ? "\u662f" : "\u5426");
                }
                rows.add(bo);
            }
            rspBO.setRows(rows);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

