/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.enumType.GuideCatalogEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.ability.api.UccReadRedisCatalogAbilityService;
import com.tydic.commodity.common.ability.bo.UccCatalogUpdateReqBO;
import com.tydic.commodity.common.ability.bo.UccCatalogUpdateRspBO;
import com.tydic.commodity.common.ability.bo.UccReadRdisCategoryQryReqBO;
import com.tydic.commodity.common.busi.api.UccCatalogUpdateBusiService;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccRelChannelCatalogMapper;
import com.tydic.commodity.po.UccCatalogDealPO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccCatalogUpdateBusiServiceImpl
implements UccCatalogUpdateBusiService {
    @Autowired
    private UccCatalogDealMapper mapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogUpdateBusiServiceImpl.class);
    @Autowired
    private UccRelChannelCatalogMapper uccRelChannelCatalogMapper;
    @Autowired
    private UccReadRedisCatalogAbilityService uccReadRedisCatalogAbilityService;
    UccCatalogUpdateRspBO rspBO = new UccCatalogUpdateRspBO();

    @Override
    public UccCatalogUpdateRspBO updateCatalog(UccCatalogUpdateReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        if (reqBO.getViewOrder() != null) {
            this.modifyOrder(reqBO);
        }
        this.rspBO = new UccCatalogUpdateRspBO();
        UccCatalogDealPO catalogDealPO = new UccCatalogDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)catalogDealPO);
        UccCatalogDealPO po = new UccCatalogDealPO();
        po.setGuideCatalogId(reqBO.getGuideCatalogId());
        po.setCatalogName(reqBO.getCatalogName());
        po.setUpperCatalogId(reqBO.getUpperCatalogId());
        List uccCatalogDealPOS = this.mapper.queryCatalogBy(po);
        if (!CollectionUtils.isEmpty((Collection)uccCatalogDealPOS)) {
            throw new BusinessException("8888", "\u60a8\u8f93\u5165\u7684\u5546\u54c1\u7c7b\u76ee\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5");
        }
        UccCatalogDealPO po1 = new UccCatalogDealPO();
        po1.setGuideCatalogId(reqBO.getUpperCatalogId());
        List uccCatalogDealPOS1 = this.mapper.queryCatalog(po1);
        if (!CollectionUtils.isEmpty((Collection)uccCatalogDealPOS1) && ((UccCatalogDealPO)uccCatalogDealPOS1.get(0)).getCatalogName().equals(reqBO.getCatalogName())) {
            throw new BusinessException("8888", "\u60a8\u8f93\u5165\u7684\u5546\u54c1\u7c7b\u76ee\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5");
        }
        int result = 0;
        try {
            result = this.mapper.updateCatalog(catalogDealPO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u4fee\u6539\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (result > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u4fee\u6539\u7c7b\u76ee\u6210\u529f");
            List chanelList = this.uccRelChannelCatalogMapper.selectChanelListByguideCatalogId(reqBO.getGuideCatalogId());
            if (!CollectionUtils.isEmpty((Collection)chanelList)) {
                UccReadRdisCategoryQryReqBO uccReadRdisCategoryQryReqBO = null;
                for (Long each : chanelList) {
                    uccReadRdisCategoryQryReqBO = new UccReadRdisCategoryQryReqBO();
                    uccReadRdisCategoryQryReqBO.setRedisKey(each.toString());
                    this.uccReadRedisCatalogAbilityService.clearCatagoryRedis(uccReadRdisCategoryQryReqBO);
                }
            }
        } else {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u4fee\u6539\u7c7b\u76ee\u5931\u8d25");
        }
        return this.rspBO;
    }

    public boolean judge(UccCatalogUpdateReqBO reqBO) {
        Map map = null;
        if (reqBO.getGuideCatalogId() == null) {
            this.rspBO.setRespDesc("\u7c7b\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        UccCatalogDealPO po = new UccCatalogDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        if (this.mapper.selectCatalogById(po) == null) {
            this.rspBO.setRespDesc("\u7c7b\u76eeID\u4e0d\u5b58\u5728");
            return false;
        }
        if (reqBO.getCatalogStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(GuideCatalogEnum.GUIDE_CATALOG_STATUS.toString())).containsKey(String.valueOf(reqBO.getCatalogStatus()))) {
            this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u72b6\u6001");
            return false;
        }
        return true;
    }

    public void modifyOrder(UccCatalogUpdateReqBO reqBO) {
        try {
            UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
            uccCatalogDealPO.setGuideCatalogId(reqBO.getGuideCatalogId());
            uccCatalogDealPO = this.mapper.selectCatalogById(uccCatalogDealPO);
            if (uccCatalogDealPO != null) {
                Integer viewOrder = uccCatalogDealPO.getViewOrder();
                if (reqBO.getOrderConfSolution() != null) {
                    uccCatalogDealPO = new UccCatalogDealPO();
                    uccCatalogDealPO.setUpperCatalogId(reqBO.getUpperCatalogId());
                    uccCatalogDealPO.setViewOrder(reqBO.getViewOrder());
                    uccCatalogDealPO.setChannelId(reqBO.getChannelId());
                    if (reqBO.getOrderConfSolution() == 0) {
                        this.mapper.modifyOrder(uccCatalogDealPO);
                    } else if (reqBO.getOrderConfSolution() == 1) {
                        this.mapper.modifyOrderByViewOrder(reqBO.getViewOrder(), viewOrder, uccCatalogDealPO);
                    } else {
                        reqBO.setViewOrder(Integer.valueOf(0));
                    }
                } else {
                    UccCatalogDealPO uccCatalogDealPO1 = new UccCatalogDealPO();
                    uccCatalogDealPO1.setCatalogLevel(uccCatalogDealPO.getCatalogLevel());
                    uccCatalogDealPO1.setChannelId(uccCatalogDealPO.getChannelId());
                    uccCatalogDealPO1.setOrderStr("VIEW_ORDER DESC");
                    List uccCatalogDealPOS = this.mapper.queryCatalog(uccCatalogDealPO1);
                    if (!CollectionUtils.isEmpty((Collection)uccCatalogDealPOS)) {
                        if (((UccCatalogDealPO)uccCatalogDealPOS.get(0)).getViewOrder() != null) {
                            reqBO.setViewOrder(Integer.valueOf(((UccCatalogDealPO)uccCatalogDealPOS.get(0)).getViewOrder() + 1));
                        } else {
                            reqBO.setViewOrder(Integer.valueOf(0));
                        }
                    } else {
                        reqBO.setViewOrder(Integer.valueOf(0));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }
}

