/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsRspBO;
import com.tydic.commodity.common.ability.api.UccSyncSceneCommodityToEsAbilityService;
import com.tydic.commodity.common.busi.api.UccModitySupNameItemBusiService;
import com.tydic.commodity.common.busi.bo.UccModitySupNameItemBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccModitySupNameItemBusiRspBO;
import com.tydic.commodity.dao.UccModitySupItemMapper;
import com.tydic.commodity.po.UccModitySupItemPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccModitySupNameItemBusiServiceImpl
implements UccModitySupNameItemBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccModitySupNameItemBusiServiceImpl.class);
    @Autowired
    private UccModitySupItemMapper uccModitySupItemMapper;
    @Autowired
    private UccSyncSceneCommodityToEsAbilityService uccSyncSceneCommodityToEsAbilityService;
    private static final List<String> TABLE_LIST = Lists.newArrayList((Object[])new String[]{"ucc_sku", "ucc_commodity", "ucc_complaint_sku"});
    private static final Map<String, String> TABLE_PK_MAP = ImmutableMap.of((Object)"ucc_sku", (Object)"sku_id", (Object)"ucc_commodity", (Object)"commodity_id", (Object)"ucc_complaint_sku", (Object)"COMPLAINT_ID");
    @Resource(name="asyncModifySupNameExecutor")
    private Executor asyncModifySupNameExecutor;
    private static final int BATCH_SIZE = 1000;

    @Override
    public UccModitySupNameItemBusiRspBO modifySupNameItem(UccModitySupNameItemBusiReqBO reqBO) {
        UccModitySupNameItemBusiRspBO rspBO = new UccModitySupNameItemBusiRspBO();
        UccModitySupItemPO updatePO = new UccModitySupItemPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)updatePO);
        UccModitySupItemPO qryModitySupItemPO = new UccModitySupItemPO();
        qryModitySupItemPO.setBatchId(reqBO.getBatchId());
        int check = this.uccModitySupItemMapper.getCheckBy(qryModitySupItemPO);
        if (check > 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u6279\u6b21\u53f7\u5df2\u5b58\u5728\uff0c\u8bef\u91cd\u590d\u63d0\u4ea4");
            return rspBO;
        }
        ArrayList<UccModitySupItemPO> list = new ArrayList<UccModitySupItemPO>();
        Date updateTime = new Date();
        int updateCount = this.uccModitySupItemMapper.updateSupplier(updatePO);
        if (updateCount <= 0) {
            log.info("\u4fee\u6539ucc_supplier\u8868\u5931\u8d25");
        } else {
            UccModitySupItemPO supplierPO = new UccModitySupItemPO();
            supplierPO.setBatchId(reqBO.getBatchId());
            supplierPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            supplierPO.setTableName("ucc_supplier");
            supplierPO.setTableId(reqBO.getSupId());
            supplierPO.setUpdateTime(updateTime);
            supplierPO.setExpand1("1");
            list.add(supplierPO);
        }
        int vendorCount = this.uccModitySupItemMapper.updateVendor(updatePO);
        if (vendorCount <= 0) {
            log.info("\u4fee\u6539ucc_vendor\u8868\u5931\u8d25");
        } else {
            UccModitySupItemPO vendorPO = new UccModitySupItemPO();
            vendorPO.setBatchId(reqBO.getBatchId());
            vendorPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            vendorPO.setTableName("ucc_vendor");
            vendorPO.setTableId(reqBO.getSupId());
            vendorPO.setUpdateTime(updateTime);
            vendorPO.setExpand1("1");
            list.add(vendorPO);
        }
        this.uccModitySupItemMapper.insertBatch(list);
        CompletableFuture.runAsync(() -> this.create(reqBO.getBatchId(), reqBO.getSupId()), this.asyncModifySupNameExecutor).thenRunAsync(() -> this.update(reqBO.getBatchId(), reqBO.getUpdatedSupName(), reqBO.getSupId()), this.asyncModifySupNameExecutor);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void create(Long batchId, Long supId) {
        Date updateTime = new Date();
        for (String tableName : TABLE_LIST) {
            List rows;
            Long lastId = 0L;
            do {
                if ((rows = this.uccModitySupItemMapper.getSupplierNameItemList(tableName, TABLE_PK_MAP.get(tableName), supId, lastId, 1000)).isEmpty()) continue;
                List tasks = rows.stream().map(row -> {
                    UccModitySupItemPO task = new UccModitySupItemPO();
                    task.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    task.setBatchId(batchId);
                    task.setTableId(task.getTableId());
                    task.setTableName(tableName);
                    task.setSupId(row.getSupId());
                    task.setUpdateTime(updateTime);
                    task.setExpand1("0");
                    return task;
                }).collect(Collectors.toList());
                this.uccModitySupItemMapper.insertBatch(tasks);
                lastId = ((UccModitySupItemPO)rows.get(rows.size() - 1)).getTableId();
            } while (!rows.isEmpty());
        }
    }

    public void update(Long batchId, String updatedSupName, Long supId) {
        ArrayList skuIds = new ArrayList();
        for (String tableName : TABLE_LIST) {
            List tasks;
            do {
                if ((tasks = this.uccModitySupItemMapper.getSupplierNameItemListByBatchId(tableName, batchId, 1000)).isEmpty()) continue;
                List ids = tasks.stream().map(UccModitySupItemPO::getId).collect(Collectors.toList());
                List tableIds = tasks.stream().map(UccModitySupItemPO::getTableId).collect(Collectors.toList());
                switch (tableName) {
                    case "ucc_sku": {
                        this.uccModitySupItemMapper.updateSkuSupplierName(tableIds, updatedSupName);
                        skuIds.addAll(tableIds);
                        break;
                    }
                    case "ucc_commodity": {
                        this.uccModitySupItemMapper.updateCommoditySupplierName(tableIds, updatedSupName);
                        break;
                    }
                    case "ucc_complaint_sku": {
                        this.uccModitySupItemMapper.updateComplaintSkuSupplierName(tableIds, updatedSupName);
                    }
                }
                this.uccModitySupItemMapper.updateStatus(ids);
            } while (!tasks.isEmpty());
        }
        if (!CollectionUtils.isEmpty(skuIds)) {
            int groupSize = 100;
            List groupedSkuIds = IntStream.range(0, skuIds.size()).boxed().collect(Collectors.groupingBy(index -> index / groupSize)).values().stream().map(indices -> indices.stream().map(skuIds::get).collect(Collectors.toList())).collect(Collectors.toList());
            for (List idss : groupedSkuIds) {
                try {
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setOperType(Integer.valueOf(0));
                    syncSceneCommodityToEsReqBO.setSingleType(0);
                    syncSceneCommodityToEsReqBO.setSupplierId(supId);
                    syncSceneCommodityToEsReqBO.setSyncType(Integer.valueOf(4));
                    syncSceneCommodityToEsReqBO.setSkuIds(idss);
                    log.info("\u5546\u54c1\u540c\u6b65\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)syncSceneCommodityToEsReqBO));
                    SyncSceneCommodityToEsRspBO syncSceneCommodityToEsRspBO = this.uccSyncSceneCommodityToEsAbilityService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                    log.info("\u5546\u54c1\u540c\u6b65\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)syncSceneCommodityToEsRspBO));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u4f9b\u5e94\u5546id\u4e3a\uff1a{}\u7684\u5546\u54c1\u540c\u6b65\u5931\u8d25\uff01", (Object)supId);
                }
            }
        }
    }
}

