/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.api.AgrQryAgreementByPageAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementByPageAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementByPageAbilityRspBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSkuPoolSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuPoolSkuListQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccTenantSkuImportBO;
import com.tydic.commodity.common.busi.api.UccAddTenantSkuImportListBusiService;
import com.tydic.commodity.common.busi.bo.UccAddTenantSkuImportListReqBO;
import com.tydic.commodity.common.busi.bo.UccAddTenantSkuImportListRspBO;
import com.tydic.commodity.common.busi.bo.queryCpNotRelateCommodityListTestReqBO;
import com.tydic.commodity.common.utils.ExcelNewUtils;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccTenantSkuImportMapper;
import com.tydic.commodity.po.UccTenantSkuImportPO;
import com.tydic.umc.general.ability.api.UmcQryTenantCommodityListAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryTenantCommodityListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryTenantCommodityListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccAddTenantSkuImportListBusiServiceImpl
implements UccAddTenantSkuImportListBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccAddTenantSkuImportListBusiServiceImpl.class);
    @Autowired
    UccTenantSkuImportMapper uccTenantSkuImportMapper;
    @Autowired
    UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuPoolSkuListQryAbilityService uccSkuPoolSkuListQryAbilityService;
    @Autowired
    private AgrQryAgreementByPageAbilityService agrQryAgreementByPageAbilityService;
    @Autowired
    private UmcQryTenantCommodityListAbilityService umcQryTenantCommodityListAbilityService;

    @Override
    public UccAddTenantSkuImportListRspBO addTenantSkuImportList(UccAddTenantSkuImportListReqBO reqBo) {
        UccAddTenantSkuImportListRspBO rspBo = new UccAddTenantSkuImportListRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (reqBo.getSysTenantIdWeb() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("SysTenantIdWeb\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (reqBo.getPoolId() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5546\u54c1\u6c60ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (reqBo.getReqId() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        UccTenantSkuImportPO deletePO = new UccTenantSkuImportPO();
        deletePO.setReqId(reqBo.getReqId());
        this.uccTenantSkuImportMapper.delete(deletePO);
        if (StringUtils.isEmpty((Object)reqBo.getUrl())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5fc5\u4f20Url\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        List<UccTenantSkuImportBO> importBOList = this.getDemandList(reqBo.getUrl());
        if (CollectionUtils.isEmpty(importBOList)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBo;
        }
        ArrayList<Long> commodityIdList = new ArrayList<Long>();
        for (UccTenantSkuImportBO importBO : importBOList) {
            importBO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            importBO.setReqId(reqBo.getReqId());
            if (StringUtils.isEmpty((Object)importBO.getSkuCode())) {
                importBO.setFialReason("e\u8d2d\u5355\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
                importBO.setStatus(Integer.valueOf(0));
            }
            commodityIdList.add(importBO.getCommodityId());
        }
        queryCpNotRelateCommodityListTestReqBO testCopyBo = (queryCpNotRelateCommodityListTestReqBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)), queryCpNotRelateCommodityListTestReqBO.class));
        List<Long> checkList = this.checkImportBOList(commodityIdList, testCopyBo);
        List sourceIds = this.uccRelPoolCommodityMapper.qryConnectionSourceIds(commodityIdList, reqBo.getPoolId());
        for (UccTenantSkuImportBO importBO : importBOList) {
            if (!checkList.contains(importBO.getCommodityId())) {
                if (importBO.getFialReason() == null) {
                    importBO.setFialReason("\u8d85\u51fa\u79df\u6237\u5408\u4f5c\u54c1\u7c7b\u8303\u56f4\u5185;");
                } else {
                    importBO.setFialReason(importBO.getFialReason() + "\u8d85\u51fa\u79df\u6237\u5408\u4f5c\u54c1\u7c7b\u8303\u56f4\u5185;");
                }
                importBO.setStatus(Integer.valueOf(0));
            }
            if (!sourceIds.contains(importBO.getCommodityId())) continue;
            if (importBO.getFialReason() == null) {
                importBO.setFialReason("\u8be5\u5546\u54c1\u5df2\u5173\u8054;");
            } else {
                importBO.setFialReason(importBO.getFialReason() + "\u8be5\u5546\u54c1\u5df2\u5173\u8054;");
            }
            importBO.setStatus(Integer.valueOf(0));
        }
        List importPOList = JSON.parseArray((String)JSON.toJSONString(importBOList), UccTenantSkuImportPO.class);
        this.uccTenantSkuImportMapper.insertAll(importPOList);
        return rspBo;
    }

    private List<Long> checkImportBOList(List<Long> commodityIdList, queryCpNotRelateCommodityListTestReqBO testCopyBo) {
        Integer agreementClassification = null;
        Integer agreementSignSupplier = null;
        if (testCopyBo.getPoolType() == null) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (testCopyBo.getPoolType() == 1) {
            agreementClassification = 1;
        } else if (testCopyBo.getPoolType() == 2) {
            agreementClassification = 2;
        } else if (testCopyBo.getPoolType() == 3) {
            agreementClassification = 3;
        } else if (testCopyBo.getPoolType() == 4) {
            agreementSignSupplier = 1;
        } else if (testCopyBo.getPoolType() == 5) {
            agreementClassification = 1;
        }
        UccSkuPoolSkuListQryAbilityReqBo cnncSkuPoolSkuListQryAbilityReqBo = new UccSkuPoolSkuListQryAbilityReqBo();
        BeanUtils.copyProperties((Object)((Object)testCopyBo), (Object)cnncSkuPoolSkuListQryAbilityReqBo);
        cnncSkuPoolSkuListQryAbilityReqBo.setSearchType(Integer.valueOf(0));
        cnncSkuPoolSkuListQryAbilityReqBo.setType(1);
        cnncSkuPoolSkuListQryAbilityReqBo.setOutType(testCopyBo.getOutType());
        List<Object> agreementIds = new ArrayList();
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)testCopyBo.getAgreementName()) || testCopyBo.getAgreementId() != null || !org.apache.commons.lang.StringUtils.isEmpty((String)testCopyBo.getOtherSourceCode()) || testCopyBo.getSysTenantIdWeb() != null) {
            AgrQryAgreementByPageAbilityReqBO agrQryAgreementByPageAbilityReqBO = new AgrQryAgreementByPageAbilityReqBO();
            agrQryAgreementByPageAbilityReqBO.setAgreementNameLike(testCopyBo.getAgreementName());
            if (testCopyBo.getAgreementId() != null) {
                agrQryAgreementByPageAbilityReqBO.setAgreementIds((List)Lists.newArrayList((Object[])new Long[]{testCopyBo.getAgreementId()}));
            }
            if (testCopyBo.getSysTenantIdWeb() != null) {
                agrQryAgreementByPageAbilityReqBO.setSysTenantIdWeb(testCopyBo.getSysTenantIdWeb());
            }
            agrQryAgreementByPageAbilityReqBO.setPageQueryFlag(Boolean.valueOf(false));
            agrQryAgreementByPageAbilityReqBO.setAgreementClassification(agreementClassification);
            agrQryAgreementByPageAbilityReqBO.setPlaAgreementCode(testCopyBo.getOtherSourceCode());
            agrQryAgreementByPageAbilityReqBO.setAgreementSignSupplier(agreementSignSupplier);
            AgrQryAgreementByPageAbilityRspBO agrQryAgreementByPageAbilityRspBO = this.agrQryAgreementByPageAbilityService.qryAgreementInfoByPage(agrQryAgreementByPageAbilityReqBO);
            if ("0000".equals(agrQryAgreementByPageAbilityRspBO.getRespCode())) {
                if (!CollectionUtils.isEmpty((Collection)agrQryAgreementByPageAbilityRspBO.getRows())) {
                    agreementIds = agrQryAgreementByPageAbilityRspBO.getRows().stream().map(AgrAgreementBO::getAgreementId).collect(Collectors.toList());
                }
            } else {
                throw new BusinessException("8888", agrQryAgreementByPageAbilityRspBO.getRespDesc());
            }
        }
        List catagoryIdList = new ArrayList();
        if (testCopyBo.getSysTenantIdWeb() != null) {
            UmcQryTenantCommodityListAbilityReqBO umcQryTenantCommodityListAbilityReqBO = new UmcQryTenantCommodityListAbilityReqBO();
            umcQryTenantCommodityListAbilityReqBO.setSysTenantIdWeb(testCopyBo.getSysTenantIdWeb());
            UmcQryTenantCommodityListAbilityRspBO umcQryTenantCommodityListAbilityRspBO = this.umcQryTenantCommodityListAbilityService.qryTenantCommodityList(umcQryTenantCommodityListAbilityReqBO);
            if ("0000".equals(umcQryTenantCommodityListAbilityRspBO.getRespCode())) {
                catagoryIdList = umcQryTenantCommodityListAbilityRspBO.getCatagoryIdList();
            } else {
                throw new ZTBusinessException(umcQryTenantCommodityListAbilityRspBO.getRespDesc());
            }
        }
        if (CollectionUtils.isEmpty(agreementIds) && CollectionUtils.isEmpty(catagoryIdList)) {
            return new ArrayList<Long>();
        }
        List skuIds = this.uccCommodityMapper.selectIsCanSelectSkuIds(agreementIds, catagoryIdList, commodityIdList);
        return skuIds;
    }

    private List<UccTenantSkuImportBO> getDemandList(String url) {
        List<Object> data = new ArrayList();
        try {
            data = this.dealEcxel(url, 2, 0, 9);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 1;
        ArrayList<UccTenantSkuImportBO> demandImportBOList = new ArrayList<UccTenantSkuImportBO>();
        try {
            if (!CollectionUtils.isEmpty(data)) {
                for (List list : data) {
                    Object commodityIdObj;
                    Object vendorName;
                    Object brandName;
                    Object commodityTypeName;
                    Object otherSourceCode;
                    Object extSkuCode;
                    Object commodityCode;
                    Object skuCode;
                    Object skuName;
                    ++rowNum;
                    UccTenantSkuImportBO demandImportBO = new UccTenantSkuImportBO();
                    int i = 0;
                    if (!StringUtils.isEmpty((Object)(skuName = list.get(i++)).toString())) {
                        demandImportBO.setSkuName(skuName.toString());
                    }
                    if (!StringUtils.isEmpty((Object)(skuCode = list.get(i++)).toString())) {
                        demandImportBO.setSkuCode(skuCode.toString());
                    }
                    if (!StringUtils.isEmpty((Object)(commodityCode = list.get(i++)).toString())) {
                        demandImportBO.setCommodityCode(commodityCode.toString());
                    }
                    if (!StringUtils.isEmpty((Object)(extSkuCode = list.get(i++)).toString())) {
                        demandImportBO.setExtSkuCode(extSkuCode.toString());
                    }
                    if (!StringUtils.isEmpty((Object)(otherSourceCode = list.get(i++)).toString())) {
                        demandImportBO.setOtherSourceCode(otherSourceCode.toString());
                    }
                    if (!StringUtils.isEmpty((Object)(commodityTypeName = list.get(i++)).toString())) {
                        demandImportBO.setCommodityTypeName(commodityTypeName.toString());
                    }
                    if (!StringUtils.isEmpty((Object)(brandName = list.get(i++)).toString())) {
                        demandImportBO.setBrandName(brandName.toString());
                    }
                    if (!StringUtils.isEmpty(vendorName = list.get(i++))) {
                        demandImportBO.setVendorName(vendorName.toString());
                    }
                    if (!StringUtils.isEmpty(commodityIdObj = list.get(i++))) {
                        Long commodityId = Long.parseLong((String)commodityIdObj);
                        demandImportBO.setCommodityId(commodityId);
                    }
                    demandImportBOList.add(demandImportBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return demandImportBOList;
    }

    private List<List<Object>> dealEcxel(String url, Integer startReadLine, Integer sheetAt, Integer inndex) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<Object>>();
        }
        ArrayList<List<Object>> lines = new ArrayList<List<Object>>();
        try {
            ExcelNewUtils.getExcelDateIndex(url, lines, startReadLine, sheetAt, inndex);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }
}

