/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.common.ability.bo.UccEbsMatertialRelSkuTimeTaskAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEbsMatertialRelSkuTimeTaskAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccEbsMatertialRelSkuTimeTaskBusiService;
import com.tydic.commodity.dao.UccEbsMaterialMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccEbsMaterialPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccEbsMatertialRelSkuTimeTaskBusiServiceImpl
implements UccEbsMatertialRelSkuTimeTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccEbsMatertialRelSkuTimeTaskBusiServiceImpl.class);
    @Autowired
    private UccEbsMaterialMapper uccEbsMaterialMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccEbsMatertialRelSkuTimeTaskAbilityRspBO updateEbsMatertialRelSku(UccEbsMatertialRelSkuTimeTaskAbilityReqBO reqBO) {
        UccEbsMatertialRelSkuTimeTaskAbilityRspBO rspBO = new UccEbsMatertialRelSkuTimeTaskAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccEbsMaterialPO uccEbsMaterialPO = new UccEbsMaterialPO();
        uccEbsMaterialPO.setRelationStatus(Integer.valueOf(1));
        uccEbsMaterialPO.setMaterialIds(reqBO.getMaterialIds());
        List uccEbsMaterialPOList = this.uccEbsMaterialMapper.getListPage(uccEbsMaterialPO, page);
        if (CollectionUtils.isEmpty((Collection)uccEbsMaterialPOList)) {
            return rspBO;
        }
        uccEbsMaterialPOList = uccEbsMaterialPOList.stream().filter(a -> !"CRC_XH".equals(a.getSkuCode())).collect(Collectors.toList());
        Map uccEbsMaterialPOMap = uccEbsMaterialPOList.stream().collect(Collectors.toMap(UccEbsMaterialPO::getEbsMaterialId, Function.identity()));
        log.info("---------------\u5df2\u5173\u8054\u7684\u5916\u90e8\u7269\u6599id\uff1a" + JSON.toJSONString(uccEbsMaterialPOList.stream().map(UccEbsMaterialPO::getEbsMaterialId).collect(Collectors.toList())));
        Map<Long, List<UccEbsMaterialPO>> collect = uccEbsMaterialPOList.stream().collect(Collectors.groupingBy(UccEbsMaterialPO::getMaterialId));
        for (Long materialId : collect.keySet()) {
            List ebsMaterialIds;
            UccSkuPo UccSkuPo2 = new UccSkuPo();
            UccSkuPo2.setSkuStatus(ModelRuleConstant.SKU_STATUS_ON_SHELF);
            UccSkuPo2.setLimitOrder(Integer.valueOf(1));
            UccSkuPo2.setMaterialId(materialId.toString());
            List uccSkuPoList = this.uccSkuMapper.qrySkuList(UccSkuPo2);
            if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) continue;
            uccSkuPoList.sort(Comparator.comparing(UccSkuPo::getSalePrice));
            List thisTimeList = collect.get(materialId).stream().filter(e -> !((UccSkuPo)uccSkuPoList.get(0)).getSkuId().equals(e.getSkuId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(thisTimeList) || CollectionUtils.isEmpty(ebsMaterialIds = thisTimeList.stream().map(UccEbsMaterialPO::getEbsMaterialId).collect(Collectors.toList()))) continue;
            UccEbsMaterialPO updatePO = new UccEbsMaterialPO();
            updatePO.setEbsMaterialIds(ebsMaterialIds);
            updatePO.setSkuId(((UccSkuPo)uccSkuPoList.get(0)).getSkuId());
            log.info("--------------\u66f4\u65b0updatePO\uff1a" + JSON.toJSONString((Object)updatePO));
            this.uccEbsMaterialMapper.updateByPrimaryKeySelective(updatePO);
        }
        return rspBO;
    }
}

