/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.ECommercePriceChangeMapper;
import com.tydic.commodity.estore.ability.api.SyncECommercePriceToEsAbilityService;
import com.tydic.commodity.estore.ability.bo.SyncECommercePriceToEsAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.SyncECommercePriceToEsAbilityRspBO;
import com.tydic.commodity.estore.atom.api.SyncECommercePriceToEsAtomService;
import com.tydic.commodity.estore.atom.bo.SyncECommercePriceToEsAtomReqBo;
import com.tydic.commodity.estore.atom.bo.SyncECommercePriceToEsAtomRspBO;
import com.tydic.commodity.po.ECommercePriceChangePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.SyncECommercePriceToEsAbilityService"})
public class SyncECommercePriceToEsAbilityServiceImpl
implements SyncECommercePriceToEsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SyncECommercePriceToEsAbilityServiceImpl.class);
    private Integer syncSize = 200;
    @Resource(name="syncCommercePriceChangeProvider")
    private ProxyMessageProducer syncCommercePriceChangeProvider;
    @Value(value="${COMMERCE_PRICE_UCC_SYNC_TOPIC}")
    private String commercePriceSyncTopic;
    @Autowired
    private ECommercePriceChangeMapper eCommercePriceChangeMapper;
    @Autowired
    private SyncECommercePriceToEsAtomService syncECommercePriceToEsAtomService;

    @PostMapping(value={"syncEs"})
    public SyncECommercePriceToEsAbilityRspBO syncEs(@RequestBody SyncECommercePriceToEsAbilityReqBO reqBo) {
        SyncECommercePriceToEsAbilityRspBO rspBO = new SyncECommercePriceToEsAbilityRspBO();
        rspBO.setRespCode("0000");
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuList())) {
            if (reqBo.getSkuList().size() > this.syncSize) {
                try {
                    this.synMq(reqBo.getSkuList());
                }
                catch (Exception e) {
                    throw new BusinessException("8888", e.getMessage());
                }
            } else {
                SyncECommercePriceToEsAtomReqBo atomReqBo = new SyncECommercePriceToEsAtomReqBo();
                atomReqBo.setSkuList(reqBo.getSkuList());
                SyncECommercePriceToEsAtomRspBO atomRspBO = this.syncECommercePriceToEsAtomService.syncEs(atomReqBo);
                BeanUtils.copyProperties((Object)atomReqBo, (Object)rspBO);
            }
        } else {
            rspBO = this.syn(reqBo);
        }
        return rspBO;
    }

    private SyncECommercePriceToEsAbilityRspBO syn(SyncECommercePriceToEsAbilityReqBO reqBO) {
        List skuList;
        SyncECommercePriceToEsAbilityRspBO rspBO = new SyncECommercePriceToEsAbilityRspBO();
        Integer sizetotal = 2000;
        Page page = new Page();
        int count = 0;
        do {
            page.setPageSize(sizetotal.intValue());
            page.setPageNo(++count);
            ECommercePriceChangePO po = new ECommercePriceChangePO();
            skuList = this.eCommercePriceChangeMapper.qryECommerceSkuChange(po, page);
            if (CollectionUtils.isEmpty((Collection)skuList)) break;
            try {
                this.synMq(skuList);
            }
            catch (Exception e) {
                throw new BusinessException("8888", e.getMessage());
            }
        } while (sizetotal.compareTo(skuList.size()) <= 0);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    void synMq(List<Long> skuList) {
        List<List<Long>> result = SyncECommercePriceToEsAbilityServiceImpl.averageAssign(skuList, this.syncSize);
        result.forEach(list -> {
            SyncECommercePriceToEsAbilityReqBO syncSceneCommodityToEsReqBO = new SyncECommercePriceToEsAbilityReqBO();
            syncSceneCommodityToEsReqBO.setSkuList(list);
            try {
                this.syncCommercePriceChangeProvider.send(new ProxyMessage(this.commercePriceSyncTopic, "*", JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                throw new BusinessException("8888", e.getMessage());
            }
        });
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int splitItemNum) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (source != null && source.size() > 0 && splitItemNum > 0) {
            if (source.size() <= splitItemNum) {
                result.add(source);
            } else {
                int splitNum = source.size() % splitItemNum == 0 ? source.size() / splitItemNum : source.size() / splitItemNum + 1;
                List<T> value = null;
                for (int i = 0; i < splitNum; ++i) {
                    value = i < splitNum - 1 ? source.subList(i * splitItemNum, (i + 1) * splitItemNum) : source.subList(i * splitItemNum, source.size());
                    result.add(value);
                }
            }
        }
        return result;
    }
}

