/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.estore.ability.bo.CnncUccOauth2RspBO;
import com.tydic.commodity.estore.ability.bo.Oauth2ModifyUserReqBo;
import com.tydic.commodity.estore.ability.bo.Oauth2ModifyUserRspBo;
import com.tydic.commodity.estore.ability.bo.Oauth2addUserReqBo;
import com.tydic.commodity.estore.ability.bo.Oauth2addUserRspBo;
import com.tydic.commodity.estore.ability.bo.RefreshTokenReqBo;
import com.tydic.commodity.estore.ability.bo.RefreshTokenRspBo;
import com.tydic.commodity.estore.busi.api.Oauth2PluginUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/oauth2"})
public class CnncUccOauth2Controller {
    private static final Logger log = LoggerFactory.getLogger(CnncUccOauth2Controller.class);
    @Autowired
    private Oauth2PluginUserService oauth2PluginUserService;

    @PostMapping(value={"/addUser"})
    @BusiResponseBody
    public CnncUccOauth2RspBO<Oauth2addUserRspBo> addUser(@RequestBody Object reqBo) {
        Oauth2addUserReqBo addUserReqBo = (Oauth2addUserReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), Oauth2addUserReqBo.class);
        if (ObjectUtils.isEmpty((Object)addUserReqBo.getUsername())) {
            throw new ZTBusinessException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)addUserReqBo.getPassword())) {
            throw new ZTBusinessException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)addUserReqBo.getGrantType())) {
            throw new ZTBusinessException("\u9274\u6743\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)addUserReqBo.getClientId())) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addUserReqBo.getClientId().length() >= 13) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aefID\u8bf7\u9650\u5236\u5230\u226412\u4f4d [\u5b8c\u6574\u683c\u5f0f\uff1a\u9996\u5b57\u7b26\u4e3a\u5b57\u6bcd\uff0c\u4e0d\u5305\u542b\u4e2d\u6587\uff0c\u957f\u5ea6\u226412]");
        }
        if (!addUserReqBo.getClientId().matches("[\\x00-\\x7F]+")) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aefID\u4e0d\u80fd\u5305\u542b\u4e2d\u6587 [\u5b8c\u6574\u683c\u5f0f\uff1a\u9996\u5b57\u7b26\u4e3a\u5b57\u6bcd\uff0c\u4e0d\u5305\u542b\u4e2d\u6587\uff0c\u957f\u5ea6\u226412]");
        }
        if (!addUserReqBo.getClientId().matches("[a-zA-Z].*")) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aefID\u9996\u5b57\u7b26\u53ea\u80fd\u4e3a\u5b57\u6bcd [\u5b8c\u6574\u683c\u5f0f\uff1a\u9996\u5b57\u7b26\u4e3a\u5b57\u6bcd\uff0c\u4e0d\u5305\u542b\u4e2d\u6587\uff0c\u957f\u5ea6\u226412]");
        }
        if (ObjectUtils.isEmpty((Object)addUserReqBo.getClusterId())) {
            throw new ZTBusinessException("\u96c6\u7fa4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Oauth2addUserRspBo rsp = this.oauth2PluginUserService.addUser(addUserReqBo);
        if (Boolean.TRUE.equals(rsp.isSuccess())) {
            return CnncUccOauth2RspBO.success((Object)rsp);
        }
        return CnncUccOauth2RspBO.error((String)rsp.getResultMessage());
    }

    @PostMapping(value={"/accessToken"})
    @BusiResponseBody
    public RefreshTokenRspBo accessToken(@RequestBody Object obj) {
        RefreshTokenReqBo reqBo = this.accessTokenCheckReq(obj);
        return this.oauth2PluginUserService.accessToken(reqBo);
    }

    private RefreshTokenReqBo accessTokenCheckReq(@RequestBody Object obj) {
        RefreshTokenReqBo reqBo = (RefreshTokenReqBo)JSON.parseObject((String)JSON.toJSONString((Object)obj), RefreshTokenReqBo.class);
        if (ObjectUtils.isEmpty((Object)reqBo.getUserName())) {
            throw new ZTBusinessException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getUserPassword())) {
            throw new ZTBusinessException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getGrantType())) {
            throw new ZTBusinessException("\u9274\u6743\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"access_token".equals(reqBo.getGrantType())) {
            throw new ZTBusinessException("\u9274\u6743\u7c7b\u578b\u5f02\u5e38");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getClientId())) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getClientSecret())) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aef\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getTimestamp())) {
            throw new ZTBusinessException("\u65f6\u95f4\u6233\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return reqBo;
    }

    @PostMapping(value={"/modifyUserPassword"})
    @BusiResponseBody
    public CnncUccOauth2RspBO<Oauth2ModifyUserRspBo> modifyUserPassword(@RequestBody Object reqBo) {
        Oauth2ModifyUserReqBo modifyUserReqBo = (Oauth2ModifyUserReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), Oauth2ModifyUserReqBo.class);
        if (ObjectUtils.isEmpty((Object)modifyUserReqBo.getOauthId())) {
            throw new ZTBusinessException("\u9274\u6743\u8d26\u53f7ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)modifyUserReqBo.getOldPassword())) {
            throw new ZTBusinessException("\u5386\u53f2\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)modifyUserReqBo.getNewPassword())) {
            throw new ZTBusinessException("\u4fee\u6539\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Oauth2ModifyUserRspBo rsp = this.oauth2PluginUserService.modifyUserPassword(modifyUserReqBo);
        if (Boolean.TRUE.equals(rsp.isSuccess())) {
            return CnncUccOauth2RspBO.success((Object)rsp);
        }
        return CnncUccOauth2RspBO.error((String)rsp.getResultMessage());
    }
}

