/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.busibase.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceListQueryService;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryInfoBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryRspBO;
import com.tydic.commodity.po.CnncUccSkuAddPricePO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddPriceListQueryService"})
public class UccSkuAddPriceListQueryServiceImpl
implements UccSkuAddPriceListQueryService {
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccEMdmCatalogMapper cnncUccEMdmCatalogMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"querySkuAddPriceList"})
    public UccSkuAddPriceListQueryRspBO querySkuAddPriceList(@RequestBody UccSkuAddPriceListQueryReqBO reqBO) {
        UccSkuAddPriceListQueryRspBO rspBO = new UccSkuAddPriceListQueryRspBO();
        if (reqBO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getExtSkuId())) {
            reqBO.setExtSkuId(null);
        }
        if (StringUtils.isEmpty((Object)reqBO.getSkuName())) {
            reqBO.setSkuName(null);
        }
        CnncUccSkuAddPricePO cnncUccSkuAddPricePO = new CnncUccSkuAddPricePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)cnncUccSkuAddPricePO);
        cnncUccSkuAddPricePO.setSupplierShopId(reqBO.getSupplierId());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List cnncUccSkuAddPricePOS = this.uccSkuAddCoefficientMapper.queryPage(cnncUccSkuAddPricePO, page);
        if (!CollectionUtils.isEmpty((Collection)cnncUccSkuAddPricePOS)) {
            DecimalFormat df1 = new DecimalFormat("#.00");
            ArrayList<UccSkuAddPriceListQueryInfoBO> rows = new ArrayList<UccSkuAddPriceListQueryInfoBO>(16);
            Map ruleMap = this.uccDictionaryAtomService.queryBypCodeBackMap("ADD_COEFFICIENT_RULE");
            for (CnncUccSkuAddPricePO uccSkuAddPricePO : cnncUccSkuAddPricePOS) {
                UccSkuAddPriceListQueryInfoBO uccSkuAddPriceListQueryInfoBO = new UccSkuAddPriceListQueryInfoBO();
                BeanUtils.copyProperties((Object)uccSkuAddPricePO, (Object)uccSkuAddPriceListQueryInfoBO);
                if (ruleMap.containsKey(uccSkuAddPricePO.getRule().toString())) {
                    uccSkuAddPriceListQueryInfoBO.setRuleDesc((String)ruleMap.get(uccSkuAddPricePO.getRule().toString()));
                }
                ArrayList<Long> catalogIds = new ArrayList<Long>();
                catalogIds.add(uccSkuAddPriceListQueryInfoBO.getCatalogId());
                List<UccEMdmCatalogPO> parent = this.findParent(catalogIds);
                StringBuffer catalogName = new StringBuffer();
                for (int i = parent.size() - 1; i >= 0; --i) {
                    catalogName.append(parent.get(i).getCatalogName()).append("/");
                }
                if (!StringUtils.isEmpty((Object)catalogName) && catalogName.length() > 1) {
                    catalogName.deleteCharAt(catalogName.length() - 1);
                    uccSkuAddPriceListQueryInfoBO.setCatalogName(catalogName.toString());
                }
                uccSkuAddPriceListQueryInfoBO.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getAgreementPrice()).setScale(2, 4));
                uccSkuAddPriceListQueryInfoBO.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getSalePrice()).setScale(2, 4));
                uccSkuAddPriceListQueryInfoBO.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getMarketPrice()).setScale(2, 4));
                rows.add(uccSkuAddPriceListQueryInfoBO);
            }
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalCount());
            rspBO.setRecordsTotal(page.getTotalCount());
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    List<UccEMdmCatalogPO> findParent(List<Long> catalogId) {
        ArrayList<UccEMdmCatalogPO> poList = new ArrayList<UccEMdmCatalogPO>();
        List qryRspList = this.cnncUccEMdmCatalogMapper.queryByIds(catalogId);
        if (CollectionUtils.isEmpty((Collection)qryRspList)) {
            return poList;
        }
        poList.addAll(qryRspList);
        ArrayList<Long> next = new ArrayList<Long>();
        qryRspList.forEach(a -> {
            if (a.getCatalogLevel() > 1) {
                next.add(a.getParentCatalogId());
            }
        });
        if (CollectionUtils.isEmpty(next)) {
            return poList;
        }
        List<UccEMdmCatalogPO> parent = this.findParent(next);
        poList.addAll(parent);
        return poList;
    }
}

