/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.atom.impl;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.estore.atom.api.UccQryECommerceEsAtomService;
import com.tydic.commodity.estore.atom.bo.SnycECommercePriceEsBO;
import com.tydic.commodity.estore.atom.bo.SyncECommercePriceToEsAtomRspBO;
import com.tydic.commodity.estore.atom.bo.UccQryCommercePriceEsBO;
import com.tydic.commodity.estore.atom.bo.UccQryECommerceEsAtomReqBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccQryECommerceEsAtomServiceImpl
implements UccQryECommerceEsAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccQryECommerceEsAtomServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccBaseDictionaryAtomService uccBaseDictionaryAtomService;

    @Override
    public SyncECommercePriceToEsAtomRspBO qryEsCommerce(UccQryECommerceEsAtomReqBO reqBo) {
        SyncECommercePriceToEsAtomRspBO rspBo = new SyncECommercePriceToEsAtomRspBO();
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBo);
        String queryString = this.excuteEsSql(reqBo, extBoolQueryBuilder);
        String result = this.searchInfo(queryString);
        if (StringUtils.isEmpty((Object)result)) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBo);
        return rspBo;
    }

    private BoolQueryBuilder buildEsSql(UccQryECommerceEsAtomReqBO reqBo) {
        RangeQueryBuilder discountDifferenceQbEnd;
        RangeQueryBuilder discountDifferenceQbStar;
        RangeQueryBuilder createTimeQb;
        WildcardQueryBuilder wildcardQuery;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBo.getCommodityTypeId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getSupplierId()));
        }
        if (reqBo.getIsDown() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"is_down", (Object)reqBo.getIsDown()));
        }
        if (reqBo.getCatalogId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"catalog_id", (Object)reqBo.getCatalogId()));
        }
        if (reqBo.getPrevent() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"prevent", (Object)reqBo.getPrevent()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getXcCategory())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"xc_category", (String)reqBo.getXcCategory()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getXcSku())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"xc_sku", (String)reqBo.getXcSku()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"ext_spu_id.keyword", (String)("*" + reqBo.getExtSpuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"ext_sku_id.keyword", (String)("*" + reqBo.getExtSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOnShelveTimeStart())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"on_shelve_time").gte((Object)reqBo.getOnShelveTimeStart().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOnShelveTimeEnd())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"on_shelve_time").lte((Object)reqBo.getOnShelveTimeEnd().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (reqBo.getHisAvgPriceMin() != null) {
            discountDifferenceQbStar = QueryBuilders.rangeQuery((String)"average_price").gte((Object)reqBo.getHisAvgPriceMin());
            boolQueryBuilder.must((QueryBuilder)discountDifferenceQbStar);
        }
        if (reqBo.getHisAvgPriceMax() != null) {
            discountDifferenceQbEnd = QueryBuilders.rangeQuery((String)"average_price").lte((Object)reqBo.getHisAvgPriceMax());
            boolQueryBuilder.must((QueryBuilder)discountDifferenceQbEnd);
        }
        if (reqBo.getSalePriceMin() != null) {
            discountDifferenceQbStar = QueryBuilders.rangeQuery((String)"price").gte((Object)reqBo.getSalePriceMin());
            boolQueryBuilder.must((QueryBuilder)discountDifferenceQbStar);
        }
        if (reqBo.getSalePriceMin() != null) {
            discountDifferenceQbEnd = QueryBuilders.rangeQuery((String)"price").lte((Object)reqBo.getSalePriceMin());
            boolQueryBuilder.must((QueryBuilder)discountDifferenceQbEnd);
        }
        if (reqBo.getPreventPriceMin() != null) {
            discountDifferenceQbStar = QueryBuilders.rangeQuery((String)"price").gte((Object)reqBo.getPreventPriceMin());
            boolQueryBuilder.must((QueryBuilder)discountDifferenceQbStar);
        }
        if (reqBo.getPreventPriceMax() != null) {
            discountDifferenceQbEnd = QueryBuilders.rangeQuery((String)"price").lte((Object)reqBo.getPreventPriceMax());
            boolQueryBuilder.must((QueryBuilder)discountDifferenceQbEnd);
        }
        if (reqBo.getBluyanceMin() != null) {
            discountDifferenceQbStar = QueryBuilders.rangeQuery((String)"floating_rate").gte((Object)reqBo.getBluyanceMin());
            boolQueryBuilder.must((QueryBuilder)discountDifferenceQbStar);
        }
        if (reqBo.getBluyanceMax() != null) {
            discountDifferenceQbEnd = QueryBuilders.rangeQuery((String)"floating_rate").lte((Object)reqBo.getBluyanceMax());
            boolQueryBuilder.must((QueryBuilder)discountDifferenceQbEnd);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpdateTimeStart())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"update_time").gte((Object)reqBo.getUpdateTimeStart().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpdateTimeEnd())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"update_time").lte((Object)reqBo.getUpdateTimeEnd().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPreventTimeStart())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"prevent_time").gte((Object)reqBo.getPreventTimeStart().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPreventTimeEnd())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"prevent_time").lte((Object)reqBo.getPreventTimeEnd().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (reqBo.getHisChangeTimesMin() != null) {
            discountDifferenceQbStar = QueryBuilders.rangeQuery((String)"frequency").gte((Object)reqBo.getBluyanceMin());
            boolQueryBuilder.must((QueryBuilder)discountDifferenceQbStar);
        }
        if (reqBo.getHisChangeTimesMax() != null) {
            createTimeQb = QueryBuilders.rangeQuery((String)"frequency").lte((Object)reqBo.getHisChangeTimesMax());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        return boolQueryBuilder;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getCommerceIndexName() + "/" + this.esConfig.getCommerceIndexType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private String excuteEsSql(UccQryECommerceEsAtomReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "update_time";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "prevent_time";
            }
        }
        JSONArray jsonArray = new JSONArray();
        if (!StringUtils.isEmpty((Object)sortField)) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            jsonArray.add((Object)JSONObject.parseObject((String)sortQuery.toString()));
        }
        queryJson.put("sort", (Object)jsonArray);
        return queryJson.toString();
    }

    private SyncECommercePriceToEsAtomRspBO dealSearchData(String result, UccQryECommerceEsAtomReqBO reqBo) {
        SyncECommercePriceToEsAtomRspBO rspBo = new SyncECommercePriceToEsAtomRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<SnycECommercePriceEsBO> commodityModels = new ArrayList<SnycECommercePriceEsBO>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                SnycECommercePriceEsBO commodity = new SnycECommercePriceEsBO();
                try {
                    commodity = (SnycECommercePriceEsBO)JSON.toJavaObject((JSON)data, SnycECommercePriceEsBO.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private SyncECommercePriceToEsAtomRspBO copyData(List<SnycECommercePriceEsBO> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        SyncECommercePriceToEsAtomRspBO rspBo = new SyncECommercePriceToEsAtomRspBO();
        ArrayList<UccQryCommercePriceEsBO> uccSkuManagementListQryBOs = new ArrayList<UccQryCommercePriceEsBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total);
            if (!CollectionUtils.isEmpty(commodityModels)) {
                Map dicMap = this.uccBaseDictionaryAtomService.queryBypCodeBackMap("IS_DOWN");
                Map xcCategoryDicMap = this.uccBaseDictionaryAtomService.queryBypCodeBackMap("XC_CATEGORY_DIC");
                Map xcSkuDicMap = this.uccBaseDictionaryAtomService.queryBypCodeBackMap("XC_SKU_DIC");
                for (SnycECommercePriceEsBO each : commodityModels) {
                    UccQryCommercePriceEsBO uccQryCommercePriceEsBO = new UccQryCommercePriceEsBO();
                    uccQryCommercePriceEsBO.setCommodityCode(each.getCommodity_code());
                    uccQryCommercePriceEsBO.setCommodityId(each.getCommodity_id());
                    uccQryCommercePriceEsBO.setCommodityName(each.getCommodity_name());
                    uccQryCommercePriceEsBO.setSkuId(each.getSku_id());
                    uccQryCommercePriceEsBO.setSkuCode(each.getSku_code());
                    uccQryCommercePriceEsBO.setSkuName(each.getSku_name());
                    uccQryCommercePriceEsBO.setCommodityTypeId(each.getCommodity_type_id());
                    uccQryCommercePriceEsBO.setCommodityTypeName(each.getCommodity_type_name());
                    uccQryCommercePriceEsBO.setCatalogId(each.getCatalog_id());
                    uccQryCommercePriceEsBO.setCatalogName(each.getCatalog_name());
                    if (each.getOn_shelve_time() != null) {
                        uccQryCommercePriceEsBO.setOnShelveTime((Date)new DateTime(each.getOn_shelve_time().longValue()));
                    }
                    uccQryCommercePriceEsBO.setSupplierShopId(each.getSupplier_shop_id());
                    uccQryCommercePriceEsBO.setVendorName(each.getVendor_name());
                    uccQryCommercePriceEsBO.setVendorId(each.getVendor_id());
                    uccQryCommercePriceEsBO.setBrandId(each.getBrand_id());
                    uccQryCommercePriceEsBO.setBrandName(each.getBrand_name());
                    uccQryCommercePriceEsBO.setShopName(each.getSupplier_shop_name());
                    uccQryCommercePriceEsBO.setSupplierId(each.getSupplier_id());
                    uccQryCommercePriceEsBO.setSupplierName(each.getSupplier_name());
                    uccQryCommercePriceEsBO.setExtSpuId(each.getExt_spu_id());
                    uccQryCommercePriceEsBO.setExtSkuId(each.getExt_sku_id());
                    uccQryCommercePriceEsBO.setAveragePrice(each.getAverage_price());
                    uccQryCommercePriceEsBO.setBeforePrice(each.getBefore_price());
                    uccQryCommercePriceEsBO.setCurrentPrice(each.getCurrent_price());
                    uccQryCommercePriceEsBO.setFloatingRate(each.getFloating_rate());
                    uccQryCommercePriceEsBO.setFrequency(each.getFrequency());
                    uccQryCommercePriceEsBO.setPreventPrice(each.getPrevent_price());
                    if (each.getPrevent_time() != null) {
                        uccQryCommercePriceEsBO.setPreventTime((Date)new DateTime(each.getPrevent_time().longValue()));
                    }
                    if (each.getUpdate_time() != null) {
                        uccQryCommercePriceEsBO.setUpdateTime((Date)new DateTime(each.getUpdate_time().longValue()));
                    }
                    if (each.getIs_down() != null) {
                        uccQryCommercePriceEsBO.setIsDownDesc((String)dicMap.get(each.getIs_down().toString()));
                    }
                    uccQryCommercePriceEsBO.setIsDown(each.getIs_down());
                    uccQryCommercePriceEsBO.setMaxPrice(each.getMax_price());
                    uccQryCommercePriceEsBO.setMinPrice(each.getMin_price());
                    uccQryCommercePriceEsBO.setPercentage(each.getPercentage());
                    uccQryCommercePriceEsBO.setPrice(each.getPrice());
                    uccQryCommercePriceEsBO.setCurrentPrice(each.getCurrent_price());
                    uccQryCommercePriceEsBO.setXcCategory(each.getXc_category());
                    uccQryCommercePriceEsBO.setXcSku(each.getXc_sku());
                    if (StringUtils.isEmpty((Object)each.getXc_category()) && xcCategoryDicMap.containsKey(each.getXc_category())) {
                        uccQryCommercePriceEsBO.setXcCategoryStr((String)xcCategoryDicMap.get(each.getXc_category()));
                    } else {
                        uccQryCommercePriceEsBO.setXcCategoryStr("\u5426");
                    }
                    if (StringUtils.isEmpty((Object)each.getXc_sku()) && xcSkuDicMap.containsKey(each.getXc_sku())) {
                        uccQryCommercePriceEsBO.setXcCategoryStr((String)xcSkuDicMap.get(each.getXc_sku()));
                    } else {
                        uccQryCommercePriceEsBO.setXcSkuStr("\u5426");
                    }
                    uccSkuManagementListQryBOs.add(uccQryCommercePriceEsBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

