/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.utils;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;

public class CnncUccOauth2DateUtil {
    private static final String DATE_FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMAT_DATETIME_SSS = "yyyy-MM-dd HH:mm:ss.SSS";

    public static LocalDateTime parseLocalDateTime(String str) {
        return LocalDateTime.parse(str, DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static Date getDateYYYY() {
        LocalDateTime localDateTime = CnncUccOauth2DateUtil.parseLocalDateTime(CnncUccOauth2DateUtil.getCurrentDateTime());
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static Date getStringToLocalDate(String time) {
        LocalDateTime localDateTime = LocalDateTime.parse(time, DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME_SSS));
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static String getCurrentDateTime() {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_DATETIME);
        Calendar calendar = Calendar.getInstance();
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateTime(String dateFormat) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        Calendar calendar = Calendar.getInstance();
        return df.format(calendar.getTime());
    }

    public static long acquireMinutesBetween(LocalDateTime start, LocalDateTime end) {
        return start.until(end, ChronoUnit.MINUTES);
    }

    public static String formatDateWithMS(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_DATETIME_SSS);
        return df.format(date);
    }
}

