/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.bo.UccMallAreaAvailableCommdBO_busi;
import com.tydic.commodity.mall.atom.api.UccMallAreaAvailableQryAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallAreaAvailableQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallAreaAvailableQryRspBO;
import com.tydic.commodity.mall.atom.impl.UccMallAvailableCommdQryAtomServiceImpl;
import com.tydic.commodity.mall.busi.api.UccMallAreaAvailableQryBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallAreaAvailableQryBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallAreaAvailableQryBusiRspBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallAreaAvailableQryBusiServiceImpl
implements UccMallAreaAvailableQryBusiService {
    @Autowired
    private UccMallAreaAvailableQryAtomService uccMallAreaAvailableQryAtomService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallAvailableCommdQryAtomServiceImpl.class);

    @Override
    public UccMallAreaAvailableQryBusiRspBO qryUccAreaAvailable(UccMallAreaAvailableQryBusiReqBO reqBO) {
        String supplierCode;
        Long supplierId;
        UccMallAreaAvailableQryBusiRspBO rspBO = new UccMallAreaAvailableQryBusiRspBO();
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc(s);
            return rspBO;
        }
        try {
            SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId(), reqBO.getSysTenantId());
            if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
                rspBO.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
                return rspBO;
            }
            supplierId = supplierShopPo.getSupplierId();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(UccMallConstantsEnums.STORE_QUERY_FAILED.code(), UccMallConstantsEnums.STORE_QUERY_FAILED.message());
        }
        try {
            SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId, reqBO.getSysTenantId());
            if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
                rspBO.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code());
                return rspBO;
            }
            supplierCode = supplierBusiPo.getSupplierCode();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code(), UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.message());
        }
        ArrayList<String> extSkuIds = new ArrayList<String>();
        try {
            for (Long skuId : reqBO.getSkuIds()) {
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPo.setSkuId(skuId);
                uccSkuPo.setSysTenantId(reqBO.getSysTenantId());
                List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
                if (uccSkuPoList == null || uccSkuPoList.size() != 1) {
                    rspBO.setRespDesc("\u5355\u54c1\u4e0d\u5b58\u5728\u6216\u4e0d\u552f\u4e00");
                    rspBO.setRespCode(UccMallConstantsEnums.SKU_NOT_UNIQUE.code());
                    return rspBO;
                }
                String extSkuId = uccSkuPoList.get(0).getExtSkuId();
                if (StringUtils.isEmpty((CharSequence)extSkuId)) {
                    rspBO.setRespDesc("\u5916\u90e8\u5355\u54c1ID\u4e3a\u7a7a");
                    rspBO.setRespCode(UccMallConstantsEnums.SKU_NOT_UNIQUE.code());
                    return rspBO;
                }
                extSkuIds.add(extSkuId);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        try {
            List<UccMallAreaAvailableCommdBO_busi> uccMallAreaAvailableCommdBO_busis;
            UccMallAreaAvailableQryReqBO uccMallsAreaAvailableQryReqBO = new UccMallAreaAvailableQryReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccMallsAreaAvailableQryReqBO);
            uccMallsAreaAvailableQryReqBO.setSupplierCode(supplierCode);
            uccMallsAreaAvailableQryReqBO.setSkuIds(extSkuIds);
            UccMallAreaAvailableQryRspBO uccMallsAreaAvailableQryRspBO = this.uccMallAreaAvailableQryAtomService.qryAreaAvailableCommd(uccMallsAreaAvailableQryReqBO);
            BeanUtils.copyProperties((Object)((Object)uccMallsAreaAvailableQryRspBO), (Object)((Object)rspBO));
            if (uccMallsAreaAvailableQryRspBO.getAreaAvailableCommdInfos() != null && (uccMallAreaAvailableCommdBO_busis = uccMallsAreaAvailableQryRspBO.getAreaAvailableCommdInfos()).size() > 0) {
                ArrayList<UccMallAreaAvailableCommdBO_busi> uccMallAreaAvailableCommdBO_busis1 = new ArrayList<UccMallAreaAvailableCommdBO_busi>();
                for (UccMallAreaAvailableCommdBO_busi uccMallAreaAvailableCommdBO_busi : uccMallAreaAvailableCommdBO_busis) {
                    if (!StringUtils.isNotEmpty((CharSequence)uccMallAreaAvailableCommdBO_busi.getSkuId())) continue;
                    UccSkuPo uccSkuPo = new UccSkuPo();
                    uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
                    uccSkuPo.setExtSkuId(uccMallAreaAvailableCommdBO_busi.getSkuId());
                    uccSkuPo.setSysTenantId(reqBO.getSysTenantId());
                    List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
                    if (uccSkuPoList == null || uccSkuPoList.size() != 1) {
                        rspBO.setRespDesc("\u5916\u90e8\u5355\u54c1\u4e0d\u5b58\u5728\u6216\u4e0d\u552f\u4e00");
                        rspBO.setRespCode(UccMallConstantsEnums.SKU_NOT_UNIQUE.code());
                        return rspBO;
                    }
                    Long skuId = uccSkuPoList.get(0).getSkuId();
                    if (skuId == null) {
                        rspBO.setRespDesc("\u5355\u54c1ID\u4e3a\u7a7a");
                        rspBO.setRespCode(UccMallConstantsEnums.SKU_NOT_UNIQUE.code());
                        return rspBO;
                    }
                    UccMallAreaAvailableCommdBO_busi uccMallAreaAvailableCommdBO_busi1 = new UccMallAreaAvailableCommdBO_busi();
                    BeanUtils.copyProperties((Object)uccMallAreaAvailableCommdBO_busi, (Object)uccMallAreaAvailableCommdBO_busi1);
                    uccMallAreaAvailableCommdBO_busi1.setSkuId(skuId.toString());
                    uccMallAreaAvailableCommdBO_busis1.add(uccMallAreaAvailableCommdBO_busi1);
                }
                rspBO.setAreaAvailableCommdInfos(uccMallAreaAvailableCommdBO_busis1);
            }
            return rspBO;
        }
        catch (BusinessException e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(e.getMsgCode(), e.getMsgInfo());
        }
    }

    public String judge(UccMallAreaAvailableQryBusiReqBO reqBO) {
        String s = "";
        if (reqBO.getSkuIds() == null || reqBO.getSkuIds().size() == 0) {
            s = "\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getSupplierShopId() == null) {
            s = "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return s;
    }
}

