/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.bo.UccMallGetJDaddrInfoBusiReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallGetJDaddrInfoBusiRspBO;
import com.tydic.commodity.mall.busi.api.UccMallGetJDaddrInfoBusiService;
import com.tydic.commodity.mall.dao.AddrAreaDAO;
import com.tydic.commodity.mall.dao.AddrCityDAO;
import com.tydic.commodity.mall.dao.AddrProvinceDAO;
import com.tydic.commodity.mall.dao.AddrTownsDAO;
import com.tydic.commodity.mall.po.AddrAreaPO;
import com.tydic.commodity.mall.po.AddrCityPO;
import com.tydic.commodity.mall.po.AddrProvincePO;
import com.tydic.commodity.mall.po.AddrTownsPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallGetJDaddrInfoBusiServiceImpl
implements UccMallGetJDaddrInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallGetJDaddrInfoBusiServiceImpl.class);
    @Autowired
    private AddrAreaDAO addrAreaDAO;
    @Autowired
    private AddrCityDAO addrCityDAO;
    @Autowired
    private AddrProvinceDAO addrProvinceDAO;
    @Autowired
    private AddrTownsDAO addrTownsDAO;
    @Value(value="${JD.PROVINCE.ADDR:https://api-iop.jd.com/api/area/getProvince}")
    private String jdProvinceAddr;
    @Value(value="${JD.CITY.ADDR:https://api-iop.jd.com/api/area/getCity}")
    private String jdCityAddr;
    @Value(value="${JD.AREA.ADDR:https://api-iop.jd.com/api/area/getCounty}")
    private String jdAreaAddr;
    @Value(value="${JD.TOWNS.ADDR:https://api-iop.jd.com/api/area/getTown}")
    private String jdTownsAddr;
    @Value(value="${JD.TOKEN:7fnICCXKkOZ4uqjg5yJUdq9Vf}")
    private String jdToken;

    @Override
    public UccMallGetJDaddrInfoBusiRspBO dealJdAddr(UccMallGetJDaddrInfoBusiReqBO reqBO) {
        UccMallGetJDaddrInfoBusiRspBO rspBO = new UccMallGetJDaddrInfoBusiRspBO();
        try {
            if (!CollectionUtils.isEmpty((Collection)reqBO.getProvinceBOList())) {
                List provincePOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getProvinceBOList()), AddrProvincePO.class);
                provincePOList.forEach(addrAreaPO -> {
                    addrAreaPO.setSysTenantId(reqBO.getSysTenantId());
                    addrAreaPO.setSysTenantName(reqBO.getSysTenantName());
                });
                this.addrProvinceDAO.batchinsert(provincePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getCityBOList())) {
                List cityPOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getCityBOList()), AddrCityPO.class);
                cityPOList.forEach(addrAreaPO -> {
                    addrAreaPO.setSysTenantId(reqBO.getSysTenantId());
                    addrAreaPO.setSysTenantName(reqBO.getSysTenantName());
                });
                this.addrCityDAO.batchinsert(cityPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getAreaBOList())) {
                List areaPOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getAreaBOList()), AddrAreaPO.class);
                areaPOList.forEach(addrAreaPO -> {
                    addrAreaPO.setSysTenantId(reqBO.getSysTenantId());
                    addrAreaPO.setSysTenantName(reqBO.getSysTenantName());
                });
                this.addrAreaDAO.batchinsert(areaPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getTownBOList())) {
                List townPOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getTownBOList()), AddrTownsPO.class);
                townPOList.forEach(addrAreaPO -> {
                    addrAreaPO.setSysTenantId(reqBO.getSysTenantId());
                    addrAreaPO.setSysTenantName(reqBO.getSysTenantName());
                });
                this.addrTownsDAO.batchinsert(townPOList);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u65b0\u589e\u4f1a\u5458\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<String, String> initProvinceReqStr() {
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        jsonObject.put("token", this.jdToken);
        return jsonObject;
    }

    private Map<String, String> initCityReqStr(String province) {
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        jsonObject.put("token", this.jdToken);
        jsonObject.put("id", province);
        return jsonObject;
    }

    private Map<String, String> initAreaReqStr(String city) {
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        jsonObject.put("token", this.jdToken);
        jsonObject.put("id", city);
        return jsonObject;
    }

    private Map<String, String> initTownsReqStr(String area) {
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        jsonObject.put("token", this.jdToken);
        jsonObject.put("id", area);
        return jsonObject;
    }
}

