/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.mall.ability.bo.UccMallUpdateIncreasePriceTypeBusiReqBO;
import com.tydic.commodity.mall.busi.api.UccMallInsertPriceChangeLogBusiService;
import com.tydic.commodity.mall.busi.api.UccMallPriChangeBusiService;
import com.tydic.commodity.mall.busi.api.UccMallQueryDBDateBusiService;
import com.tydic.commodity.mall.busi.api.UccMallSkuAdjustPriceBusiService;
import com.tydic.commodity.mall.busi.api.UccMallUpdateIncreasePriceTypeBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallInsertPriceChangeLogBusiReqBo;
import com.tydic.commodity.mall.busi.bo.UccMallInsertPriceChangeLogReqBo;
import com.tydic.commodity.mall.busi.bo.UccMallMqSyncCommdPriceBo;
import com.tydic.commodity.mall.busi.bo.UccMallPriChangeReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallPriChangeRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallSkuPriceChangeBO;
import com.tydic.commodity.mall.busi.bo.UccMallSkuPriceVO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallAddCoefficientMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallDefaultCoefficientMapper;
import com.tydic.commodity.mall.dao.UccMallECommercePriceChangeLogMapper;
import com.tydic.commodity.mall.dao.UccMallECommercePriceChangeMapper;
import com.tydic.commodity.mall.dao.UccMallParamsConfigDetailMapper;
import com.tydic.commodity.mall.dao.UccMallParamsConfigMapper;
import com.tydic.commodity.mall.dao.UccMallSkuAddCoefficientMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceLogMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.dao.UccSkuExpandMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccAddCoefficientPO;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccMallDefaultCoefficientPO;
import com.tydic.commodity.mall.po.UccMallSkuAddCoefficientPO;
import com.tydic.commodity.mall.po.UccSkuExpandPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallPriChangeBusiServiceImpl
implements UccMallPriChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallPriChangeBusiServiceImpl.class);
    @Autowired
    private UccMallSkuPriceMapper uccMallSkuPriceMapper;
    @Autowired
    private UccMallSkuPriceLogMapper uccMallSkuPriceLogMapper;
    @Autowired
    private UccMallAddCoefficientMapper uccMallAddCoefficientMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallPriChangeBusiServiceImpl.class);
    @Autowired
    private UccMallSkuAdjustPriceBusiService uccMallSkuAdjustPriceBusiService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccMallECommercePriceChangeMapper uccMallECommercePriceChangeMapper;
    @Autowired
    private UccMallECommercePriceChangeLogMapper uccMallECommercePriceChangeLogMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    private Sequence coefficientSequence = Sequence.getInstance();
    private static final BigDecimal yuanToMilli = new BigDecimal(10000);
    @Resource(name="uccMallchangePriceServiceProvider")
    private ProxyMessageProducer uccMallchangePriceServiceProvider;
    @Autowired
    private UccMallQueryDBDateBusiService uccMallQueryDBDateBusiService;
    @Autowired
    private UccMallInsertPriceChangeLogBusiService uccMallInsertPriceChangeLogBusiService;
    @Autowired
    private UccMallSkuAddCoefficientMapper uccMallSkuAddCoefficientMapper;
    @Autowired
    private UccMallDefaultCoefficientMapper uccMallDefaultCoefficientMapper;
    @Autowired
    private UccMallParamsConfigMapper uccMallParamsConfigMapper;
    @Autowired
    private UccMallParamsConfigDetailMapper uccMallParamsConfigDetailMapper;
    @Autowired
    private UccMallUpdateIncreasePriceTypeBusiService uccMallUpdateIncreasePriceTypeBusiService;

    @Override
    public UccMallPriChangeRspBO changePrice(UccMallPriChangeReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code(), "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSkuPriceInfos() == null) {
            throw new BusinessException(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code(), "\u4ef7\u683c\u53d8\u66f4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierShopId() == null) {
            throw new BusinessException(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code(), "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<UccMallInsertPriceChangeLogReqBo> uccMallInsertPriceChangeLogReqBos = new ArrayList<UccMallInsertPriceChangeLogReqBo>();
        ArrayList<UccMallSkuPriceVO> uccMallSkuPriceVOList = new ArrayList<UccMallSkuPriceVO>();
        ArrayList<UccMallMqSyncCommdPriceBo> uccMallMqSyncCommdPriceBoList = new ArrayList<UccMallMqSyncCommdPriceBo>();
        for (UccMallSkuPriceChangeBO uccMallSkuPriceChangeBO : reqBO.getSkuPriceInfos()) {
            UccCommodityTypePo uccCommodityTypePo;
            if (uccMallSkuPriceChangeBO.getSkuId() == null || uccMallSkuPriceChangeBO.getPrice() == null || uccMallSkuPriceChangeBO.getMarketPrice() == null) continue;
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setExtSkuId(uccMallSkuPriceChangeBO.getSkuId());
            uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
            List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
            if (uccSkuPoList == null || uccSkuPoList.size() != 1) continue;
            UccSkuExpandPo uccSkuExpandPo = new UccSkuExpandPo();
            uccSkuExpandPo.setSkuId(uccSkuPoList.get(0).getSkuId());
            List<UccSkuExpandPo> uccSkuExpandPos = this.uccSkuExpandMapper.querySkuExpand(uccSkuExpandPo);
            boolean agrEstoreSku = false;
            if (!CollectionUtils.isEmpty(uccSkuExpandPos) && uccSkuExpandPos.get(0).getSourceAssort() != null && uccSkuExpandPos.get(0).getSourceAssort() == 1) {
                agrEstoreSku = true;
            }
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            uccSkuPricePo.setSkuId(uccSkuPoList.get(0).getSkuId());
            uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPricePo.setCurrencyType(null);
            uccSkuPricePo.setSysTenantId(reqBO.getSysTenantId());
            if ((uccSkuPricePo = this.uccMallSkuPriceMapper.querySkuPrice(uccSkuPricePo)) == null || (uccCommodityTypePo = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeId(uccSkuPoList.get(0).getCommodityTypeId(), uccSkuPoList.get(0).getSysTenantId())) == null) continue;
            Long catalogId = uccCommodityTypePo.getCatalogId();
            BigDecimal addCoefficient = new BigDecimal(0);
            BigDecimal addPrice = new BigDecimal(0);
            Integer rule = null;
            Integer allowMarketPrice = 0;
            UccMallSkuAddCoefficientPO uccSkuAddCoefficientPO = this.uccMallSkuAddCoefficientMapper.selectBySkuId(uccSkuPoList.get(0).getSkuId(), null);
            if (uccSkuAddCoefficientPO != null) {
                rule = uccSkuAddCoefficientPO.getRule();
                if (rule == 1 && uccSkuAddCoefficientPO.getAddCoefficient() != null) {
                    addCoefficient = uccSkuAddCoefficientPO.getAddCoefficient();
                    addCoefficient = addCoefficient.divide(new BigDecimal(100), 6, 5);
                }
                if (rule == 2) {
                    addPrice = uccSkuAddCoefficientPO.getAddPrice();
                }
                if (uccSkuAddCoefficientPO.getAllowMarketPrice() != null) {
                    allowMarketPrice = uccSkuAddCoefficientPO.getAllowMarketPrice();
                }
            } else {
                UccAddCoefficientPO uccAddCoefficientPO = this.uccMallAddCoefficientMapper.qryCoefficientByCatalogIdAndSupplierShopId(catalogId, reqBO.getSupplierShopId(), uccSkuPoList.get(0).getSysTenantId());
                if (uccAddCoefficientPO != null) {
                    rule = uccAddCoefficientPO.getRule();
                    if (rule == 1 && uccAddCoefficientPO.getAddCoefficient() != null) {
                        addCoefficient = uccAddCoefficientPO.getAddCoefficient();
                        addCoefficient = addCoefficient.divide(new BigDecimal(100), 6, 5);
                    }
                    if (rule == 2) {
                        addPrice = uccAddCoefficientPO.getAddPrice();
                    }
                    if (uccAddCoefficientPO.getAllowMarketPrice() != null) {
                        allowMarketPrice = uccAddCoefficientPO.getAllowMarketPrice();
                    }
                } else {
                    UccMallDefaultCoefficientPO defaultCoefficientPO = new UccMallDefaultCoefficientPO();
                    defaultCoefficientPO.setSysTenantId(reqBO.getSysTenantId());
                    List<UccMallDefaultCoefficientPO> poList = this.uccMallDefaultCoefficientMapper.getList(defaultCoefficientPO);
                    if (!CollectionUtils.isEmpty(poList)) {
                        rule = poList.get(0).getRule();
                        if (1 == rule) {
                            addCoefficient = poList.get(0).getAddCoefficient().divide(new BigDecimal(100), 6, 5);
                        }
                        if (2 == rule) {
                            addPrice = poList.get(0).getAddPrice();
                        }
                        if (poList.get(0).getAllowMarketPrice() != null) {
                            allowMarketPrice = poList.get(0).getAllowMarketPrice();
                        }
                    }
                }
            }
            if (agrEstoreSku) {
                log.info(uccSkuPoList.get(0).getSkuId() + "\u5355\u54c1\u4e3a\u534f\u8bae\u7535\u5546\uff0c\u76f4\u63a5\u4e0d\u8ba1\u7b97\u4ef7\u683c");
                UccMallSkuPriceVO skuPriceVO = new UccMallSkuPriceVO();
                skuPriceVO.setAgreementPrice(MoneyUtils.yuanToHaoToLong(uccMallSkuPriceChangeBO.getPrice()));
                skuPriceVO.setMarketPrice(MoneyUtils.yuanToHaoToLong(uccMallSkuPriceChangeBO.getMarketPrice()));
                skuPriceVO.setSalePrice(MoneyUtils.yuanToHaoToLong(uccMallSkuPriceChangeBO.getPrice()));
                skuPriceVO.setSkuId(uccSkuPoList.get(0).getSkuId());
                skuPriceVO.setExtSkuId(uccSkuPoList.get(0).getExtSkuId());
                skuPriceVO.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
                uccMallSkuPriceVOList.add(skuPriceVO);
                continue;
            }
            BigDecimal salePrice = new BigDecimal("0");
            if (rule == 1) {
                salePrice = uccMallSkuPriceChangeBO.getPrice().multiply(addCoefficient.add(new BigDecimal(1)));
            } else if (rule == 2) {
                salePrice = uccMallSkuPriceChangeBO.getPrice().add(addPrice);
            }
            if (allowMarketPrice == 0 && salePrice.compareTo(uccMallSkuPriceChangeBO.getMarketPrice()) > 0) {
                salePrice = uccMallSkuPriceChangeBO.getMarketPrice();
            }
            salePrice = salePrice.setScale(2, 0);
            int result1 = MoneyUtils.yuanToHao(salePrice).compareTo(new BigDecimal(uccSkuPricePo.getSalePrice()));
            UccMallSkuPriceVO skuPriceVO = new UccMallSkuPriceVO();
            skuPriceVO.setAgreementPrice(MoneyUtils.yuanToHaoToLong(uccMallSkuPriceChangeBO.getPrice()));
            skuPriceVO.setMarketPrice(MoneyUtils.yuanToHaoToLong(uccMallSkuPriceChangeBO.getMarketPrice()));
            skuPriceVO.setSalePrice(MoneyUtils.yuanToHaoToLong(salePrice));
            skuPriceVO.setSkuId(uccSkuPoList.get(0).getSkuId());
            skuPriceVO.setExtSkuId(uccSkuPoList.get(0).getExtSkuId());
            skuPriceVO.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
            uccMallSkuPriceVOList.add(skuPriceVO);
            int result = MoneyUtils.yuanToHao(uccMallSkuPriceChangeBO.getPrice()).compareTo(new BigDecimal(uccSkuPricePo.getAgreementPrice()));
            int result2 = MoneyUtils.yuanToHao(uccMallSkuPriceChangeBO.getMarketPrice()).compareTo(new BigDecimal(uccSkuPricePo.getMarketPrice()));
            if (result == 0 && result1 == 0 && result2 == 0) continue;
            UccMallMqSyncCommdPriceBo mqSyncCommdPriceBo = new UccMallMqSyncCommdPriceBo();
            mqSyncCommdPriceBo.setAgreementPrice(MoneyUtils.yuanToHaoToLong(uccMallSkuPriceChangeBO.getPrice()));
            mqSyncCommdPriceBo.setOrgSalePrice(salePrice);
            mqSyncCommdPriceBo.setSalePrice(MoneyUtils.yuanToHaoToLong(salePrice));
            mqSyncCommdPriceBo.setMarketPrice(MoneyUtils.yuanToHaoToLong(uccMallSkuPriceChangeBO.getMarketPrice()));
            mqSyncCommdPriceBo.setExtSkuId(uccSkuPo.getExtSkuId());
            mqSyncCommdPriceBo.setOnShelveTime(uccSkuPoList.get(0).getOnShelveTime());
            mqSyncCommdPriceBo.setSkuId(uccSkuPoList.get(0).getSkuId());
            mqSyncCommdPriceBo.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
            mqSyncCommdPriceBo.setOldAgreementPrice(uccSkuPricePo.getAgreementPrice());
            mqSyncCommdPriceBo.setCommodityId(uccSkuPoList.get(0).getCommodityId());
            mqSyncCommdPriceBo.setSkuName(uccSkuPoList.get(0).getSkuName());
            mqSyncCommdPriceBo.setBrandId(uccSkuPoList.get(0).getBrandId());
            mqSyncCommdPriceBo.setSysTenantId(reqBO.getSysTenantId());
            mqSyncCommdPriceBo.setSysTenantName(reqBO.getSysTenantName());
            uccMallMqSyncCommdPriceBoList.add(mqSyncCommdPriceBo);
            this.dealIncreasePriceType(mqSyncCommdPriceBo);
            UccMallInsertPriceChangeLogReqBo uccMallInsertPriceChangeLogReqBo = new UccMallInsertPriceChangeLogReqBo();
            uccMallInsertPriceChangeLogReqBo.setSkuId(uccSkuPoList.get(0).getSkuId());
            uccMallInsertPriceChangeLogReqBo.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
            uccMallInsertPriceChangeLogReqBo.setCommodityId(uccSkuPoList.get(0).getCommodityId());
            uccMallInsertPriceChangeLogReqBo.setChangeTime(new Date());
            uccMallInsertPriceChangeLogReqBo.setOldPrice(new BigDecimal(uccSkuPricePo.getAgreementPrice().toString()));
            uccMallInsertPriceChangeLogReqBo.setCurrentPrice(MoneyUtils.yuanToHao(uccMallSkuPriceChangeBO.getPrice()));
            BigDecimal range = null;
            range = !uccMallInsertPriceChangeLogReqBo.getOldPrice().equals(new BigDecimal(0)) ? uccMallInsertPriceChangeLogReqBo.getCurrentPrice().subtract(uccMallInsertPriceChangeLogReqBo.getOldPrice()).divide(uccMallInsertPriceChangeLogReqBo.getOldPrice(), 2, 0) : new BigDecimal("9999999.99");
            uccMallInsertPriceChangeLogReqBo.setChangeRange(range);
            uccMallInsertPriceChangeLogReqBos.add(uccMallInsertPriceChangeLogReqBo);
        }
        if (!CollectionUtils.isEmpty(uccMallMqSyncCommdPriceBoList)) {
            try {
                this.uccMallchangePriceServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("PRICE_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("PRICE_UCC_SYNC_TAG"), JSON.toJSONString(uccMallMqSyncCommdPriceBoList)));
            }
            catch (Exception e) {
                LOGGER.error("\u4ef7\u683c\u53d8\u52a8\u540c\u6b65\u6570\u636e\u5e93 mq \u751f\u4ea7\u8005\u53d1\u9001\u5f02\u5e38\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString(uccMallMqSyncCommdPriceBoList));
            }
        }
        try {
            if (!CollectionUtils.isEmpty(uccMallInsertPriceChangeLogReqBos)) {
                this.dealPriceChangeLog(uccMallInsertPriceChangeLogReqBos, reqBO);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u4ef7\u683c\u53d8\u52a8\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        UccMallPriChangeRspBO rspBO = new UccMallPriChangeRspBO();
        rspBO.setUccMallSkuPriceVOList(uccMallSkuPriceVOList);
        rspBO.setRespDesc("\u8c03\u4ef7\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void dealPriceChangeLog(List<UccMallInsertPriceChangeLogReqBo> bos, UccMallPriChangeReqBO reqBO) {
        if (!CollectionUtils.isEmpty(bos)) {
            UccMallInsertPriceChangeLogBusiReqBo uccMallInsertPriceChangeLogBusiReqBo = new UccMallInsertPriceChangeLogBusiReqBo();
            uccMallInsertPriceChangeLogBusiReqBo.setUccMallInsertPriceChangeLogReqBos(bos);
            uccMallInsertPriceChangeLogBusiReqBo.setSysTenantId(reqBO.getSysTenantId());
            uccMallInsertPriceChangeLogBusiReqBo.setSysTenantName(reqBO.getSysTenantName());
            LOGGER.info("\u6dfb\u52a0\u4ef7\u683c\u53d8\u52a8\u8bb0\u5f55\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)uccMallInsertPriceChangeLogBusiReqBo));
            this.uccMallInsertPriceChangeLogBusiService.dealUccInsertPriceChangeLog(uccMallInsertPriceChangeLogBusiReqBo);
        }
    }

    private void dealIncreasePriceType(UccMallMqSyncCommdPriceBo bo) {
        try {
            UccMallUpdateIncreasePriceTypeBusiReqBO reqBO = new UccMallUpdateIncreasePriceTypeBusiReqBO();
            if (bo.getAgreementPrice().equals(bo.getSalePrice())) {
                reqBO.setIncreasePriceType(Integer.valueOf(2));
            } else {
                reqBO.setIncreasePriceType(Integer.valueOf(1));
            }
            reqBO.setSkuId(bo.getSkuId());
            reqBO.setSupplierShopId(bo.getSupplierShopId());
            reqBO.setSysTenantId(bo.getSysTenantId());
            this.uccMallUpdateIncreasePriceTypeBusiService.updateIncreasePriceType(reqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u54c1\u8d38\u6613\u6a21\u5f0f\u4fee\u6539\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

