/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccMsgPoolRunMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.SupplierShopPo;
import com.tydic.commodity.po.UccMsgPoolRunPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.zone.ability.bo.UccAgrPutMsgPoolAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrPutMsgPoolAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccAgrPutMsgPoolBO;
import com.tydic.commodity.zone.busi.api.UccAgrPutMsgPoolBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAgrPutMsgPoolBusiServiceImpl
implements UccAgrPutMsgPoolBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrPutMsgPoolBusiServiceImpl.class);
    @Autowired
    private UccMsgPoolRunMapper uccMsgPoolRunMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccAgrPutMsgPoolAbilityRspBO dealPushMsgPool(UccAgrPutMsgPoolAbilityReqBO reqBO) {
        UccAgrPutMsgPoolAbilityRspBO rspBO = new UccAgrPutMsgPoolAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getMsgList())) {
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getMsgType() == null || UccConstants.MSG_TYPE.ADD != reqBO.getMsgType() && UccConstants.MSG_TYPE.PRICE != reqBO.getMsgType() && UccConstants.MSG_TYPE.SHELF != reqBO.getMsgType() && UccConstants.MSG_TYPE.MODIFY != reqBO.getMsgType()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6d88\u606f\u7c7b\u578b");
            return rspBO;
        }
        List skus = reqBO.getMsgList().stream().map(UccAgrPutMsgPoolBO::getSkuId).collect(Collectors.toList());
        List uccSkuPoList = this.uccSkuMapper.batchQrySku(skus, null);
        if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            rspBO.setRespCode("0000");
            return rspBO;
        }
        List shopIds = uccSkuPoList.stream().map(UccSkuPo::getSupplierShopId).collect(Collectors.toList());
        List supplierShopPoList = this.supplierShopMapper.batchquerySupplierShopIds(shopIds);
        Map<Object, Object> supMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)supplierShopPoList)) {
            supMap = supplierShopPoList.stream().collect(Collectors.toMap(SupplierShopPo::getSupplierShopId, Function.identity()));
        }
        ArrayList<UccMsgPoolRunPO> list = new ArrayList<UccMsgPoolRunPO>();
        if (UccConstants.MSG_TYPE.ADD == reqBO.getMsgType()) {
            for (UccSkuPo each : uccSkuPoList) {
                UccMsgPoolRunPO runPO = new UccMsgPoolRunPO();
                runPO.setColumn1(each.getSkuSource().toString());
                runPO.setSysTenantId(Long.valueOf(305775845729763327L));
                runPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
                runPO.setMsgId(Long.valueOf(this.sequence.nextId()));
                runPO.setMsgGetId(runPO.getMsgId().toString());
                runPO.setMsgGetType(UccConstants.MSG_TYPE.ADD.toString());
                if (supMap.containsKey(each.getSupplierShopId())) {
                    runPO.setSupplierId(((SupplierShopPo)supMap.get(each.getSupplierShopId())).getSupplierId());
                    runPO.setSupplierCode(((SupplierShopPo)supMap.get(each.getSupplierShopId())).getSupplierCode());
                }
                runPO.setSupplierShopId(each.getSupplierShopId());
                runPO.setSkuPoolState(reqBO.getOperType());
                runPO.setObjId(each.getSkuId().toString());
                runPO.setCreateTime(new Date());
                runPO.setMsgGetTime(runPO.getCreateTime());
                JSONObject body = new JSONObject();
                body.put("skuId", (Object)("[" + each.getSkuId() + "]"));
                body.put("spuId", (Object)each.getCommodityId());
                body.put("state", (Object)reqBO.getOperType());
                JSONObject resut = new JSONObject();
                resut.put("id", (Object)runPO.getMsgId());
                resut.put("time", (Object)runPO.getCreateTime());
                resut.put("type", (Object)reqBO.getMsgType());
                resut.put("result", (Object)body);
                runPO.setResult(JSONObject.toJSONString((Object)resut));
                list.add(runPO);
            }
        }
        try {
            this.uccMsgPoolRunMapper.insertBatch(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u63d2\u5165\u6570\u636e\u5f02\u5e38 \uff1a" + e.getMessage());
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

