/*
 * Decompiled with CFR 0.152.
 */
package com.haotiao.proxy.cache.impl;

import com.haotiao.proxy.cache.CacheLoader;
import com.haotiao.proxy.cache.impl.CacheServiceEx;
import com.haotiao.proxy.cache.impl.RedisException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.util.SerializationUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisCacheService
implements CacheServiceEx {
    private JedisPool jedisPool;
    private Properties config;

    public void set(String key, Object value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.set(key.getBytes(), SerializationUtils.serialize((Object)value));
        }
        catch (Exception e) {
            throw new RedisException("set key[" + key + "] error", e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    public void set(String key, Object value, int expireTime) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Transaction tx = jedis.multi();
            byte[] keycode = key.getBytes();
            tx.set(keycode, SerializationUtils.serialize((Object)value));
            tx.expire(keycode, expireTime);
            tx.exec();
            tx.close();
        }
        catch (Exception e) {
            throw new RedisException("set key[" + key + "] expireTime[" + expireTime + "] error", e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    public void setExpireTime(String key, int expireTime) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.expire(key.getBytes(), expireTime);
        }
        catch (Exception e) {
            throw new RedisException("set expire time[" + expireTime + "] for key[" + key + "] error", e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    public <T> T get(String key, Class<T> requiredType) {
        return (T)this.getObj(key);
    }

    private Object getObj(String key) {
        Object target = null;
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            byte[] value = jedis.get(key.getBytes());
            if (value != null) {
                target = SerializationUtils.deserialize((byte[])value);
            }
        }
        catch (Exception e) {
            throw new RedisException("get key[" + key + "] error", e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return target;
    }

    public <T> T get(String key, CacheLoader<T> cacheLoader) {
        Object target = this.getObj(key);
        if (target == null && (target = cacheLoader.load(key)) != null) {
            this.set(key, target);
        }
        return (T)target;
    }

    public int getExpireTime(String key) {
        int target = -1;
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            target = jedis.ttl(key.getBytes()).intValue();
        }
        catch (Exception e) {
            throw new RedisException("get expire time for key[" + key + "] error", e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return target;
    }

    public void del(String key) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.del(key.getBytes());
        }
        catch (Exception e) {
            throw new RedisException("del key[" + key + "] error", e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    public Set<String> keys(String pattern) {
        Set keys = null;
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            keys = jedis.keys(pattern);
        }
        catch (Exception e) {
            throw new RedisException("list keys[" + pattern + "] error", e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return keys;
    }

    public void lpush(String key, Object value) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.lpush(key.getBytes(), (byte[][])new byte[][]{SerializationUtils.serialize((Object)value)});
        }
        catch (Exception e) {
            throw new RedisException("push key[" + key + "] error", e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    public <T> T lpop(String key, Class<T> requireType) {
        return (T)this.lpop(key);
    }

    public long llen(String key) {
        long length = 0L;
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            length = jedis.llen(key.getBytes());
        }
        catch (Exception e) {
            throw new RedisException("llen for key[" + key + "] error", e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return length;
    }

    public void setConfig(Properties config) {
        this.config = config;
    }

    public Object get(String key) {
        return this.getObj(key);
    }

    public Object lpop(String key) {
        Object target = null;
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            byte[] data = jedis.lpop(key.getBytes());
            if (data != null) {
                target = SerializationUtils.deserialize((byte[])jedis.lpop(key.getBytes()));
            }
        }
        catch (Exception e) {
            throw new RedisException("pop key[" + key + "] error", e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return target;
    }

    public void startup() {
        if (this.jedisPool != null) {
            return;
        }
        GenericObjectPoolConfig redisConfig = new GenericObjectPoolConfig();
        URI redisUri = null;
        String redisCfgUrl = this.config.getProperty("cache.redis.url");
        try {
            redisUri = new URI(redisCfgUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("[" + redisCfgUrl + "] parsed error", e);
        }
        this.jedisPool = new JedisPool(redisConfig, redisUri.getHost(), redisUri.getPort(), 3000, redisUri.getUserInfo(), 0);
    }

    public void shutdown() {
        this.jedisPool.close();
    }

    public boolean support(String strategy) {
        return "Redis".equals(strategy);
    }
}

